/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.attachments;

import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.datafilters.service.DataFilterService;
import com.atlassian.jira.migration.datafilters.utils.DataFiltersUtil;
import com.atlassian.jira.migration.events.DataFilterExportStatsEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.db.core.JiraAttachmentReader;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.serverdataextractors.attachments.JiraAttachmentsService;
import com.atlassian.jira.migration.serverdataextractors.attachments.MissingAttachment;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 72\u00020\u0001:\u00017BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012JX\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010%\u001a\u00020#JD\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00142\u0006\u0010\u001d\u001a\u00020\u001a2\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010+\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001aJJ\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00142\u0006\u0010\u001d\u001a\u00020\u001a2\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\"2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 J\u000e\u00100\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001aJ\u0018\u00101\u001a\u0002022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J8\u00103\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/attachments/JiraAttachmentsService;", "", "attachmentManager", "Lcom/atlassian/jira/issue/AttachmentManager;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "jiraIssueReader", "Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;", "jiraAttachmentReader", "Lcom/atlassian/jira/migration/export/db/core/JiraAttachmentReader;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "dataFilterService", "Lcom/atlassian/jira/migration/datafilters/service/DataFilterService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/issue/AttachmentManager;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;Lcom/atlassian/jira/migration/export/db/core/JiraAttachmentReader;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/datafilters/service/DataFilterService;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "filterEntities", "Lkotlin/sequences/Sequence;", "T", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "entities", "logMessage", "", "migrationId", "cloudId", "projectKey", "entityType", "projectDataMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "getAllAttachmentsIds", "", "", "getAttachmentIdsByProject", "projectId", "getAttachmentsByProject", "Lcom/atlassian/jira/issue/attachment/Attachment;", "onProgressUpdate", "Lkotlin/Function0;", "", "getAttachmentsCountByProject", "getIssues", "Lcom/atlassian/jira/issue/Issue;", "getMissingAttachmentsByProject", "Lcom/atlassian/jira/migration/serverdataextractors/attachments/MissingAttachment;", "getTotalAttachmentsSizeByProject", "isEntityTypeCompatibleWithProjectMode", "", "sendFilteredEntitiesMetrics", "totalCount", "", "filteredCount", "Companion", "jira-migration-plugin"})
public final class JiraAttachmentsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AttachmentManager attachmentManager;
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final JiraIssueReader jiraIssueReader;
    @NotNull
    private final JiraAttachmentReader jiraAttachmentReader;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final DataFilterService dataFilterService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(JiraAttachmentsService.class);
    @NotNull
    private static final String ISSUE_ENTITY_TYPE = "issue";
    @NotNull
    private static final String ATTACHMENT_ENTITY_TYPE = "attachment";
    @NotNull
    private static final String DUMMY_MIGRATION_ID = "dummyMigrationId";
    @NotNull
    private static final String DUMMY_CLOUD_ID = "dummyCloudId";

    @Inject
    public JiraAttachmentsService(@NotNull AttachmentManager attachmentManager, @NotNull IssueManager issueManager, @NotNull ProjectManager projectManager, @NotNull JiraIssueReader jiraIssueReader, @NotNull JiraAttachmentReader jiraAttachmentReader, @NotNull MigrationFeatures migrationFeatures, @NotNull DataFilterService dataFilterService, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)attachmentManager, (String)"attachmentManager");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)jiraIssueReader, (String)"jiraIssueReader");
        Intrinsics.checkNotNullParameter((Object)jiraAttachmentReader, (String)"jiraAttachmentReader");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)dataFilterService, (String)"dataFilterService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.attachmentManager = attachmentManager;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.jiraIssueReader = jiraIssueReader;
        this.jiraAttachmentReader = jiraAttachmentReader;
        this.migrationFeatures = migrationFeatures;
        this.dataFilterService = dataFilterService;
        this.migrationEventBus = migrationEventBus;
    }

    @NotNull
    public final Sequence<Attachment> getAttachmentsByProject(@NotNull String projectKey, @NotNull Function0<Unit> onProgressUpdate2, @NotNull DataFilterContext dataFilterContext, @NotNull String migrationId, @NotNull String cloudId2, @NotNull ProjectDataMigrationMode projectDataMode) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMode), (String)"projectDataMode");
        Sequence attachments2 = SequencesKt.flatMap((Sequence)SequencesKt.onEach(this.getIssues(projectKey, onProgressUpdate2, dataFilterContext, migrationId, cloudId2, projectDataMode), (Function1)((Function1)new Function1<Issue, Unit>(onProgressUpdate2){
            final /* synthetic */ Function0<Unit> $onProgressUpdate;
            {
                this.$onProgressUpdate = $onProgressUpdate;
                super(1);
            }

            public final void invoke(@NotNull Issue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$onProgressUpdate.invoke();
            }
        })), (Function1)((Function1)new Function1<Issue, Sequence<? extends Attachment>>(this, onProgressUpdate2){
            final /* synthetic */ JiraAttachmentsService this$0;
            final /* synthetic */ Function0<Unit> $onProgressUpdate;
            {
                this.this$0 = $receiver;
                this.$onProgressUpdate = $onProgressUpdate;
                super(1);
            }

            @NotNull
            public final Sequence<Attachment> invoke(@NotNull Issue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                List list = JiraAttachmentsService.access$getAttachmentManager$p(this.this$0).getAttachments(it);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttachments(...)");
                return SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Attachment, Unit>(this.$onProgressUpdate){
                    final /* synthetic */ Function0<Unit> $onProgressUpdate;
                    {
                        this.$onProgressUpdate = $onProgressUpdate;
                        super(1);
                    }

                    public final void invoke(Attachment it) {
                        this.$onProgressUpdate.invoke();
                    }
                }));
            }
        }));
        boolean bl = false;
        return this.filterEntities(dataFilterContext, attachments2, "Filtering attachments using data filters", migrationId, cloudId2, projectKey, ATTACHMENT_ENTITY_TYPE, projectDataMode);
    }

    public static /* synthetic */ Sequence getAttachmentsByProject$default(JiraAttachmentsService jiraAttachmentsService, String string, Function0 function0, DataFilterContext dataFilterContext, String string2, String string3, ProjectDataMigrationMode projectDataMigrationMode, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = getAttachmentsByProject.1.INSTANCE;
        }
        return jiraAttachmentsService.getAttachmentsByProject(string, (Function0<Unit>)function0, dataFilterContext, string2, string3, projectDataMigrationMode);
    }

    @NotNull
    public final <T> Sequence<T> filterEntities(@NotNull DataFilterContext dataFilterContext, @NotNull Sequence<? extends T> entities, @NotNull String logMessage, @NotNull String migrationId, @NotNull String cloudId2, @NotNull String projectKey, @NotNull String entityType, @NotNull ProjectDataMigrationMode projectDataMode) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)logMessage, (String)"logMessage");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMode), (String)"projectDataMode");
        if (DataFiltersUtil.INSTANCE.shouldApplyDataFilters(this.migrationFeatures, dataFilterContext) && this.isEntityTypeCompatibleWithProjectMode(projectDataMode, entityType)) {
            log.debug(logMessage);
            Sequence filteredEntities2 = SequencesKt.filter(entities, (Function1)new Function1<T, Boolean>(this, dataFilterContext){
                final /* synthetic */ JiraAttachmentsService this$0;
                final /* synthetic */ DataFilterContext $dataFilterContext;
                {
                    this.this$0 = $receiver;
                    this.$dataFilterContext = $dataFilterContext;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(T entity) {
                    return JiraAttachmentsService.access$getDataFilterService$p(this.this$0).shouldExportEntity(this.$dataFilterContext, entity);
                }
            });
            this.dataFilterService.logFilteringResults(dataFilterContext);
            if (!Intrinsics.areEqual((Object)migrationId, (Object)DUMMY_MIGRATION_ID)) {
                this.sendFilteredEntitiesMetrics(migrationId, cloudId2, SequencesKt.count((Sequence)entities), SequencesKt.count((Sequence)filteredEntities2), projectKey, entityType);
            }
            sequence = filteredEntities2;
        } else {
            sequence = entities;
        }
        return sequence;
    }

    private final void sendFilteredEntitiesMetrics(String migrationId, String cloudId2, int totalCount, int filteredCount, String projectKey, String entityType) {
        this.migrationEventBus.post(new DataFilterExportStatsEvent(cloudId2, migrationId, filteredCount, totalCount, projectKey, entityType));
    }

    private final boolean isEntityTypeCompatibleWithProjectMode(ProjectDataMigrationMode projectDataMode, String entityType) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[projectDataMode.ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)entityType, (Object)ISSUE_ENTITY_TYPE);
                break;
            }
            case 2: 
            case 3: {
                bl = Intrinsics.areEqual((Object)entityType, (Object)ATTACHMENT_ENTITY_TYPE);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final long getTotalAttachmentsSizeByProject(@NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        Long l = project.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.jiraAttachmentReader.getTotalAttachmentsSizeByProject(((Number)l).longValue());
    }

    private final Sequence<Issue> getIssues(String projectKey, Function0<Unit> onProgressUpdate2, DataFilterContext dataFilterContext, String migrationId, String cloudId2, ProjectDataMigrationMode projectDataMode) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        Ref.IntRef count2 = new Ref.IntRef();
        Long l = project.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return SequencesKt.flatMap((Sequence)SequencesKt.onEach((Sequence)SequencesKt.chunked(this.jiraIssueReader.getAllIssueIdsForProject(((Number)l).longValue()), (int)100), (Function1)((Function1)new Function1<List<? extends Long>, Unit>(onProgressUpdate2){
            final /* synthetic */ Function0<Unit> $onProgressUpdate;
            {
                this.$onProgressUpdate = $onProgressUpdate;
                super(1);
            }

            public final void invoke(@NotNull List<Long> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$onProgressUpdate.invoke();
            }
        })), (Function1)((Function1)new Function1<List<? extends Long>, Sequence<? extends Issue>>(count2, projectKey, this, dataFilterContext, migrationId, cloudId2, projectDataMode, onProgressUpdate2){
            final /* synthetic */ Ref.IntRef $count;
            final /* synthetic */ String $projectKey;
            final /* synthetic */ JiraAttachmentsService this$0;
            final /* synthetic */ DataFilterContext $dataFilterContext;
            final /* synthetic */ String $migrationId;
            final /* synthetic */ String $cloudId;
            final /* synthetic */ ProjectDataMigrationMode $projectDataMode;
            final /* synthetic */ Function0<Unit> $onProgressUpdate;
            {
                this.$count = $count;
                this.$projectKey = $projectKey;
                this.this$0 = $receiver;
                this.$dataFilterContext = $dataFilterContext;
                this.$migrationId = $migrationId;
                this.$cloudId = $cloudId;
                this.$projectDataMode = $projectDataMode;
                this.$onProgressUpdate = $onProgressUpdate;
                super(1);
            }

            @NotNull
            public final Sequence<Issue> invoke(@NotNull List<Long> chunkIds) {
                Intrinsics.checkNotNullParameter(chunkIds, (String)"chunkIds");
                this.$count.element += chunkIds.size();
                if (this.$count.element % 1000 == 0 || chunkIds.size() < 100) {
                    JiraAttachmentsService.access$getLog$cp().info("Loading issues for attachment manipulation,project key=" + this.$projectKey + " count=" + this.$count.element);
                }
                List issueObjects2 = JiraAttachmentsService.access$getIssueManager$p(this.this$0).getIssueObjects((Collection)chunkIds);
                Intrinsics.checkNotNull((Object)issueObjects2);
                Sequence<T> filteredIssues2 = this.this$0.filterEntities(this.$dataFilterContext, CollectionsKt.asSequence((Iterable)issueObjects2), "Filtering issues using data filters", this.$migrationId, this.$cloudId, this.$projectKey, "issue", this.$projectDataMode);
                return SequencesKt.onEach(filteredIssues2, (Function1)((Function1)new Function1<Issue, Unit>(this.$onProgressUpdate){
                    final /* synthetic */ Function0<Unit> $onProgressUpdate;
                    {
                        this.$onProgressUpdate = $onProgressUpdate;
                        super(1);
                    }

                    public final void invoke(Issue it) {
                        this.$onProgressUpdate.invoke();
                    }
                }));
            }
        }));
    }

    static /* synthetic */ Sequence getIssues$default(JiraAttachmentsService jiraAttachmentsService, String string, Function0 function0, DataFilterContext dataFilterContext, String string2, String string3, ProjectDataMigrationMode projectDataMigrationMode, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = getIssues.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            string2 = DUMMY_MIGRATION_ID;
        }
        if ((n & 0x10) != 0) {
            string3 = DUMMY_CLOUD_ID;
        }
        return jiraAttachmentsService.getIssues(string, (Function0<Unit>)function0, dataFilterContext, string2, string3, projectDataMigrationMode);
    }

    public final long getAttachmentsCountByProject(@NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        Long l = project.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.jiraAttachmentReader.getAttachmentsCountByProject(((Number)l).longValue());
    }

    @NotNull
    public final List<Long> getAllAttachmentsIds() {
        return this.jiraAttachmentReader.getAllAttachmentsIds();
    }

    @NotNull
    public final List<Long> getAttachmentIdsByProject(long projectId) {
        return this.jiraAttachmentReader.getAttachmentsIdsByProject(projectId);
    }

    @NotNull
    public final List<MissingAttachment> getMissingAttachmentsByProject(@NotNull String projectKey, @NotNull DataFilterContext dataFilterContext, @NotNull ProjectDataMigrationMode projectDataMode) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMode), (String)"projectDataMode");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)JiraAttachmentsService.getIssues$default(this, projectKey, null, dataFilterContext, null, null, projectDataMode, 26, null), (Function1)((Function1)new Function1<Issue, List<Attachment>>(this){
            final /* synthetic */ JiraAttachmentsService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final List<Attachment> invoke(@NotNull Issue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                List list = JiraAttachmentsService.access$getAttachmentManager$p(this.this$0).getAttachments(it);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttachments(...)");
                return list;
            }
        })), (Function1)((Function1)new Function1<Attachment, MissingAttachment>(this, projectKey){
            final /* synthetic */ JiraAttachmentsService this$0;
            final /* synthetic */ String $projectKey;
            {
                this.this$0 = $receiver;
                this.$projectKey = $projectKey;
                super(1);
            }

            @Nullable
            public final MissingAttachment invoke(Attachment it) {
                MissingAttachment missingAttachment;
                try {
                    JiraAttachmentsService.access$getAttachmentManager$p(this.this$0).streamAttachmentContent(it, getMissingAttachmentsByProject.2::invoke$lambda$0);
                    missingAttachment = null;
                }
                catch (Exception e) {
                    String[] stringArray;
                    JiraAttachmentsService.access$getLog$cp().error("Exception when streaming attachment for missing attachments check", (Throwable)e);
                    Long l = it.getIssueId();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getIssueId(...)");
                    long l2 = ((Number)l).longValue();
                    Long l3 = it.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getId(...)");
                    long l4 = ((Number)l3).longValue();
                    Object object = e.getMessage();
                    if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) == null || (object = (String)CollectionsKt.last((List)object)) == null) {
                        object = "";
                    }
                    missingAttachment = new MissingAttachment(this.$projectKey, l2, l4, (String)object);
                }
                return missingAttachment;
            }

            private static final Boolean invoke$lambda$0(InputStream content) {
                return content != null;
            }
        })));
    }

    public static final /* synthetic */ AttachmentManager access$getAttachmentManager$p(JiraAttachmentsService $this) {
        return $this.attachmentManager;
    }

    public static final /* synthetic */ DataFilterService access$getDataFilterService$p(JiraAttachmentsService $this) {
        return $this.dataFilterService;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ IssueManager access$getIssueManager$p(JiraAttachmentsService $this) {
        return $this.issueManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/attachments/JiraAttachmentsService$Companion;", "", "()V", "ATTACHMENT_ENTITY_TYPE", "", "DUMMY_CLOUD_ID", "DUMMY_MIGRATION_ID", "ISSUE_ENTITY_TYPE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectDataMigrationMode.values().length];
            try {
                nArray[ProjectDataMigrationMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectDataMigrationMode.ATTACHMENTS_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectDataMigrationMode.ATTACHMENTS_ONLY_V2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

