/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.cpb.helper;

import com.atlassian.jira.migration.export.core.filter.service.jql.FilterJqlService;
import com.atlassian.jira.migration.serverdataextractors.cpb.model.CrossProjectEntityReferringProjectsInfo;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u000bJ\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper;", "", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "filterJqlService", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService;", "(Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService;)V", "collectProjectRefInfoList", "", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;", "filterIdsList", "", "getFilteredJqlProjectRefInfoListReferencingAnySelectedProject", "crossProjectEntityJqlProjectRefInfoList", "selectedProjectKeys", "", "getJqlProjectRefInfoForCrossProjectEntity", "filterId", "getJqlProjectRefInfoForProjectEntity", "isCrossProjectEntityReferencingAnySelectedProject", "", "crossProjectEntityReferringProjectsInfo", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/model/CrossProjectEntityReferringProjectsInfo;", "selectedProjectIds", "logFilterInfo", "", "jqlProjectRefInfo", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCrossProjectEntityHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossProjectEntityHelper.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1603#2,9:97\n1855#2:106\n1856#2:108\n1612#2:109\n766#2:110\n857#2,2:111\n766#2:113\n857#2,2:114\n1#3:107\n*S KotlinDebug\n*F\n+ 1 CrossProjectEntityHelper.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper\n*L\n20#1:97,9\n20#1:106\n20#1:108\n20#1:109\n28#1:110\n28#1:111,2\n51#1:113\n51#1:114,2\n20#1:107\n*E\n"})
public final class CrossProjectEntityHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final FilterJqlService filterJqlService;
    private static final Logger log = LoggerFactory.getLogger(CrossProjectEntityHelper.class);

    @Inject
    public CrossProjectEntityHelper(@NotNull ProjectManager projectManager, @NotNull FilterJqlService filterJqlService) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)filterJqlService, (String)"filterJqlService");
        this.projectManager = projectManager;
        this.filterJqlService = filterJqlService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FilterJqlService.JqlProjectReferenceInfo> getFilteredJqlProjectRefInfoListReferencingAnySelectedProject(@NotNull List<FilterJqlService.JqlProjectReferenceInfo> crossProjectEntityJqlProjectRefInfoList, @NotNull List<String> selectedProjectKeys) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(crossProjectEntityJqlProjectRefInfoList, (String)"crossProjectEntityJqlProjectRefInfoList");
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        Iterable $this$mapNotNull$iv = selectedProjectKeys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Project project = this.projectManager.getProjectObjByKey(it);
            Long projectId = project != null ? project.getId() : null;
            log.debug("Selected project key: " + it + " refers to project with id: " + projectId);
            if (projectId == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List selectedProjectIds = (List)destination$iv$iv;
        log.debug("Selected project ids are: {}", (Object)selectedProjectIds);
        Iterable $this$filter$iv = crossProjectEntityJqlProjectRefInfoList;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FilterJqlService.JqlProjectReferenceInfo entity = (FilterJqlService.JqlProjectReferenceInfo)element$iv$iv;
            boolean bl = false;
            boolean isReferringAnySelectedProject = !((Collection)CollectionsKt.intersect((Iterable)selectedProjectIds, (Iterable)CollectionsKt.toSet((Iterable)entity.getReferringProjectIds()))).isEmpty();
            log.debug("Cross Project Entity with filter id: " + entity.getFilter().getId() + " and filter name: " + entity.getFilter().getName() + " is referring to project ids: " + entity.getReferringProjectIds());
            if (!isReferringAnySelectedProject) {
                log.debug("Cross Project Entity with filter id: " + entity.getFilter().getId() + " and filter name: " + entity.getFilter().getName() + " is not referring to any selected project, Skipping...");
            } else {
                log.debug("Cross Project Entity with filter id: " + entity.getFilter().getId() + " and filter name: " + entity.getFilter().getName() + " is referring to atleast one selected project..");
            }
            if (!isReferringAnySelectedProject) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FilterJqlService.JqlProjectReferenceInfo> collectProjectRefInfoList(@NotNull List<Long> filterIdsList) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filterIdsList, (String)"filterIdsList");
        Iterable $this$filter$iv = this.filterJqlService.collectProjectReferenceInfoList(filterIdsList);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FilterJqlService.JqlProjectReferenceInfo it = (FilterJqlService.JqlProjectReferenceInfo)element$iv$iv;
            boolean bl = false;
            this.logFilterInfo(it);
            if (!it.isReferringMultiProjects()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final FilterJqlService.JqlProjectReferenceInfo getJqlProjectRefInfoForCrossProjectEntity(long filterId) {
        FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo;
        FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo2 = this.filterJqlService.collectProjectReferenceInfo((List<Long>)CollectionsKt.emptyList(), filterId);
        if (jqlProjectReferenceInfo2 != null) {
            FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo3;
            FilterJqlService.JqlProjectReferenceInfo it = jqlProjectReferenceInfo3 = jqlProjectReferenceInfo2;
            boolean bl = false;
            this.logFilterInfo(it);
            jqlProjectReferenceInfo = it.isReferringMultiProjects() ? jqlProjectReferenceInfo3 : null;
        } else {
            jqlProjectReferenceInfo = null;
        }
        return jqlProjectReferenceInfo;
    }

    @Nullable
    public final FilterJqlService.JqlProjectReferenceInfo getJqlProjectRefInfoForProjectEntity(long filterId) {
        FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo;
        FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo2 = this.filterJqlService.collectProjectReferenceInfo((List<Long>)CollectionsKt.emptyList(), filterId);
        if (jqlProjectReferenceInfo2 != null) {
            FilterJqlService.JqlProjectReferenceInfo it = jqlProjectReferenceInfo2;
            boolean bl = false;
            this.logFilterInfo(it);
            jqlProjectReferenceInfo = it;
        } else {
            jqlProjectReferenceInfo = null;
        }
        return jqlProjectReferenceInfo;
    }

    private final void logFilterInfo(FilterJqlService.JqlProjectReferenceInfo jqlProjectRefInfo) {
        boolean isReferringMultipleProjects = jqlProjectRefInfo.isReferringMultiProjects();
        if (!isReferringMultipleProjects) {
            log.debug("Filter with id: " + jqlProjectRefInfo.getFilter().getId() + " and name: " + jqlProjectRefInfo.getFilter().getName() + " has referring project ids: " + jqlProjectRefInfo.getReferringProjectIds() + " is not referring to multiple projects, Skipping..");
        } else {
            log.debug("Filter with id: " + jqlProjectRefInfo.getFilter().getId() + " and name: " + jqlProjectRefInfo.getFilter().getName() + " has referring project ids: " + jqlProjectRefInfo.getReferringProjectIds() + " is referring to multiple projects, fetching..");
        }
    }

    public final boolean isCrossProjectEntityReferencingAnySelectedProject(@NotNull CrossProjectEntityReferringProjectsInfo crossProjectEntityReferringProjectsInfo, @NotNull List<Long> selectedProjectIds) {
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityReferringProjectsInfo, (String)"crossProjectEntityReferringProjectsInfo");
        Intrinsics.checkNotNullParameter(selectedProjectIds, (String)"selectedProjectIds");
        return !((Collection)CollectionsKt.intersect((Iterable)selectedProjectIds, (Iterable)CollectionsKt.toSet((Iterable)crossProjectEntityReferringProjectsInfo.getReferringProjectIds()))).isEmpty();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

