/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.cpb.rest;

import com.atlassian.jira.migration.analytics.crossproject.service.CrossProjectEntityStatsEventService;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.sen.JiraLicenseInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.serverdataextractors.cpb.rest.BoardsAndFiltersDto;
import com.atlassian.jira.migration.serverdataextractors.cpb.service.CPBFilterService;
import com.atlassian.jira.migration.serverdataextractors.cpb.service.CPBRapidViewService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="crossprojectdata")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB-\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\n\b\u0003\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/rest/CPBDataResource;", "", "cpbRapidViewServiceProvider", "Ljavax/inject/Provider;", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBRapidViewService;", "cpbFiltersService", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService;", "crossProjectEntityEventService", "Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "(Ljavax/inject/Provider;Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService;Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;Lcom/atlassian/jira/migration/sen/SENSupplier;)V", "getCrossProjectBoardsAndFiltersStats", "Ljavax/ws/rs/core/Response;", "crossProjectBoardAndFiltersMigrationMode", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardAndFiltersMigrationMode;", "selectedProjectKeys", "", "parseSelectedProjectKeys", "", "sendCrossProjectRapidViewFilterTaskListStatsEvent", "", "timeTakenToFetchCrossProjectRapidViews", "", "timeTakenToFetchCrossProjectFilters", "crossProjectRapidViewCount", "crossProjectFilterCount", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCPBDataResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPBDataResource.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/rest/CPBDataResource\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n17#2,6:133\n17#2,6:139\n1549#3:145\n1620#3,3:146\n*S KotlinDebug\n*F\n+ 1 CPBDataResource.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/rest/CPBDataResource\n*L\n62#1:133,6\n72#1:139,6\n103#1:145\n103#1:146,3\n*E\n"})
public final class CPBDataResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Provider<CPBRapidViewService> cpbRapidViewServiceProvider;
    @NotNull
    private final CPBFilterService cpbFiltersService;
    @NotNull
    private final CrossProjectEntityStatsEventService crossProjectEntityEventService;
    @NotNull
    private final SENSupplier senSupplier;
    private static final Logger log = LoggerFactory.getLogger(CPBDataResource.class);
    @NotNull
    public static final String CROSS_PROJECT_MIGRATION_MODE_NOT_SUPPORTED = "Cross Project Boards And Filters migration mode not supported";

    @Inject
    public CPBDataResource(@NotNull Provider<CPBRapidViewService> cpbRapidViewServiceProvider, @NotNull CPBFilterService cpbFiltersService, @NotNull CrossProjectEntityStatsEventService crossProjectEntityEventService, @NotNull SENSupplier senSupplier) {
        Intrinsics.checkNotNullParameter(cpbRapidViewServiceProvider, (String)"cpbRapidViewServiceProvider");
        Intrinsics.checkNotNullParameter((Object)cpbFiltersService, (String)"cpbFiltersService");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityEventService, (String)"crossProjectEntityEventService");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        this.cpbRapidViewServiceProvider = cpbRapidViewServiceProvider;
        this.cpbFiltersService = cpbFiltersService;
        this.crossProjectEntityEventService = crossProjectEntityEventService;
        this.senSupplier = senSupplier;
    }

    @GET
    @Path(value="/boards-and-filters")
    @NotNull
    public final Response getCrossProjectBoardsAndFiltersStats(@QueryParam(value="boardsAndFiltersSelectionMode") @NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, @QueryParam(value="projectKeys") @Nullable String selectedProjectKeys) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        if (crossProjectBoardAndFiltersMigrationMode == CrossProjectBoardAndFiltersMigrationMode.ALL || crossProjectBoardAndFiltersMigrationMode == CrossProjectBoardAndFiltersMigrationMode.SELECTED_PROJECTS) {
            List<String> selectedProjectKeysList = this.parseSelectedProjectKeys(selectedProjectKeys);
            log.debug("Cross Project Boards and Filters Migration mode selected: " + (Object)((Object)crossProjectBoardAndFiltersMigrationMode) + ", Project keys selected: " + selectedProjectKeysList);
            long crossProjectRapidViewCount = 0L;
            long crossProjectFilterCount = 0L;
            JiraLicenseInfo licenses = this.senSupplier.getLicenses();
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            if (licenses.getJiraSoftwareLicense() == null) {
                crossProjectRapidViewCount = 0L;
            } else {
                CPBRapidViewService cPBRapidViewService = (CPBRapidViewService)this.cpbRapidViewServiceProvider.get();
                crossProjectRapidViewCount = cPBRapidViewService != null ? cPBRapidViewService.getCrossProjectRapidViewCount(crossProjectBoardAndFiltersMigrationMode, selectedProjectKeysList) : 0L;
            }
            long timeTakenToFetchCrossProjectRapidViews = System.currentTimeMillis() - start$iv;
            boolean $i$f$measureTimeMillis2 = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl2 = false;
            crossProjectFilterCount = this.cpbFiltersService.getCrossProjectFiltersCount(crossProjectBoardAndFiltersMigrationMode, selectedProjectKeysList);
            long timeTakenToFetchCrossProjectFilters = System.currentTimeMillis() - start$iv2;
            log.info("CrossProjectRapidViewCount: " + crossProjectRapidViewCount + " and CrossProjectFilterCount: " + crossProjectFilterCount);
            this.sendCrossProjectRapidViewFilterTaskListStatsEvent(crossProjectBoardAndFiltersMigrationMode, timeTakenToFetchCrossProjectRapidViews, timeTakenToFetchCrossProjectFilters, crossProjectRapidViewCount, crossProjectFilterCount);
            response2 = ResponseUtils.INSTANCE.ok(new BoardsAndFiltersDto(crossProjectRapidViewCount, crossProjectFilterCount));
        } else {
            log.info("Cross Project Boards and Filters Migration Mode: " + (Object)((Object)crossProjectBoardAndFiltersMigrationMode) + " not supported");
            response2 = ResponseUtils.INSTANCE.badRequest(CROSS_PROJECT_MIGRATION_MODE_NOT_SUPPORTED);
        }
        return response2;
    }

    public static /* synthetic */ Response getCrossProjectBoardsAndFiltersStats$default(CPBDataResource cPBDataResource, CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return cPBDataResource.getCrossProjectBoardsAndFiltersStats(crossProjectBoardAndFiltersMigrationMode, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseSelectedProjectKeys(String selectedProjectKeys) {
        List list;
        char[] cArray;
        Object object = selectedProjectKeys;
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void sendCrossProjectRapidViewFilterTaskListStatsEvent(CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, long timeTakenToFetchCrossProjectRapidViews, long timeTakenToFetchCrossProjectFilters, long crossProjectRapidViewCount, long crossProjectFilterCount) {
        this.crossProjectEntityEventService.sendCrossProjectRapidViewFilterTaskListStatsEvent(crossProjectBoardAndFiltersMigrationMode, timeTakenToFetchCrossProjectRapidViews, timeTakenToFetchCrossProjectFilters, crossProjectRapidViewCount, crossProjectFilterCount);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/rest/CPBDataResource$Companion;", "", "()V", "CROSS_PROJECT_MIGRATION_MODE_NOT_SUPPORTED", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

