/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.cpb.service;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.migration.export.core.filter.service.jql.FilterJqlService;
import com.atlassian.jira.migration.export.core.filter.service.retrieve.FilterRetrieveService;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.serverdataextractors.cpb.helper.CrossProjectEntityHelper;
import com.atlassian.jira.migration.serverdataextractors.cpb.model.CrossProjectFilterReferringProjectsInfo;
import com.atlassian.jira.migration.serverdataextractors.cpb.service.CrossProjectEntityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001c\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nJ\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService;", "", "filterRetrieveService", "Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;", "crossProjectEntityHelper", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper;", "crossProjectEntityService", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CrossProjectEntityService;", "(Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;Lcom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper;Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CrossProjectEntityService;)V", "getAllFilterIds", "", "", "getAllFilters", "Lcom/atlassian/jira/issue/search/SearchRequest;", "getCrossProjectFilterReferringProjectsInfoList", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/model/CrossProjectFilterReferringProjectsInfo;", "selectedProjectIds", "getCrossProjectFiltersCount", "crossProjectBoardAndFiltersMigrationMode", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardAndFiltersMigrationMode;", "selectedProjectKeys", "", "getJqlProjectRefInfoSetFromEligibleCrossProjectFilters", "", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCPBFilterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPBFilterService.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1603#2,9:100\n1855#2:109\n1856#2:111\n1612#2:112\n766#2:113\n857#2,2:114\n1549#2:116\n1620#2,3:117\n1#3:110\n*S KotlinDebug\n*F\n+ 1 CPBFilterService.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService\n*L\n54#1:100,9\n54#1:109\n54#1:111\n54#1:112\n69#1:113\n69#1:114,2\n93#1:116\n93#1:117,3\n54#1:110\n*E\n"})
public final class CPBFilterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FilterRetrieveService filterRetrieveService;
    @NotNull
    private final CrossProjectEntityHelper crossProjectEntityHelper;
    @NotNull
    private final CrossProjectEntityService crossProjectEntityService;
    private static final Logger log = LoggerFactory.getLogger(CPBFilterService.class);

    @Inject
    public CPBFilterService(@NotNull FilterRetrieveService filterRetrieveService, @NotNull CrossProjectEntityHelper crossProjectEntityHelper, @NotNull CrossProjectEntityService crossProjectEntityService) {
        Intrinsics.checkNotNullParameter((Object)filterRetrieveService, (String)"filterRetrieveService");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityHelper, (String)"crossProjectEntityHelper");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityService, (String)"crossProjectEntityService");
        this.filterRetrieveService = filterRetrieveService;
        this.crossProjectEntityHelper = crossProjectEntityHelper;
        this.crossProjectEntityService = crossProjectEntityService;
    }

    public final long getCrossProjectFiltersCount(@NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, @NotNull List<String> selectedProjectKeys) {
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        List<Long> filterIdsList = this.getAllFilterIds();
        return this.crossProjectEntityService.calculateEligibleCrossProjectEntityCounts(crossProjectBoardAndFiltersMigrationMode, selectedProjectKeys, filterIdsList);
    }

    @NotNull
    public final Set<FilterJqlService.JqlProjectReferenceInfo> getJqlProjectRefInfoSetFromEligibleCrossProjectFilters(@NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, @NotNull List<String> selectedProjectKeys) {
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        Set filterIds = CollectionsKt.toSet((Iterable)this.getAllFilterIds());
        return CollectionsKt.toSet((Iterable)this.crossProjectEntityService.getJqlProjectRefInfoListForEligibleCrossProjectEntity(crossProjectBoardAndFiltersMigrationMode, selectedProjectKeys, CollectionsKt.toList((Iterable)filterIds)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CrossProjectFilterReferringProjectsInfo> getCrossProjectFilterReferringProjectsInfoList() {
        void $this$mapNotNullTo$iv$iv;
        log.info("Fetching all the cross project filters...");
        Iterable $this$mapNotNull$iv = this.getAllFilters();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CrossProjectFilterReferringProjectsInfo crossProjectFilterReferringProjectsInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SearchRequest filter = (SearchRequest)element$iv$iv;
            boolean bl2 = false;
            log.debug("Evaluating filter with id: " + filter.getId());
            Long l = filter.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            if (this.crossProjectEntityHelper.getJqlProjectRefInfoForCrossProjectEntity(((Number)l).longValue()) != null) {
                FilterJqlService.JqlProjectReferenceInfo it;
                boolean bl3 = false;
                crossProjectFilterReferringProjectsInfo = new CrossProjectFilterReferringProjectsInfo(filter, it.getReferringProjectIds());
            } else {
                crossProjectFilterReferringProjectsInfo = null;
            }
            if (crossProjectFilterReferringProjectsInfo == null) continue;
            CrossProjectFilterReferringProjectsInfo it$iv$iv = crossProjectFilterReferringProjectsInfo;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CrossProjectFilterReferringProjectsInfo> getCrossProjectFilterReferringProjectsInfoList(@NotNull List<Long> selectedProjectIds) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(selectedProjectIds, (String)"selectedProjectIds");
        Iterable $this$filter$iv = this.getCrossProjectFilterReferringProjectsInfoList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CrossProjectFilterReferringProjectsInfo it = (CrossProjectFilterReferringProjectsInfo)element$iv$iv;
            boolean bl = false;
            boolean isReferencingAnySelectedProject = this.crossProjectEntityHelper.isCrossProjectEntityReferencingAnySelectedProject(it, selectedProjectIds);
            if (!isReferencingAnySelectedProject) {
                log.debug("Cross Project Filter with id: " + it.getCrossProjectFilter().getId() + " and name: " + it.getCrossProjectFilter().getName() + " id not referencing any selected project, Skipping...");
            }
            if (!isReferencingAnySelectedProject) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<SearchRequest> getAllFilters() {
        List filtersList = new ArrayList();
        this.filterRetrieveService.visitAllFilters((Function1<? super SearchRequest, Unit>)((Function1)new Function1<SearchRequest, Unit>((List<SearchRequest>)filtersList){
            final /* synthetic */ List<SearchRequest> $filtersList;
            {
                this.$filtersList = $filtersList;
                super(1);
            }

            public final void invoke(@NotNull SearchRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CPBFilterService.access$getLog$cp().debug("Fetched filter with id: " + it.getId() + " and name: " + it.getName());
                this.$filtersList.add(it);
            }
        }));
        return filtersList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> getAllFilterIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getAllFilters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SearchRequest searchRequest = (SearchRequest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

