/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.cpb.service;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.jira.migration.config.JiraSoftwareOnly;
import com.atlassian.jira.migration.export.core.filter.service.jql.FilterJqlService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.software.board.retrieve.RapidViewRetrieveService;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.serverdataextractors.cpb.helper.CrossProjectEntityHelper;
import com.atlassian.jira.migration.serverdataextractors.cpb.model.CrossProjectRapidViewReferringProjectsInfo;
import com.atlassian.jira.migration.serverdataextractors.cpb.service.CrossProjectEntityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraSoftwareOnly.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u0014\u001a\u00020\u0015J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\nJ\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nJ\u0016\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\r0\r0\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBRapidViewService;", "", "rapidViewRetrieveService", "Lcom/atlassian/jira/migration/export/software/board/retrieve/RapidViewRetrieveService;", "crossProjectEntityHelper", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper;", "crossProjectEntityService", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CrossProjectEntityService;", "(Lcom/atlassian/jira/migration/export/software/board/retrieve/RapidViewRetrieveService;Lcom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper;Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CrossProjectEntityService;)V", "getAllRapidViews", "", "Lcom/atlassian/greenhopper/model/rapid/RapidView;", "getCrossProjectRapidViewCount", "", "crossProjectBoardAndFiltersMigrationMode", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardAndFiltersMigrationMode;", "selectedProjectKeys", "", "getCrossProjectRapidViewReferringProjectsInfoList", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/model/CrossProjectRapidViewReferringProjectsInfo;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "selectedProjectIds", "getCrossProjectRapidViewsFromFilters", "filtersIds", "", "getJqlProjectRefInfoSetFromEligibleCrossProjectRapidViews", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;", "getSavedFilterIdsListForAllRapidViews", "kotlin.jvm.PlatformType", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCPBRapidViewService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPBRapidViewService.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBRapidViewService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1603#2,9:120\n1855#2:129\n1856#2:131\n1612#2:132\n766#2:133\n857#2,2:134\n766#2:136\n857#2,2:137\n1549#2:139\n1620#2,3:140\n1#3:130\n*S KotlinDebug\n*F\n+ 1 CPBRapidViewService.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBRapidViewService\n*L\n59#1:120,9\n59#1:129\n59#1:131\n59#1:132\n77#1:133\n77#1:134,2\n94#1:136\n94#1:137,2\n108#1:139\n108#1:140,3\n59#1:130\n*E\n"})
public final class CPBRapidViewService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RapidViewRetrieveService rapidViewRetrieveService;
    @NotNull
    private final CrossProjectEntityHelper crossProjectEntityHelper;
    @NotNull
    private final CrossProjectEntityService crossProjectEntityService;
    private static final Logger log = LoggerFactory.getLogger(CPBRapidViewService.class);
    private static final int DEFAULT_FETCH_SIZE = 100;

    @Inject
    public CPBRapidViewService(@NotNull RapidViewRetrieveService rapidViewRetrieveService, @NotNull CrossProjectEntityHelper crossProjectEntityHelper, @NotNull CrossProjectEntityService crossProjectEntityService) {
        Intrinsics.checkNotNullParameter((Object)rapidViewRetrieveService, (String)"rapidViewRetrieveService");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityHelper, (String)"crossProjectEntityHelper");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityService, (String)"crossProjectEntityService");
        this.rapidViewRetrieveService = rapidViewRetrieveService;
        this.crossProjectEntityHelper = crossProjectEntityHelper;
        this.crossProjectEntityService = crossProjectEntityService;
    }

    public final long getCrossProjectRapidViewCount(@NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, @NotNull List<String> selectedProjectKeys) {
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        List<Long> savedFilterIdsList = this.getSavedFilterIdsListForAllRapidViews();
        return this.crossProjectEntityService.calculateEligibleCrossProjectEntityCounts(crossProjectBoardAndFiltersMigrationMode, selectedProjectKeys, savedFilterIdsList);
    }

    @NotNull
    public final Set<FilterJqlService.JqlProjectReferenceInfo> getJqlProjectRefInfoSetFromEligibleCrossProjectRapidViews(@NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, @NotNull List<String> selectedProjectKeys) {
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        Set savedFilterIds = CollectionsKt.toSet((Iterable)this.getSavedFilterIdsListForAllRapidViews());
        return CollectionsKt.toSet((Iterable)this.crossProjectEntityService.getJqlProjectRefInfoListForEligibleCrossProjectEntity(crossProjectBoardAndFiltersMigrationMode, selectedProjectKeys, CollectionsKt.toList((Iterable)savedFilterIds)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CrossProjectRapidViewReferringProjectsInfo> getCrossProjectRapidViewReferringProjectsInfoList(@NotNull ExportContext ctx) {
        void var3_4;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        log.info("Fetching all rapid views..");
        Iterable $this$mapNotNull$iv = this.getAllRapidViews();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CrossProjectRapidViewReferringProjectsInfo crossProjectRapidViewReferringProjectsInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            RapidView rapidView = (RapidView)element$iv$iv;
            boolean bl2 = false;
            log.debug("Evaluating rapid view with id: " + rapidView.getId() + " and name: " + rapidView.getName() + " and saved filter id: " + rapidView.getSavedFilterId());
            List<Long> list = ctx.getFiltersCrossProjectsMapping().get(rapidView.getSavedFilterId());
            if (list != null) {
                List<Long> it = list;
                boolean bl3 = false;
                log.info("Found stored project Ids mapping for rapid view with saved filter id: " + rapidView.getSavedFilterId());
                crossProjectRapidViewReferringProjectsInfo = new CrossProjectRapidViewReferringProjectsInfo(rapidView, it);
            } else {
                crossProjectRapidViewReferringProjectsInfo = null;
            }
            if (crossProjectRapidViewReferringProjectsInfo == null) continue;
            CrossProjectRapidViewReferringProjectsInfo it$iv$iv = crossProjectRapidViewReferringProjectsInfo;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        log.info("Done fetching all rapid views");
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RapidView> getCrossProjectRapidViewsFromFilters(@NotNull Set<Long> filtersIds) {
        void var3_4;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filtersIds, (String)"filtersIds");
        log.info("Fetching all rapid views to filter out the ones that are not referencing to the given filters.");
        Iterable $this$filter$iv = this.getAllRapidViews();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RapidView rapidView = (RapidView)element$iv$iv;
            boolean bl = false;
            if (!filtersIds.contains(rapidView.getSavedFilterId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        log.info("Found " + it.size() + " rapid views for the given filters.");
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CrossProjectRapidViewReferringProjectsInfo> getCrossProjectRapidViewReferringProjectsInfoList(@NotNull ExportContext ctx, @NotNull List<Long> selectedProjectIds) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(selectedProjectIds, (String)"selectedProjectIds");
        Iterable $this$filter$iv = this.getCrossProjectRapidViewReferringProjectsInfoList(ctx);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CrossProjectRapidViewReferringProjectsInfo it = (CrossProjectRapidViewReferringProjectsInfo)element$iv$iv;
            boolean bl = false;
            boolean isReferencingAnySelectedProject = this.crossProjectEntityHelper.isCrossProjectEntityReferencingAnySelectedProject(it, selectedProjectIds);
            if (!isReferencingAnySelectedProject) {
                log.debug("Cross project rapid view with id: " + it.getCrossProjectRapidView().getId() + " and name: " + it.getCrossProjectRapidView().getName() + " is not referencing to any selected project, Skipping...");
            }
            if (!isReferencingAnySelectedProject) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Long> getSavedFilterIdsListForAllRapidViews() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getAllRapidViews();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RapidView rapidView = (RapidView)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            log.debug("Fetched rapid view with name " + it.getName() + " and id " + it.getId() + " and  saved filter with id " + it.getSavedFilterId());
            collection.add(it.getSavedFilterId());
        }
        return (List)destination$iv$iv;
    }

    private final List<RapidView> getAllRapidViews() {
        return SequencesKt.toList(this.rapidViewRetrieveService.retrieveAllRapidViews(100));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBRapidViewService$Companion;", "", "()V", "DEFAULT_FETCH_SIZE", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

