/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.cpb.service;

import com.atlassian.jira.migration.export.core.filter.service.jql.FilterJqlService;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.serverdataextractors.cpb.helper.CrossProjectEntityHelper;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\nJ0\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CrossProjectEntityService;", "", "crossProjectEntityHelper", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper;", "(Lcom/atlassian/jira/migration/serverdataextractors/cpb/helper/CrossProjectEntityHelper;)V", "calculateEligibleCrossProjectEntityCounts", "", "crossProjectBoardAndFiltersMigrationMode", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardAndFiltersMigrationMode;", "selectedProjectKeys", "", "", "filterIdsList", "getJqlProjectRefInfoListForEligibleCrossProjectEntity", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCrossProjectEntityService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossProjectEntityService.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/service/CrossProjectEntityService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1855#2,2:61\n*S KotlinDebug\n*F\n+ 1 CrossProjectEntityService.kt\ncom/atlassian/jira/migration/serverdataextractors/cpb/service/CrossProjectEntityService\n*L\n49#1:61,2\n*E\n"})
public final class CrossProjectEntityService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CrossProjectEntityHelper crossProjectEntityHelper;
    private static final Logger log = LoggerFactory.getLogger(CrossProjectEntityService.class);

    @Inject
    public CrossProjectEntityService(@NotNull CrossProjectEntityHelper crossProjectEntityHelper) {
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityHelper, (String)"crossProjectEntityHelper");
        this.crossProjectEntityHelper = crossProjectEntityHelper;
    }

    public final long calculateEligibleCrossProjectEntityCounts(@NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, @NotNull List<String> selectedProjectKeys, @NotNull List<Long> filterIdsList) {
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        Intrinsics.checkNotNullParameter(filterIdsList, (String)"filterIdsList");
        if (filterIdsList.isEmpty()) {
            return 0L;
        }
        return this.getJqlProjectRefInfoListForEligibleCrossProjectEntity(crossProjectBoardAndFiltersMigrationMode, selectedProjectKeys, filterIdsList).size();
    }

    @NotNull
    public final List<FilterJqlService.JqlProjectReferenceInfo> getJqlProjectRefInfoListForEligibleCrossProjectEntity(@NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, @NotNull List<String> selectedProjectKeys, @NotNull List<Long> filterIdsList) {
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        Intrinsics.checkNotNullParameter(filterIdsList, (String)"filterIdsList");
        List<FilterJqlService.JqlProjectReferenceInfo> crossProjectEntityJqlProjectRefInfoList = this.crossProjectEntityHelper.collectProjectRefInfoList(filterIdsList);
        List<FilterJqlService.JqlProjectReferenceInfo> jqlProjectRefInfoListForEligibleCrossProjectEntity = WhenMappings.$EnumSwitchMapping$0[crossProjectBoardAndFiltersMigrationMode.ordinal()] == 1 ? crossProjectEntityJqlProjectRefInfoList : this.crossProjectEntityHelper.getFilteredJqlProjectRefInfoListReferencingAnySelectedProject(crossProjectEntityJqlProjectRefInfoList, selectedProjectKeys);
        log.info("Cross Project Entity with filter counts " + jqlProjectRefInfoListForEligibleCrossProjectEntity.size() + " are eligible for migration");
        Iterable $this$forEach$iv = jqlProjectRefInfoListForEligibleCrossProjectEntity;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FilterJqlService.JqlProjectReferenceInfo it = (FilterJqlService.JqlProjectReferenceInfo)element$iv;
            boolean bl = false;
            log.debug("Cross Project Entity with filter id: " + it.getFilter().getId() + " and filter name: " + it.getFilter().getName() + " referring to project ids " + it.getReferringProjectIds() + " is eligible for migration");
        }
        return jqlProjectRefInfoListForEligibleCrossProjectEntity;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CrossProjectEntityService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CrossProjectBoardAndFiltersMigrationMode.values().length];
            try {
                nArray[CrossProjectBoardAndFiltersMigrationMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

