/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.liftandshift;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.DuplicatedFile;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.LASAllowedFiles;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.ManualInterventionValidationResult;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.ValidationDetails;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.ValidationStatus;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0002J\u0016\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0016\u0010\u0012\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0007J\u0016\u0010\u0015\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/liftandshift/ManualInterventionValidator;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "canRead", "", "files", "", "Ljava/io/File;", "containsRequiredFileForLz4", "filenames", "", "containsRequiredFiles", "zipFiles", "Lorg/apache/commons/compress/archivers/zip/ZipArchiveEntry;", "containsZipMagicBytes", "file", "filesAreEmpty", "getDuplicatedFiles", "Lcom/atlassian/jira/migration/serverdataextractors/liftandshift/DuplicatedFile;", "hasEmptyFiles", "validate", "Lcom/atlassian/jira/migration/serverdataextractors/liftandshift/ManualInterventionValidationResult;", "filePath", "validateFolderContents", "folder", "Ljava/nio/file/Path;", "validateLz4Folder", "validateZipContents", "validateZipFile", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nManualInterventionValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualInterventionValidator.kt\ncom/atlassian/jira/migration/serverdataextractors/liftandshift/ManualInterventionValidator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,183:1\n3792#2:184\n4307#2,2:185\n1549#3:187\n1620#3,3:188\n766#3:191\n857#3,2:192\n2634#3:194\n1477#3:196\n1502#3,3:197\n1505#3,3:207\n223#3,2:220\n223#3,2:222\n766#3:225\n857#3,2:226\n1747#3,3:228\n1549#3:231\n1620#3,3:232\n766#3:235\n857#3,2:236\n1747#3,3:238\n1#4:195\n372#5,7:200\n494#5,7:210\n125#6:217\n152#6,2:218\n154#6:224\n*S KotlinDebug\n*F\n+ 1 ManualInterventionValidator.kt\ncom/atlassian/jira/migration/serverdataextractors/liftandshift/ManualInterventionValidator\n*L\n101#1:184\n101#1:185,2\n102#1:187\n102#1:188,3\n129#1:191\n129#1:192,2\n130#1:194\n150#1:196\n150#1:197,3\n150#1:207,3\n154#1:220,2\n155#1:222,2\n161#1:225\n161#1:226,2\n162#1:228,3\n165#1:231\n165#1:232,3\n169#1:235\n169#1:236,2\n172#1:238,3\n130#1:195\n150#1:200,7\n151#1:210,7\n152#1:217\n152#1:218,2\n152#1:224\n*E\n"})
public final class ManualInterventionValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final int ZIP_MAGIC_BYTES = 1347093252;
    private static final int EMPTY_ARCHIVE_ZIP_MAGIC_BYTES = 1347093766;
    private static final Logger log = LoggerFactory.getLogger(ManualInterventionValidator.class);

    @Inject
    public ManualInterventionValidator(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    public final ManualInterventionValidationResult validate(@NotNull String filePath) {
        ManualInterventionValidationResult manualInterventionValidationResult;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.migrationFeatures.getEnableSinglePathLZ4MCS()) {
            Path path = Paths.get(filePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            manualInterventionValidationResult = this.validateLz4Folder(path);
        } else {
            manualInterventionValidationResult = this.validateZipFile(new File(filePath));
        }
        return manualInterventionValidationResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @NotNull
    public final ManualInterventionValidationResult validateLz4Folder(@NotNull Path folder) {
        ManualInterventionValidationResult manualInterventionValidationResult;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(folder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(folder, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                manualInterventionValidationResult = this.validateFolderContents(folder);
                return manualInterventionValidationResult;
            }
        }
        manualInterventionValidationResult = new ManualInterventionValidationResult(ValidationStatus.ERROR_NON_EXISTENT, null, 2, null);
        return manualInterventionValidationResult;
    }

    @VisibleForTesting
    @NotNull
    public final ManualInterventionValidationResult validateZipFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return !file2.exists() ? new ManualInterventionValidationResult(ValidationStatus.ERROR_NON_EXISTENT, null, 2, null) : (!this.containsZipMagicBytes(file2) ? new ManualInterventionValidationResult(ValidationStatus.ERROR_TYPE_INVALID, null, 2, null) : this.validateZipContents(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean containsZipMagicBytes(File file2) {
        boolean bl;
        try {
            boolean bl2;
            Closeable closeable = new RandomAccessFile(file2, "r");
            Throwable throwable = null;
            try {
                RandomAccessFile it = (RandomAccessFile)closeable;
                boolean bl3 = false;
                int fileMagicBytes = it.readInt();
                bl2 = fileMagicBytes == 1347093252 || fileMagicBytes == 1347093766;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = bl2;
        }
        catch (IOException ioException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ManualInterventionValidationResult validateZipContents(File file2) {
        Object object;
        try {
            ManualInterventionValidationResult manualInterventionValidationResult;
            object = (Closeable)new ZipFile(file2);
            Throwable throwable = null;
            try {
                ManualInterventionValidationResult manualInterventionValidationResult2;
                ZipFile it = (ZipFile)object;
                boolean bl = false;
                Enumeration enumeration = it.getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
                ArrayList arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                List zipFiles = arrayList;
                if (zipFiles.isEmpty()) {
                    manualInterventionValidationResult2 = new ManualInterventionValidationResult(ValidationStatus.ERROR_EMPTY, null, 2, null);
                } else if (!this.containsRequiredFiles(zipFiles)) {
                    manualInterventionValidationResult2 = new ManualInterventionValidationResult(ValidationStatus.ERROR_MISSING_FILES, null, 2, null);
                } else if (this.filesAreEmpty(zipFiles)) {
                    log.info("Required file(s) activeobjects.xml and/or entities.xml are empty");
                    manualInterventionValidationResult2 = new ManualInterventionValidationResult(ValidationStatus.ERROR_EMPTY, null, 2, null);
                } else {
                    manualInterventionValidationResult2 = new ManualInterventionValidationResult(ValidationStatus.SUCCESS, null, 2, null);
                }
                manualInterventionValidationResult = manualInterventionValidationResult2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = manualInterventionValidationResult;
        }
        catch (IOException ioException) {
            object = new ManualInterventionValidationResult(ValidationStatus.ERROR_TYPE_INVALID, null, 2, null);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final ManualInterventionValidationResult validateFolderContents(Path folder) {
        void $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        File[] fileArray = folder.toFile().listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(!it.isHidden())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return new ManualInterventionValidationResult(ValidationStatus.ERROR_NO_PERMISSION, null, 2, null);
        }
        List files = (List)destination$iv$iv;
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable $i$f$filter = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getName());
        }
        List filenames = (List)destination$iv$iv2;
        return files.isEmpty() ? new ManualInterventionValidationResult(ValidationStatus.ERROR_FOLDER_EMPTY, null, 2, null) : (!this.canRead(files) ? new ManualInterventionValidationResult(ValidationStatus.ERROR_NO_PERMISSION, null, 2, null) : (!this.containsRequiredFileForLz4(filenames) ? new ManualInterventionValidationResult(ValidationStatus.ERROR_MISSING_FILES, null, 2, null) : (!((Collection)this.getDuplicatedFiles(filenames)).isEmpty() ? new ManualInterventionValidationResult(ValidationStatus.WARNING_MORE_THAN_ONE_FILE_TYPE, new ValidationDetails(this.getDuplicatedFiles(filenames))) : (this.hasEmptyFiles(files) ? new ManualInterventionValidationResult(ValidationStatus.ERROR_FOLDER_FILE_EMPTY, null, 2, null) : new ManualInterventionValidationResult(ValidationStatus.SUCCESS, null, 2, null)))));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canRead(List<? extends File> files) {
        boolean bl;
        try {
            File it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = files;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (File)element$iv$iv;
                boolean bl2 = false;
                if (!CollectionsKt.plus((Collection)LASAllowedFiles.INSTANCE.getLZ4_FILES(), (Iterable)LASAllowedFiles.INSTANCE.getNON_LZ4_FILES()).contains(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
            boolean bl3 = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                it = (File)element$iv;
                boolean bl4 = false;
                FileInputStream inputStream = new FileInputStream(it);
                inputStream.close();
            }
            bl = true;
        }
        catch (IOException e) {
            log.info("Failed to read file: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    private final boolean containsRequiredFileForLz4(List<String> filenames) {
        return !(!filenames.contains("entities.xml") && !filenames.contains("entities.xml.lz4") || !filenames.contains("activeobjects.xml") && !filenames.contains("activeobjects.xml.lz4"));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<DuplicatedFile> getDuplicatedFiles(@NotNull List<String> filenames) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        boolean bl;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(filenames, (String)"filenames");
        Iterable $this$groupBy$iv = filenames;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean bl2 = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)t;
            bl = false;
            String key$iv$iv = StringsKt.substringBefore$default((String)it, (String)".", null, (int)2, null);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        Map result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List it = (List)entry.getValue();
            boolean bl3 = false;
            if (!(it.size() > 1)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        Map $this$map$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean bl4 = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            Object element$iv32;
            String string;
            Object object;
            block8: {
                Object element$iv222;
                void entry2;
                block7: {
                    list$iv$iv = entry;
                    object = destination$iv$iv;
                    bl = false;
                    Iterable $this$first$iv = (Iterable)entry2.getValue();
                    boolean $i$f$first = false;
                    for (Object element$iv222 : $this$first$iv) {
                        String it = (String)element$iv222;
                        boolean bl3 = false;
                        if (!LASAllowedFiles.INSTANCE.getNON_LZ4_FILES().contains(it)) continue;
                        break block7;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                string = (String)element$iv222;
                Iterable $this$first$iv = (Iterable)entry2.getValue();
                boolean $i$f$first = false;
                for (Object element$iv32 : $this$first$iv) {
                    String it = (String)element$iv32;
                    boolean bl5 = false;
                    if (!LASAllowedFiles.INSTANCE.getLZ4_FILES().contains(it)) continue;
                    break block8;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            String string2 = (String)element$iv32;
            object.add(new DuplicatedFile(string2, string));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasEmptyFiles(List<? extends File> files) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = files;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                if (!CollectionsKt.plus((Collection)LASAllowedFiles.INSTANCE.getLZ4_FILES(), (Iterable)LASAllowedFiles.INSTANCE.getNON_LZ4_FILES()).contains(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    File it = (File)element$iv;
                    boolean bl3 = false;
                    if (!(Files.size(it.toPath()) == 0L)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsRequiredFiles(List<? extends ZipArchiveEntry> zipFiles) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = zipFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Object[] objectArray = new String[]{"activeobjects.xml", "entities.xml"};
        return ((List)destination$iv$iv).containsAll(CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean filesAreEmpty(List<? extends ZipArchiveEntry> zipFiles) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = zipFiles;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ZipArchiveEntry it = (ZipArchiveEntry)element$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"activeobjects.xml") || Intrinsics.areEqual((Object)it.getName(), (Object)"entities.xml"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ZipArchiveEntry it = (ZipArchiveEntry)element$iv;
                    boolean bl3 = false;
                    if (!(it.getSize() == 0L)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/liftandshift/ManualInterventionValidator$Companion;", "", "()V", "EMPTY_ARCHIVE_ZIP_MAGIC_BYTES", "", "ZIP_MAGIC_BYTES", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

