/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.usergroup;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.jira.migration.common.PaginatedList;
import com.atlassian.jira.migration.db.CwdUserAttributesTable;
import com.atlassian.jira.migration.db.CwdUserTable;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraDirectoryService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroup;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 &2\u00020\u0001:\u0002&'B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u001c\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J&\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J1\u0010\"\u001a\b\u0012\u0004\u0012\u0002H#0\u0015\"\u0004\b\u0000\u0010#2\u0006\u0010\u0016\u001a\u00020\u000b2\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\u00150%H\u0082\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService;", "", "directoryManager", "Lcom/atlassian/crowd/manager/directory/DirectoryManager;", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/crowd/manager/directory/DirectoryManager;Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "activeDirectories", "Lkotlin/sequences/Sequence;", "", "getActiveDirectories", "()Lkotlin/sequences/Sequence;", "allGroups", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroup;", "limitPerPage", "", "allUsers", "Lcom/atlassian/crowd/embedded/api/User;", "fetchGroups", "", "directoryId", "offset", "limit", "fetchJiraUserDetails", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService$JiraUserDetailsQueryResult;", "emails", "", "", "fetchUsersWithAttributes", "Lcom/atlassian/crowd/model/user/UserWithAttributes;", "fetchUsersWithAttributesImproved", "search", "T", "block", "Lkotlin/Function0;", "Companion", "JiraUserDetailsQueryResult", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraDirectoryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraDirectoryService.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n148#1,11:190\n148#1,11:205\n148#1,11:216\n1#2:189\n1549#3:201\n1620#3,3:202\n1549#3:227\n1620#3,3:228\n*S KotlinDebug\n*F\n+ 1 JiraDirectoryService.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService\n*L\n56#1:190,11\n95#1:205,11\n104#1:216,11\n56#1:201\n56#1:202,3\n168#1:227\n168#1:228,3\n*E\n"})
public final class JiraDirectoryService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DirectoryManager directoryManager;
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final Logger log = LoggerFactory.getLogger(JiraDirectoryService.class);
    @NotNull
    private static final String SERVICE_DESK_REQUESTOR = "synch.servicedesk.requestor";

    @Inject
    public JiraDirectoryService(@NotNull DirectoryManager directoryManager, @NotNull DatabaseAccessor databaseAccessor, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)directoryManager, (String)"directoryManager");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.directoryManager = directoryManager;
        this.databaseAccessor = databaseAccessor;
        this.migrationFeatures = migrationFeatures;
    }

    private final Sequence<Long> getActiveDirectories() {
        List list = this.directoryManager.findAllDirectories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllDirectories(...)");
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)activeDirectories.1.INSTANCE), (Function1)activeDirectories.2.INSTANCE);
    }

    @NotNull
    public final Sequence<JiraGroup> allGroups(int limitPerPage) {
        if (!(limitPerPage > 0)) {
            boolean bl = false;
            String string = "limitPerPage must be greater than zero";
            throw new IllegalArgumentException(string.toString());
        }
        return SequencesKt.flatMap((Sequence)SequencesKt.flatMap(this.getActiveDirectories(), (Function1)((Function1)new Function1<Long, Sequence<? extends PaginatedList<JiraGroup>>>(limitPerPage, this){
            final /* synthetic */ int $limitPerPage;
            final /* synthetic */ JiraDirectoryService this$0;
            {
                this.$limitPerPage = $limitPerPage;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<PaginatedList<JiraGroup>> invoke(long it) {
                return SequencesKt.asSequence(PaginatedList.Companion.fetchByPage(this.$limitPerPage, (Function2)new Function2<Integer, Integer, Collection<? extends JiraGroup>>(this.this$0, it){
                    final /* synthetic */ JiraDirectoryService this$0;
                    final /* synthetic */ long $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2);
                    }

                    @NotNull
                    public final Collection<JiraGroup> invoke(int offset, int limit) {
                        return JiraDirectoryService.access$fetchGroups(this.this$0, this.$it, offset, limit);
                    }
                }));
            }
        })), (Function1)allGroups.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<JiraGroup> fetchGroups(long directoryId, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        Object this_$iv;
        block4: {
            EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt(offset).returningAtMost(limit);
            this_$iv = this;
            boolean $i$f$search = false;
            try {
                boolean bl = false;
                List list = this.directoryManager.searchGroups(directoryId, query);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"searchGroups(...)");
                collection = list;
                break block4;
            }
            catch (DirectoryNotFoundException e$iv) {
                log.warn("Directory Not Found for id '" + directoryId + '\'', (Throwable)e$iv);
            }
            catch (OperationFailedException e$iv) {
                log.error("Operation Failed for directory id '" + directoryId + '\'', (Throwable)e$iv);
            }
            collection = CollectionsKt.emptyList();
        }
        this_$iv = collection;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(new JiraGroup((String)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Sequence<User> allUsers(int limitPerPage) {
        if (!(limitPerPage > 0)) {
            boolean bl = false;
            String string = "limitPerPage must be greater than zero";
            throw new IllegalArgumentException(string.toString());
        }
        return SequencesKt.flatMap((Sequence)SequencesKt.flatMap(this.getActiveDirectories(), (Function1)((Function1)new Function1<Long, Sequence<? extends PaginatedList<UserWithAttributes>>>(limitPerPage, this){
            final /* synthetic */ int $limitPerPage;
            final /* synthetic */ JiraDirectoryService this$0;
            {
                this.$limitPerPage = $limitPerPage;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<PaginatedList<UserWithAttributes>> invoke(long directory) {
                return SequencesKt.asSequence(PaginatedList.Companion.fetchByPage(this.$limitPerPage, (Function2)new Function2<Integer, Integer, Collection<? extends UserWithAttributes>>(directory, this.this$0){
                    final /* synthetic */ long $directory;
                    final /* synthetic */ JiraDirectoryService this$0;
                    {
                        this.$directory = $directory;
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final Collection<UserWithAttributes> invoke(int offset, int limit) {
                        JiraDirectoryService.access$getLog$cp().info("Fetching users for directoryId: " + this.$directory + ", offset: " + offset + ", limit: " + limit);
                        Collection fetchedUsers = JiraDirectoryService.access$fetchUsersWithAttributes(this.this$0, this.$directory, offset, limit);
                        JiraDirectoryService.access$getLog$cp().info("Fetched " + fetchedUsers.size() + " users for offset: " + offset + ", limit: " + limit);
                        return fetchedUsers;
                    }
                }));
            }
        })), (Function1)allUsers.3.INSTANCE);
    }

    private final Collection<UserWithAttributes> fetchUsersWithAttributes(long directoryId, int offset, int limit) {
        Collection collection;
        block5: {
            if (this.migrationFeatures.getEnableOptimisedUserFetch()) {
                collection = this.fetchUsersWithAttributesImproved(directoryId, offset, limit);
            } else {
                EntityQuery query = QueryBuilder.queryFor(UserWithAttributes.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(offset).returningAtMost(limit);
                JiraDirectoryService this_$iv = this;
                boolean $i$f$search = false;
                try {
                    boolean bl = false;
                    List list = this.directoryManager.searchUsers(directoryId, query);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"searchUsers(...)");
                    collection = list;
                    break block5;
                }
                catch (DirectoryNotFoundException e$iv) {
                    log.warn("Directory Not Found for id '" + directoryId + '\'', (Throwable)e$iv);
                }
                catch (OperationFailedException e$iv) {
                    log.error("Operation Failed for directory id '" + directoryId + '\'', (Throwable)e$iv);
                }
                collection = CollectionsKt.emptyList();
            }
        }
        return collection;
    }

    private final Collection<UserWithAttributes> fetchUsersWithAttributesImproved(long directoryId, int offset, int limit) {
        Collection collection;
        block3: {
            EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(offset).returningAtMost(limit);
            JiraDirectoryService this_$iv = this;
            boolean $i$f$search = false;
            try {
                boolean bl = false;
                List list = this.directoryManager.searchUsers(directoryId, query);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"searchUsers(...)");
                collection = list;
                break block3;
            }
            catch (DirectoryNotFoundException e$iv) {
                log.warn("Directory Not Found for id '" + directoryId + '\'', (Throwable)e$iv);
            }
            catch (OperationFailedException e$iv) {
                log.error("Operation Failed for directory id '" + directoryId + '\'', (Throwable)e$iv);
            }
            collection = CollectionsKt.emptyList();
        }
        Collection userBatch = collection;
        List userNames2 = userBatch.stream().map(arg_0 -> JiraDirectoryService.fetchUsersWithAttributesImproved$lambda$5(fetchUsersWithAttributesImproved.userNames.1.INSTANCE, arg_0)).collect(Collectors.toList());
        Set userWithServiceDeskUserWithAttribute = (Set)this.databaseAccessor.run(arg_0 -> JiraDirectoryService.fetchUsersWithAttributesImproved$lambda$6(directoryId, userNames2, arg_0), OnRollback.NOOP);
        List list = userBatch.stream().map(arg_0 -> JiraDirectoryService.fetchUsersWithAttributesImproved$lambda$7((Function1)new Function1<User, UserTemplateWithAttributes>((Set<String>)userWithServiceDeskUserWithAttribute){
            final /* synthetic */ Set<String> $userWithServiceDeskUserWithAttribute;
            {
                this.$userWithServiceDeskUserWithAttribute = $userWithServiceDeskUserWithAttribute;
                super(1);
            }

            public final UserTemplateWithAttributes invoke(User u) {
                UserTemplateWithAttributes userWithAttributes = UserTemplateWithAttributes.toUserWithNoAttributes((User)u);
                if (this.$userWithServiceDeskUserWithAttribute.contains(u.getName())) {
                    userWithAttributes.setAttribute("synch.servicedesk.requestor", "true");
                }
                return userWithAttributes;
            }
        }, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    private final <T> Collection<T> search(long directoryId, Function0<? extends Collection<? extends T>> block) {
        boolean $i$f$search = false;
        try {
            return (Collection)block.invoke();
        }
        catch (DirectoryNotFoundException e) {
            log.warn("Directory Not Found for id '" + directoryId + '\'', (Throwable)e);
        }
        catch (OperationFailedException e) {
            log.error("Operation Failed for directory id '" + directoryId + '\'', (Throwable)e);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final List<JiraUserDetailsQueryResult> fetchJiraUserDetails(@NotNull Set<String> emails) {
        Intrinsics.checkNotNullParameter(emails, (String)"emails");
        Object object = this.databaseAccessor.run(arg_0 -> JiraDirectoryService.fetchJiraUserDetails$lambda$9(emails, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    private static final String fetchUsersWithAttributesImproved$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Set fetchUsersWithAttributesImproved$lambda$6(long $directoryId, List $userNames, DatabaseConnection db) {
        CloseableIterator closeableIterator = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)CwdUserTable.Companion.getCWD_USER_TABLE().getLowerUserName()).from((Expression)CwdUserTable.Companion.getCWD_USER_TABLE())).join((EntityPath)CwdUserAttributesTable.Companion.getCWD_USER_ATTRIBUTES_TABLE())).on((Predicate)CwdUserAttributesTable.Companion.getCWD_USER_ATTRIBUTES_TABLE().getUserId().eq((Expression)CwdUserTable.Companion.getCWD_USER_TABLE().getUserId()))).where((Predicate)CwdUserAttributesTable.Companion.getCWD_USER_ATTRIBUTES_TABLE().getDirectoryId().eq((Object)$directoryId).and((Predicate)CwdUserAttributesTable.Companion.getCWD_USER_ATTRIBUTES_TABLE().getAttributeName().eq((Object)SERVICE_DESK_REQUESTOR)).and((Predicate)CwdUserAttributesTable.Companion.getCWD_USER_ATTRIBUTES_TABLE().getAttributeValue().equalsIgnoreCase("true")).and((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getLowerUserName().in((Collection)$userNames)))).iterate();
        Intrinsics.checkNotNullExpressionValue((Object)closeableIterator, (String)"iterate(...)");
        return SequencesKt.toSet((Sequence)SequencesKt.asSequence((Iterator)((Iterator)closeableIterator)));
    }

    private static final UserTemplateWithAttributes fetchUsersWithAttributesImproved$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (UserTemplateWithAttributes)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchJiraUserDetails$lambda$9(Set $emails, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$emails, (String)"$emails");
        Expression[] expressionArray = new Expression[]{CwdUserTable.Companion.getCWD_USER_TABLE().getCREATED_DATE(), CwdUserTable.Companion.getCWD_USER_TABLE().getUPDATED_DATE()};
        List list = ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)CwdUserTable.Companion.getCWD_USER_TABLE())).where((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getEmailAddress().in((Collection)$emails))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JiraUserDetailsQueryResult((Timestamp)it.get((Expression)CwdUserTable.Companion.getCWD_USER_TABLE().getCREATED_DATE()), (Timestamp)it.get((Expression)CwdUserTable.Companion.getCWD_USER_TABLE().getUPDATED_DATE())));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ Collection access$fetchGroups(JiraDirectoryService $this, long directoryId, int offset, int limit) {
        return $this.fetchGroups(directoryId, offset, limit);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ Collection access$fetchUsersWithAttributes(JiraDirectoryService $this, long directoryId, int offset, int limit) {
        return $this.fetchUsersWithAttributes(directoryId, offset, limit);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService$Companion;", "", "()V", "SERVICE_DESK_REQUESTOR", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService$JiraUserDetailsQueryResult;", "", "createdDate", "Ljava/sql/Timestamp;", "updatedDate", "(Ljava/sql/Timestamp;Ljava/sql/Timestamp;)V", "getCreatedDate", "()Ljava/sql/Timestamp;", "getUpdatedDate", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class JiraUserDetailsQueryResult {
        @Nullable
        private final Timestamp createdDate;
        @Nullable
        private final Timestamp updatedDate;

        public JiraUserDetailsQueryResult(@Nullable Timestamp createdDate, @Nullable Timestamp updatedDate) {
            this.createdDate = createdDate;
            this.updatedDate = updatedDate;
        }

        @Nullable
        public final Timestamp getCreatedDate() {
            return this.createdDate;
        }

        @Nullable
        public final Timestamp getUpdatedDate() {
            return this.updatedDate;
        }

        @Nullable
        public final Timestamp component1() {
            return this.createdDate;
        }

        @Nullable
        public final Timestamp component2() {
            return this.updatedDate;
        }

        @NotNull
        public final JiraUserDetailsQueryResult copy(@Nullable Timestamp createdDate, @Nullable Timestamp updatedDate) {
            return new JiraUserDetailsQueryResult(createdDate, updatedDate);
        }

        public static /* synthetic */ JiraUserDetailsQueryResult copy$default(JiraUserDetailsQueryResult jiraUserDetailsQueryResult, Timestamp timestamp, Timestamp timestamp2, int n, Object object) {
            if ((n & 1) != 0) {
                timestamp = jiraUserDetailsQueryResult.createdDate;
            }
            if ((n & 2) != 0) {
                timestamp2 = jiraUserDetailsQueryResult.updatedDate;
            }
            return jiraUserDetailsQueryResult.copy(timestamp, timestamp2);
        }

        @NotNull
        public String toString() {
            return "JiraUserDetailsQueryResult(createdDate=" + this.createdDate + ", updatedDate=" + this.updatedDate + ')';
        }

        public int hashCode() {
            int result2 = this.createdDate == null ? 0 : this.createdDate.hashCode();
            result2 = result2 * 31 + (this.updatedDate == null ? 0 : this.updatedDate.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JiraUserDetailsQueryResult)) {
                return false;
            }
            JiraUserDetailsQueryResult jiraUserDetailsQueryResult = (JiraUserDetailsQueryResult)other;
            if (!Intrinsics.areEqual((Object)this.createdDate, (Object)jiraUserDetailsQueryResult.createdDate)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.updatedDate, (Object)jiraUserDetailsQueryResult.updatedDate);
        }
    }
}

