/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.usergroup;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.CompanyUserRecognitionAlgorithm;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraGroupManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.GroupProductAccess;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroup;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserFilter;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserPluginWrapper;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.net.InternetDomainName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ.\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0007J&\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u00102\u0006\u0010\u0019\u001a\u00020\u0013J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0019\u001a\u00020\u0013H\u0007J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0017H\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0011J\u000e\u0010(\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0011J \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u00102\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00170+J:\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u00102\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u00160\u00122\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter;", "", "jiraGroupManager", "Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "globalPermissionManager", "Lcom/atlassian/jira/security/GlobalPermissionManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/sal/api/ApplicationProperties;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/security/GlobalPermissionManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "buildDomainMatchingPredicate", "Lkotlin/Function1;", "Lcom/atlassian/crowd/embedded/api/User;", "", "Lcom/atlassian/jira/migration/common/CompanyUserRecognitionAlgorithm;", "", "validDomainNames", "", "", "doesUserEmailDomainBelongToCompany", "companyUserRecognitionAlgorithm", "getAllAdminEmails", "", "getAllValidDomainsNames", "getCloudSiteURLs", "getEmailDomain", "email", "getLowestLevelEmailDomain", "getServerURL", "getSiteAdminEmail", "getTopPrivateDomain", "domain", "getTopPrivateEmailDomain", "hasNoServiceDeskCustomerFlag", "user", "hasServiceDeskCustomerFlag", "isInGroups", "groups", "", "isInGroupsContainingAccess", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroup;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/GroupProductAccess;", "groupProductAccess", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraUserFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraUserFilter.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1360#2:201\n1446#2,5:202\n1549#2:207\n1620#2,3:208\n1747#2,3:214\n1549#2:221\n1620#2,3:222\n1620#2,3:225\n1603#2,9:228\n1855#2:237\n1856#2:239\n1612#2:240\n1360#2:241\n1446#2,5:242\n766#2:247\n857#2,2:248\n1549#2:250\n1620#2,3:251\n766#2:254\n857#2,2:255\n1549#2:257\n1620#2,3:258\n526#3:211\n511#3,2:212\n513#3,4:217\n1#4:238\n*S KotlinDebug\n*F\n+ 1 JiraUserFilter.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter\n*L\n66#1:201\n66#1:202,5\n67#1:207\n67#1:208,3\n73#1:214,3\n73#1:221\n73#1:222,3\n114#1:225,3\n171#1:228,9\n171#1:237\n171#1:239\n171#1:240\n172#1:241\n172#1:242,5\n173#1:247\n173#1:248,2\n174#1:250\n174#1:251,3\n183#1:254\n183#1:255,2\n184#1:257\n184#1:258,3\n73#1:211\n73#1:212,2\n73#1:217,4\n171#1:238\n*E\n"})
public final class JiraUserFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraGroupManager jiraGroupManager;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final GlobalPermissionManager globalPermissionManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    public static final String SYNCH_SERVICEDESK_REQUESTOR = "synch.servicedesk.requestor";
    private static final Logger log = LoggerFactory.getLogger(JiraUserFilter.class);
    public static final int OLDEST_BUILD_NUMBER_WITH_FIXED_MEMBERSHIP_QUERIES = 814000;

    @Inject
    public JiraUserFilter(@NotNull JiraGroupManager jiraGroupManager, @NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull ApplicationProperties applicationProperties, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull GlobalPermissionManager globalPermissionManager, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)jiraGroupManager, (String)"jiraGroupManager");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)globalPermissionManager, (String)"globalPermissionManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.jiraGroupManager = jiraGroupManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.applicationProperties = applicationProperties;
        this.cloudSiteRepository = cloudSiteRepository;
        this.globalPermissionManager = globalPermissionManager;
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    public final Function1<User, Map<CompanyUserRecognitionAlgorithm, Boolean>> doesUserEmailDomainBelongToCompany(@NotNull CompanyUserRecognitionAlgorithm companyUserRecognitionAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)companyUserRecognitionAlgorithm), (String)"companyUserRecognitionAlgorithm");
        Set<String> validDomainNames = this.getAllValidDomainsNames(companyUserRecognitionAlgorithm);
        return this.buildDomainMatchingPredicate(validDomainNames);
    }

    @VisibleForTesting
    @NotNull
    public final Function1<User, Map<CompanyUserRecognitionAlgorithm, Boolean>> buildDomainMatchingPredicate(@NotNull Set<String> validDomainNames) {
        Intrinsics.checkNotNullParameter(validDomainNames, (String)"validDomainNames");
        return (Function1)new Function1<User, Map<CompanyUserRecognitionAlgorithm, ? extends Boolean>>(this, validDomainNames){
            final /* synthetic */ JiraUserFilter this$0;
            final /* synthetic */ Set<String> $validDomainNames;
            {
                this.this$0 = $receiver;
                this.$validDomainNames = $validDomainNames;
                super(1);
            }

            @NotNull
            public final Map<CompanyUserRecognitionAlgorithm, Boolean> invoke(@NotNull User user) {
                Map map;
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                Pair[] pairArray = (Pair[])user.getEmailAddress();
                if (pairArray == null || StringsKt.isBlank((CharSequence)pairArray)) {
                    pairArray = new Pair[]{TuplesKt.to((Object)((Object)CompanyUserRecognitionAlgorithm.LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH), (Object)false), TuplesKt.to((Object)((Object)CompanyUserRecognitionAlgorithm.DOMAIN_AND_SUBDOMAINS_MATCH), (Object)false)};
                    map = MapsKt.mapOf((Pair[])pairArray);
                } else {
                    String string = IdentityAcceptedEmailValidator.cleanse((String)user.getEmailAddress());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanse(...)");
                    String string2 = string;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    String string3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    String lowerCasedUserEmail = string3;
                    String userDomainName = JiraUserFilter.access$getLowestLevelEmailDomain(this.this$0, lowerCasedUserEmail);
                    String userDomain = JiraUserFilter.access$getTopPrivateEmailDomain(this.this$0, lowerCasedUserEmail);
                    Regex pattern = new Regex(".*" + userDomainName + ".*");
                    boolean initialAlgorithmAnswer2 = this.$validDomainNames.stream().anyMatch(arg_0 -> buildDomainMatchingPredicate.1.invoke$lambda$0((Function1)new Function1<String, Boolean>(pattern){
                        final /* synthetic */ Regex $pattern;
                        {
                            this.$pattern = $pattern;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(String it) {
                            Intrinsics.checkNotNull((Object)it);
                            CharSequence charSequence = it;
                            return this.$pattern.matches(charSequence);
                        }
                    }, arg_0));
                    boolean newAlgorithmAnswer2 = this.$validDomainNames.stream().anyMatch(arg_0 -> buildDomainMatchingPredicate.1.invoke$lambda$1((Function1)new Function1<String, Boolean>(userDomain){
                        final /* synthetic */ String $userDomain;
                        {
                            this.$userDomain = $userDomain;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(String it) {
                            Intrinsics.checkNotNull((Object)it);
                            return StringsKt.endsWith$default((String)it, (String)this.$userDomain, (boolean)false, (int)2, null);
                        }
                    }, arg_0));
                    Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)CompanyUserRecognitionAlgorithm.LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH), (Object)initialAlgorithmAnswer2), TuplesKt.to((Object)((Object)CompanyUserRecognitionAlgorithm.DOMAIN_AND_SUBDOMAINS_MATCH), (Object)newAlgorithmAnswer2)};
                    map = MapsKt.mapOf((Pair[])pairArray2);
                }
                return map;
            }

            private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Function1<User, Boolean> isInGroups(@NotNull Collection<String> groups2) {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Iterable $this$flatMap$iv = groups2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.jiraGroupManager.getUsersInGroup(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ApplicationUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set results2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return (Function1)new Function1<User, Boolean>((Set<String>)results2){
            final /* synthetic */ Set<String> $results;
            {
                this.$results = $results;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull User user) {
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                return this.$results.contains(user.getName());
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Function1<User, Boolean> isInGroupsContainingAccess(@NotNull Map<JiraGroup, ? extends Set<? extends GroupProductAccess>> groups, @NotNull Set<? extends GroupProductAccess> groupProductAccess) {
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter(groupProductAccess, (String)"groupProductAccess");
        var3_3 = groups;
        var18_4 = this;
        $i$f$filter = false;
        var5_6 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            block7: {
                it = element$iv$iv;
                $i$a$-filter-JiraUserFilter$isInGroupsContainingAccess$1 = false;
                if (((Set)it.getValue()).contains((Object)GroupProductAccess.NO_ACCESS)) ** GOTO lbl-1000
                $this$any$iv = (Iterable)it.getValue();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        p0 = (GroupProductAccess)element$iv;
                        $i$a$-any-JiraUserFilter$isInGroupsContainingAccess$1$1 = false;
                        if (!groupProductAccess.contains((Object)p0)) continue;
                        v0 = true;
                        break block7;
                    }
                    v0 = false;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv.keySet();
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Map.Entry<K, V> item$iv$iv : $this$mapTo$iv$iv) {
            it = (JiraGroup)item$iv$iv;
            var19_19 = destination$iv$iv;
            $i$a$-map-JiraUserFilter$isInGroupsContainingAccess$2 = false;
            var19_19.add(it.getName());
        }
        return var18_4.isInGroups((List)destination$iv$iv);
    }

    public final boolean hasNoServiceDeskCustomerFlag(@NotNull User user) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        User user2 = user;
        if (user2 instanceof UserWithAttributes) {
            String string = ((UserWithAttributes)user).getValue(SYNCH_SERVICEDESK_REQUESTOR);
            bl = string != null ? !Boolean.parseBoolean(string) : true;
        } else if (user2 instanceof UserPluginWrapper) {
            if (((UserPluginWrapper)user).getUser() instanceof UserWithAttributes) {
                String string = ((UserWithAttributes)((UserPluginWrapper)user).getUser()).getValue(SYNCH_SERVICEDESK_REQUESTOR);
                bl = string != null ? !Boolean.parseBoolean(string) : true;
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean hasServiceDeskCustomerFlag(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return !this.hasNoServiceDeskCustomerFlag(user);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Set<String> getAllValidDomainsNames(@NotNull CompanyUserRecognitionAlgorithm companyUserRecognitionAlgorithm) {
        void destination$iv;
        void $this$mapTo$iv;
        String siteAdminEmail;
        Intrinsics.checkNotNullParameter((Object)((Object)companyUserRecognitionAlgorithm), (String)"companyUserRecognitionAlgorithm");
        Set domainNameList = new LinkedHashSet();
        if (!this.migrationFeatures.getEnableCustomerIdentificationImprovements()) {
            String serverURL = this.getServerURL(companyUserRecognitionAlgorithm);
            if (StringExtensionsKt.isNotNullOrBlank(serverURL)) {
                String string = serverURL;
                Intrinsics.checkNotNull((Object)string);
                domainNameList.add(string);
            }
            List<String> cloudSiteURLs = this.getCloudSiteURLs(companyUserRecognitionAlgorithm);
            domainNameList.addAll((Collection)cloudSiteURLs);
        }
        if (StringExtensionsKt.isNotNullOrBlank(siteAdminEmail = this.getSiteAdminEmail())) {
            String string = siteAdminEmail;
            Intrinsics.checkNotNull((Object)string);
            domainNameList.add(string);
        }
        List<String> allAdminEmails = this.getAllAdminEmails(companyUserRecognitionAlgorithm);
        domainNameList.addAll((Collection)allAdminEmails);
        Iterable iterable = domainNameList;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            String string;
            void it;
            String string2 = (String)item$iv;
            void var13_13 = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)IdentityAcceptedEmailValidator.cleanse((String)it), (String)"cleanse(...)");
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            var13_13.add(string3);
        }
        return (Set)destination$iv;
    }

    private final String getServerURL(CompanyUserRecognitionAlgorithm companyUserRecognitionAlgorithm) {
        String string = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseUrl(...)");
        String serverUrl = string;
        if (StringExtensionsKt.isNotNullOrBlank(serverUrl)) {
            String string2;
            switch (WhenMappings.$EnumSwitchMapping$0[companyUserRecognitionAlgorithm.ordinal()]) {
                case 1: {
                    string2 = this.getTopPrivateDomain(serverUrl);
                    break;
                }
                case 2: {
                    string2 = serverUrl;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string2;
        }
        return null;
    }

    private final String getSiteAdminEmail() {
        String siteAdminEmail;
        if (this.jiraAuthenticationContext.getLoggedInUser() != null && StringExtensionsKt.isNotNullOrBlank(siteAdminEmail = this.jiraAuthenticationContext.getLoggedInUser().getEmailAddress())) {
            Intrinsics.checkNotNull((Object)siteAdminEmail);
            String[] stringArray = new String[]{"@"};
            List siteAdminEmailSplit = StringsKt.split$default((CharSequence)siteAdminEmail, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (siteAdminEmailSplit.size() - 1 > 0) {
                return (String)siteAdminEmailSplit.get(siteAdminEmailSplit.size() - 1);
            }
        }
        return null;
    }

    private final String getEmailDomain(String email) {
        String[] stringArray = new String[]{"@"};
        List emailSplit = StringsKt.split$default((CharSequence)email, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return (String)emailSplit.get(emailSplit.size() - 1);
    }

    private final String getTopPrivateEmailDomain(String email) {
        String emailDomain = this.getEmailDomain(email);
        return this.getTopPrivateDomain(emailDomain);
    }

    private final String getTopPrivateDomain(String domain) {
        String string;
        try {
            string = InternetDomainName.from((String)domain).topPrivateDomain().toString();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            log.warn("Could not get top private domain for: " + domain, (Throwable)e);
            string = domain;
        }
        return string;
    }

    private final String getLowestLevelEmailDomain(String email) {
        String[] stringArray = new String[]{"@"};
        List emailSplit = StringsKt.split$default((CharSequence)email, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String domainName = (String)emailSplit.get(emailSplit.size() - 1);
        String[] stringArray2 = new String[]{"."};
        List domainNameSplit = StringsKt.split$default((CharSequence)domainName, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        return (String)domainNameSplit.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAllAdminEmails(CompanyUserRecognitionAlgorithm companyUserRecognitionAlgorithm) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Collection collection = this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.SYSTEM_ADMIN);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getGroupsWithPermission(...)");
        Iterable $this$mapNotNull$iv = CollectionsKt.filterNotNull((Iterable)collection);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Group it2 = (Group)element$iv$iv;
            boolean bl2 = false;
            if (it2.getName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.jiraGroupManager.getUsersInGroup(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ApplicationUser)element$iv$iv;
            boolean bl = false;
            if (!StringExtensionsKt.isNotNullOrBlank(it.getEmailAddress())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            it = (ApplicationUser)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[companyUserRecognitionAlgorithm.ordinal()]) {
                case 2: {
                    String string2 = it.getEmailAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEmailAddress(...)");
                    string = this.getLowestLevelEmailDomain(string2);
                    break;
                }
                case 1: {
                    String string3 = it.getEmailAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getEmailAddress(...)");
                    string = this.getEmailDomain(string3);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection2.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getCloudSiteURLs(CompanyUserRecognitionAlgorithm companyUserRecognitionAlgorithm) {
        void $this$mapTo$iv$iv;
        CloudSite it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.cloudSiteRepository.findAll();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CloudSite)element$iv$iv;
            boolean bl = false;
            if (!StringExtensionsKt.isNotNullOrBlank(it.getCloudUrl().getHost())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            it = (CloudSite)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[companyUserRecognitionAlgorithm.ordinal()]) {
                case 2: {
                    String string2 = it.getCloudUrl().getHost();
                    string = string2;
                    Intrinsics.checkNotNull((Object)string2);
                    break;
                }
                case 1: {
                    String string3 = it.getCloudUrl().getHost();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHost(...)");
                    string = this.getTopPrivateDomain(string3);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(string);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public static final /* synthetic */ String access$getLowestLevelEmailDomain(JiraUserFilter $this, String email) {
        return $this.getLowestLevelEmailDomain(email);
    }

    public static final /* synthetic */ String access$getTopPrivateEmailDomain(JiraUserFilter $this, String email) {
        return $this.getTopPrivateEmailDomain(email);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter$Companion;", "", "()V", "OLDEST_BUILD_NUMBER_WITH_FIXED_MEMBERSHIP_QUERIES", "", "SYNCH_SERVICEDESK_REQUESTOR", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompanyUserRecognitionAlgorithm.values().length];
            try {
                nArray[CompanyUserRecognitionAlgorithm.DOMAIN_AND_SUBDOMAINS_MATCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompanyUserRecognitionAlgorithm.LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

