/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.usergroup;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.migration.db.CwdDirectoryTable;
import com.atlassian.jira.migration.db.CwdUserTable;
import com.atlassian.jira.migration.db.UserNameEmailData;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.jira.migration.jiraservice.JiraGroupManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraDirectoryService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserReader;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u001d\u001a\u00020\u0013R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserReader;", "", "jiraDirectoryService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "projectRoleManager", "Lcom/atlassian/jira/security/roles/ProjectRoleManager;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "jiraGroupManager", "Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/security/roles/ProjectRoleManager;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/jiraservice/JiraGroupManager;Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "allUsers", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/crowd/embedded/api/User;", "fetchAllCollaborators", "", "getAllUserNameEmails", "", "Lcom/atlassian/jira/migration/db/UserNameEmailData;", "getEmailsByUsernames", "usernames", "mapRoleActorToUserName", "roleActor", "Lcom/atlassian/jira/security/roles/RoleActor;", "mapUserRoleActorToUserName", "userRoleActorParameter", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraUserReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraUserReader.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1549#2:131\n1620#2,3:132\n1549#2:136\n1620#2,3:137\n1549#2:140\n1620#2,3:141\n1#3:135\n*S KotlinDebug\n*F\n+ 1 JiraUserReader.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserReader\n*L\n72#1:131\n72#1:132,3\n94#1:136\n94#1:137,3\n117#1:140\n117#1:141,3\n*E\n"})
public final class JiraUserReader {
    @NotNull
    private final JiraDirectoryService jiraDirectoryService;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final ProjectRoleManager projectRoleManager;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final JiraGroupManager jiraGroupManager;
    @NotNull
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public JiraUserReader(@NotNull JiraDirectoryService jiraDirectoryService, @NotNull ProjectManager projectManager, @NotNull ProjectRoleManager projectRoleManager, @NotNull UserManager userManager, @NotNull JiraGroupManager jiraGroupManager, @NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)jiraDirectoryService, (String)"jiraDirectoryService");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)projectRoleManager, (String)"projectRoleManager");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)jiraGroupManager, (String)"jiraGroupManager");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.jiraDirectoryService = jiraDirectoryService;
        this.projectManager = projectManager;
        this.projectRoleManager = projectRoleManager;
        this.userManager = userManager;
        this.jiraGroupManager = jiraGroupManager;
        this.databaseAccessor = databaseAccessor;
    }

    @NotNull
    public final Sequence<User> allUsers() {
        return SequencesKt.map((Sequence)SequencesKt.filter(this.jiraDirectoryService.allUsers(1000), (Function1)allUsers.1.INSTANCE), (Function1)allUsers.2.INSTANCE);
    }

    @NotNull
    public final Sequence<String> fetchAllCollaborators() {
        List list = this.projectManager.getProjects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProjects(...)");
        List allProjects = list;
        Collection allProjectRoles = this.projectRoleManager.getProjectRoles();
        return SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)allProjects), (Function1)((Function1)new Function1<Project, Sequence<? extends String>>((Collection<ProjectRole>)allProjectRoles, this){
            final /* synthetic */ Collection<ProjectRole> $allProjectRoles;
            final /* synthetic */ JiraUserReader this$0;
            {
                this.$allProjectRoles = $allProjectRoles;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<String> invoke(Project project) {
                Collection<ProjectRole> collection = this.$allProjectRoles;
                Intrinsics.checkNotNullExpressionValue(collection, (String)"$allProjectRoles");
                return SequencesKt.flatMapIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)fetchAllCollaborators.1.INSTANCE), (Function1)((Function1)new Function1<ProjectRole, ProjectRoleActors>(this.this$0, project){
                    final /* synthetic */ JiraUserReader this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    @Nullable
                    public final ProjectRoleActors invoke(ProjectRole it) {
                        return JiraUserReader.access$getProjectRoleManager$p(this.this$0).getProjectRoleActors(it, this.$project);
                    }
                })), (Function1)fetchAllCollaborators.3.INSTANCE), (Function1)fetchAllCollaborators.4.INSTANCE), (Function1)((Function1)new Function1<RoleActor, List<? extends String>>(this.this$0){
                    final /* synthetic */ JiraUserReader this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final List<String> invoke(RoleActor it) {
                        Intrinsics.checkNotNull((Object)it);
                        return this.this$0.mapRoleActorToUserName(it);
                    }
                }));
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> mapRoleActorToUserName(@NotNull RoleActor roleActor) {
        List list;
        Intrinsics.checkNotNullParameter((Object)roleActor, (String)"roleActor");
        String string = roleActor.getType();
        if (Intrinsics.areEqual((Object)string, (Object)"atlassian-user-role-actor")) {
            String string2 = roleActor.getParameter();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParameter(...)");
            list = this.mapUserRoleActorToUserName(string2);
        } else if (Intrinsics.areEqual((Object)string, (Object)"atlassian-group-role-actor")) {
            void $this$mapTo$iv$iv;
            String string3 = roleActor.getParameter();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getParameter(...)");
            Iterable $this$map$iv = this.jiraGroupManager.getUsersInGroup(string3);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ApplicationUser applicationUser = (ApplicationUser)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            throw new IllegalArgumentException("Unsupported Role Type " + roleActor.getType());
        }
        return list;
    }

    @NotNull
    public final List<String> mapUserRoleActorToUserName(@NotNull String userRoleActorParameter) {
        Object object;
        block5: {
            block4: {
                ApplicationUser appUser;
                Intrinsics.checkNotNullParameter((Object)userRoleActorParameter, (String)"userRoleActorParameter");
                ApplicationUser applicationUser = this.userManager.getUserByKey(userRoleActorParameter);
                if (applicationUser == null) {
                    applicationUser = this.userManager.getUserByName(userRoleActorParameter);
                }
                if ((object = (appUser = applicationUser)) == null) break block4;
                ApplicationUser it = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)it.getName());
                object = list;
                if (list != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<UserNameEmailData> getAllUserNameEmails() {
        Object object = this.databaseAccessor.run(JiraUserReader::getAllUserNameEmails$lambda$2, OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    @NotNull
    public final List<UserNameEmailData> getEmailsByUsernames(@NotNull List<String> usernames) {
        Intrinsics.checkNotNullParameter(usernames, (String)"usernames");
        Object object = this.databaseAccessor.run(arg_0 -> JiraUserReader.getEmailsByUsernames$lambda$4(usernames, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getAllUserNameEmails$lambda$2(DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new Expression[]{CwdUserTable.Companion.getCWD_USER_TABLE().getUserName(), CwdUserTable.Companion.getCWD_USER_TABLE().getEmailAddress(), CwdUserTable.Companion.getCWD_USER_TABLE().getActive()};
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])object).from((Expression)CwdUserTable.Companion.getCWD_USER_TABLE())).join((EntityPath)CwdDirectoryTable.Companion.getCWD_DIRECTORY_TABLE())).on((Predicate)CwdDirectoryTable.Companion.getCWD_DIRECTORY_TABLE().getId().eq((Expression)CwdUserTable.Companion.getCWD_USER_TABLE().getDirectoryId()))).where((Predicate)CwdDirectoryTable.Companion.getCWD_DIRECTORY_TABLE().getActive().eq((Object)1).and((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getUserName().isNotNull()).and((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getEmailAddress().isNotNull()))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = CwdUserTable.Companion.getCWD_USER_TABLE();
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CwdUserTable)((Object)object)).toUserNameEmail((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getEmailsByUsernames$lambda$4(List $usernames, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$usernames, (String)"$usernames");
        Object object = new Expression[]{CwdUserTable.Companion.getCWD_USER_TABLE().getUserName(), CwdUserTable.Companion.getCWD_USER_TABLE().getEmailAddress(), CwdUserTable.Companion.getCWD_USER_TABLE().getActive()};
        SQLQuery sQLQuery = (SQLQuery)db.select((Expression[])object).from((Expression)CwdUserTable.Companion.getCWD_USER_TABLE());
        StringPath stringPath = CwdUserTable.Companion.getCWD_USER_TABLE().getUserName();
        Intrinsics.checkNotNullExpressionValue((Object)stringPath, (String)"<get-userName>(...)");
        SimpleExpression simpleExpression = (SimpleExpression)stringPath;
        Collection collection = $usernames;
        Intrinsics.checkNotNull((Object)db);
        Iterable iterable = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)sQLQuery.where((Predicate)QuerydslHelpersKt.bigIn(simpleExpression, collection, db))).join((EntityPath)CwdDirectoryTable.Companion.getCWD_DIRECTORY_TABLE())).on((Predicate)CwdDirectoryTable.Companion.getCWD_DIRECTORY_TABLE().getId().eq((Expression)CwdUserTable.Companion.getCWD_USER_TABLE().getDirectoryId()))).where((Predicate)CwdDirectoryTable.Companion.getCWD_DIRECTORY_TABLE().getActive().eq((Object)1).and((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getUserName().isNotNull()).and((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getEmailAddress().isNotNull()))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        object = CwdUserTable.Companion.getCWD_USER_TABLE();
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((CwdUserTable)((Object)object)).toUserNameEmail((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ ProjectRoleManager access$getProjectRoleManager$p(JiraUserReader $this) {
        return $this.projectRoleManager;
    }
}

