/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.usergroup;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.migration.common.CompanyUserRecognitionAlgorithm;
import com.atlassian.jira.migration.events.JiraUserFilterAnalytics;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.serverdataextractors.usergroup.GroupProductAccess;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroup;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserFilter;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JsmCustomerReader;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010J4\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00102\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001a2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013J,\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;", "", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "jiraUserFilter", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter;", "jiraUserReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserReader;", "jiraGroupReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroupReader;", "jiraUserFilterAnalytics", "Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserReader;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroupReader;Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "getAllJsdCustomersAsApplicationUser", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/user/ApplicationUser;", "userInGroupWithAccessPredicate", "Lkotlin/Function1;", "Lcom/atlassian/crowd/embedded/api/User;", "", "allUsers", "getAllJsmCustomers", "", "allGroups", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroup;", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/GroupProductAccess;", "getAllJsmCustomersCount", "", "usersWithProductAccess", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsmCustomerReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsmCustomerReader.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1313#2:121\n1314#2:123\n1#3:122\n*S KotlinDebug\n*F\n+ 1 JsmCustomerReader.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader\n*L\n64#1:121\n64#1:123\n*E\n"})
public final class JsmCustomerReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final JiraUserFilter jiraUserFilter;
    @NotNull
    private final JiraUserReader jiraUserReader;
    @NotNull
    private final JiraGroupReader jiraGroupReader;
    @NotNull
    private final JiraUserFilterAnalytics jiraUserFilterAnalytics;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private static final Set<GroupProductAccess> groupProductAccessSet;
    private static final Logger log;

    @Inject
    public JsmCustomerReader(@NotNull UserManager userManager, @NotNull JiraUserFilter jiraUserFilter, @NotNull JiraUserReader jiraUserReader, @NotNull JiraGroupReader jiraGroupReader, @NotNull JiraUserFilterAnalytics jiraUserFilterAnalytics, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)jiraUserFilter, (String)"jiraUserFilter");
        Intrinsics.checkNotNullParameter((Object)jiraUserReader, (String)"jiraUserReader");
        Intrinsics.checkNotNullParameter((Object)jiraGroupReader, (String)"jiraGroupReader");
        Intrinsics.checkNotNullParameter((Object)jiraUserFilterAnalytics, (String)"jiraUserFilterAnalytics");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.userManager = userManager;
        this.jiraUserFilter = jiraUserFilter;
        this.jiraUserReader = jiraUserReader;
        this.jiraGroupReader = jiraGroupReader;
        this.jiraUserFilterAnalytics = jiraUserFilterAnalytics;
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    public final Sequence<String> getAllJsmCustomers() {
        return this.getAllJsmCustomers(this.jiraGroupReader.allGroups(), this.jiraUserReader.allUsers());
    }

    @NotNull
    public final Sequence<String> getAllJsmCustomers(@NotNull Sequence<? extends User> allUsers2) {
        Intrinsics.checkNotNullParameter(allUsers2, (String)"allUsers");
        return this.getAllJsmCustomers(this.jiraGroupReader.allGroups(), allUsers2);
    }

    @NotNull
    public final Sequence<String> getAllJsmCustomers(@NotNull Map<JiraGroup, ? extends Set<? extends GroupProductAccess>> allGroups2, @NotNull Sequence<? extends User> allUsers2) {
        Intrinsics.checkNotNullParameter(allGroups2, (String)"allGroups");
        Intrinsics.checkNotNullParameter(allUsers2, (String)"allUsers");
        return this.getAllJsmCustomers(this.usersWithProductAccess(allGroups2), allUsers2);
    }

    @NotNull
    public final Sequence<String> getAllJsmCustomers(@NotNull Function1<? super User, Boolean> userInGroupWithAccessPredicate, @NotNull Sequence<? extends User> allUsers2) {
        Intrinsics.checkNotNullParameter(userInGroupWithAccessPredicate, (String)"userInGroupWithAccessPredicate");
        Intrinsics.checkNotNullParameter(allUsers2, (String)"allUsers");
        log.info("Fetching all JSM customers for {} users", (Object)SequencesKt.count(allUsers2));
        Sequence allDistinctUsersByName2 = SequencesKt.distinctBy(allUsers2, (Function1)getAllJsmCustomers.allDistinctUsersByName.1.INSTANCE);
        CompanyUserRecognitionAlgorithm companyUserRecognitionAlgorithm = this.migrationFeatures.getEnableCustomerIdentificationImprovements() ? CompanyUserRecognitionAlgorithm.DOMAIN_AND_SUBDOMAINS_MATCH : CompanyUserRecognitionAlgorithm.LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH;
        Function1<User, Map<CompanyUserRecognitionAlgorithm, Boolean>> doesUserEmailDomainBelongToCompanyPredicate = this.jiraUserFilter.doesUserEmailDomainBelongToCompany(companyUserRecognitionAlgorithm);
        List customers = new ArrayList();
        EnumMap<JiraUserFilterAnalytics.UserClassificationCounter, Integer> analyticsCounter = this.jiraUserFilterAnalytics.createCounterMap();
        Sequence $this$forEach$iv = allDistinctUsersByName2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            User user;
            User user2 = (User)element$iv;
            boolean bl = false;
            Map resultMap = (Map)doesUserEmailDomainBelongToCompanyPredicate.invoke((Object)user2);
            boolean bl2 = false;
            this.jiraUserFilterAnalytics.updateCountsByAlgorithm(resultMap, analyticsCounter);
            Boolean bl3 = (Boolean)resultMap.get((Object)companyUserRecognitionAlgorithm);
            boolean isEmailDomainSame = bl3 != null ? bl3 : false;
            User it = user = user2;
            boolean bl4 = false;
            Object object = !isEmailDomainSame && (Boolean)userInGroupWithAccessPredicate.invoke((Object)it) == false ? user : null;
            if (object == null) continue;
            it = object;
            boolean bl5 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            customers.add(string);
        }
        this.jiraUserFilterAnalytics.sendClassificationAnalyticsEvents(SequencesKt.count((Sequence)allDistinctUsersByName2), analyticsCounter);
        log.info("JSM customer extraction finished with total {} customers", (Object)customers.size());
        return CollectionsKt.asSequence((Iterable)customers);
    }

    @NotNull
    public final Function1<User, Boolean> usersWithProductAccess() {
        return this.usersWithProductAccess(this.jiraGroupReader.allGroups());
    }

    @NotNull
    public final Function1<User, Boolean> usersWithProductAccess(@NotNull Map<JiraGroup, ? extends Set<? extends GroupProductAccess>> allGroups2) {
        Intrinsics.checkNotNullParameter(allGroups2, (String)"allGroups");
        return this.jiraUserFilter.isInGroupsContainingAccess(allGroups2, groupProductAccessSet);
    }

    public final long getAllJsmCustomersCount() {
        return SequencesKt.count(this.getAllJsmCustomers());
    }

    @NotNull
    public final Sequence<ApplicationUser> getAllJsdCustomersAsApplicationUser() {
        return SequencesKt.mapNotNull(this.getAllJsmCustomers(), (Function1)((Function1)new Function1<String, ApplicationUser>(this){
            final /* synthetic */ JsmCustomerReader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ApplicationUser invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JsmCustomerReader.access$getUserManager$p(this.this$0).getUserByName(it);
            }
        }));
    }

    @NotNull
    public final Sequence<ApplicationUser> getAllJsdCustomersAsApplicationUser(@NotNull Sequence<? extends User> allUsers2) {
        Intrinsics.checkNotNullParameter(allUsers2, (String)"allUsers");
        return SequencesKt.mapNotNull(this.getAllJsmCustomers(allUsers2), (Function1)((Function1)new Function1<String, ApplicationUser>(this){
            final /* synthetic */ JsmCustomerReader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ApplicationUser invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JsmCustomerReader.access$getUserManager$p(this.this$0).getUserByName(it);
            }
        }));
    }

    @NotNull
    public final Sequence<ApplicationUser> getAllJsdCustomersAsApplicationUser(@NotNull Function1<? super User, Boolean> userInGroupWithAccessPredicate, @NotNull Sequence<? extends User> allUsers2) {
        Intrinsics.checkNotNullParameter(userInGroupWithAccessPredicate, (String)"userInGroupWithAccessPredicate");
        Intrinsics.checkNotNullParameter(allUsers2, (String)"allUsers");
        return SequencesKt.mapNotNull(this.getAllJsmCustomers(userInGroupWithAccessPredicate, allUsers2), (Function1)((Function1)new Function1<String, ApplicationUser>(this){
            final /* synthetic */ JsmCustomerReader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ApplicationUser invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JsmCustomerReader.access$getUserManager$p(this.this$0).getUserByName(it);
            }
        }));
    }

    public static final /* synthetic */ UserManager access$getUserManager$p(JsmCustomerReader $this) {
        return $this.userManager;
    }

    static {
        GroupProductAccess[] groupProductAccessArray = new GroupProductAccess[]{GroupProductAccess.JIRA_SOFTWARE_ACCESS, GroupProductAccess.JIRA_CORE_ACCESS, GroupProductAccess.JIRA_SERVICE_DESK_ACCESS};
        groupProductAccessSet = SetsKt.setOf((Object[])groupProductAccessArray);
        log = LoggerFactory.getLogger(JsmCustomerReader.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader$Companion;", "", "()V", "groupProductAccessSet", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/GroupProductAccess;", "getGroupProductAccessSet", "()Ljava/util/Set;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<GroupProductAccess> getGroupProductAccessSet() {
            return groupProductAccessSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

