/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.usergroup;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.migration.common.CompanyUserRecognitionAlgorithm;
import com.atlassian.jira.migration.events.JiraUserFilterAnalytics;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.serverdataextractors.usergroup.GroupProductAccess;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroup;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserFilter;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JsmCustomerReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserClassificationCount;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserClassificationFilterResults;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserClassificationMetrics;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserClassifications;
import com.atlassian.jira.migration.utility.JsmUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReaderAnalytics;", "", "jiraUserFilter", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter;", "jsmUtility", "Lcom/atlassian/jira/migration/utility/JsmUtility;", "jiraUserFilterAnalytics", "Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter;Lcom/atlassian/jira/migration/utility/JsmUtility;Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "getUserClassificationMetrics", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserClassificationMetrics;", "allUsers", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/crowd/embedded/api/User;", "allGroups", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroup;", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/GroupProductAccess;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsmCustomerReaderAnalytics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsmCustomerReaderAnalytics.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReaderAnalytics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,188:1\n1549#2:189\n1620#2,3:190\n1855#2,2:199\n8406#3,2:193\n9088#3,4:195\n*S KotlinDebug\n*F\n+ 1 JsmCustomerReaderAnalytics.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReaderAnalytics\n*L\n32#1:189\n32#1:190,3\n41#1:199,2\n38#1:193,2\n38#1:195,4\n*E\n"})
public final class JsmCustomerReaderAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraUserFilter jiraUserFilter;
    @NotNull
    private final JsmUtility jsmUtility;
    @NotNull
    private final JiraUserFilterAnalytics jiraUserFilterAnalytics;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    public static final String USER_CLASSIFICATION_METRICS = "userClassificationMetrics";

    @Inject
    public JsmCustomerReaderAnalytics(@NotNull JiraUserFilter jiraUserFilter, @NotNull JsmUtility jsmUtility, @NotNull JiraUserFilterAnalytics jiraUserFilterAnalytics, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)jiraUserFilter, (String)"jiraUserFilter");
        Intrinsics.checkNotNullParameter((Object)jsmUtility, (String)"jsmUtility");
        Intrinsics.checkNotNullParameter((Object)jiraUserFilterAnalytics, (String)"jiraUserFilterAnalytics");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.jiraUserFilter = jiraUserFilter;
        this.jsmUtility = jsmUtility;
        this.jiraUserFilterAnalytics = jiraUserFilterAnalytics;
        this.migrationFeatures = migrationFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UserClassificationMetrics getUserClassificationMetrics(@NotNull Sequence<? extends User> allUsers2, @NotNull Map<JiraGroup, ? extends Set<? extends GroupProductAccess>> allGroups2) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        UserClassifications[] $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(allUsers2, (String)"allUsers");
        Intrinsics.checkNotNullParameter(allGroups2, (String)"allGroups");
        CompanyUserRecognitionAlgorithm companyUserRecognitionAlgorithm = this.migrationFeatures.getEnableCustomerIdentificationImprovements() ? CompanyUserRecognitionAlgorithm.DOMAIN_AND_SUBDOMAINS_MATCH : CompanyUserRecognitionAlgorithm.LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH;
        Function1<User, Map<CompanyUserRecognitionAlgorithm, Boolean>> doesUserEmailDomainBelongToCompanyPredicate = this.jiraUserFilter.doesUserEmailDomainBelongToCompany(companyUserRecognitionAlgorithm);
        Iterable iterable = allGroups2.keySet();
        JiraUserFilter jiraUserFilter = this.jiraUserFilter;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            JiraGroup jiraGroup = (JiraGroup)t;
            Collection collection = destination$iv$iv;
            int n = 0;
            collection.add(it.getName());
        }
        Function1<User, Boolean> inGroupsPredicate = jiraUserFilter.isInGroups((List)destination$iv$iv);
        Function1<User, Boolean> inGroupsContainingAccessPredicate = this.jiraUserFilter.isInGroupsContainingAccess(allGroups2, JsmCustomerReader.Companion.getGroupProductAccessSet());
        $this$mapTo$iv$iv = UserClassifications.values();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associate$iv).length), (int)16);
        Iterator iterator2 = $this$associate$iv;
        Map map = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = map;
            Pair it = element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.userClassificationFilter(), (Object)new UserClassificationCount(it.name(), 0));
            map2.put(it.getFirst(), it.getSecond());
        }
        Map userClassificationCountMap = map;
        EnumMap<JiraUserFilterAnalytics.UserClassificationCounter, Integer> analyticsCounter = this.jiraUserFilterAnalytics.createCounterMap();
        Iterable $this$forEach$iv = SequencesKt.toList(allUsers2);
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            User user = (User)t;
            boolean bl = false;
            Map it = (Map)doesUserEmailDomainBelongToCompanyPredicate.invoke((Object)user);
            boolean bl2 = false;
            this.jiraUserFilterAnalytics.updateCountsByAlgorithm(it, analyticsCounter);
            Boolean bl3 = (Boolean)it.get((Object)companyUserRecognitionAlgorithm);
            boolean bl4 = bl3 != null ? bl3 : false;
            boolean bl5 = this.jiraUserFilter.hasNoServiceDeskCustomerFlag(user);
            boolean bl6 = (Boolean)inGroupsContainingAccessPredicate.invoke((Object)user);
            boolean bl7 = bl4;
            boolean bl8 = (Boolean)inGroupsPredicate.invoke((Object)user);
            UserClassificationFilterResults userClassificationFilterResult = new UserClassificationFilterResults(bl7, bl8, bl6, bl5);
            if (!userClassificationCountMap.containsKey(userClassificationFilterResult)) continue;
            Object v = userClassificationCountMap.get(userClassificationFilterResult);
            Intrinsics.checkNotNull(v);
            UserClassificationCount userClassificationCount = (UserClassificationCount)v;
            int n = userClassificationCount.getCount();
            userClassificationCount.setCount(n + 1);
        }
        this.jiraUserFilterAnalytics.sendClassificationAnalyticsEvents(SequencesKt.count(allUsers2), analyticsCounter);
        return new UserClassificationMetrics(CollectionsKt.toList((Iterable)userClassificationCountMap.values()), this.jsmUtility.isJsmInstalled(), this.jsmUtility.isJswInstalled());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReaderAnalytics$Companion;", "", "()V", "USER_CLASSIFICATION_METRICS", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

