/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors.usergroup;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.common.CompanyUserRecognitionAlgorithm;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.events.JiraUserFilterAnalytics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.UserExportMismatchClassification;
import com.atlassian.jira.migration.events.UserExportMismatchCount;
import com.atlassian.jira.migration.events.UserExportMismatchFilterResult;
import com.atlassian.jira.migration.events.UserExportMismatchStats;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.JsdCustomersMigrationOption;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraServerUserMappings;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserFilter;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JsmCustomerReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserInfo;
import com.atlassian.jira.migration.utility.JsmUtility;
import com.atlassian.jira.user.ApplicationUser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 D2\u00020\u0001:\u0001DBO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J2\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J,\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001bH\u0002J*\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020 J(\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001b2\b\u0010-\u001a\u0004\u0018\u00010.2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010\u001bJ2\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u00182\u0006\u0010+\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u00102\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u00103\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010\u001b2\u0006\u0010+\u001a\u00020 J \u00104\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010+\u001a\u00020 2\u0006\u00102\u001a\u00020 H\u0002J\u0010\u00105\u001a\u0004\u0018\u00010.2\u0006\u0010+\u001a\u00020 J\u001a\u00106\u001a\u0004\u0018\u0001072\u0006\u0010+\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J.\u00109\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001b0:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0002J3\u0010<\u001a\u0004\u0018\u0001H=\"\u0004\b\u0000\u0010=2\u0006\u0010+\u001a\u00020 2\u0006\u00108\u001a\u00020 2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H=0?H\u0002\u00a2\u0006\u0002\u0010@J)\u0010A\u001a\u00020*\"\u0004\b\u0000\u0010=2\u0006\u0010+\u001a\u00020 2\u0006\u00108\u001a\u00020 2\u0006\u0010B\u001a\u0002H=\u00a2\u0006\u0002\u0010CR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;", "", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "jiraUserFilter", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "jsmCustomerReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;", "jsmUtility", "Lcom/atlassian/jira/migration/utility/JsmUtility;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "jiraUserFilterAnalytics", "Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/config/util/JiraHome;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserFilter;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;Lcom/atlassian/jira/migration/utility/JsmUtility;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/events/JiraUserFilterAnalytics;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "calculateDeletedAtlassianAccounts", "", "Lcom/atlassian/jira/user/ApplicationUser;", "extraAtlassianAccounts", "", "usersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "userKeysReferenced", "", "", "calculateDeletedCustomerAccounts", "extraCustomerAccounts", "calculateExtraJiraUsers", "users", "allExportedUserKeys", "calculateUserExportClassificationMetrics", "Lcom/atlassian/jira/migration/events/UserExportMismatchCount;", "deletedCustomerAccounts", "deleteFiles", "", "migrationId", "extractAllExportedUserKeys", "userExportObject", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraServerUserMappings;", "customerExportObject", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "extractDeletedUsersAndSendUserExportMismatchMetrics", "projectKey", "fetchCustomerExportObject", "fetchReferencedUserExportForProject", "fetchUserExportObject", "outputFileForUsersData", "Ljava/io/File;", "entity", "partitionExtraAccounts", "Lkotlin/Pair;", "extraJiraUsers", "readFileContentsFromFile", "T", "returnType", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Ljava/lang/String;Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "writeIntoFile", "data", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUserExportMismatchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserExportMismatchService.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,291:1\n1603#2,9:292\n1855#2:301\n1856#2:303\n1612#2:304\n1360#2:308\n1446#2,2:309\n1549#2:311\n1620#2,3:312\n1448#2,3:315\n1549#2:318\n1620#2,3:319\n1549#2:322\n1620#2,3:323\n766#2:326\n857#2,2:327\n1549#2:329\n1620#2,3:330\n3190#2,10:333\n766#2:343\n857#2,2:344\n766#2:346\n857#2,2:347\n1855#2,2:355\n1#3:302\n51#4:305\n51#4:306\n51#4:307\n8406#5,2:349\n9088#5,4:351\n*S KotlinDebug\n*F\n+ 1 UserExportMismatchService.kt\ncom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService\n*L\n161#1:292,9\n161#1:301\n161#1:303\n161#1:304\n203#1:308\n203#1:309,2\n204#1:311\n204#1:312,3\n203#1:315,3\n206#1:318\n206#1:319,3\n214#1:322\n214#1:323,3\n215#1:326\n215#1:327,2\n221#1:329\n221#1:330,3\n222#1:333,10\n233#1:343\n233#1:344,2\n247#1:346\n247#1:347,2\n265#1:355,2\n161#1:302\n182#1:305\n188#1:306\n195#1:307\n257#1:349,2\n257#1:351,4\n*E\n"})
public final class UserExportMismatchService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraHome jiraHome;
    @NotNull
    private final JiraUserFilter jiraUserFilter;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final JsmCustomerReader jsmCustomerReader;
    @NotNull
    private final JsmUtility jsmUtility;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final JiraUserFilterAnalytics jiraUserFilterAnalytics;
    @NotNull
    private final ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(UserExportMismatchService.class);
    @NotNull
    public static final String USERS = "users";
    @NotNull
    public static final String CUSTOMERS = "customers";
    @NotNull
    public static final String REF_USER_FILE_SUFFIX = "_users";

    @Inject
    public UserExportMismatchService(@NotNull JiraHome jiraHome, @NotNull JiraUserFilter jiraUserFilter, @NotNull MigrationEventBus migrationEventBus, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull JsmCustomerReader jsmCustomerReader, @NotNull JsmUtility jsmUtility, @NotNull MigrationFeatures migrationFeatures, @NotNull JiraUserFilterAnalytics jiraUserFilterAnalytics, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkNotNullParameter((Object)jiraUserFilter, (String)"jiraUserFilter");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)jsmCustomerReader, (String)"jsmCustomerReader");
        Intrinsics.checkNotNullParameter((Object)jsmUtility, (String)"jsmUtility");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)jiraUserFilterAnalytics, (String)"jiraUserFilterAnalytics");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.jiraHome = jiraHome;
        this.jiraUserFilter = jiraUserFilter;
        this.migrationEventBus = migrationEventBus;
        this.localFileDataOutput = localFileDataOutput;
        this.jsmCustomerReader = jsmCustomerReader;
        this.jsmUtility = jsmUtility;
        this.migrationFeatures = migrationFeatures;
        this.jiraUserFilterAnalytics = jiraUserFilterAnalytics;
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    private final File outputFileForUsersData(String migrationId, String entity) {
        Object object = new String[]{"export", "migration-to-cloud", migrationId, USERS};
        Path dir = Paths.get(this.jiraHome.getHome().getAbsolutePath(), (String[])object);
        try {
            Object it = Files.createDirectories(dir, new FileAttribute[0]);
            boolean bl = false;
            object = dir.resolve(migrationId + '-' + entity + ".json");
            it = object;
            boolean bl2 = false;
            Files.deleteIfExists((Path)it);
            it = object;
            boolean bl3 = false;
            Object $this$outputFileForUsersData_u24lambda_u243 = object = Files.createFile((Path)it, new FileAttribute[0]).toFile();
            boolean bl4 = false;
            ((File)$this$outputFileForUsersData_u24lambda_u243).deleteOnExit();
            return object;
        }
        catch (Exception ex) {
            throw new Exception("Error while creating output file for users and groups data: " + ex);
        }
    }

    public final <T> void writeIntoFile(@NotNull String migrationId, @NotNull String entity, T data2) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.migrationFeatures.getDisableMissingUserMismatchFix()) {
            return;
        }
        try {
            File outputFile = this.outputFileForUsersData(migrationId, entity);
            this.mapper.writeValue(outputFile, data2);
        }
        catch (Exception ex) {
            log.warn("Unable to write " + entity + " data to a file", (Throwable)ex);
        }
    }

    private final <T> T readFileContentsFromFile(String migrationId, String entity, TypeReference<T> returnType) {
        try {
            String[] stringArray = new String[]{"export", "migration-to-cloud", migrationId, USERS, migrationId + '-' + entity + ".json"};
            Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return (T)(Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? this.mapper.readValue(path.toFile(), returnType) : null);
        }
        catch (JsonProcessingException e) {
            log.info("Exception caught while fetching " + entity + " export file", (Throwable)e);
        }
        catch (IOException e) {
            log.info("Exception caught while fetching " + entity + " export file", (Throwable)e);
        }
        return null;
    }

    public final void deleteFiles(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String[] stringArray = new String[]{"export", "migration-to-cloud", migrationId, USERS};
        Path path = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        try {
            Intrinsics.checkNotNull((Object)path);
            this.localFileDataOutput.deleteDirectoryIfExists(path);
        }
        catch (Throwable t) {
            log.info("Failed to delete user export directory " + path.toAbsolutePath(), t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> extractDeletedUsersAndSendUserExportMismatchMetrics(@NotNull String migrationId, @NotNull Set<? extends ApplicationUser> users2, @NotNull String projectKey, @NotNull UsersGroupsMigrationOption usersGroupsMigrationOption) {
        void $this$mapNotNullTo$iv$iv;
        List<ApplicationUser> extraJiraUsers;
        Set userExportForProject;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter(users2, (String)USERS);
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
        if (this.migrationFeatures.getDisableMissingUserMismatchFix()) {
            return SetsKt.emptySet();
        }
        JiraServerUserMappings userExportObject = this.fetchUserExportObject(migrationId);
        List customerExportObject = this.fetchCustomerExportObject(migrationId);
        Set set = this.fetchReferencedUserExportForProject(migrationId, projectKey);
        if (set == null) {
            set = userExportForProject = (Set)new LinkedHashSet();
        }
        if (userExportObject == null) {
            return SetsKt.emptySet();
        }
        if (customerExportObject == null) {
            if (!Intrinsics.areEqual((Object)usersGroupsMigrationOption.getJsdCustomersMigrationOption(), (Object)JsdCustomersMigrationOption.Companion.getNONE())) {
                return SetsKt.emptySet();
            }
            customerExportObject = CollectionsKt.emptyList();
        }
        if ((extraJiraUsers = this.calculateExtraJiraUsers(users2, this.extractAllExportedUserKeys(userExportObject, customerExportObject))).isEmpty()) {
            return SetsKt.emptySet();
        }
        Pair<List<ApplicationUser>, List<ApplicationUser>> pair = this.partitionExtraAccounts(extraJiraUsers);
        List extraCustomerAccounts = (List)pair.component1();
        List extraAtlassianAccounts = (List)pair.component2();
        Set<ApplicationUser> deletedCustomerAccounts = this.calculateDeletedCustomerAccounts(extraCustomerAccounts, usersGroupsMigrationOption, userExportForProject);
        Set<ApplicationUser> deletedAtlassianAccounts = this.calculateDeletedAtlassianAccounts(extraAtlassianAccounts, usersGroupsMigrationOption, userExportForProject);
        Iterable $this$mapNotNull$iv = SetsKt.plus(deletedAtlassianAccounts, (Iterable)deletedCustomerAccounts);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ApplicationUser it = (ApplicationUser)element$iv$iv;
            boolean bl2 = false;
            if (it.getKey() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set deletedUserKeys2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        UsersGroupsMigrationOption.MigrationMode migrationMode = usersGroupsMigrationOption.getMode();
        Object object = usersGroupsMigrationOption.getJsdCustomersMigrationOption();
        if (object == null || (object = object.getMode()) == null) {
            object = JsdCustomersMigrationOption.JsdCustomersMigrationMode.NONE;
        }
        this.migrationEventBus.post(new UserExportMismatchStats(migrationId, projectKey, migrationMode, (JsdCustomersMigrationOption.JsdCustomersMigrationMode)((Object)object), this.jsmUtility.isJsmInstalled(), deletedUserKeys2.size(), this.calculateUserExportClassificationMetrics(extraCustomerAccounts, deletedCustomerAccounts)));
        return deletedUserKeys2;
    }

    @Nullable
    public final JiraServerUserMappings fetchUserExportObject(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        boolean $i$f$jacksonTypeRef = false;
        return (JiraServerUserMappings)this.readFileContentsFromFile(migrationId, USERS, (TypeReference)new TypeReference<JiraServerUserMappings>(){});
    }

    @Nullable
    public final List<JiraUser> fetchCustomerExportObject(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        boolean $i$f$jacksonTypeRef = false;
        return (List)this.readFileContentsFromFile(migrationId, CUSTOMERS, (TypeReference)new TypeReference<List<? extends JiraUser>>(){});
    }

    private final Set<String> fetchReferencedUserExportForProject(String migrationId, String projectKey) {
        boolean $i$f$jacksonTypeRef = false;
        return (Set)this.readFileContentsFromFile(migrationId, projectKey + REF_USER_FILE_SUFFIX, (TypeReference)new TypeReference<Set<String>>(){});
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> extractAllExportedUserKeys(@Nullable JiraServerUserMappings userExportObject, @Nullable List<JiraUser> customerExportObject) {
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$flatMap$iv;
        List list;
        List totalUsersExported = new ArrayList();
        if (userExportObject != null) {
            Iterable iterable = userExportObject.getEmailToUserInfo().values();
            list = totalUsersExported;
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                List userInfos = (List)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = userInfos;
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    UserInfo userInfo = (UserInfo)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.getUserKey());
                }
                list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
        }
        if (customerExportObject != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$flatMap$iv = customerExportObject;
            list = totalUsersExported;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                list$iv$iv = (JiraUser)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUserKey());
            }
            list.addAll((List)destination$iv$iv);
        }
        return totalUsersExported;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ApplicationUser> calculateExtraJiraUsers(Set<? extends ApplicationUser> users2, List<String> allExportedUserKeys) {
        void $this$filterTo$iv$iv;
        ApplicationUser it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = users2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ApplicationUser applicationUser = (ApplicationUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        Set missingUserKeys = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (Iterable)CollectionsKt.toSet((Iterable)allExportedUserKeys));
        Iterable $this$filter$iv = users2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ApplicationUser)element$iv$iv;
            boolean bl = false;
            if (!missingUserKeys.contains(it.getKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<ApplicationUser>, List<ApplicationUser>> partitionExtraAccounts(List<? extends ApplicationUser> extraJiraUsers) {
        Set set;
        if (this.jsmUtility.isJsmInstalled()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = extraJiraUsers;
            JsmCustomerReader jsmCustomerReader = this.jsmCustomerReader;
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ApplicationUser applicationUser = (ApplicationUser)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getDirectoryUser());
            }
            set = SequencesKt.toSet(jsmCustomerReader.getAllJsmCustomers((Sequence<? extends User>)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv))));
        } else {
            set = SetsKt.emptySet();
        }
        Set extraCustomerNames = set;
        Iterable $this$partition$iv = extraJiraUsers;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            ApplicationUser it = (ApplicationUser)element$iv;
            boolean bl = false;
            if (extraCustomerNames.contains(it.getKey()) || extraCustomerNames.contains(it.getName())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        return new Pair(first$iv, second$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ApplicationUser> calculateDeletedCustomerAccounts(List<? extends ApplicationUser> extraCustomerAccounts, UsersGroupsMigrationOption usersGroupsMigrationOption, Set<String> userKeysReferenced) {
        Set set;
        JsdCustomersMigrationOption jsdCustomersMigrationOption = usersGroupsMigrationOption.getJsdCustomersMigrationOption();
        if (Intrinsics.areEqual((Object)jsdCustomersMigrationOption, (Object)JsdCustomersMigrationOption.Companion.getALL())) {
            set = CollectionsKt.toSet((Iterable)extraCustomerAccounts);
        } else if (Intrinsics.areEqual((Object)jsdCustomersMigrationOption, (Object)JsdCustomersMigrationOption.Companion.getREFERENCED())) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = extraCustomerAccounts;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ApplicationUser it = (ApplicationUser)element$iv$iv;
                boolean bl = false;
                if (!userKeysReferenced.contains(it.getKey())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ApplicationUser> calculateDeletedAtlassianAccounts(List<? extends ApplicationUser> extraAtlassianAccounts, UsersGroupsMigrationOption usersGroupsMigrationOption, Set<String> userKeysReferenced) {
        Set set;
        switch (WhenMappings.$EnumSwitchMapping$0[usersGroupsMigrationOption.getMode().ordinal()]) {
            case 1: {
                set = CollectionsKt.toSet((Iterable)extraAtlassianAccounts);
                break;
            }
            case 2: {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = extraAtlassianAccounts;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ApplicationUser it = (ApplicationUser)element$iv$iv;
                    boolean bl = false;
                    if (!userKeysReferenced.contains(it.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                break;
            }
            default: {
                set = SetsKt.emptySet();
            }
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UserExportMismatchCount> calculateUserExportClassificationMetrics(List<? extends ApplicationUser> extraCustomerAccounts, Set<? extends ApplicationUser> deletedCustomerAccounts) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        UserExportMismatchClassification[] userExportMismatchClassificationArray = UserExportMismatchClassification.values();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associate$iv).length), (int)16);
        void var7_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            void it = element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.userExportMismatchFilter(), (Object)new UserExportMismatchCount(it.name(), 0));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map userExportClassificationMap = destination$iv$iv;
        int totalUserCount = extraCustomerAccounts.size() - deletedCustomerAccounts.size();
        EnumMap<JiraUserFilterAnalytics.UserClassificationCounter, Integer> analyticsCounter = this.jiraUserFilterAnalytics.createCounterMap();
        CompanyUserRecognitionAlgorithm companyUserRecognitionAlgorithm = this.migrationFeatures.getEnableCustomerIdentificationImprovements() ? CompanyUserRecognitionAlgorithm.DOMAIN_AND_SUBDOMAINS_MATCH : CompanyUserRecognitionAlgorithm.LOWEST_LEVEL_DOMAIN_COMPONENT_MATCH;
        Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)extraCustomerAccounts, (Iterable)deletedCustomerAccounts);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ApplicationUser it = (ApplicationUser)element$iv;
            boolean bl = false;
            Function1<User, Map<CompanyUserRecognitionAlgorithm, Boolean>> function1 = this.jiraUserFilter.doesUserEmailDomainBelongToCompany(companyUserRecognitionAlgorithm);
            User user = it.getDirectoryUser();
            Intrinsics.checkNotNullExpressionValue((Object)user, (String)"getDirectoryUser(...)");
            Map resultMap = (Map)function1.invoke((Object)user);
            boolean bl2 = false;
            this.jiraUserFilterAnalytics.updateCountsByAlgorithm(resultMap, analyticsCounter);
            Boolean bl3 = (Boolean)resultMap.get((Object)companyUserRecognitionAlgorithm);
            boolean bl4 = bl3 != null ? bl3 : false;
            boolean bl5 = it.isActive();
            User user2 = it.getDirectoryUser();
            Intrinsics.checkNotNullExpressionValue((Object)user2, (String)"getDirectoryUser(...)");
            boolean bl6 = this.jiraUserFilter.hasServiceDeskCustomerFlag(user2);
            boolean bl7 = bl5;
            boolean bl8 = bl4;
            UserExportMismatchFilterResult userExportMismatchFilterResult = new UserExportMismatchFilterResult(bl8, bl7, bl6);
            Object v = userExportClassificationMap.get(userExportMismatchFilterResult);
            Intrinsics.checkNotNull(v);
            UserExportMismatchCount userExportMismatchCount = (UserExportMismatchCount)v;
            int n = userExportMismatchCount.getCount();
            userExportMismatchCount.setCount(n + 1);
        }
        this.jiraUserFilterAnalytics.sendClassificationAnalyticsEvents(totalUserCount, analyticsCounter);
        return CollectionsKt.toList((Iterable)userExportClassificationMap.values());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService$Companion;", "", "()V", "CUSTOMERS", "", "REF_USER_FILE_SUFFIX", "USERS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UsersGroupsMigrationOption.MigrationMode.values().length];
            try {
                nArray[UsersGroupsMigrationOption.MigrationMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsersGroupsMigrationOption.MigrationMode.REFERENCED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

