/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.setup;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.setup.DefaultPollingSettings;
import com.atlassian.jira.migration.tracking.MigrationTracker;
import com.atlassian.jira.migration.tracking.polling.PollerConfig;
import com.atlassian.jira.migration.tracking.tasks.V4Worker;
import com.atlassian.jira.migration.tracking.tasks.Worker;
import com.atlassian.jira.migration.workers.app.V4AppPreloadNotificationWorker;
import com.atlassian.jira.migration.workers.app.V4AppPreloadWorker;
import com.atlassian.jira.migration.workers.assets.V4AssetsWorker;
import com.atlassian.jira.migration.workers.attachments.V3MediaWorker;
import com.atlassian.jira.migration.workers.attachments.V4MediaWorker;
import com.atlassian.jira.migration.workers.cpd.V3CrossProjectDataWorker;
import com.atlassian.jira.migration.workers.cpd.V4CrossProjectDataWorker;
import com.atlassian.jira.migration.workers.customers.V3CustomersWorker;
import com.atlassian.jira.migration.workers.customers.V4CustomersWorker;
import com.atlassian.jira.migration.workers.projects.V3ProjectsWorker;
import com.atlassian.jira.migration.workers.projects.V4ProjectsWorker;
import com.atlassian.jira.migration.workers.site.V3SiteAttachmentWorker;
import com.atlassian.jira.migration.workers.site.V3SiteDataWorker;
import com.atlassian.jira.migration.workers.usersgroups.V3UsersGroupsWorker;
import com.atlassian.jira.migration.workers.usersgroups.V4UsersGroupsWorker;
import com.atlassian.migration.udc.usermapping.UserMappingService;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 @2\u00020\u0001:\u0001@B\u0081\u0002\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0007\u0012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0007\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007\u0012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0007\u0012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0007\u0012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0007\u0012\u0006\u0010%\u001a\u00020&\u0012\u0006\u0010'\u001a\u00020(\u0012\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000201H\u0002J\u001c\u00103\u001a\u00020-2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020705H\u0002J\u001c\u00108\u001a\u00020-2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020905H\u0002J\u0014\u0010:\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020705H\u0002J\u0014\u0010;\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020905H\u0002J\b\u0010<\u001a\u00020/H\u0002J\u0006\u0010=\u001a\u00020-J\u0006\u0010>\u001a\u00020-J\u0006\u0010?\u001a\u00020-R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/atlassian/jira/migration/setup/PollingSetup;", "", "tracker", "Lcom/atlassian/jira/migration/tracking/MigrationTracker;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "v3CrossProjectDataWorkerProvider", "Ljavax/inject/Provider;", "Lcom/atlassian/jira/migration/workers/cpd/V3CrossProjectDataWorker;", "v3ProjectWorkerProvider", "Lcom/atlassian/jira/migration/workers/projects/V3ProjectsWorker;", "v3UsersGroupsWorkerProvider", "Lcom/atlassian/jira/migration/workers/usersgroups/V3UsersGroupsWorker;", "v3CustomersProvider", "Lcom/atlassian/jira/migration/workers/customers/V3CustomersWorker;", "v3MediaWorkerProvider", "Lcom/atlassian/jira/migration/workers/attachments/V3MediaWorker;", "v3SiteDataWorkerProvider", "Lcom/atlassian/jira/migration/workers/site/V3SiteDataWorker;", "v3SiteAttachmentWorkerProvider", "Lcom/atlassian/jira/migration/workers/site/V3SiteAttachmentWorker;", "v4UsersGroupsWorkerProvider", "Lcom/atlassian/jira/migration/workers/usersgroups/V4UsersGroupsWorker;", "v4MediaWorkerProvider", "Lcom/atlassian/jira/migration/workers/attachments/V4MediaWorker;", "v4CustomersWorkerProvider", "Lcom/atlassian/jira/migration/workers/customers/V4CustomersWorker;", "v4CrossProjectDataWorkerProvider", "Lcom/atlassian/jira/migration/workers/cpd/V4CrossProjectDataWorker;", "v4AssetsDataWorkerProvider", "Lcom/atlassian/jira/migration/workers/assets/V4AssetsWorker;", "v4ProjectWorkerProvider", "Lcom/atlassian/jira/migration/workers/projects/V4ProjectsWorker;", "v4AppPreloadWorkerProvider", "Lcom/atlassian/jira/migration/workers/app/V4AppPreloadWorker;", "v4AppPreloadNotificationWorkerProvider", "Lcom/atlassian/jira/migration/workers/app/V4AppPreloadNotificationWorker;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "udcDelegate", "Lcom/atlassian/migration/udc/usermapping/UserMappingService;", "(Lcom/atlassian/jira/migration/tracking/MigrationTracker;Lcom/atlassian/jira/cluster/ClusterManager;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/migration/udc/usermapping/UserMappingService;)V", "addAndStartStatusPoller", "", "statusPollingDelay", "Ljava/time/Duration;", "maxTasks", "", "parallelism", "addAndStartV3WorkPollers", "configMap", "", "Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;", "Lcom/atlassian/jira/migration/tracking/tasks/Worker;", "addAndStartV4WorkPoller", "Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "getV3Workers", "getV4Workers", "getWorkerPollingDelay", "init", "manageV3Pollers", "manageV4Pollers", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPollingSetup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PollingSetup.kt\ncom/atlassian/jira/migration/setup/PollingSetup\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,197:1\n215#2,2:198\n215#2,2:200\n*S KotlinDebug\n*F\n+ 1 PollingSetup.kt\ncom/atlassian/jira/migration/setup/PollingSetup\n*L\n107#1:198,2\n111#1:200,2\n*E\n"})
public final class PollingSetup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationTracker tracker;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final Provider<V3CrossProjectDataWorker> v3CrossProjectDataWorkerProvider;
    @NotNull
    private final Provider<V3ProjectsWorker> v3ProjectWorkerProvider;
    @NotNull
    private final Provider<V3UsersGroupsWorker> v3UsersGroupsWorkerProvider;
    @NotNull
    private final Provider<V3CustomersWorker> v3CustomersProvider;
    @NotNull
    private final Provider<V3MediaWorker> v3MediaWorkerProvider;
    @NotNull
    private final Provider<V3SiteDataWorker> v3SiteDataWorkerProvider;
    @NotNull
    private final Provider<V3SiteAttachmentWorker> v3SiteAttachmentWorkerProvider;
    @NotNull
    private final Provider<V4UsersGroupsWorker> v4UsersGroupsWorkerProvider;
    @NotNull
    private final Provider<V4MediaWorker> v4MediaWorkerProvider;
    @NotNull
    private final Provider<V4CustomersWorker> v4CustomersWorkerProvider;
    @NotNull
    private final Provider<V4CrossProjectDataWorker> v4CrossProjectDataWorkerProvider;
    @NotNull
    private final Provider<V4AssetsWorker> v4AssetsDataWorkerProvider;
    @NotNull
    private final Provider<V4ProjectsWorker> v4ProjectWorkerProvider;
    @NotNull
    private final Provider<V4AppPreloadWorker> v4AppPreloadWorkerProvider;
    @NotNull
    private final Provider<V4AppPreloadNotificationWorker> v4AppPreloadNotificationWorkerProvider;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final PluginSettingsFactory pluginSettingsFactory;
    @NotNull
    private final UserMappingService udcDelegate;
    private static final Logger log = LoggerFactory.getLogger(PollingSetup.class);

    @Inject
    public PollingSetup(@NotNull MigrationTracker tracker, @NotNull ClusterManager clusterManager, @NotNull Provider<V3CrossProjectDataWorker> v3CrossProjectDataWorkerProvider, @NotNull Provider<V3ProjectsWorker> v3ProjectWorkerProvider, @NotNull Provider<V3UsersGroupsWorker> v3UsersGroupsWorkerProvider, @NotNull Provider<V3CustomersWorker> v3CustomersProvider, @NotNull Provider<V3MediaWorker> v3MediaWorkerProvider, @NotNull Provider<V3SiteDataWorker> v3SiteDataWorkerProvider, @NotNull Provider<V3SiteAttachmentWorker> v3SiteAttachmentWorkerProvider, @NotNull Provider<V4UsersGroupsWorker> v4UsersGroupsWorkerProvider, @NotNull Provider<V4MediaWorker> v4MediaWorkerProvider, @NotNull Provider<V4CustomersWorker> v4CustomersWorkerProvider, @NotNull Provider<V4CrossProjectDataWorker> v4CrossProjectDataWorkerProvider, @NotNull Provider<V4AssetsWorker> v4AssetsDataWorkerProvider, @NotNull Provider<V4ProjectsWorker> v4ProjectWorkerProvider, @NotNull Provider<V4AppPreloadWorker> v4AppPreloadWorkerProvider, @NotNull Provider<V4AppPreloadNotificationWorker> v4AppPreloadNotificationWorkerProvider, @NotNull MigrationFeatures migrationFeatures, @NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull UserMappingService udcDelegate) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter(v3CrossProjectDataWorkerProvider, (String)"v3CrossProjectDataWorkerProvider");
        Intrinsics.checkNotNullParameter(v3ProjectWorkerProvider, (String)"v3ProjectWorkerProvider");
        Intrinsics.checkNotNullParameter(v3UsersGroupsWorkerProvider, (String)"v3UsersGroupsWorkerProvider");
        Intrinsics.checkNotNullParameter(v3CustomersProvider, (String)"v3CustomersProvider");
        Intrinsics.checkNotNullParameter(v3MediaWorkerProvider, (String)"v3MediaWorkerProvider");
        Intrinsics.checkNotNullParameter(v3SiteDataWorkerProvider, (String)"v3SiteDataWorkerProvider");
        Intrinsics.checkNotNullParameter(v3SiteAttachmentWorkerProvider, (String)"v3SiteAttachmentWorkerProvider");
        Intrinsics.checkNotNullParameter(v4UsersGroupsWorkerProvider, (String)"v4UsersGroupsWorkerProvider");
        Intrinsics.checkNotNullParameter(v4MediaWorkerProvider, (String)"v4MediaWorkerProvider");
        Intrinsics.checkNotNullParameter(v4CustomersWorkerProvider, (String)"v4CustomersWorkerProvider");
        Intrinsics.checkNotNullParameter(v4CrossProjectDataWorkerProvider, (String)"v4CrossProjectDataWorkerProvider");
        Intrinsics.checkNotNullParameter(v4AssetsDataWorkerProvider, (String)"v4AssetsDataWorkerProvider");
        Intrinsics.checkNotNullParameter(v4ProjectWorkerProvider, (String)"v4ProjectWorkerProvider");
        Intrinsics.checkNotNullParameter(v4AppPreloadWorkerProvider, (String)"v4AppPreloadWorkerProvider");
        Intrinsics.checkNotNullParameter(v4AppPreloadNotificationWorkerProvider, (String)"v4AppPreloadNotificationWorkerProvider");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)pluginSettingsFactory, (String)"pluginSettingsFactory");
        Intrinsics.checkNotNullParameter((Object)udcDelegate, (String)"udcDelegate");
        this.tracker = tracker;
        this.clusterManager = clusterManager;
        this.v3CrossProjectDataWorkerProvider = v3CrossProjectDataWorkerProvider;
        this.v3ProjectWorkerProvider = v3ProjectWorkerProvider;
        this.v3UsersGroupsWorkerProvider = v3UsersGroupsWorkerProvider;
        this.v3CustomersProvider = v3CustomersProvider;
        this.v3MediaWorkerProvider = v3MediaWorkerProvider;
        this.v3SiteDataWorkerProvider = v3SiteDataWorkerProvider;
        this.v3SiteAttachmentWorkerProvider = v3SiteAttachmentWorkerProvider;
        this.v4UsersGroupsWorkerProvider = v4UsersGroupsWorkerProvider;
        this.v4MediaWorkerProvider = v4MediaWorkerProvider;
        this.v4CustomersWorkerProvider = v4CustomersWorkerProvider;
        this.v4CrossProjectDataWorkerProvider = v4CrossProjectDataWorkerProvider;
        this.v4AssetsDataWorkerProvider = v4AssetsDataWorkerProvider;
        this.v4ProjectWorkerProvider = v4ProjectWorkerProvider;
        this.v4AppPreloadWorkerProvider = v4AppPreloadWorkerProvider;
        this.v4AppPreloadNotificationWorkerProvider = v4AppPreloadNotificationWorkerProvider;
        this.migrationFeatures = migrationFeatures;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.udcDelegate = udcDelegate;
    }

    public final void init() {
        boolean isClustered = this.clusterManager.isClustered();
        log.info("initializing pollers");
        int projectExportDataParallelism = 8;
        log.info("Project parallelism export thread count set to = " + projectExportDataParallelism);
        this.tracker.clearInProgressMigrationIds();
        this.pluginSettingsFactory.createGlobalSettings().remove("com.atlassian.jira.migration.jira-migration-plugin:domainScanStatus");
        this.udcDelegate.deleteValidationStatus();
        Duration workerPollingDelay = isClustered ? DefaultPollingSettings.INSTANCE.getDEFAULT_CLUSTERED_POLLING_DELAY() : DefaultPollingSettings.INSTANCE.getDEFAULT_POLLING_DELAY();
        Duration statusPollingDelay = isClustered ? DefaultPollingSettings.INSTANCE.getDEFAULT_CLUSTERED_STATUS_POLLING_DELAY() : DefaultPollingSettings.INSTANCE.getDEFAULT_STATUS_POLLING_DELAY();
        this.addAndStartV3WorkPollers(this.getV3Workers());
        if (!this.migrationFeatures.getEnableProjectPollyPoller()) {
            this.addAndStartV4WorkPoller(this.getV4Workers());
        }
        this.addAndStartStatusPoller(statusPollingDelay, 1, 1);
        log.info("pollers were successfully initialized!");
    }

    private final void addAndStartV3WorkPollers(Map<PollerConfig, ? extends Worker> configMap) {
        Map<PollerConfig, ? extends Worker> $this$forEach$iv = configMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<PollerConfig, ? extends Worker>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<PollerConfig, ? extends Worker> element$iv;
            Map.Entry<PollerConfig, ? extends Worker> entry = element$iv = iterator2.next();
            boolean bl = false;
            PollerConfig t = entry.getKey();
            Worker u = entry.getValue();
            this.tracker.addAndStartWorkPoller(t, u);
        }
    }

    private final void addAndStartV4WorkPoller(Map<PollerConfig, ? extends V4Worker> configMap) {
        Map<PollerConfig, ? extends V4Worker> $this$forEach$iv = configMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<PollerConfig, ? extends V4Worker>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<PollerConfig, ? extends V4Worker> element$iv;
            Map.Entry<PollerConfig, ? extends V4Worker> entry = element$iv = iterator2.next();
            boolean bl = false;
            PollerConfig t = entry.getKey();
            V4Worker u = entry.getValue();
            this.tracker.addAndStartV4WorkPoller(t, u);
        }
    }

    private final void addAndStartStatusPoller(Duration statusPollingDelay, int maxTasks, int parallelism) {
        this.tracker.addAndStartStatusPoller(new PollerConfig(statusPollingDelay, maxTasks, parallelism));
    }

    public final void manageV4Pollers() {
        if (!this.tracker.isMigrationInProgress()) {
            this.migrationFeatures.refreshProjectPolly();
        }
        if (!this.migrationFeatures.getEnableV4Polling() || this.migrationFeatures.getEnableProjectPollyPoller()) {
            this.tracker.stopV4Pollers();
        } else if (!this.tracker.isAnyV4PollerRunning() && !this.migrationFeatures.getEnableProjectPollyPoller()) {
            log.info("Starting V4 Pollers");
            this.addAndStartV4WorkPoller(this.getV4Workers());
        }
    }

    public final void manageV3Pollers() {
        if (!this.migrationFeatures.getEnableV3Polling()) {
            this.tracker.stopV3Pollers();
        } else if (!this.tracker.isAnyV3PollerRunning()) {
            log.info("Starting V3 Pollers");
            this.addAndStartV3WorkPollers(this.getV3Workers());
        }
    }

    private final Map<PollerConfig, V4Worker> getV4Workers() {
        Duration workerPollingDelay = this.getWorkerPollingDelay();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 2), (Object)this.v4UsersGroupsWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 2), (Object)this.v4CustomersWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 2), (Object)this.v4MediaWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 8), (Object)this.v4ProjectWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 1), (Object)this.v4CrossProjectDataWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 2), (Object)this.v4AppPreloadWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 1), (Object)this.v4AppPreloadNotificationWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 1), (Object)this.v4AssetsDataWorkerProvider.get())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<PollerConfig, Worker> getV3Workers() {
        Duration workerPollingDelay = this.getWorkerPollingDelay();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 2), (Object)this.v3UsersGroupsWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 2), (Object)this.v3CustomersProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 8), (Object)this.v3ProjectWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 2), (Object)this.v3MediaWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 1), (Object)this.v3CrossProjectDataWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 8), (Object)this.v3SiteDataWorkerProvider.get()), TuplesKt.to((Object)new PollerConfig(workerPollingDelay, 1, 2), (Object)this.v3SiteAttachmentWorkerProvider.get())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Duration getWorkerPollingDelay() {
        return this.clusterManager.isClustered() ? DefaultPollingSettings.INSTANCE.getDEFAULT_CLUSTERED_POLLING_DELAY() : DefaultPollingSettings.INSTANCE.getDEFAULT_POLLING_DELAY();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/setup/PollingSetup$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

