/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.setup.migrationsettings;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.jira.migration.MigrationConfigType;
import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.analytics.AnalyticsEventMrcService;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.cloud.CloudType;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.events.CloudTypeSettingsEvent;
import com.atlassian.jira.migration.execution.PlanExecutionService;
import com.atlassian.jira.migration.fx3.Fx3Helper;
import com.atlassian.jira.migration.setup.migrationsettings.CloudSettingsException;
import com.atlassian.jira.migration.setup.migrationsettings.CloudTypeSettingRetrievalService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'BG\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012BE\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\u001c\u0010\u001f\u001a\u00020\u001e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u001a\u0010!\u001a\u00020\u001e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0019H\u0002J\u001c\u0010$\u001a\u00020\u001e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u001a\u0010%\u001a\u00020\u001e2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001bJ\b\u0010&\u001a\u00020\u001eH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingUpdateService;", "", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "planExecutionService", "Lcom/atlassian/jira/migration/execution/PlanExecutionService;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "analyticsEventMrcService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventMrcService;", "cloudTypeSettingRetrievalService", "Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingRetrievalService;", "fx3Helper", "Lcom/atlassian/jira/migration/fx3/Fx3Helper;", "(Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/execution/PlanExecutionService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventMrcService;Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingRetrievalService;Lcom/atlassian/jira/migration/fx3/Fx3Helper;)V", "pluginSettings", "Lcom/atlassian/sal/api/pluginsettings/PluginSettings;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/sal/api/pluginsettings/PluginSettings;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/execution/PlanExecutionService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventMrcService;Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingRetrievalService;Lcom/atlassian/jira/migration/fx3/Fx3Helper;)V", "getSelectedClodType", "Lcom/atlassian/jira/migration/cloud/CloudType;", "settings", "", "", "postConstruct", "", "publishSettingsUpdatedEvent", "value", "saveSetting", "setupMigrationConfig", "cloudType", "updatePluginSettings", "validate", "validateNoInProgressPlans", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudTypeSettingUpdateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudTypeSettingUpdateService.kt\ncom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingUpdateService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,112:1\n1#2:113\n478#3,23:114\n494#3,7:137\n*S KotlinDebug\n*F\n+ 1 CloudTypeSettingUpdateService.kt\ncom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingUpdateService\n*L\n94#1:114,23\n96#1:137,7\n*E\n"})
public final class CloudTypeSettingUpdateService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginSettings pluginSettings;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final PlanExecutionService planExecutionService;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final AnalyticsEventMrcService analyticsEventMrcService;
    @NotNull
    private final CloudTypeSettingRetrievalService cloudTypeSettingRetrievalService;
    @NotNull
    private final Fx3Helper fx3Helper;
    private static final Logger log = LoggerFactory.getLogger(CloudTypeSettingUpdateService.class);
    @NotNull
    private static final String CLOUD_TYPE_SETTING_KEY = "com.atlassian.jira.migration.jira-migration-plugin:cloudType";
    @NotNull
    private static final Map<CloudType, Boolean> DEFAULT_CLOUD_TYPES;

    public CloudTypeSettingUpdateService(@NotNull PluginSettings pluginSettings, @NotNull ObjectMapper objectMapper2, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull PlanExecutionService planExecutionService, @NotNull AnalyticsEventService analyticsEventService, @NotNull AnalyticsEventMrcService analyticsEventMrcService, @NotNull CloudTypeSettingRetrievalService cloudTypeSettingRetrievalService, @NotNull Fx3Helper fx3Helper) {
        Intrinsics.checkNotNullParameter((Object)pluginSettings, (String)"pluginSettings");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)planExecutionService, (String)"planExecutionService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventMrcService, (String)"analyticsEventMrcService");
        Intrinsics.checkNotNullParameter((Object)cloudTypeSettingRetrievalService, (String)"cloudTypeSettingRetrievalService");
        Intrinsics.checkNotNullParameter((Object)fx3Helper, (String)"fx3Helper");
        this.pluginSettings = pluginSettings;
        this.objectMapper = objectMapper2;
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.planExecutionService = planExecutionService;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventMrcService = analyticsEventMrcService;
        this.cloudTypeSettingRetrievalService = cloudTypeSettingRetrievalService;
        this.fx3Helper = fx3Helper;
    }

    @Inject
    public CloudTypeSettingUpdateService(@NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull PlanExecutionService planExecutionService, @NotNull AnalyticsEventService analyticsEventService, @NotNull AnalyticsEventMrcService analyticsEventMrcService, @NotNull CloudTypeSettingRetrievalService cloudTypeSettingRetrievalService, @NotNull Fx3Helper fx3Helper) {
        Intrinsics.checkNotNullParameter((Object)pluginSettingsFactory, (String)"pluginSettingsFactory");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)planExecutionService, (String)"planExecutionService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventMrcService, (String)"analyticsEventMrcService");
        Intrinsics.checkNotNullParameter((Object)cloudTypeSettingRetrievalService, (String)"cloudTypeSettingRetrievalService");
        Intrinsics.checkNotNullParameter((Object)fx3Helper, (String)"fx3Helper");
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pluginSettings, (String)"createGlobalSettings(...)");
        this(pluginSettings, objectMapperFactory.createObjectMapper(), migrationServicesConfiguration, planExecutionService, analyticsEventService, analyticsEventMrcService, cloudTypeSettingRetrievalService, fx3Helper);
    }

    @PostConstruct
    public final void postConstruct() {
        if (this.cloudTypeSettingRetrievalService.getSetting() == null) {
            this.updatePluginSettings(DEFAULT_CLOUD_TYPES);
        }
        Map<CloudType, Boolean> map = this.cloudTypeSettingRetrievalService.getSetting();
        Intrinsics.checkNotNull(map);
        this.setupMigrationConfig(this.getSelectedClodType(map));
    }

    public final void saveSetting(@NotNull Map<CloudType, Boolean> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.validate(value);
        this.validateNoInProgressPlans();
        CloudType cloudType = this.getSelectedClodType(value);
        if (this.cloudTypeSettingRetrievalService.getSetting() != null && Intrinsics.areEqual(value, this.cloudTypeSettingRetrievalService.getSetting())) {
            log.info("Cloud type: " + cloudType.name() + " is already set.");
        } else {
            log.info("Updating cloud type settings to: " + value);
            this.analyticsEventMrcService.flushAllAnalytics();
            this.updatePluginSettings(value);
            this.setupMigrationConfig(cloudType);
            this.publishSettingsUpdatedEvent(value);
            this.fx3Helper.updateFx3Config();
        }
    }

    private final void publishSettingsUpdatedEvent(Map<CloudType, Boolean> value) {
        CloudTypeSettingsEvent event = new CloudTypeSettingsEvent(value.toString());
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)event.asOperationalEvent(), null, 2, null);
    }

    private final void updatePluginSettings(Map<CloudType, Boolean> value) {
        this.pluginSettings.put(CLOUD_TYPE_SETTING_KEY, (Object)this.objectMapper.writeValueAsString(value));
    }

    private final void setupMigrationConfig(CloudType cloudType) {
        switch (WhenMappings.$EnumSwitchMapping$0[cloudType.ordinal()]) {
            case 1: {
                this.migrationServicesConfiguration.setupMigrationConfig(MigrationConfigType.FEDRAMP);
                break;
            }
            case 2: {
                this.migrationServicesConfiguration.setupMigrationConfig(MigrationConfigType.DEFAULT);
            }
        }
    }

    private final CloudType getSelectedClodType(Map<CloudType, Boolean> settings) {
        Object v0;
        block1: {
            Iterable iterable = settings.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!((Boolean)it.getValue()).booleanValue()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return (CloudType)((Object)((Map.Entry)v0).getKey());
    }

    public final void validate(@NotNull Map<CloudType, Boolean> settings) {
        boolean bl;
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        if (settings.isEmpty()) {
            throw new IllegalArgumentException("Invalid cloud type settings: can't be null or empty");
        }
        if (!settings.keySet().containsAll(ArraysKt.toList((Object[])CloudType.values()))) {
            throw new IllegalArgumentException("Invalid cloud type settings: values for all cloud types should be provided");
        }
        Map<CloudType, Boolean> $this$filterKeys$iv = settings;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<CloudType, Boolean> result$iv = new LinkedHashMap<CloudType, Boolean>();
        for (Map.Entry<CloudType, Boolean> entry : $this$filterKeys$iv.entrySet()) {
            CloudType it = entry.getKey();
            bl = false;
            if (!ArraysKt.contains((Object[])CloudType.values(), (Object)((Object)it))) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map<CloudType, Boolean> $this$filterValues$iv = (Map<CloudType, Boolean>)result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry<CloudType, Boolean> entry : $this$filterValues$iv.entrySet()) {
            boolean it = entry.getValue();
            bl = false;
            if (!it) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        if (((Map)result$iv).isEmpty()) {
            throw new IllegalArgumentException("Invalid cloud type settings: at least one cloud type should be selected");
        }
        $this$filterValues$iv = settings;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry<CloudType, Boolean> entry : $this$filterValues$iv.entrySet()) {
            boolean it = entry.getValue();
            bl = false;
            if (!it) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        if (((Map)result$iv).size() > 1) {
            throw new IllegalArgumentException("Invalid cloud type settings: only one cloud type can be selected");
        }
    }

    private final void validateNoInProgressPlans() {
        Collection collection = this.planExecutionService.getInProgressPlans();
        if (!(collection == null || collection.isEmpty())) {
            throw new CloudSettingsException("Plan execution is in-progress. Can't change the cloud type right now");
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)CloudType.STANDARD), (Object)true), TuplesKt.to((Object)((Object)CloudType.FEDRAMP), (Object)false)};
        DEFAULT_CLOUD_TYPES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingUpdateService$Companion;", "", "()V", "CLOUD_TYPE_SETTING_KEY", "", "DEFAULT_CLOUD_TYPES", "", "Lcom/atlassian/jira/migration/cloud/CloudType;", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CloudType.values().length];
            try {
                nArray[CloudType.FEDRAMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudType.STANDARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

