/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.setup.migrationsettings;

import com.atlassian.jira.migration.cloud.CloudType;
import com.atlassian.jira.migration.setup.migrationsettings.CloudTypeSettingRetrievalService;
import com.atlassian.jira.migration.setup.migrationsettings.CloudTypeSettingUpdateService;
import com.atlassian.jira.migration.setup.migrationsettings.MigrationSettings;
import com.atlassian.jira.migration.setup.migrationsettings.MigrationSettingsType;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/setup/migrationsettings/MigrationSettingService;", "", "cloudTypeSettingUpdateService", "Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingUpdateService;", "cloudTypeSettingRetrievalService", "Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingRetrievalService;", "(Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingUpdateService;Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingRetrievalService;)V", "getAllSettings", "Lcom/atlassian/jira/migration/setup/migrationsettings/MigrationSettings;", "getSetting", "type", "", "getTypeSettings", "upsertSettings", "", "migrationSettings", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationSettingsService.kt\ncom/atlassian/jira/migration/setup/migrationsettings/MigrationSettingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class MigrationSettingService {
    @NotNull
    private final CloudTypeSettingUpdateService cloudTypeSettingUpdateService;
    @NotNull
    private final CloudTypeSettingRetrievalService cloudTypeSettingRetrievalService;

    @Inject
    public MigrationSettingService(@NotNull CloudTypeSettingUpdateService cloudTypeSettingUpdateService, @NotNull CloudTypeSettingRetrievalService cloudTypeSettingRetrievalService) {
        Intrinsics.checkNotNullParameter((Object)cloudTypeSettingUpdateService, (String)"cloudTypeSettingUpdateService");
        Intrinsics.checkNotNullParameter((Object)cloudTypeSettingRetrievalService, (String)"cloudTypeSettingRetrievalService");
        this.cloudTypeSettingUpdateService = cloudTypeSettingUpdateService;
        this.cloudTypeSettingRetrievalService = cloudTypeSettingRetrievalService;
    }

    @NotNull
    public final MigrationSettings getSetting(@Nullable String type) {
        return type == null ? this.getAllSettings() : this.getTypeSettings(type);
    }

    public static /* synthetic */ MigrationSettings getSetting$default(MigrationSettingService migrationSettingService, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return migrationSettingService.getSetting(string);
    }

    private final MigrationSettings getTypeSettings(String type) {
        String string = type.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = MigrationSettingsType.CLOUD_TYPE.getValue().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string, (Object)string2)) {
            throw new IllegalArgumentException("Unknown migration settings type");
        }
        return new MigrationSettings(this.cloudTypeSettingRetrievalService.getSetting());
    }

    private final MigrationSettings getAllSettings() {
        return new MigrationSettings(this.cloudTypeSettingRetrievalService.getSetting());
    }

    public final void upsertSettings(@NotNull MigrationSettings migrationSettings) {
        Intrinsics.checkNotNullParameter((Object)migrationSettings, (String)"migrationSettings");
        try {
            Map<CloudType, Boolean> map = migrationSettings.getCloudTypes();
            if (map != null) {
                Map<CloudType, Boolean> it = map;
                boolean bl = false;
                this.cloudTypeSettingUpdateService.saveSetting(it);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid cloud type settings");
        }
    }
}

