/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.shadow;

import com.atlassian.cmpt.domain.Edition;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.cloud.CloudType;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.execution.MigrationExecutionService;
import com.atlassian.jira.migration.fx3.Fx3Helper;
import com.atlassian.jira.migration.jiracloudservice.JiraCloudClient;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.migrationservice.shadow.CloudSiteCreateResponse;
import com.atlassian.jira.migration.plan.AppsMigrationOption;
import com.atlassian.jira.migration.plan.CrossProjectBoardsAndFiltersMigrationOption;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.plan.JiraDataMigrationOption;
import com.atlassian.jira.migration.plan.LiftAndShiftMode;
import com.atlassian.jira.migration.plan.MigrationTag;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanActiveStatus;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.plan.PlanSource;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.shadow.ShadowMigrationProtocol;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.shadow.db.ShadowCloudSiteRepository;
import com.atlassian.jira.migration.shadow.db.ShadowMigrationJobRepository;
import com.atlassian.jira.migration.shadow.event.MigrationCompletionStatusEvent;
import com.atlassian.jira.migration.shadow.verify.ShadowMigrationVerifier;
import com.atlassian.migration.api.ContainerToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.Subscribe;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 82\u00020\u0001:\u00018Bw\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0007J\b\u0010.\u001a\u00020\"H\u0007J\b\u0010/\u001a\u00020\"H\u0007J8\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020*2\u0006\u0010%\u001a\u00020&2\u0006\u00102\u001a\u0002032\n\b\u0002\u00104\u001a\u0004\u0018\u00010*2\n\b\u0002\u00105\u001a\u0004\u0018\u00010*H\u0002J\u0018\u00106\u001a\u00020\"2\u0006\u0010)\u001a\u00020*2\u0006\u00107\u001a\u00020*H\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/atlassian/jira/migration/shadow/ShadowMigrationExecutor;", "", "eventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationExecutionService", "Lcom/atlassian/jira/migration/execution/MigrationExecutionService;", "shadowMigrationVerifier", "Lcom/atlassian/jira/migration/shadow/verify/ShadowMigrationVerifier;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "fx3Helper", "Lcom/atlassian/jira/migration/fx3/Fx3Helper;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "shadowCloudSiteRepository", "Lcom/atlassian/jira/migration/shadow/db/ShadowCloudSiteRepository;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "jiraCloudClient", "Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;", "shadowMigrationJobRepository", "Lcom/atlassian/jira/migration/shadow/db/ShadowMigrationJobRepository;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/execution/MigrationExecutionService;Lcom/atlassian/jira/migration/shadow/verify/ShadowMigrationVerifier;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/fx3/Fx3Helper;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/shadow/db/ShadowCloudSiteRepository;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;Lcom/atlassian/jira/migration/shadow/db/ShadowMigrationJobRepository;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "createShadowCloudSiteRepository", "", "event", "Lcom/atlassian/jira/migration/shadow/event/MigrationCompletionStatusEvent;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "deleteCloudSite", "fetchNextShadowPlan", "originalMigrationId", "", "isShadowMigrationApplicable", "", "onMigrationCompleted", "postConstruct", "preDestroy", "saveShadowPlanFor", "migrationId", "shadowMigrationProtocol", "Lcom/atlassian/jira/migration/shadow/ShadowMigrationProtocol;", "cloudId", "cloudUrl", "triggerShadowPlanChain", "startedBy", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nShadowMigrationExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowMigrationExecutor.kt\ncom/atlassian/jira/migration/shadow/ShadowMigrationExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n1#2:232\n58#3:233\n51#3:234\n819#4:235\n847#4,2:236\n1855#4,2:238\n*S KotlinDebug\n*F\n+ 1 ShadowMigrationExecutor.kt\ncom/atlassian/jira/migration/shadow/ShadowMigrationExecutor\n*L\n140#1:233\n140#1:234\n156#1:235\n156#1:236,2\n157#1:238,2\n*E\n"})
public final class ShadowMigrationExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus eventBus;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationExecutionService migrationExecutionService;
    @NotNull
    private final ShadowMigrationVerifier shadowMigrationVerifier;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final Fx3Helper fx3Helper;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final ShadowCloudSiteRepository shadowCloudSiteRepository;
    @NotNull
    private final JiraCloudClient jiraCloudClient;
    @NotNull
    private final ShadowMigrationJobRepository shadowMigrationJobRepository;
    @NotNull
    private final ObjectMapper mapper;
    private static final Logger log = Logger.getLogger(ShadowMigrationExecutor.class);

    @Inject
    public ShadowMigrationExecutor(@NotNull MigrationEventBus eventBus, @NotNull DiscoveryService discoveryService, @NotNull PlanRepository planRepository, @NotNull MigrationExecutionService migrationExecutionService, @NotNull ShadowMigrationVerifier shadowMigrationVerifier, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull MigrationServiceClient migrationServiceClient, @NotNull MigrationScopeManager migrationScopeManager, @NotNull Fx3Helper fx3Helper, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull ShadowCloudSiteRepository shadowCloudSiteRepository, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull JiraCloudClient jiraCloudClient, @NotNull ShadowMigrationJobRepository shadowMigrationJobRepository) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationExecutionService, (String)"migrationExecutionService");
        Intrinsics.checkNotNullParameter((Object)shadowMigrationVerifier, (String)"shadowMigrationVerifier");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)fx3Helper, (String)"fx3Helper");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)shadowCloudSiteRepository, (String)"shadowCloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)jiraCloudClient, (String)"jiraCloudClient");
        Intrinsics.checkNotNullParameter((Object)shadowMigrationJobRepository, (String)"shadowMigrationJobRepository");
        this.eventBus = eventBus;
        this.discoveryService = discoveryService;
        this.planRepository = planRepository;
        this.migrationExecutionService = migrationExecutionService;
        this.shadowMigrationVerifier = shadowMigrationVerifier;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.migrationServiceClient = migrationServiceClient;
        this.migrationScopeManager = migrationScopeManager;
        this.fx3Helper = fx3Helper;
        this.cloudSiteRepository = cloudSiteRepository;
        this.shadowCloudSiteRepository = shadowCloudSiteRepository;
        this.jiraCloudClient = jiraCloudClient;
        this.shadowMigrationJobRepository = shadowMigrationJobRepository;
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    @PostConstruct
    public final void postConstruct() {
        this.eventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.eventBus.unregister(this);
    }

    private final Plan saveShadowPlanFor(String migrationId, Plan plan2, ShadowMigrationProtocol shadowMigrationProtocol, String cloudId2, String cloudUrl) {
        String string;
        String string2;
        String string3 = UUID.randomUUID().toString();
        String string4 = "shadow-" + (Object)((Object)shadowMigrationProtocol) + ' ' + plan2.getPlanName();
        String string5 = cloudId2;
        if (string5 == null) {
            string5 = string2 = plan2.getCloudId();
        }
        if ((string = cloudUrl) == null) {
            string = plan2.getCloudUrl();
        }
        String string6 = string;
        List<String> list = plan2.getProjectKeys();
        List<Long> list2 = plan2.getAdvancedRoadmapsPlanIds();
        UsersGroupsMigrationOption usersGroupsMigrationOption = plan2.getUsersGroupsMigrationOption();
        AppsMigrationOption appsMigrationOption = new AppsMigrationOption(false, null, null, null, false, null, 62, null);
        ProjectDataMigrationMode projectDataMigrationMode = plan2.getProjectDataMigrationMode();
        Boolean bl = plan2.getForceRelinking();
        MigrationType migrationType = plan2.getMigrationType();
        String string7 = plan2.getPreflightCheckExecutionId();
        EnumSet<CheckType> enumSet = plan2.getPreflightChecksToOverride();
        Boolean bl2 = plan2.isCustomFieldsDeleted();
        PlanActiveStatus planActiveStatus = plan2.getActiveStatus();
        SinglePathMode singlePathMode = plan2.getSinglePathMode();
        MigrationTag migrationTag = plan2.getMigrationTag();
        String string8 = plan2.getManualImportFile();
        LiftAndShiftMode liftAndShiftMode = plan2.getLiftAndShiftMode();
        JiraDataMigrationOption jiraDataMigrationOption = plan2.getJiraDataMigrationOption();
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption = plan2.getCrossProjectBoardsAndFiltersMigrationOption();
        DashboardsMigrationMode dashboardsMigrationMode = plan2.getDashboardsMigrationMode();
        PlanSource planSource = PlanSource.SHADOW;
        Boolean bl3 = plan2.getUserPreMigration();
        Boolean bl4 = plan2.getMigrateArchivedIssues();
        String string9 = plan2.getCloudRegion();
        Intrinsics.checkNotNull((Object)string3);
        Plan shadowPlan = new Plan(string3, string4, string2, string6, list, list2, usersGroupsMigrationOption, appsMigrationOption, projectDataMigrationMode, bl, migrationType, string7, enumSet, bl2, planActiveStatus, 0L, singlePathMode, migrationTag, string8, liftAndShiftMode, jiraDataMigrationOption, crossProjectBoardsAndFiltersMigrationOption, dashboardsMigrationMode, null, null, planSource, bl3, bl4, true, migrationId, null, null, shadowMigrationProtocol, string9, null, null, null, null, null, null, -1048576000, 252, null);
        return this.planRepository.create(shadowPlan);
    }

    static /* synthetic */ Plan saveShadowPlanFor$default(ShadowMigrationExecutor shadowMigrationExecutor, String string, Plan plan2, ShadowMigrationProtocol shadowMigrationProtocol, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        return shadowMigrationExecutor.saveShadowPlanFor(string, plan2, shadowMigrationProtocol, string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isShadowMigrationApplicable(MigrationCompletionStatusEvent event, Plan plan2) {
        if (!event.isMigrationCompletedSuccessfully()) return false;
        Boolean bl = plan2.getCanBeShadowed();
        if (bl == null) return false;
        boolean bl2 = bl;
        if (!bl2) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void createShadowCloudSiteRepository(MigrationCompletionStatusEvent event, Plan plan2) {
        Object object;
        String string;
        String string2;
        URI uRI;
        String string3;
        CloudSiteRepository cloudSiteRepository;
        Plan savedPlan;
        CloudSiteCreateResponse newCloudSiteDetails;
        block3: {
            block2: {
                void it;
                CloudSite cloudSite2 = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, event.getMigrationId(), false, 2, null);
                Intrinsics.checkNotNull((Object)cloudSite2);
                CloudSite cloudSiteForOriginalMigration = cloudSite2;
                Pair<String, CloudSiteCreateResponse> pair = this.migrationServiceClient.createCloudSite(cloudSiteForOriginalMigration.getContainerToken(), event.getMigrationId(), this.migrationScopeManager.getMigrationScope(cloudSiteForOriginalMigration), plan2.getCloudRegion(), this.jiraCloudClient.getTenantInformation(new ContainerToken(cloudSiteForOriginalMigration.getContainerToken()), plan2.getCloudId()).getShard());
                String jobId = (String)pair.component1();
                newCloudSiteDetails = (CloudSiteCreateResponse)pair.component2();
                String string4 = event.getMigrationId();
                String string5 = newCloudSiteDetails.getCloudId();
                Intrinsics.checkNotNull((Object)string5);
                savedPlan = this.saveShadowPlanFor(string4, plan2, ShadowMigrationProtocol.V4_WDCS, string5, String.valueOf(newCloudSiteDetails.getCloudUrl()));
                this.shadowMigrationJobRepository.saveJobDetails(savedPlan.getId(), jobId);
                cloudSiteRepository = this.cloudSiteRepository;
                String string6 = newCloudSiteDetails.getCloudId();
                string3 = string6;
                Intrinsics.checkNotNull((Object)string6);
                URI uRI2 = newCloudSiteDetails.getCloudUrl();
                uRI = uRI2;
                Intrinsics.checkNotNull((Object)uRI2);
                String string7 = newCloudSiteDetails.getContainerToken();
                string2 = string7;
                Intrinsics.checkNotNull((Object)string7);
                Edition edition = cloudSiteForOriginalMigration.getCloudEdition();
                string = edition != null ? edition.getKey() : null;
                object = cloudSiteForOriginalMigration.getProductsJson();
                if (object == null) break block2;
                String string8 = object;
                String string9 = string;
                String string10 = string2;
                URI uRI3 = uRI;
                String string11 = string3;
                CloudSiteRepository cloudSiteRepository2 = cloudSiteRepository;
                boolean bl = false;
                ObjectMapper $this$readValue$iv = this.mapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                List list = (List)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<List<? extends TcsProductInfo>>(){});
                cloudSiteRepository = cloudSiteRepository2;
                string3 = string11;
                uRI = uRI3;
                string2 = string10;
                string = string9;
                List list2 = list;
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        cloudSiteRepository.saveOrUpdate(string3, uRI, string2, string, (List<TcsProductInfo>)object, CloudType.STANDARD);
        this.shadowCloudSiteRepository.create(savedPlan.getId(), newCloudSiteDetails.getCloudId());
    }

    /*
     * WARNING - void declaration
     */
    @Subscribe
    public final void onMigrationCompleted(@NotNull MigrationCompletionStatusEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, event.getMigrationId(), false, 2, null);
        if (plan2 == null) {
            return;
        }
        Plan plan3 = plan2;
        Migration migration = this.discoveryService.findByMigrationId(event.getMigrationId());
        if (migration == null) {
            return;
        }
        Migration migration2 = migration;
        if (this.isShadowMigrationApplicable(event, plan3)) {
            log.debug((Object)"Saving Shadow Migration Chains");
            Collection<ShadowMigrationProtocol> collection = plan3.getShadowMigrationProtocolsEligible();
            if (collection != null) {
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = collection;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    ShadowMigrationProtocol it = (ShadowMigrationProtocol)((Object)element$iv$iv);
                    boolean bl = false;
                    if (it == ShadowMigrationProtocol.V4_WDCS) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv));
                if (collection != null) {
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ShadowMigrationProtocol it = (ShadowMigrationProtocol)((Object)element$iv);
                        boolean bl = false;
                        ShadowMigrationExecutor.saveShadowPlanFor$default(this, event.getMigrationId(), plan3, it, null, null, 24, null);
                    }
                }
            }
            Set<ShadowMigrationProtocol> set = plan3.getShadowMigrationProtocolsEligible();
            boolean bl = set != null ? set.contains((Object)ShadowMigrationProtocol.V4_WDCS) : false;
            if (bl) {
                try {
                    this.createShadowCloudSiteRepository(event, plan3);
                }
                catch (Exception e) {
                    log.error((Object)("Could not create shadow migration with different cloud site due to Exception: " + e));
                }
            }
            String string = event.getMigrationId();
            String string2 = migration2.getStartedBy();
            Intrinsics.checkNotNull((Object)string2);
            this.triggerShadowPlanChain(string, string2);
        } else if (Intrinsics.areEqual((Object)plan3.isShadowPlan(), (Object)true)) {
            String string = plan3.getOriginalMigrationId();
            Intrinsics.checkNotNull((Object)string);
            this.shadowMigrationVerifier.compareOutcome(string, event.getMigrationId(), event.isMigrationCompletedSuccessfully());
            if (plan3.getShadowMigrationProtocol() == ShadowMigrationProtocol.V4_WDCS) {
                this.deleteCloudSite(event, plan3);
            }
            this.planRepository.delete(plan3.getId());
            String string3 = plan3.getOriginalMigrationId();
            String string4 = migration2.getStartedBy();
            Intrinsics.checkNotNull((Object)string4);
            this.triggerShadowPlanChain(string3, string4);
        } else {
            this.migrationFinalStatusRepository.deleteByMigrationId(event.getMigrationId());
        }
    }

    private final void deleteCloudSite(MigrationCompletionStatusEvent event, Plan plan2) {
        CloudSite cloudSite2 = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, event.getMigrationId(), false, 2, null);
        Intrinsics.checkNotNull((Object)cloudSite2);
        CloudSite cloudSite3 = cloudSite2;
        String string = this.shadowMigrationJobRepository.getJobDetailsByPlanId(plan2.getId());
        Intrinsics.checkNotNull((Object)string);
        String jobId = string;
        this.migrationServiceClient.deleteCloudSite(cloudSite3.getContainerToken(), this.migrationScopeManager.getMigrationScope(cloudSite3), event.getMigrationId(), jobId);
        this.cloudSiteRepository.deleteSite(plan2.getCloudId());
        this.shadowCloudSiteRepository.deleteByPlanId(plan2.getId());
        this.shadowMigrationJobRepository.deleteByPlanId(plan2.getId());
    }

    private final Plan fetchNextShadowPlan(String originalMigrationId) {
        return this.planRepository.fetchFirstOrNullShadowPlan(originalMigrationId);
    }

    private final void triggerShadowPlanChain(String originalMigrationId, String startedBy) {
        Plan nextShadowPlan = this.fetchNextShadowPlan(originalMigrationId);
        if (nextShadowPlan != null) {
            log.debug((Object)("Triggering Shadow Migration with plan id: " + nextShadowPlan + ".planId, original migration id: " + nextShadowPlan.getOriginalMigrationId() + ", migration protocol: " + (Object)((Object)nextShadowPlan.getShadowMigrationProtocol())));
            this.fx3Helper.updateUserCustomAttributes(nextShadowPlan);
            this.migrationExecutionService.startClassicMigration(nextShadowPlan.getId(), startedBy);
        } else {
            this.migrationFinalStatusRepository.deleteByMigrationId(originalMigrationId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/shadow/ShadowMigrationExecutor$Companion;", "", "()V", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

