/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.shadow.db;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusCacheTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.Tuple;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J'\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ)\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "convertToStatusObject", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatus;", "json", "", "create", "", "migrationId", "migrationFinalStatus", "projectId", "", "(Ljava/lang/String;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatus;Ljava/lang/Long;)V", "deleteByMigrationId", "getShadowMigrationMetadata", "phase", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "(Ljava/lang/String;Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;Ljava/lang/Long;)Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatus;", "toString", "Companion", "jira-migration-plugin"})
public final class MigrationFinalStatusRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(MigrationFinalStatusRepository.class);

    @Inject
    public MigrationFinalStatusRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.databaseAccessor = databaseAccessor;
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    private final String toString(MigrationFinalStatus migrationFinalStatus) {
        String string;
        try {
            string = this.mapper.writeValueAsString((Object)migrationFinalStatus);
        }
        catch (IOException ex) {
            log.info("exception occurred while serialising MigrationFinalStatus: " + ex);
            return null;
        }
        return string;
    }

    private final MigrationFinalStatus convertToStatusObject(String json) {
        MigrationFinalStatus migrationFinalStatus;
        try {
            migrationFinalStatus = (MigrationFinalStatus)this.mapper.readValue(json, MigrationFinalStatus.class);
        }
        catch (IOException ex) {
            log.info("exception occurred while de-serialising MigrationFinalStatus: " + ex);
            return null;
        }
        return migrationFinalStatus;
    }

    @Nullable
    public final MigrationFinalStatus getShadowMigrationMetadata(@NotNull String migrationId, @NotNull MigrationTaskType phase, @Nullable Long projectId) {
        MigrationFinalStatus migrationFinalStatus;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        Tuple tuple = (Tuple)this.databaseAccessor.run(arg_0 -> MigrationFinalStatusRepository.getShadowMigrationMetadata$lambda$1(migrationId, phase, projectId, arg_0), OnRollback.NOOP);
        if (tuple != null) {
            Tuple it = tuple;
            boolean bl = false;
            Object object = it.get((Expression)MigrationFinalStatusCacheTable.INSTANCE.getJSON());
            Intrinsics.checkNotNull((Object)object);
            migrationFinalStatus = this.convertToStatusObject((String)object);
        } else {
            migrationFinalStatus = null;
        }
        return migrationFinalStatus;
    }

    public static /* synthetic */ MigrationFinalStatus getShadowMigrationMetadata$default(MigrationFinalStatusRepository migrationFinalStatusRepository, String string, MigrationTaskType migrationTaskType, Long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = null;
        }
        return migrationFinalStatusRepository.getShadowMigrationMetadata(string, migrationTaskType, l);
    }

    public final void create(@NotNull String migrationId, @NotNull MigrationFinalStatus migrationFinalStatus, @Nullable Long projectId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatus, (String)"migrationFinalStatus");
        try {
            String string = this.toString(migrationFinalStatus);
            if (string == null) {
                return;
            }
            String migrationStatusString = string;
            this.databaseAccessor.run(arg_0 -> MigrationFinalStatusRepository.create$lambda$4(migrationId, migrationFinalStatus, migrationStatusString, projectId, arg_0), OnRollback.NOOP);
        }
        catch (Exception ex) {
            log.info("Exception occurred while caching migration final status: " + ex);
        }
    }

    public static /* synthetic */ void create$default(MigrationFinalStatusRepository migrationFinalStatusRepository, String string, MigrationFinalStatus migrationFinalStatus, Long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = null;
        }
        migrationFinalStatusRepository.create(string, migrationFinalStatus, l);
    }

    public final void deleteByMigrationId(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        try {
            this.databaseAccessor.run(arg_0 -> MigrationFinalStatusRepository.deleteByMigrationId$lambda$5(migrationId, arg_0), MigrationFinalStatusRepository::deleteByMigrationId$lambda$6);
        }
        catch (Exception ex) {
            log.info("Exception occurred while deleting cached migration entity: " + ex);
        }
    }

    private static final Tuple getShadowMigrationMetadata$lambda$1(String $migrationId, MigrationTaskType $phase, Long $projectId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        Intrinsics.checkNotNullParameter((Object)((Object)$phase), (String)"$phase");
        QueryBase queryBase = MigrationFinalStatusCacheTable.INSTANCE.all();
        queryBase = ((SQLQuery)db.select((Expression[])Arrays.copyOf(queryBase, ((Path[])queryBase).length)).from((Expression)MigrationFinalStatusCacheTable.INSTANCE)).where((Predicate)MigrationFinalStatusCacheTable.INSTANCE.getMIGRATION_ID().eq((Object)$migrationId).and((Predicate)MigrationFinalStatusCacheTable.INSTANCE.getTASK_TYPE().eq((Object)$phase.getTaskTypeName())));
        SQLQuery $this$getShadowMigrationMetadata_u24lambda_u241_u24lambda_u240 = (SQLQuery)queryBase;
        boolean bl = false;
        if ($projectId != null) {
            $this$getShadowMigrationMetadata_u24lambda_u241_u24lambda_u240.where((Predicate)MigrationFinalStatusCacheTable.INSTANCE.getPROJECT_ID().eq((Object)$projectId));
        } else {
            $this$getShadowMigrationMetadata_u24lambda_u241_u24lambda_u240.where((Predicate)MigrationFinalStatusCacheTable.INSTANCE.getPROJECT_ID().isNull());
        }
        List list = ((SQLQuery)queryBase).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return (Tuple)CollectionsKt.firstOrNull((List)list);
    }

    private static final SQLInsertClause create$lambda$4(String $migrationId, MigrationFinalStatus $migrationFinalStatus, String $migrationStatusString, Long $projectId, DatabaseConnection db) {
        SQLInsertClause sQLInsertClause;
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        Intrinsics.checkNotNullParameter((Object)$migrationFinalStatus, (String)"$migrationFinalStatus");
        Intrinsics.checkNotNullParameter((Object)$migrationStatusString, (String)"$migrationStatusString");
        SQLInsertClause $this$create_u24lambda_u244_u24lambda_u243 = sQLInsertClause = db.insert((RelationalPath)MigrationFinalStatusCacheTable.INSTANCE);
        boolean bl = false;
        $this$create_u24lambda_u244_u24lambda_u243.set((Path)MigrationFinalStatusCacheTable.INSTANCE.getMIGRATION_ID(), (Object)$migrationId);
        $this$create_u24lambda_u244_u24lambda_u243.set((Path)MigrationFinalStatusCacheTable.INSTANCE.getTASK_TYPE(), (Object)$migrationFinalStatus.getPhase());
        $this$create_u24lambda_u244_u24lambda_u243.set((Path)MigrationFinalStatusCacheTable.INSTANCE.getJSON(), (Object)$migrationStatusString);
        $this$create_u24lambda_u244_u24lambda_u243.set((Path)MigrationFinalStatusCacheTable.INSTANCE.getPROJECT_ID(), (Object)$projectId);
        $this$create_u24lambda_u244_u24lambda_u243.execute();
        return sQLInsertClause;
    }

    private static final Long deleteByMigrationId$lambda$5(String $migrationId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        return db.delete((RelationalPath)MigrationFinalStatusCacheTable.INSTANCE).where((Predicate)MigrationFinalStatusCacheTable.INSTANCE.getMIGRATION_ID().eq((Object)$migrationId)).execute();
    }

    private static final void deleteByMigrationId$lambda$6() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

