/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.shadow.db;

import com.atlassian.jira.migration.shadow.db.ShadowCloudSiteTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/shadow/db/ShadowCloudSiteRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "create", "", "planId", "", "cloudId", "deleteByPlanId", "isShadowCloud", "", "Companion", "jira-migration-plugin"})
public final class ShadowCloudSiteRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(ShadowCloudSiteRepository.class);

    @Inject
    public ShadowCloudSiteRepository(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    public final void create(@NotNull String planId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        try {
            this.databaseAccessor.run(arg_0 -> ShadowCloudSiteRepository.create$lambda$1(planId, cloudId2, arg_0), OnRollback.NOOP);
        }
        catch (Exception ex) {
            log.info("Exception occurred while storing cloudId for shadow: " + ex);
        }
    }

    public final boolean isShadowCloud(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        int data2 = 0;
        try {
            Object object = this.databaseAccessor.run(arg_0 -> ShadowCloudSiteRepository.isShadowCloud$lambda$2(cloudId2, arg_0), OnRollback.NOOP);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
            data2 = ((Number)object).intValue();
        }
        catch (Exception ex) {
            log.info("Exception occurred while fetching planId for shadow cloudId: " + ex);
        }
        return data2 > 0;
    }

    public final void deleteByPlanId(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        try {
            this.databaseAccessor.run(arg_0 -> ShadowCloudSiteRepository.deleteByPlanId$lambda$3(planId, arg_0), OnRollback.NOOP);
        }
        catch (Exception ex) {
            log.info("Exception occurred while deleting shadow cloud id: " + ex);
        }
    }

    private static final SQLInsertClause create$lambda$1(String $planId, String $cloudId, DatabaseConnection db) {
        SQLInsertClause sQLInsertClause;
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        Intrinsics.checkNotNullParameter((Object)$cloudId, (String)"$cloudId");
        SQLInsertClause $this$create_u24lambda_u241_u24lambda_u240 = sQLInsertClause = db.insert((RelationalPath)ShadowCloudSiteTable.INSTANCE);
        boolean bl = false;
        $this$create_u24lambda_u241_u24lambda_u240.set((Path)ShadowCloudSiteTable.INSTANCE.getPLAN_ID(), (Object)$planId);
        $this$create_u24lambda_u241_u24lambda_u240.set((Path)ShadowCloudSiteTable.INSTANCE.getCLOUD_ID(), (Object)$cloudId);
        $this$create_u24lambda_u241_u24lambda_u240.execute();
        return sQLInsertClause;
    }

    private static final Integer isShadowCloud$lambda$2(String $cloudId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$cloudId, (String)"$cloudId");
        Path[] pathArray = ShadowCloudSiteTable.INSTANCE.all();
        return (int)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)ShadowCloudSiteTable.INSTANCE)).where((Predicate)ShadowCloudSiteTable.INSTANCE.getCLOUD_ID().eq((Object)$cloudId))).fetchCount();
    }

    private static final Long deleteByPlanId$lambda$3(String $planId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        return db.delete((RelationalPath)ShadowCloudSiteTable.INSTANCE).where((Predicate)ShadowCloudSiteTable.INSTANCE.getPLAN_ID().eq((Object)$planId)).execute();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/shadow/db/ShadowCloudSiteRepository$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

