/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.shadow.db;

import com.atlassian.jira.migration.shadow.db.ShadowMigrationJobDetailsTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/shadow/db/ShadowMigrationJobRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "deleteByPlanId", "", "planId", "", "getJobDetailsByPlanId", "saveJobDetails", "jobId", "Companion", "jira-migration-plugin"})
public final class ShadowMigrationJobRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(ShadowMigrationJobRepository.class);

    @Inject
    public ShadowMigrationJobRepository(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @Nullable
    public final String getJobDetailsByPlanId(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        try {
            String string;
            Tuple tuple = (Tuple)this.databaseAccessor.run(arg_0 -> ShadowMigrationJobRepository.getJobDetailsByPlanId$lambda$0(planId, arg_0), OnRollback.NOOP);
            if (tuple != null) {
                Tuple it = tuple;
                boolean bl = false;
                string = (String)it.get((Expression)ShadowMigrationJobDetailsTable.INSTANCE.getJOB_ID());
            } else {
                string = null;
            }
            return string;
        }
        catch (Exception e) {
            log.info("exception occurred while fetching jobId for plan with id " + planId);
            return null;
        }
    }

    public final void saveJobDetails(@NotNull String planId, @NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        try {
            this.databaseAccessor.run(arg_0 -> ShadowMigrationJobRepository.saveJobDetails$lambda$3(jobId, planId, arg_0), OnRollback.NOOP);
        }
        catch (Exception ex) {
            log.info("Exception occurred while storing shadow job details for " + planId + ": " + ex);
        }
    }

    public final void deleteByPlanId(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        try {
            this.databaseAccessor.run(arg_0 -> ShadowMigrationJobRepository.deleteByPlanId$lambda$4(planId, arg_0), ShadowMigrationJobRepository::deleteByPlanId$lambda$5);
        }
        catch (Exception ex) {
            log.info("Exception occurred while deleting shadow migration job details for " + planId + ": " + ex);
        }
    }

    private static final Tuple getJobDetailsByPlanId$lambda$0(String $planId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        Path[] pathArray = ShadowMigrationJobDetailsTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)ShadowMigrationJobDetailsTable.INSTANCE)).where((Predicate)ShadowMigrationJobDetailsTable.INSTANCE.getPLAN_ID().eq((Object)$planId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return (Tuple)CollectionsKt.firstOrNull((List)list);
    }

    private static final SQLInsertClause saveJobDetails$lambda$3(String $jobId, String $planId, DatabaseConnection db) {
        SQLInsertClause sQLInsertClause;
        Intrinsics.checkNotNullParameter((Object)$jobId, (String)"$jobId");
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        SQLInsertClause $this$saveJobDetails_u24lambda_u243_u24lambda_u242 = sQLInsertClause = db.insert((RelationalPath)ShadowMigrationJobDetailsTable.INSTANCE);
        boolean bl = false;
        $this$saveJobDetails_u24lambda_u243_u24lambda_u242.set((Path)ShadowMigrationJobDetailsTable.INSTANCE.getJOB_ID(), (Object)$jobId);
        $this$saveJobDetails_u24lambda_u243_u24lambda_u242.set((Path)ShadowMigrationJobDetailsTable.INSTANCE.getPLAN_ID(), (Object)$planId);
        $this$saveJobDetails_u24lambda_u243_u24lambda_u242.execute();
        return sQLInsertClause;
    }

    private static final Long deleteByPlanId$lambda$4(String $planId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        return db.delete((RelationalPath)ShadowMigrationJobDetailsTable.INSTANCE).where((Predicate)ShadowMigrationJobDetailsTable.INSTANCE.getPLAN_ID().eq((Object)$planId)).execute();
    }

    private static final void deleteByPlanId$lambda$5() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/shadow/db/ShadowMigrationJobRepository$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

