/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.shadow.verify;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.shadow.event.ShadowMigrationVerificationEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/shadow/verify/ShadowMigrationVerifier;", "", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "getMigrationEventBus", "()Lcom/atlassian/jira/migration/events/MigrationEventBus;", "getMigrationRepository", "()Lcom/atlassian/jira/migration/migration/MigrationRepository;", "tasksToVerify", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "compareMigrationOutcome", "Lkotlin/Pair;", "", "", "outcome1", "", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "outcome2", "compareOutcome", "", "originalMigrationId", "shadowMigrationId", "migrationStatus", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nShadowMigrationVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowMigrationVerifier.kt\ncom/atlassian/jira/migration/shadow/verify/ShadowMigrationVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n766#2:87\n857#2,2:88\n1045#2:90\n766#2:91\n857#2,2:92\n1045#2:94\n1855#2,2:95\n*S KotlinDebug\n*F\n+ 1 ShadowMigrationVerifier.kt\ncom/atlassian/jira/migration/shadow/verify/ShadowMigrationVerifier\n*L\n36#1:87\n36#1:88,2\n36#1:90\n37#1:91\n37#1:92,2\n37#1:94\n42#1:95,2\n*E\n"})
public final class ShadowMigrationVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final Set<MigrationTaskType> tasksToVerify;
    private static final Logger log = Logger.getLogger(ShadowMigrationVerifier.class);

    @Inject
    public ShadowMigrationVerifier(@NotNull MigrationRepository migrationRepository, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.migrationRepository = migrationRepository;
        this.migrationEventBus = migrationEventBus;
        MigrationTaskType[] migrationTaskTypeArray = new MigrationTaskType[]{MigrationTaskType.PROJECT_DATA_MIGRATION, MigrationTaskType.CROSS_PROJECT_DATA_MIGRATION};
        this.tasksToVerify = SetsKt.setOf((Object[])migrationTaskTypeArray);
    }

    @NotNull
    public final MigrationRepository getMigrationRepository() {
        return this.migrationRepository;
    }

    @NotNull
    public final MigrationEventBus getMigrationEventBus() {
        return this.migrationEventBus;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Boolean, String> compareMigrationOutcome(List<GetTaskStatusResponse.TaskProgress> outcome1, List<GetTaskStatusResponse.TaskProgress> outcome2) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        void $this$sortedBy$iv2;
        void $this$filterTo$iv$iv2;
        if (outcome1 == null && outcome2 == null) {
            return new Pair((Object)true, null);
        }
        if (outcome1 == null || outcome2 == null) {
            return new Pair((Object)false, (Object)"One of the migration outcome is null");
        }
        Iterable $this$filter$iv = outcome1;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            if (!this.tasksToVerify.contains((Object)it.getTask().getMigrationTaskType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List filteredOutcome1 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getTask().getTaskId());
                it = (GetTaskStatusResponse.TaskProgress)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getTask().getTaskId())));
            }
        });
        Iterable $this$filter$iv2 = outcome2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            if (!this.tasksToVerify.contains((Object)it.getTask().getMigrationTaskType())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$sortedBy2 = false;
        List filteredOutcome2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getTask().getTaskId());
                it = (GetTaskStatusResponse.TaskProgress)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getTask().getTaskId())));
            }
        });
        if (filteredOutcome1.size() != filteredOutcome2.size()) {
            return new Pair((Object)false, (Object)"Either of the outcomes contain extra tasks.");
        }
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)filteredOutcome1, (Iterable)filteredOutcome2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)pair.getFirst(), (Object)pair.getSecond())) continue;
            return new Pair((Object)false, (Object)new Pair((Object)((GetTaskStatusResponse.TaskProgress)pair.getFirst()).toString(), (Object)((GetTaskStatusResponse.TaskProgress)pair.getSecond()).toString()).toString());
        }
        return new Pair((Object)true, null);
    }

    public final void compareOutcome(@NotNull String originalMigrationId, @NotNull String shadowMigrationId, boolean migrationStatus) {
        Intrinsics.checkNotNullParameter((Object)originalMigrationId, (String)"originalMigrationId");
        Intrinsics.checkNotNullParameter((Object)shadowMigrationId, (String)"shadowMigrationId");
        Migration migration = this.migrationRepository.findByMigrationId(originalMigrationId);
        Intrinsics.checkNotNull((Object)migration);
        Migration originalMigOutcome = migration;
        Migration migration2 = this.migrationRepository.findByMigrationId(shadowMigrationId);
        Intrinsics.checkNotNull((Object)migration2);
        Migration shadowMigOutcome = migration2;
        Pair<Boolean, String> comparisonStatus = this.compareMigrationOutcome(originalMigOutcome.getOutcome(), shadowMigOutcome.getOutcome());
        if (((Boolean)comparisonStatus.getFirst()).booleanValue()) {
            log.debug((Object)"Shadow Migration Verification passed");
            this.migrationEventBus.post(new ShadowMigrationVerificationEvent(shadowMigrationId, originalMigrationId, migrationStatus, true, null));
        } else {
            log.debug((Object)"Shadow Migration Verification failed");
            this.migrationEventBus.post(new ShadowMigrationVerificationEvent(shadowMigrationId, originalMigrationId, migrationStatus, false, (String)comparisonStatus.getSecond()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/shadow/verify/ShadowMigrationVerifier$Companion;", "", "()V", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

