/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.tracking;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.events.PollingErrorEvent;
import com.atlassian.jira.migration.tracking.polling.AbstractPoller;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.polling.Poller;
import com.atlassian.jira.migration.tracking.polling.PollerConfig;
import com.atlassian.jira.migration.tracking.polling.PollerFactory;
import com.atlassian.jira.migration.tracking.polling.StatusPoller;
import com.atlassian.jira.migration.tracking.polling.V4Poller;
import com.atlassian.jira.migration.tracking.tasks.V4Worker;
import com.atlassian.jira.migration.tracking.tasks.Worker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0019J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020 H\u0007J\b\u0010!\u001a\u00020\u000fH\u0007J\b\u0010\"\u001a\u00020\u000fH\u0007J\u0006\u0010#\u001a\u00020\u000fJ\u0006\u0010$\u001a\u00020\u000fJ\b\u0010%\u001a\u00020\u000fH\u0007J\u0006\u0010&\u001a\u00020\u000fJ\u0006\u0010'\u001a\u00020\u000fJ\u0006\u0010(\u001a\u00020\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/atlassian/jira/migration/tracking/MigrationTracker;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "pollerFactory", "Lcom/atlassian/jira/migration/tracking/polling/PollerFactory;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/tracking/polling/PollerFactory;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "registeredPollers", "", "Lcom/atlassian/jira/migration/tracking/polling/AbstractPoller;", "addAndStartStatusPoller", "", "config", "Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;", "addAndStartV4WorkPoller", "worker", "Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "addAndStartWorkPoller", "Lcom/atlassian/jira/migration/tracking/tasks/Worker;", "clearInProgressMigrationIds", "isAnyV3PollerRunning", "", "isAnyV4PollerRunning", "isMigrationInProgress", "onMigrationStatusUpdate", "event", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent;", "onPollingError", "Lcom/atlassian/jira/migration/events/PollingErrorEvent;", "postConstruct", "preDestroy", "startPollingWorkForMigration", "startTracking", "stopPollingWorkForMigration", "stopTracking", "stopV3Pollers", "stopV4Pollers", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationTracker.kt\ncom/atlassian/jira/migration/tracking/MigrationTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n1855#2,2:198\n1855#2,2:200\n1747#2,3:202\n1747#2,3:205\n*S KotlinDebug\n*F\n+ 1 MigrationTracker.kt\ncom/atlassian/jira/migration/tracking/MigrationTracker\n*L\n58#1:198,2\n68#1:200,2\n79#1:202,3\n85#1:205,3\n*E\n"})
public final class MigrationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final PollerFactory pollerFactory;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final List<AbstractPoller> registeredPollers;
    private static final Logger log = LoggerFactory.getLogger(MigrationTracker.class);

    @Inject
    public MigrationTracker(@NotNull MigrationEventBus migrationEventBus, @NotNull PollerFactory pollerFactory, @NotNull InProgressMigrationIds migrationIds) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)pollerFactory, (String)"pollerFactory");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        this.migrationEventBus = migrationEventBus;
        this.pollerFactory = pollerFactory;
        this.migrationIds = migrationIds;
        ExecutorService executorService = Executors.newCachedThreadPool(new GroupedThreadFactory("MigrationTracker"));
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        this.executor = executorService;
        this.registeredPollers = new ArrayList();
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        log.info("Shutting down pollers");
        this.executor.shutdownNow();
        this.migrationEventBus.unregister(this);
    }

    public final void startTracking() {
        log.info("Starting tracking");
        Iterable $this$forEach$iv = this.registeredPollers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractPoller it = (AbstractPoller)element$iv;
            boolean bl = false;
            this.executor.submit(() -> MigrationTracker.startTracking$lambda$1$lambda$0(it));
        }
    }

    public final void stopTracking() {
        log.info("Stopping tracking");
        Iterable $this$forEach$iv = this.registeredPollers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractPoller it = (AbstractPoller)element$iv;
            boolean bl = false;
            it.stopPolling();
        }
    }

    public final boolean isAnyV4PollerRunning() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.registeredPollers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractPoller it = (AbstractPoller)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof V4Poller)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isAnyV3PollerRunning() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.registeredPollers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractPoller it = (AbstractPoller)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof Poller)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void stopV4Pollers() {
        Iterator<AbstractPoller> iterator2 = this.registeredPollers.iterator();
        while (iterator2.hasNext()) {
            AbstractPoller poller = iterator2.next();
            if (!(poller instanceof V4Poller)) continue;
            log.info("Stopping tracking of V4Poller");
            poller.stopPolling();
            iterator2.remove();
        }
    }

    public final void stopV3Pollers() {
        Iterator<AbstractPoller> iterator2 = this.registeredPollers.iterator();
        while (iterator2.hasNext()) {
            AbstractPoller poller = iterator2.next();
            if (!(poller instanceof Poller)) continue;
            log.info("Stopping tracking of V3Poller");
            poller.stopPolling();
            iterator2.remove();
        }
    }

    public final void addAndStartWorkPoller(@NotNull PollerConfig config2, @NotNull Worker worker) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        int n = config2.getParallelism();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Poller poller = this.pollerFactory.createWorkPoller(config2, worker, this.migrationIds);
            log.info("Creating task poller: " + poller.getPollerId());
            this.registeredPollers.add(poller);
            this.executor.submit(() -> MigrationTracker.addAndStartWorkPoller$lambda$6$lambda$5(poller));
        }
    }

    public final void addAndStartStatusPoller(@NotNull PollerConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        StatusPoller statusPoller = this.pollerFactory.createStatusPoller(config2, this.migrationIds);
        log.info("Creating status poller");
        this.registeredPollers.add(statusPoller);
        this.executor.submit(() -> MigrationTracker.addAndStartStatusPoller$lambda$7(statusPoller));
    }

    public final void addAndStartV4WorkPoller(@NotNull PollerConfig config2, @NotNull V4Worker worker) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        int n = config2.getParallelism();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            V4Poller poller = this.pollerFactory.createV4Poller(config2, worker, this.migrationIds);
            log.info("Creating V4 command poller: " + poller.getPollerId());
            this.registeredPollers.add(poller);
            this.executor.submit(() -> MigrationTracker.addAndStartV4WorkPoller$lambda$9$lambda$8(poller));
        }
    }

    public final void startPollingWorkForMigration() {
        this.clearInProgressMigrationIds();
    }

    @VisibleForTesting
    public final void stopPollingWorkForMigration() {
        this.clearInProgressMigrationIds();
    }

    public final boolean isMigrationInProgress() {
        return SequencesKt.any(this.migrationIds.sequence());
    }

    public final void clearInProgressMigrationIds() {
        this.migrationIds.clear();
    }

    @Subscribe
    public final void onPollingError(@NotNull PollingErrorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        log.error("unrecoverable error in poller for migration " + event.getMigrationId() + ", stop polling", event.getThrowable());
        this.stopPollingWorkForMigration();
    }

    @Subscribe
    public final void onMigrationStatusUpdate(@NotNull MigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (MigrationStatusUpdatedEvent.Status.ERRORED == event.getStatus() || MigrationStatusUpdatedEvent.Status.FINISHED == event.getStatus() || MigrationStatusUpdatedEvent.Status.CANCELLED == event.getStatus()) {
            log.info("Migration: " + event.getMigrationId() + " updated to " + (Object)((Object)event.getStatus()) + ". Stop polling");
            this.stopPollingWorkForMigration();
        }
    }

    private static final void startTracking$lambda$1$lambda$0(AbstractPoller $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        $it.startPolling();
    }

    private static final void addAndStartWorkPoller$lambda$6$lambda$5(Poller $poller) {
        Intrinsics.checkNotNullParameter((Object)$poller, (String)"$poller");
        $poller.startPolling();
    }

    private static final void addAndStartStatusPoller$lambda$7(StatusPoller $statusPoller) {
        Intrinsics.checkNotNullParameter((Object)$statusPoller, (String)"$statusPoller");
        $statusPoller.startPolling();
    }

    private static final void addAndStartV4WorkPoller$lambda$9$lambda$8(V4Poller $poller) {
        Intrinsics.checkNotNullParameter((Object)$poller, (String)"$poller");
        $poller.startPolling();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/tracking/MigrationTracker$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

