/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.tracking.polling;

import com.atlassian.jira.migration.tracking.utils.SystemTimeProvider;
import com.atlassian.jira.migration.tracking.utils.ThreadUtils;
import com.atlassian.jira.migration.tracking.utils.TimeProvider;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0010J\u0006\u0010\u0017\u001a\u00020\u0010R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/AbstractPoller;", "", "pollerId", "", "pollingDelay", "Ljava/time/Duration;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "timeProvider", "Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;", "(Ljava/lang/String;Ljava/time/Duration;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;)V", "currentState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/atlassian/jira/migration/tracking/polling/AbstractPoller$Companion$PollerState;", "kotlin.jvm.PlatformType", "doPoll", "", "execute", "isPolling", "", "isStopped", "isStopping", "startPolling", "stopPolling", "Companion", "jira-migration-plugin"})
public abstract class AbstractPoller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pollerId;
    @NotNull
    private final Duration pollingDelay;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final AtomicReference<Companion.PollerState> currentState;
    private static final Logger log = LoggerFactory.getLogger(AbstractPoller.class);

    public AbstractPoller(@NotNull String pollerId, @NotNull Duration pollingDelay, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)pollerId, (String)"pollerId");
        Intrinsics.checkNotNullParameter((Object)pollingDelay, (String)"pollingDelay");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.pollerId = pollerId;
        this.pollingDelay = pollingDelay;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.timeProvider = timeProvider;
        this.currentState = new AtomicReference<Companion.PollerState>(Companion.PollerState.STOPPED);
    }

    public /* synthetic */ AbstractPoller(String string, Duration duration, JiraThreadLocalUtil jiraThreadLocalUtil, TimeProvider timeProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            timeProvider = new SystemTimeProvider();
        }
        this(string, duration, jiraThreadLocalUtil, timeProvider);
    }

    public final void startPolling() {
        while (this.isStopping()) {
            log.debug(this.pollerId + ": Wait for previous shutdown");
            this.timeProvider.sleep(150L, TimeUnit.MILLISECONDS);
        }
        if (this.currentState.compareAndSet(Companion.PollerState.STOPPED, Companion.PollerState.RUNNING)) {
            ThreadUtils.INSTANCE.safeExecutePeriodicallyUntilStopped((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    AbstractPoller.access$execute((AbstractPoller)this.receiver);
                }
            }), this.pollingDelay, (Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

                @NotNull
                public final Boolean invoke() {
                    return ((AbstractPoller)this.receiver).isPolling();
                }
            }));
            this.currentState.set(Companion.PollerState.STOPPED);
        }
    }

    public final boolean isPolling() {
        return this.currentState.get() == Companion.PollerState.RUNNING;
    }

    public final boolean isStopping() {
        return this.currentState.get() == Companion.PollerState.STOPPING;
    }

    public final boolean isStopped() {
        return this.currentState.get() == Companion.PollerState.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void execute() {
        try {
            this.jiraThreadLocalUtil.preCall();
            this.doPoll();
        }
        finally {
            this.jiraThreadLocalUtil.postCall(org.apache.log4j.Logger.getLogger(AbstractPoller.class));
        }
    }

    public abstract void doPoll();

    public final void stopPolling() {
        this.currentState.compareAndSet(Companion.PollerState.RUNNING, Companion.PollerState.STOPPING);
    }

    public static final /* synthetic */ void access$execute(AbstractPoller $this) {
        $this.execute();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/AbstractPoller$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PollerState", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/AbstractPoller$Companion$PollerState;", "", "(Ljava/lang/String;I)V", "RUNNING", "STOPPING", "STOPPED", "jira-migration-plugin"})
        private static final class PollerState
        extends Enum<PollerState> {
            public static final /* enum */ PollerState RUNNING = new PollerState();
            public static final /* enum */ PollerState STOPPING = new PollerState();
            public static final /* enum */ PollerState STOPPED = new PollerState();
            private static final /* synthetic */ PollerState[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static PollerState[] values() {
                return (PollerState[])$VALUES.clone();
            }

            public static PollerState valueOf(String value) {
                return Enum.valueOf(PollerState.class, value);
            }

            @NotNull
            public static EnumEntries<PollerState> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = pollerStateArray = new PollerState[]{PollerState.RUNNING, PollerState.STOPPING, PollerState.STOPPED};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

