/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.tracking.polling;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.progress.MigrationTerminator;
import com.atlassian.jira.migration.tracking.polling.InProgressMigration;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B1\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB=\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\b\u001a\u00020\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ3\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0010\b\u0002\u0010!\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0096\u0001J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u0012J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'J!\u0010(\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0096\u0001J\u001a\u0010)\u001a\u00020**\u00020+2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002RC\u0010\u0010\u001a*\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0015 \u0013*\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u00140\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u0013*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "Lcom/atlassian/jira/migration/progress/MigrationTerminator;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationTerminator", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/cache/CacheManager;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/progress/MigrationTerminator;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "instantProvider", "Lkotlin/Function0;", "Ljava/time/Instant;", "(Lcom/atlassian/cache/CacheManager;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;Lkotlin/jvm/functions/Function0;Lcom/atlassian/jira/migration/progress/MigrationTerminator;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "cache", "Lcom/atlassian/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigration;", "getCache", "()Lcom/atlassian/cache/Cache;", "cache$delegate", "Lkotlin/Lazy;", "log", "Lorg/slf4j/Logger;", "checkTerminateOrDefault", "", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "migrationId", "message", "defaultStatus", "clear", "", "getMigrationType", "Lcom/atlassian/jira/migration/plan/MigrationType;", "sequence", "Lkotlin/sequences/Sequence;", "terminateMigration", "isStale", "", "Lcom/atlassian/jira/migration/migration/Migration;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nInProgressMigrationIds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InProgressMigrationIds.kt\ncom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,117:1\n3190#2,10:118\n1855#2,2:129\n1549#2:131\n1620#2,3:132\n1#3:128\n37#4,2:135\n*S KotlinDebug\n*F\n+ 1 InProgressMigrationIds.kt\ncom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds\n*L\n74#1:118,10\n76#1:129,2\n83#1:131\n83#1:132,3\n84#1:135,2\n*E\n"})
public final class InProgressMigrationIds
implements MigrationTerminator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final Function0<Instant> instantProvider;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final /* synthetic */ MigrationTerminator $$delegate_0;
    private final Logger log;
    @NotNull
    private final Lazy cache$delegate;
    @NotNull
    private static final String CACHE_NAME = InProgressMigrationIds.class.getName() + ".cache";
    @NotNull
    private static final Duration MAX_IN_PROGRESS_MIGRATION_WINDOW;
    @NotNull
    private static final Duration MAX_IN_PROGRESS_MIGRATION_WINDOW_V4;
    @NotNull
    private static final String CACHE_KEY = "inProgMigs";

    @VisibleForTesting
    public InProgressMigrationIds(@NotNull CacheManager cacheManager, @NotNull MigrationRepository migrationRepository, @NotNull PlanRepository planRepository, @NotNull Function0<Instant> instantProvider, @NotNull MigrationTerminator migrationTerminator, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter(instantProvider, (String)"instantProvider");
        Intrinsics.checkNotNullParameter((Object)migrationTerminator, (String)"migrationTerminator");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationRepository = migrationRepository;
        this.planRepository = planRepository;
        this.instantProvider = instantProvider;
        this.migrationFeatures = migrationFeatures;
        this.$$delegate_0 = migrationTerminator;
        this.log = LoggerFactory.getLogger(InProgressMigrationIds.class);
        this.cache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Cache<String, InProgressMigration[]>>(cacheManager){
            final /* synthetic */ CacheManager $cacheManager;
            {
                this.$cacheManager = $cacheManager;
                super(0);
            }

            @NotNull
            public final Cache<String, InProgressMigration[]> invoke() {
                return this.$cacheManager.getCache(InProgressMigrationIds.Companion.getCACHE_NAME(), null, new CacheSettingsBuilder().replicateViaInvalidation().expireAfterWrite(15L, TimeUnit.MINUTES).remote().build());
            }
        }));
    }

    @Override
    @Nullable
    public List<GetTaskStatusResponse.TaskProgress> checkTerminateOrDefault(@NotNull String migrationId, @NotNull String message, @Nullable List<GetTaskStatusResponse.TaskProgress> defaultStatus) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.$$delegate_0.checkTerminateOrDefault(migrationId, message, defaultStatus);
    }

    @Override
    @Nullable
    public List<GetTaskStatusResponse.TaskProgress> terminateMigration(@NotNull String migrationId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.$$delegate_0.terminateMigration(migrationId, message);
    }

    @Inject
    public InProgressMigrationIds(@NotNull CacheManager cacheManager, @NotNull MigrationRepository migrationRepository, @NotNull PlanRepository planRepository, @Qualifier(value="MigrationTerminator") @NotNull MigrationTerminator migrationTerminator, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationTerminator, (String)"migrationTerminator");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this(cacheManager, migrationRepository, planRepository, (Function0<Instant>)((Function0)1.INSTANCE), migrationTerminator, migrationFeatures);
    }

    private final Cache<String, InProgressMigration[]> getCache() {
        Lazy lazy = this.cache$delegate;
        return (Cache)lazy.getValue();
    }

    public final void clear() {
        this.log.info("Clearing in-progress migration IDs");
        this.getCache().removeAll();
    }

    @NotNull
    public final Sequence<InProgressMigration> sequence() {
        Object object = this.getCache().get((Object)CACHE_KEY, () -> InProgressMigrationIds.sequence$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Object[] inProgressMigrations = (InProgressMigration[])object;
        return ArraysKt.asSequence((Object[])inProgressMigrations);
    }

    @NotNull
    public final MigrationType getMigrationType(@NotNull String migrationId) {
        String planId;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String string = planId = this.migrationRepository.findPlanIdByMigrationId(migrationId);
        Intrinsics.checkNotNull((Object)string);
        return this.planRepository.getMigrationTypeForPlan(string);
    }

    private final boolean isStale(Migration $this$isStale, Function0<Instant> instantProvider) {
        Duration maxInProgressMigrationWindow = $this$isStale.getProtocol() == MigrationProtocol.V4 && this.migrationFeatures.getDecreaseMigrationTimeout() ? MAX_IN_PROGRESS_MIGRATION_WINDOW_V4 : MAX_IN_PROGRESS_MIGRATION_WINDOW;
        return $this$isStale.getUpdated().compareTo(((Instant)instantProvider.invoke()).minus(maxInProgressMigrationWindow)) < 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final InProgressMigration[] sequence$lambda$4(InProgressMigrationIds this$0) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$partition$iv = this$0.migrationRepository.getInProgressMigrations();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Migration it = (Migration)element$iv;
            boolean bl3 = false;
            if (this$0.isStale(it, this$0.instantProvider)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        boolean bl = false;
        List staleMig = (List)pair.component1();
        List freshMig = (List)pair.component2();
        Iterable $this$forEach$iv = staleMig;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Migration it = (Migration)element$iv;
            boolean bl2 = false;
            this$0.log.error("migration with id " + it.getMigrationId() + " hasn't been updated in more than " + MAX_IN_PROGRESS_MIGRATION_WINDOW.toDays() + " days, terminating migration.");
            this$0.terminateMigration(it.getMigrationId(), "Migration with id: " + it.getMigrationId() + " has timed out. Create a new migration and run the migration again.");
        }
        Iterable $this$map$iv = freshMig;
        boolean $i$f$map = false;
        Iterable bl3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Migration migration = (Migration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(new InProgressMigration(it.getMigrationId(), it.getProtocol()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new InProgressMigration[0]);
    }

    static {
        Duration duration = Duration.ofDays(14L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        MAX_IN_PROGRESS_MIGRATION_WINDOW = duration;
        Duration duration2 = Duration.ofDays(3L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofDays(...)");
        MAX_IN_PROGRESS_MIGRATION_WINDOW_V4 = duration2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds$Companion;", "", "()V", "CACHE_KEY", "", "CACHE_NAME", "getCACHE_NAME$annotations", "getCACHE_NAME", "()Ljava/lang/String;", "MAX_IN_PROGRESS_MIGRATION_WINDOW", "Ljava/time/Duration;", "getMAX_IN_PROGRESS_MIGRATION_WINDOW", "()Ljava/time/Duration;", "MAX_IN_PROGRESS_MIGRATION_WINDOW_V4", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCACHE_NAME() {
            return CACHE_NAME;
        }

        @VisibleForTesting
        public static /* synthetic */ void getCACHE_NAME$annotations() {
        }

        @NotNull
        public final Duration getMAX_IN_PROGRESS_MIGRATION_WINDOW() {
            return MAX_IN_PROGRESS_MIGRATION_WINDOW;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

