/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.tracking.polling;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.TransferMigrationTask;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferResultRequest;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.platform.V3PollAndLockRequest;
import com.atlassian.jira.migration.progress.MigrationTerminator;
import com.atlassian.jira.migration.tracking.polling.AbstractPoller;
import com.atlassian.jira.migration.tracking.polling.InProgressMigration;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.polling.PollerConfig;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.Worker;
import com.atlassian.jira.migration.tracking.utils.SystemTimeProvider;
import com.atlassian.jira.migration.tracking.utils.TimeProvider;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.TransferId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0001\u0010\u0011\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J3\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0010\b\u0002\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cH\u0096\u0001J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\"H\u0016J\u0018\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0016\u0010)\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\bJ\u0018\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0002J!\u0010.\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0096\u0001R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00060"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/Poller;", "Lcom/atlassian/jira/migration/tracking/polling/AbstractPoller;", "Lcom/atlassian/jira/migration/progress/MigrationTerminator;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "pollerId", "", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "worker", "Lcom/atlassian/jira/migration/tracking/tasks/Worker;", "config", "Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "migrationTerminator", "timeProvider", "Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Ljava/lang/String;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/tracking/tasks/Worker;Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/progress/MigrationTerminator;Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;)V", "getConfig", "()Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;", "getPollerId", "()Ljava/lang/String;", "getWorker", "()Lcom/atlassian/jira/migration/tracking/tasks/Worker;", "checkTerminateOrDefault", "", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "migrationId", "message", "defaultStatus", "dispatchTask", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "doPoll", "pollForTaskAndDispatch", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "pollForTaskAndDispatchNoThrow", "reportFailureNoThrow", "", "e", "", "terminateMigration", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPoller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Poller.kt\ncom/atlassian/jira/migration/tracking/polling/Poller\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1313#2,2:187\n1549#3:189\n1620#3,3:190\n1855#3,2:193\n*S KotlinDebug\n*F\n+ 1 Poller.kt\ncom/atlassian/jira/migration/tracking/polling/Poller\n*L\n63#1:187,2\n129#1:189\n129#1:190,3\n130#1:193,2\n*E\n"})
public final class Poller
extends AbstractPoller
implements MigrationTerminator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final String pollerId;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final Worker worker;
    @NotNull
    private final PollerConfig config;
    private final /* synthetic */ MigrationTerminator $$delegate_0;
    private static final Logger log = LoggerFactory.getLogger(Poller.class);

    public Poller(@NotNull PlatformService platformService, @NotNull DiscoveryService discoveryService, @NotNull String pollerId, @NotNull InProgressMigrationIds migrationIds, @NotNull Worker worker, @NotNull PollerConfig config2, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @Qualifier(value="MigrationTerminator") @NotNull MigrationTerminator migrationTerminator, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)pollerId, (String)"pollerId");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)migrationTerminator, (String)"migrationTerminator");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        super(pollerId, config2.getPollingDelay(), jiraThreadLocalUtil, timeProvider);
        this.platformService = platformService;
        this.discoveryService = discoveryService;
        this.pollerId = pollerId;
        this.migrationIds = migrationIds;
        this.worker = worker;
        this.config = config2;
        this.$$delegate_0 = migrationTerminator;
    }

    public /* synthetic */ Poller(PlatformService platformService, DiscoveryService discoveryService, String string, InProgressMigrationIds inProgressMigrationIds, Worker worker, PollerConfig pollerConfig, JiraThreadLocalUtil jiraThreadLocalUtil, MigrationTerminator migrationTerminator, TimeProvider timeProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            timeProvider = new SystemTimeProvider();
        }
        this(platformService, discoveryService, string, inProgressMigrationIds, worker, pollerConfig, jiraThreadLocalUtil, migrationTerminator, timeProvider);
    }

    @NotNull
    public final String getPollerId() {
        return this.pollerId;
    }

    @NotNull
    public final Worker getWorker() {
        return this.worker;
    }

    @NotNull
    public final PollerConfig getConfig() {
        return this.config;
    }

    @Override
    @Nullable
    public List<GetTaskStatusResponse.TaskProgress> checkTerminateOrDefault(@NotNull String migrationId, @NotNull String message, @Nullable List<GetTaskStatusResponse.TaskProgress> defaultStatus) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.$$delegate_0.checkTerminateOrDefault(migrationId, message, defaultStatus);
    }

    @Override
    @Nullable
    public List<GetTaskStatusResponse.TaskProgress> terminateMigration(@NotNull String migrationId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.$$delegate_0.terminateMigration(migrationId, message);
    }

    @Override
    public void doPoll() {
        Sequence $this$forEach$iv = SequencesKt.filter(this.migrationIds.sequence(), (Function1)((Function1)new Function1<InProgressMigration, Boolean>(this){
            final /* synthetic */ Poller this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull InProgressMigration inProgressMigration) {
                Intrinsics.checkNotNullParameter((Object)inProgressMigration, (String)"<name for destructuring parameter 0>");
                MigrationProtocol migrationProtocol = inProgressMigration.component2();
                return this.this$0.getWorker().getMigrationProtocol() == migrationProtocol || migrationProtocol == MigrationProtocol.V3_5;
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InProgressMigration inProgressMigration = (InProgressMigration)element$iv;
            boolean bl = false;
            String migrationId = inProgressMigration.component1();
            CloudSite cloudSite2 = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, migrationId, false, 2, null);
            if (cloudSite2 != null) {
                this.pollForTaskAndDispatchNoThrow(cloudSite2, migrationId);
                continue;
            }
            log.warn("poller " + this.pollerId + " failed to retrieve cloud site info for migration id " + migrationId + ", will keep trying");
        }
    }

    public final void pollForTaskAndDispatchNoThrow(@NotNull CloudSite cloudSite2, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        try {
            this.pollForTaskAndDispatch(cloudSite2, migrationId);
        }
        catch (Throwable e) {
            boolean bl;
            Integer n;
            UnexpectedStatusCodeException unexpectedStatusCodeException;
            UnexpectedStatusCodeException unexpectedStatusCodeException2 = e instanceof UnexpectedStatusCodeException ? (UnexpectedStatusCodeException)e : null;
            if (unexpectedStatusCodeException2 == null) {
                Throwable throwable = e.getCause();
                unexpectedStatusCodeException2 = throwable instanceof UnexpectedStatusCodeException ? (UnexpectedStatusCodeException)throwable : null;
            }
            UnexpectedStatusCodeException unexpectedStatusCodeException3 = unexpectedStatusCodeException = unexpectedStatusCodeException2;
            Integer n2 = n = unexpectedStatusCodeException3 != null ? Integer.valueOf(unexpectedStatusCodeException3.getStatusCode()) : null;
            int n3 = 409;
            if (n2 != null && n2 == n3) {
                log.debug("poller " + this.pollerId + " detected completed migration");
            }
            Integer n4 = n;
            n3 = 404;
            if (n4 != null && n4 == n3) {
                bl = true;
            } else {
                Integer n5 = n;
                n3 = 400;
                bl = n5 != null && n5 == n3;
            }
            if (bl) {
                log.error("poller " + this.pollerId + " detected non-existent migration with id " + migrationId + ". Will retry or terminate migration", e);
                MigrationTerminator.DefaultImpls.checkTerminateOrDefault$default(this, migrationId, "Migration with id: " + migrationId + " has timed out. Create a new migration and run the migration again.", null, 4, null);
            }
            log.warn("poller " + this.pollerId + " failed to poll for migration " + migrationId + ", will keep trying", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void pollForTaskAndDispatch(CloudSite cloudSite2, String migrationId) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List<MigrationTask> responseTasks = this.platformService.pollAndLock(new ContainerToken(cloudSite2.getContainerToken()), new MigrationId(migrationId), new V3PollAndLockRequest(this.worker.getTaskType().getTaskTypeName(), this.pollerId)).getTasks();
        Iterable iterable = responseTasks;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void task;
            MigrationTask migrationTask = (MigrationTask)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Poller.Companion.taskFromOrchestrator(migrationId, cloudSite2, (MigrationTask)task));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Task it = (Task)element$iv;
            boolean bl = false;
            this.dispatchTask(it);
        }
    }

    private final void dispatchTask(Task task) {
        try {
            this.worker.process(task);
        }
        catch (Throwable e) {
            log.error(task.getMigrationId() + '-' + task.getMigrationTask().getTaskId() + ": task worker " + this.worker.getId() + " failed to process " + task, e);
            log.error("marking task as failed in MO");
            this.reportFailureNoThrow(task, e);
        }
    }

    private final boolean reportFailureNoThrow(Task task, Throwable e) {
        try {
            if (task.getMigrationTask() instanceof TransferMigrationTask) {
                ContainerToken containerToken = new ContainerToken(task.getCloudSite().getContainerToken());
                MigrationId migrationId = new MigrationId(task.getMigrationId());
                MigrationTask migrationTask = task.getMigrationTask();
                Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.TransferMigrationTask");
                this.platformService.transferResult(containerToken, migrationId, new TransferId(((TransferMigrationTask)migrationTask).getTransferId()), new TransferResultRequest(TransferStatus.FAILED, null, ProgressItem.Companion.throwableToDetailsMessage(e), null, 10, null));
            }
            return true;
        }
        catch (RuntimeException updateError) {
            log.error(task.getMigrationId() + '-' + task.getMigrationTask().getTaskId() + ": failed to update task status in MO: " + task, (Throwable)updateError);
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/Poller$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "taskFromOrchestrator", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "migrationId", "", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "task", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTask;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final Task taskFromOrchestrator(String migrationId, CloudSite cloudSite2, MigrationTask task) {
            return new Task(migrationId, task, cloudSite2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

