/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.tracking.polling;

import com.atlassian.jira.migration.setup.PollingSetup;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/PollerJobScheduler;", "Lcom/atlassian/scheduler/JobRunner;", "pollingSetup", "Lcom/atlassian/jira/migration/setup/PollingSetup;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "(Lcom/atlassian/jira/migration/setup/PollingSetup;Lcom/atlassian/scheduler/SchedulerService;)V", "postConstruct", "", "preDestroy", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "jobRunnerRequest", "Lcom/atlassian/scheduler/JobRunnerRequest;", "Companion", "jira-migration-plugin"})
public final class PollerJobScheduler
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PollingSetup pollingSetup;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;
    private static final Logger log;

    @Inject
    public PollerJobScheduler(@NotNull PollingSetup pollingSetup, @NotNull SchedulerService schedulerService) {
        Intrinsics.checkNotNullParameter((Object)pollingSetup, (String)"pollingSetup");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        this.pollingSetup = pollingSetup;
        this.schedulerService = schedulerService;
    }

    @PostConstruct
    public final void postConstruct() {
        log.debug("PollerJobScheduler is enabled");
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)TimeUnit.MINUTES.toMillis(5L), (Date)Date.from(Instant.now().plus(Duration.ofMinutes(5L))))));
        log.info("Successfully registered job " + JOB_RUNNER_KEY);
    }

    @PreDestroy
    public final void preDestroy() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        Intrinsics.checkNotNullParameter((Object)jobRunnerRequest, (String)"jobRunnerRequest");
        log.info("PollerJobScheduler job started: jobId=" + jobRunnerRequest.getJobId() + " startTime=" + jobRunnerRequest.getStartTime());
        this.pollingSetup.manageV4Pollers();
        this.pollingSetup.manageV3Pollers();
        return JobRunnerResponse.success((String)("Successfully ran PollerJobScheduler job: jobId=" + jobRunnerRequest.getJobId()));
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-poller-scheduler-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-poller-scheduler-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
        log = LoggerFactory.getLogger(PollerJobScheduler.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/PollerJobScheduler$Companion;", "", "()V", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

