/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.tracking.polling;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.crossproject.service.CrossProjectEntityStatsEventService;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.eventHandlers.MetricsEventHandler;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.events.MigrationTaskCompletedEvent;
import com.atlassian.jira.migration.events.crossproject.AdvancedRoadmapsPlansMigrationFinishedEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.log.PMRAFailedEntityLogService;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationIncrement;
import com.atlassian.jira.migration.migration.MigrationIncrementRepository;
import com.atlassian.jira.migration.migration.MigrationIncrementStatus;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.EntityCounts;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.TaskCompletionStatus;
import com.atlassian.jira.migration.orchestratorclient.tasks.UsersGroupsMigration;
import com.atlassian.jira.migration.plan.AdvancedRoadmapPlanMigrationMode;
import com.atlassian.jira.migration.plan.AdvancedRoadmapsMigrationOption;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.polly.MigrationPoller;
import com.atlassian.jira.migration.preflight.reports.ActualProjectEntityTypeCounts;
import com.atlassian.jira.migration.preflight.reports.MigrationReportFeatureFlagEvaluator;
import com.atlassian.jira.migration.preflight.reports.PostMigrationReportsService;
import com.atlassian.jira.migration.progress.IncrementalTaskStatus;
import com.atlassian.jira.migration.progress.MigrationTaskStatus;
import com.atlassian.jira.migration.progress.ProjectProgressBuilder;
import com.atlassian.jira.migration.progress.StatusRetrievalService;
import com.atlassian.jira.migration.progress.TaskList;
import com.atlassian.jira.migration.scale.MigrationScaleEventService;
import com.atlassian.jira.migration.serverdataextractors.ProjectsReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserExportMismatchService;
import com.atlassian.jira.migration.shadow.event.MigrationCompletionEventService;
import com.atlassian.jira.migration.tracking.polling.AbstractPoller;
import com.atlassian.jira.migration.tracking.polling.InProgressMigration;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.polling.PollerConfig;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 `2\u00020\u0001:\u0001`B\u00bd\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u0012\u0006\u0010(\u001a\u00020)\u0012\u0006\u0010*\u001a\u00020+\u0012\u0006\u0010,\u001a\u00020-\u0012\u0006\u0010.\u001a\u00020/\u00a2\u0006\u0002\u00100J\b\u00103\u001a\u000204H\u0016J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J<\u0010=\u001a\u0002042\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J4\u0010F\u001a\u0002042\u0006\u0010G\u001a\u00020H2\u0006\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020?2\b\u0010B\u001a\u0004\u0018\u00010C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J\u001e\u0010I\u001a\u0002042\u0006\u0010>\u001a\u00020?2\u0006\u00107\u001a\u0002082\u0006\u0010@\u001a\u00020AJ(\u0010J\u001a\u0002042\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J \u0010K\u001a\u0002042\u0006\u0010B\u001a\u00020C2\u0006\u00107\u001a\u0002082\u0006\u0010L\u001a\u00020HH\u0002J2\u0010M\u001a\u0002042\u0006\u0010L\u001a\u00020H2\u0006\u00107\u001a\u0002082\u0006\u0010N\u001a\u0002082\u0006\u0010O\u001a\u00020:2\b\u0010B\u001a\u0004\u0018\u00010CH\u0002J \u0010P\u001a\u0002042\u0006\u0010G\u001a\u00020H2\u0006\u00107\u001a\u0002082\u0006\u0010N\u001a\u000208H\u0002J*\u0010Q\u001a\u0002042\u0006\u0010G\u001a\u00020H2\u0006\u00107\u001a\u0002082\u0006\u0010N\u001a\u0002082\b\u0010R\u001a\u0004\u0018\u00010SH\u0002J\u0010\u0010T\u001a\u0002042\u0006\u0010L\u001a\u00020HH\u0002J \u0010U\u001a\u0002042\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010V\u001a\u0002042\u0006\u0010L\u001a\u00020H2\u0006\u00107\u001a\u000208H\u0007J\u0018\u0010W\u001a\u0002042\u0006\u0010L\u001a\u00020H2\u0006\u00107\u001a\u000208H\u0002J\u0018\u0010X\u001a\u0002042\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u000208H\u0002J<\u0010Y\u001a\u0002042\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u0002082\u0006\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010>\u001a\u00020?2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J,\u0010Z\u001a\u0002042\u0006\u00107\u001a\u0002082\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010>\u001a\u00020?2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J\u0018\u0010[\u001a\u0002042\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u000208H\u0002J*\u0010\\\u001a\u0002042\u0006\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020?2\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J\f\u0010]\u001a\u00020:*\u00020HH\u0002J\f\u0010^\u001a\u000204*\u00020_H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/StatusPoller;", "Lcom/atlassian/jira/migration/tracking/polling/AbstractPoller;", "statusRetrievalService", "Lcom/atlassian/jira/migration/progress/StatusRetrievalService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "config", "Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "postMigrationReportsService", "Lcom/atlassian/jira/migration/preflight/reports/PostMigrationReportsService;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "migrationReportFeatureFlagEvaluator", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportFeatureFlagEvaluator;", "projectsReader", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "incrementRepository", "Lcom/atlassian/jira/migration/migration/MigrationIncrementRepository;", "projectProgressBuilder", "Lcom/atlassian/jira/migration/progress/ProjectProgressBuilder;", "metricsEventHandler", "Lcom/atlassian/jira/migration/eventHandlers/MetricsEventHandler;", "userExportMismatchService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;", "crossProjectEntityEventService", "Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationScaleEventService", "Lcom/atlassian/jira/migration/scale/MigrationScaleEventService;", "migrationCompletionEventService", "Lcom/atlassian/jira/migration/shadow/event/MigrationCompletionEventService;", "pmraFailedEntityLogService", "Lcom/atlassian/jira/migration/log/PMRAFailedEntityLogService;", "migrationPoller", "Lcom/atlassian/jira/migration/polly/MigrationPoller;", "(Lcom/atlassian/jira/migration/progress/StatusRetrievalService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/preflight/reports/PostMigrationReportsService;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/preflight/reports/MigrationReportFeatureFlagEvaluator;Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/migration/MigrationIncrementRepository;Lcom/atlassian/jira/migration/progress/ProjectProgressBuilder;Lcom/atlassian/jira/migration/eventHandlers/MetricsEventHandler;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/scale/MigrationScaleEventService;Lcom/atlassian/jira/migration/shadow/event/MigrationCompletionEventService;Lcom/atlassian/jira/migration/log/PMRAFailedEntityLogService;Lcom/atlassian/jira/migration/polly/MigrationPoller;)V", "getConfig", "()Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;", "doPoll", "", "getMigration", "Lcom/atlassian/jira/migration/migration/Migration;", "migrationId", "", "isStatusUnchanged", "", "status", "Lcom/atlassian/jira/migration/progress/MigrationTaskStatus;", "onCompletionOfTask", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "migrationType", "Lcom/atlassian/jira/migration/plan/MigrationType;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "protocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "onTaskFailures", "currentStatus", "Lcom/atlassian/jira/migration/progress/TaskList;", "pollStatusAndProcess", "processUpdatedStatus", "saveIncrementStatus", "taskList", "sendAdvancedRoadmapsPlansEvent", "cloudId", "successful", "sendCrossProjectRapidViewsFiltersMigrationEntityStatsEvent", "sendDashboardEntityMigrationStatsEvent", "dashboardsMigrationMode", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "sendProjectByProjectMetrics", "sendTaskStatusToEventBus", "sendUsersAndGroupsMetrics", "sendUsersGroupsMigrationTimeMetric", "setStartTimeForMigratedUsers", "triggerReportDataGeneration", "triggerSendingPostReports", "updateFinishTime", "validateAndProcessPMRAEvents", "isFailed", "sendUsersGroupsStatusMetric", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressItem;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nStatusPoller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatusPoller.kt\ncom/atlassian/jira/migration/tracking/polling/StatusPoller\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,498:1\n1313#2:499\n1314#2:501\n1#3:500\n1#3:557\n1#3:589\n288#4,2:502\n766#4:504\n857#4,2:505\n1477#4:507\n1502#4,3:508\n1505#4,3:518\n1855#4:523\n1856#4:533\n766#4:534\n857#4,2:535\n1360#4:537\n1446#4,5:538\n1774#4,4:543\n1603#4,9:547\n1855#4:556\n1856#4:558\n1612#4:559\n766#4:560\n857#4,2:561\n1360#4:563\n1446#4,5:564\n1855#4:569\n766#4:570\n857#4,2:571\n819#4:573\n847#4,2:574\n1360#4:576\n1446#4,2:577\n1603#4,9:579\n1855#4:588\n1856#4:590\n1612#4:591\n1448#4,3:592\n1747#4,3:595\n1747#4,3:598\n1856#4:601\n372#5,7:511\n526#5:524\n511#5,6:525\n215#6,2:521\n215#6,2:531\n*S KotlinDebug\n*F\n+ 1 StatusPoller.kt\ncom/atlassian/jira/migration/tracking/polling/StatusPoller\n*L\n87#1:499\n87#1:501\n208#1:557\n378#1:589\n116#1:502,2\n151#1:504\n151#1:505,2\n152#1:507\n152#1:508,3\n152#1:518,3\n165#1:523\n165#1:533\n191#1:534\n191#1:535,2\n192#1:537\n192#1:538,5\n193#1:543,4\n208#1:547,9\n208#1:556\n208#1:558\n208#1:559\n337#1:560\n337#1:561,2\n338#1:563\n338#1:564,5\n375#1:569\n376#1:570\n376#1:571,2\n377#1:573\n377#1:574,2\n378#1:576\n378#1:577,2\n378#1:579,9\n378#1:588\n378#1:590\n378#1:591\n378#1:592,3\n380#1:595,3\n381#1:598,3\n375#1:601\n152#1:511,7\n167#1:524\n167#1:525,6\n153#1:521,2\n168#1:531,2\n*E\n"})
public final class StatusPoller
extends AbstractPoller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StatusRetrievalService statusRetrievalService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final PollerConfig config;
    @NotNull
    private final PostMigrationReportsService postMigrationReportsService;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final JiraEventDetectionService jiraEventDetectionService;
    @NotNull
    private final MigrationReportFeatureFlagEvaluator migrationReportFeatureFlagEvaluator;
    @NotNull
    private final ProjectsReader projectsReader;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationIncrementRepository incrementRepository;
    @NotNull
    private final ProjectProgressBuilder projectProgressBuilder;
    @NotNull
    private final MetricsEventHandler metricsEventHandler;
    @NotNull
    private final UserExportMismatchService userExportMismatchService;
    @NotNull
    private final CrossProjectEntityStatsEventService crossProjectEntityEventService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationScaleEventService migrationScaleEventService;
    @NotNull
    private final MigrationCompletionEventService migrationCompletionEventService;
    @NotNull
    private final PMRAFailedEntityLogService pmraFailedEntityLogService;
    @NotNull
    private final MigrationPoller migrationPoller;
    private static final Logger log = LoggerFactory.getLogger(StatusPoller.class);
    @NotNull
    private static final String SUCCESS = "Success";
    @NotNull
    private static final String INCOMPLETE = "Incomplete";
    @NotNull
    private static final String FAILED = "Failed";
    @NotNull
    private static final String JOIN_SEPARATOR = ",\n";

    public StatusPoller(@NotNull StatusRetrievalService statusRetrievalService, @NotNull DiscoveryService discoveryService, @NotNull MigrationRepository migrationRepository, @NotNull MigrationEventBus migrationEventBus, @NotNull InProgressMigrationIds migrationIds, @NotNull PollerConfig config2, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull PostMigrationReportsService postMigrationReportsService, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull MigrationReportFeatureFlagEvaluator migrationReportFeatureFlagEvaluator, @NotNull ProjectsReader projectsReader, @NotNull PlanRepository planRepository, @NotNull MigrationIncrementRepository incrementRepository, @NotNull ProjectProgressBuilder projectProgressBuilder, @NotNull MetricsEventHandler metricsEventHandler, @NotNull UserExportMismatchService userExportMismatchService, @NotNull CrossProjectEntityStatsEventService crossProjectEntityEventService, @NotNull MigrationFeatures migrationFeatures, @NotNull MigrationScaleEventService migrationScaleEventService, @NotNull MigrationCompletionEventService migrationCompletionEventService, @NotNull PMRAFailedEntityLogService pmraFailedEntityLogService, @NotNull MigrationPoller migrationPoller) {
        Intrinsics.checkNotNullParameter((Object)statusRetrievalService, (String)"statusRetrievalService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)postMigrationReportsService, (String)"postMigrationReportsService");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)migrationReportFeatureFlagEvaluator, (String)"migrationReportFeatureFlagEvaluator");
        Intrinsics.checkNotNullParameter((Object)projectsReader, (String)"projectsReader");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)incrementRepository, (String)"incrementRepository");
        Intrinsics.checkNotNullParameter((Object)projectProgressBuilder, (String)"projectProgressBuilder");
        Intrinsics.checkNotNullParameter((Object)metricsEventHandler, (String)"metricsEventHandler");
        Intrinsics.checkNotNullParameter((Object)userExportMismatchService, (String)"userExportMismatchService");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityEventService, (String)"crossProjectEntityEventService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationScaleEventService, (String)"migrationScaleEventService");
        Intrinsics.checkNotNullParameter((Object)migrationCompletionEventService, (String)"migrationCompletionEventService");
        Intrinsics.checkNotNullParameter((Object)pmraFailedEntityLogService, (String)"pmraFailedEntityLogService");
        Intrinsics.checkNotNullParameter((Object)migrationPoller, (String)"migrationPoller");
        super("Status", config2.getPollingDelay(), jiraThreadLocalUtil, null, 8, null);
        this.statusRetrievalService = statusRetrievalService;
        this.discoveryService = discoveryService;
        this.migrationRepository = migrationRepository;
        this.migrationEventBus = migrationEventBus;
        this.migrationIds = migrationIds;
        this.config = config2;
        this.postMigrationReportsService = postMigrationReportsService;
        this.metricsEventService = metricsEventService;
        this.jiraEventDetectionService = jiraEventDetectionService;
        this.migrationReportFeatureFlagEvaluator = migrationReportFeatureFlagEvaluator;
        this.projectsReader = projectsReader;
        this.planRepository = planRepository;
        this.incrementRepository = incrementRepository;
        this.projectProgressBuilder = projectProgressBuilder;
        this.metricsEventHandler = metricsEventHandler;
        this.userExportMismatchService = userExportMismatchService;
        this.crossProjectEntityEventService = crossProjectEntityEventService;
        this.migrationFeatures = migrationFeatures;
        this.migrationScaleEventService = migrationScaleEventService;
        this.migrationCompletionEventService = migrationCompletionEventService;
        this.pmraFailedEntityLogService = pmraFailedEntityLogService;
        this.migrationPoller = migrationPoller;
    }

    @NotNull
    public final PollerConfig getConfig() {
        return this.config;
    }

    @Override
    public void doPoll() {
        Sequence<InProgressMigration> $this$forEach$iv = this.migrationIds.sequence();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InProgressMigration inProgressMigration = (InProgressMigration)element$iv;
            boolean bl = false;
            String migrationId = inProgressMigration.component1();
            try {
                CloudSite cloudSite2 = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, migrationId, false, 2, null);
                if (cloudSite2 == null) continue;
                CloudSite cloudSite3 = cloudSite2;
                boolean bl2 = false;
                this.pollStatusAndProcess(cloudSite3, migrationId, this.migrationIds.getMigrationType(migrationId));
            }
            catch (Throwable e) {
                log.error("failed to poll & update status of migration id " + migrationId, e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isStatusUnchanged(MigrationTaskStatus status) {
        if (!status.getStatusRetrievalSuccessful()) return false;
        TaskList taskList2 = status.getCurrentStatus();
        Intrinsics.checkNotNull((Object)taskList2);
        if (!Intrinsics.areEqual((Object)taskList2, (Object)status.getPreviousStatus())) return false;
        return true;
    }

    public final void pollStatusAndProcess(@NotNull CloudSite cloudSite2, @NotNull String migrationId, @NotNull MigrationType migrationType) {
        block2: {
            MigrationTaskStatus migrationTaskStatus;
            MigrationTaskStatus migrationTaskStatus2;
            Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
            Intrinsics.checkNotNullParameter((Object)((Object)migrationType), (String)"migrationType");
            MigrationTaskStatus it = migrationTaskStatus2 = this.statusRetrievalService.getAdaptedMigrationStatus(cloudSite2.getContainerToken(), migrationId);
            boolean bl = false;
            MigrationTaskStatus migrationTaskStatus3 = migrationTaskStatus = it.getCurrentStatus() != null ? migrationTaskStatus2 : null;
            if (migrationTaskStatus == null) break block2;
            MigrationTaskStatus status = migrationTaskStatus;
            boolean bl2 = false;
            this.setStartTimeForMigratedUsers(status, migrationId);
            if (this.isStatusUnchanged(status)) {
                MigrationRepository.touch$default(this.migrationRepository, migrationId, null, 2, null);
            } else {
                this.processUpdatedStatus(status, migrationId, cloudSite2, migrationType);
            }
        }
    }

    private final void setStartTimeForMigratedUsers(MigrationTaskStatus status, String migrationId) {
        Object v1;
        block2: {
            TaskList taskList2 = status.getCurrentStatus();
            Intrinsics.checkNotNull((Object)taskList2);
            Iterable $this$firstOrNull$iv = taskList2.getTaskProgressList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GetTaskStatusResponse.TaskProgress t = (GetTaskStatusResponse.TaskProgress)element$iv;
                boolean bl = false;
                if (!(t.getTask() instanceof UsersGroupsMigration)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        GetTaskStatusResponse.TaskProgress usersGroupsMigration = v1;
        Migration migration = this.migrationRepository.findByMigrationId(migrationId);
        if (usersGroupsMigration != null && migration != null && Intrinsics.areEqual((Object)migration.getUserMigrationStartTime(), (Object)Instant.EPOCH)) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            this.migrationRepository.saveStartUserMigrationTime(migrationId, instant);
        }
    }

    private final boolean isFailed(TaskList $this$isFailed) {
        return $this$isFailed.findAllFailedBlockerProgressItems() != null;
    }

    private final void processUpdatedStatus(MigrationTaskStatus status, String migrationId, CloudSite cloudSite2, MigrationType migrationType) {
        block8: {
            Plan plan2;
            Migration migration;
            TaskList taskList2 = status.getCurrentStatus();
            Intrinsics.checkNotNull((Object)taskList2);
            TaskList currentStatus = taskList2;
            Migration migration2 = migration = this.getMigration(migrationId);
            if (migration2 != null) {
                Migration it = migration2;
                boolean bl = false;
                plan2 = this.planRepository.get(it.getPlanId());
            } else {
                plan2 = null;
            }
            Plan plan3 = plan2;
            Migration migration3 = migration;
            MigrationProtocol migrationProtocol = migration3 != null ? migration3.getProtocol() : null;
            this.sendTaskStatusToEventBus(status, migrationId, cloudSite2);
            this.updateFinishTime(status, migrationId);
            if (this.isFailed(currentStatus)) {
                this.onTaskFailures(currentStatus, migrationId, cloudSite2, plan3, migrationProtocol);
            } else if (currentStatus.isCompleted()) {
                this.onCompletionOfTask(status, migrationId, cloudSite2, migrationType, plan3, migrationProtocol);
            } else if (status.getStatusRetrievalSuccessful()) {
                MigrationRepository.saveStatus$default(this.migrationRepository, migrationId, currentStatus.getTaskProgressList(), null, 4, null);
            }
            Plan plan4 = plan3;
            if (plan4 == null) break block8;
            Plan $this$processUpdatedStatus_u24lambda_u246 = plan4;
            boolean bl = false;
            if ($this$processUpdatedStatus_u24lambda_u246.isIncremental()) {
                this.saveIncrementStatus($this$processUpdatedStatus_u24lambda_u246, migrationId, currentStatus);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveIncrementStatus(Plan plan2, String migrationId, TaskList taskList2) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        GetTaskStatusResponse.TaskProgress it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        boolean hasFinalIncrement = this.incrementRepository.hasFinalIncrement(plan2.getId());
        Iterable iterable = taskList2.getTaskProgressList();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            if (!MigrationTaskType.Companion.getPROJECT_TASK_TYPES().contains((Object)it.getTask().getMigrationTaskType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            MigrationTask migrationTask = it.getTask();
            Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask");
            String key$iv$iv = ((ProjectTask)migrationTask).getProjectKey();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String projectKey = (String)entry.getKey();
            List taskProgresses = (List)entry.getValue();
            MigrationIncrementStatus incrementStatus = Companion.toIncrementStatus(this.projectProgressBuilder.getIncrementalTaskStatus(plan2, new TaskList(taskProgresses), hasFinalIncrement));
            if (incrementStatus == null) continue;
            Project project = this.projectsReader.getProject(projectKey);
            Long l = project.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            MigrationIncrement increment = this.incrementRepository.getIncrementForProjectAndMigration(((Number)l).longValue(), migrationId);
            increment.setStatus(incrementStatus);
            this.incrementRepository.save(increment);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendTaskStatusToEventBus(MigrationTaskStatus status, String migrationId, CloudSite cloudSite2) {
        Iterable $this$forEach$iv = status.modifiedTasks().getTaskProgressList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv;
            GetTaskStatusResponse.TaskProgress taskProgress = (GetTaskStatusResponse.TaskProgress)element$iv;
            boolean bl = false;
            Map<ProgressUnit, ProgressItem> map = taskProgress.getProgressItems();
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator3.next();
                boolean bl2 = false;
                ProgressItem progressItem = (ProgressItem)entry.getValue();
                if (!progressItem.getCompleted()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$forEach2 = false;
            iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator2.next();
                boolean bl3 = false;
                ProgressItem progressItem = (ProgressItem)entry.getValue();
                MigrationTask migTask = taskProgress.getTask();
                String taskLabel = migTask instanceof ProjectTask ? (Object)((Object)migTask.getMigrationTaskType()) + " for project " + ((ProjectTask)migTask).getProjectKey() : (Object)((Object)migTask.getMigrationTaskType()) + " for " + (Object)((Object)progressItem.getUnit());
                log.info(migrationId + '-' + migTask.getTaskId() + ": migration task " + taskLabel + " completed with status: " + (Object)((Object)progressItem.getCompletionStatus()));
                this.migrationEventBus.post(new MigrationTaskCompletedEvent(migrationId, cloudSite2, migTask, progressItem));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateFinishTime(MigrationTaskStatus status, String migrationId) {
        int n;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        GetTaskStatusResponse.TaskProgress it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = status.modifiedTasks().getTaskProgressList();
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it.getTask().getTaskId(), (CharSequence)"usersAndGroupsData", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getProgressItems().values();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List userGroupMigrationTasks = (List)destination$iv$iv;
        Iterable $this$count$iv = userGroupMigrationTasks;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ProgressItem it2 = (ProgressItem)element$iv;
                boolean bl = false;
                if (!it2.getCompleted() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int finishedUsersGroupsMigration = n;
        Migration migration = this.migrationRepository.findByMigrationId(migrationId);
        if (finishedUsersGroupsMigration == userGroupMigrationTasks.size() && migration != null && Intrinsics.areEqual((Object)migration.getUserMigrationEndTime(), (Object)Instant.EPOCH)) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            this.migrationRepository.saveEndUserMigrationTime(migrationId, instant);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onTaskFailures(TaskList currentStatus, String migrationId, CloudSite cloudSite2, Plan plan2, MigrationProtocol protocol) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        MigrationRepository.saveOutcome$default(this.migrationRepository, migrationId, currentStatus.getTaskProgressList(), null, 4, null);
        if (this.migrationFeatures.getEnableProjectPollyPoller()) {
            this.migrationPoller.stopPolling(migrationId);
        }
        this.triggerSendingPostReports(migrationId, plan2, cloudSite2, protocol);
        List<ProgressItem> list = currentStatus.findAllFailedBlockerProgressItems();
        Intrinsics.checkNotNull(list);
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var9_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ProgressItem it = (ProgressItem)element$iv$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Migration ").append(migrationId).append(" failed in stage ").append((Object)it.getUnit()).append(": ");
            String string = it.getCompletionDetails();
            if (string == null) {
                string = "";
            }
            log.info(stringBuilder.append(string).toString());
            if (it.getCompletionDetails() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable it = iterable = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = !((Collection)it).isEmpty() ? iterable : null;
        String errorMessages2 = iterable2 != null ? CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)JOIN_SEPARATOR, null, null, (int)0, null, null, (int)62, null) : null;
        String string = cloudSite2.getCloudId();
        String string2 = errorMessages2;
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(new MigrationStatusUpdatedEvent(migrationId, string, MigrationStatusUpdatedEvent.Status.ERRORED, string2));
        this.migrationCompletionEventService.sendMigrationCompletionStatusEvent(migrationId, cloudSite2.getCloudId(), currentStatus.isCompletedSuccessfully());
        this.userExportMismatchService.deleteFiles(migrationId);
        this.sendProjectByProjectMetrics(currentStatus);
        this.metricsEventHandler.createAndSendPlanCompletionEvents(currentStatus, migrationId, cloudSite2.getCloudId());
        this.sendCrossProjectRapidViewsFiltersMigrationEntityStatsEvent(currentStatus, migrationId, cloudSite2.getCloudId());
        Plan plan3 = plan2;
        this.sendDashboardEntityMigrationStatsEvent(currentStatus, migrationId, cloudSite2.getCloudId(), plan3 != null ? plan3.getDashboardsMigrationMode() : null);
        this.sendAdvancedRoadmapsPlansEvent(currentStatus, migrationId, cloudSite2.getCloudId(), false, plan2);
    }

    private final void onCompletionOfTask(MigrationTaskStatus status, String migrationId, CloudSite cloudSite2, MigrationType migrationType, Plan plan2, MigrationProtocol protocol) {
        TaskList taskList2 = status.getCurrentStatus();
        Intrinsics.checkNotNull((Object)taskList2);
        TaskList currentStatus = taskList2;
        String errorMessages2 = CollectionsKt.joinToString$default((Iterable)currentStatus.errorMessages(), (CharSequence)JOIN_SEPARATOR, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(migrationId){
            final /* synthetic */ String $migrationId;
            {
                this.$migrationId = $migrationId;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.removePrefix((String)it, (CharSequence)(this.$migrationId + '-'));
            }
        }), (int)30, null);
        String statusMessage = !StringsKt.isBlank((CharSequence)errorMessages2) ? "Migration errors: " + errorMessages2 : (currentStatus.isCompletedPartially() ? "Migration incomplete" : "Migration successful");
        log.info("Migration " + migrationId + " completed, " + statusMessage);
        MigrationRepository.saveOutcome$default(this.migrationRepository, migrationId, currentStatus.getTaskProgressList(), null, 4, null);
        if (this.migrationFeatures.getEnableProjectPollyPoller()) {
            this.migrationPoller.stopPolling(migrationId);
        }
        this.userExportMismatchService.deleteFiles(migrationId);
        this.triggerReportDataGeneration(status, migrationId, migrationType, plan2, cloudSite2, protocol);
        this.migrationEventBus.post(new MigrationStatusUpdatedEvent(migrationId, cloudSite2.getCloudId(), MigrationStatusUpdatedEvent.Status.FINISHED, errorMessages2));
        this.migrationCompletionEventService.sendMigrationCompletionStatusEvent(migrationId, cloudSite2.getCloudId(), currentStatus.isCompletedSuccessfully());
        this.metricsEventHandler.createAndSendPlanCompletionEvents(currentStatus, migrationId, cloudSite2.getCloudId());
        this.sendProjectByProjectMetrics(currentStatus);
        this.sendUsersAndGroupsMetrics(currentStatus, migrationId);
        this.sendCrossProjectRapidViewsFiltersMigrationEntityStatsEvent(currentStatus, migrationId, cloudSite2.getCloudId());
        Plan plan3 = plan2;
        this.sendDashboardEntityMigrationStatsEvent(currentStatus, migrationId, cloudSite2.getCloudId(), plan3 != null ? plan3.getDashboardsMigrationMode() : null);
        this.sendAdvancedRoadmapsPlansEvent(currentStatus, migrationId, cloudSite2.getCloudId(), true, plan2);
        this.migrationScaleEventService.sendFinalTotalEntitiesMigrated(migrationId, cloudSite2.getCloudId(), currentStatus);
    }

    private final void sendCrossProjectRapidViewsFiltersMigrationEntityStatsEvent(TaskList currentStatus, String migrationId, String cloudId2) {
        this.crossProjectEntityEventService.sendCrossProjectEntityMigrationStatsEvent(currentStatus, migrationId, cloudId2);
    }

    private final void sendDashboardEntityMigrationStatsEvent(TaskList currentStatus, String migrationId, String cloudId2, DashboardsMigrationMode dashboardsMigrationMode) {
        this.crossProjectEntityEventService.sendDashboardEntityMigrationStatsEvent(currentStatus, migrationId, cloudId2, dashboardsMigrationMode);
    }

    private final void sendUsersGroupsStatusMetric(ProgressItem $this$sendUsersGroupsStatusMetric) {
        if ($this$sendUsersGroupsStatusMetric.getUnit() != ProgressUnit.USER && $this$sendUsersGroupsStatusMetric.getUnit() != ProgressUnit.GROUP) {
            return;
        }
        if ($this$sendUsersGroupsStatusMetric.getSuccessfullyCompleted() > 0L) {
            log.debug("Submitting UserGroupMigration SUCCESS analytics event with count=[" + (double)$this$sendUsersGroupsStatusMetric.getSuccessfullyCompleted() + "] for unit=[" + (Object)((Object)$this$sendUsersGroupsStatusMetric.getUnit()) + ']');
            this.metricsEventService.sendEventForTask(MigrationTaskType.USERS_GRPS_DATA_MIGRATION, SUCCESS, $this$sendUsersGroupsStatusMetric.getSuccessfullyCompleted(), $this$sendUsersGroupsStatusMetric.getUnit());
        }
        if ($this$sendUsersGroupsStatusMetric.getTotal() - $this$sendUsersGroupsStatusMetric.getSuccessfullyCompleted() > 0L) {
            log.debug("Submitting UserGroupMigration FAILED analytics event with count=[" + (double)($this$sendUsersGroupsStatusMetric.getTotal() - $this$sendUsersGroupsStatusMetric.getSuccessfullyCompleted()) + "] for unit=[" + (Object)((Object)$this$sendUsersGroupsStatusMetric.getUnit()) + ']');
            this.metricsEventService.sendEventForTask(MigrationTaskType.USERS_GRPS_DATA_MIGRATION, FAILED, $this$sendUsersGroupsStatusMetric.getTotal() - $this$sendUsersGroupsStatusMetric.getSuccessfullyCompleted(), $this$sendUsersGroupsStatusMetric.getUnit());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendUsersGroupsMigrationTimeMetric(TaskList taskList2, String migrationId) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        GetTaskStatusResponse.TaskProgress it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = taskList2.getTaskProgressList();
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTask().getTaskId(), (Object)"usersAndGroupsData")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getProgressItems().values();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        int groupsAndUsersCount = ((Collection)((List)destination$iv$iv)).size();
        String operationUniqueKey = "prj-" + migrationId + '-' + UUID.randomUUID() + "-migrate-project-users-groups";
        this.jiraEventDetectionService.runAndDetect(operationUniqueKey, (Function0)new Function0<Unit>(this, operationUniqueKey, migrationId, groupsAndUsersCount){
            final /* synthetic */ StatusPoller this$0;
            final /* synthetic */ String $operationUniqueKey;
            final /* synthetic */ String $migrationId;
            final /* synthetic */ int $groupsAndUsersCount;
            {
                this.this$0 = $receiver;
                this.$operationUniqueKey = $operationUniqueKey;
                this.$migrationId = $migrationId;
                this.$groupsAndUsersCount = $groupsAndUsersCount;
                super(0);
            }

            public final void invoke() {
                Map<String, String> eventTags = StatusPoller.access$getJiraEventDetectionService$p(this.this$0).getEventMapForOperation(this.$operationUniqueKey);
                Migration migration = StatusPoller.access$getMigrationRepository$p(this.this$0).findByMigrationId(this.$migrationId);
                if (migration == null) {
                    return;
                }
                Migration migration2 = migration;
                StatusPoller.access$getMetricsEventService$p(this.this$0).sendTimeForOperation(MetricsEventService.OperationType.USERS_AND_GROUPS_MIGRATION, TaskCompletionStatus.SUCCESS.getTaskStatus(), migration2.getUserMigrationEndTime().getEpochSecond() - migration2.getUserMigrationStartTime().getEpochSecond(), this.$groupsAndUsersCount, eventTags);
            }
        });
        log.info("Analytics for users and group sent.");
    }

    @VisibleForTesting
    public final void sendUsersAndGroupsMetrics(@NotNull TaskList taskList2, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)taskList2, (String)"taskList");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        try {
            ProgressItem progressItem = taskList2.completedProgressItemFor(MigrationTaskType.USERS_GRPS_DATA_MIGRATION, ProgressUnit.USER);
            if (progressItem != null) {
                this.sendUsersGroupsStatusMetric(progressItem);
            }
            if ((progressItem = taskList2.completedProgressItemFor(MigrationTaskType.USERS_GRPS_DATA_MIGRATION, ProgressUnit.GROUP)) != null) {
                this.sendUsersGroupsStatusMetric(progressItem);
            }
            this.sendUsersGroupsMigrationTimeMetric(taskList2, migrationId);
        }
        catch (Throwable t) {
            log.error("Could not submit UsersGroupsMigration analytics event.", t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendProjectByProjectMetrics(TaskList taskList2) {
        Iterable $this$forEach$iv = taskList2.getUniqueProjectKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List completionStatusForTasks;
            block14: {
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block13: {
                    void $this$flatMapTo$iv$iv;
                    void $this$filterNotTo$iv$iv;
                    Object element$iv$iv2;
                    void $this$filterTo$iv$iv;
                    String projectKey = (String)element$iv;
                    boolean bl3 = false;
                    Iterable $this$filter$iv = taskList2.getTaskProgressList();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Iterable destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)element$iv$iv2;
                        boolean bl4 = false;
                        if (!(it.getTask() instanceof ProjectTask && Intrinsics.areEqual((Object)((ProjectTask)it.getTask()).getProjectKey(), (Object)projectKey))) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    List projectTasksForProjectKey = (List)destination$iv$iv;
                    Iterable $this$filterNot$iv = projectTasksForProjectKey;
                    boolean $i$f$filterNot = false;
                    destination$iv$iv = $this$filterNot$iv;
                    Iterable destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    element$iv$iv2 = $this$filterNotTo$iv$iv.iterator();
                    while (element$iv$iv2.hasNext()) {
                        Object element$iv$iv3 = element$iv$iv2.next();
                        GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)element$iv$iv3;
                        boolean bl5 = false;
                        if (it.getTask().getMigrationTaskType() == MigrationTaskType.ATTACHMENTS_UPLOAD) continue;
                        destination$iv$iv2.add(element$iv$iv3);
                    }
                    List projectTasksWithoutAttachmentTask = (List)destination$iv$iv2;
                    Iterable $this$flatMap$iv = projectTasksWithoutAttachmentTask;
                    boolean $i$f$flatMap = false;
                    destination$iv$iv2 = $this$flatMap$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv4 : $this$flatMapTo$iv$iv) {
                        void $this$mapNotNullTo$iv$iv;
                        GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)element$iv$iv4;
                        boolean bl6 = false;
                        Iterable $this$mapNotNull$iv = it.getProgressItems().values();
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable2 = $this$mapNotNull$iv;
                        Collection destination$iv$iv4 = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach2 = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            TaskCompletionStatus it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv5 = element$iv$iv$iv = iterator2.next();
                            boolean bl7 = false;
                            ProgressItem progressItem = (ProgressItem)element$iv$iv5;
                            boolean bl8 = false;
                            if (progressItem.getCompletionStatus() == null) continue;
                            boolean bl9 = false;
                            destination$iv$iv4.add(it$iv$iv);
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv4;
                        CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                    }
                    completionStatusForTasks = (List)destination$iv$iv3;
                    $this$any$iv = completionStatusForTasks;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            TaskCompletionStatus it = (TaskCompletionStatus)((Object)element$iv2);
                            boolean bl10 = false;
                            if (!(it == TaskCompletionStatus.FAILURE || it == TaskCompletionStatus.CANCELLED)) continue;
                            bl2 = true;
                            break block13;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    MetricsEventService.sendEventForProject$default(this.metricsEventService, FAILED, 0.0, 2, null);
                    continue;
                }
                $this$any$iv = completionStatusForTasks;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        TaskCompletionStatus it = (TaskCompletionStatus)((Object)element$iv2);
                        boolean bl11 = false;
                        if (!(it == TaskCompletionStatus.INCOMPLETE)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                MetricsEventService.sendEventForProject$default(this.metricsEventService, INCOMPLETE, 0.0, 2, null);
                continue;
            }
            if (((Collection)completionStatusForTasks).isEmpty()) continue;
            MetricsEventService.sendEventForProject$default(this.metricsEventService, SUCCESS, 0.0, 2, null);
        }
        taskList2.completedTaskProgressFor(MigrationTaskType.PROJECT_DATA_UPLOAD);
    }

    private final void sendAdvancedRoadmapsPlansEvent(TaskList taskList2, String migrationId, String cloudId2, boolean successful, Plan plan2) {
        Integer totalAdvancedRoadmapsPlans;
        Object object = plan2;
        Integer n = object != null && (object = ((Plan)object).getAdvancedRoadmapsPlanIds()) != null ? Integer.valueOf(object.size()) : (totalAdvancedRoadmapsPlans = null);
        if (totalAdvancedRoadmapsPlans == null || totalAdvancedRoadmapsPlans == 0) {
            return;
        }
        EntityCounts advancedRoadmapsMigrationEntityCounts = new MigrationTaskStatus(taskList2, false, null, null, 14, null).getCrossProjectEntityTypeCounts().get("jira/advancedroadmaps:plan");
        AdvancedRoadmapsMigrationOption advancedRoadmapsMigrationOption = plan2.getAdvancedRoadmapsMigrationOption();
        AdvancedRoadmapPlanMigrationMode advancedRoadmapPlanMigrationMode = advancedRoadmapsMigrationOption != null ? advancedRoadmapsMigrationOption.getAdvancedRoadmapsMigrationMode() : null;
        EntityCounts entityCounts = advancedRoadmapsMigrationEntityCounts;
        EntityCounts entityCounts2 = advancedRoadmapsMigrationEntityCounts;
        EntityCounts entityCounts3 = advancedRoadmapsMigrationEntityCounts;
        this.migrationEventBus.post(new AdvancedRoadmapsPlansMigrationFinishedEvent(cloudId2, migrationId, totalAdvancedRoadmapsPlans, entityCounts != null ? entityCounts.getTotal() : 0L, entityCounts2 != null ? entityCounts2.getFailed() : 0L, entityCounts3 != null ? entityCounts3.getCreated() : 0L, successful, advancedRoadmapPlanMigrationMode));
        log.info("Advanced Roadmaps migration finished event sent.");
    }

    private final void triggerReportDataGeneration(MigrationTaskStatus status, String migrationId, MigrationType migrationType, Plan plan2, CloudSite cloudSite2, MigrationProtocol protocol) {
        Map<String, Map<String, EntityCounts>> projectEntityTypeCounts = status.getProjectEntityTypeCounts();
        Map<String, EntityCounts> crossProjectEntityTypeCounts = status.getCrossProjectEntityTypeCounts();
        Map<String, EntityCounts> attachmentsUploadCounts = status.getAttachmentsUploadCounts();
        Pair<EntityCounts, EntityCounts> pair = status.getUsersGroupsCount();
        EntityCounts userCounts = (EntityCounts)pair.component1();
        EntityCounts groupCounts = (EntityCounts)pair.component2();
        EntityCounts customerCounts = status.getCustomersCount();
        Plan plan3 = plan2;
        if (this.migrationReportFeatureFlagEvaluator.isPostMigrationReportEnabled(migrationType, plan3 != null ? plan3.getSinglePathMode() : null)) {
            this.postMigrationReportsService.generateReportData(migrationId, new ActualProjectEntityTypeCounts(projectEntityTypeCounts), crossProjectEntityTypeCounts, userCounts, groupCounts, customerCounts, attachmentsUploadCounts);
            if (plan2 != null) {
                this.validateAndProcessPMRAEvents(migrationId, cloudSite2, plan2, protocol);
                this.postMigrationReportsService.sendPostReport(plan2, migrationId);
            }
        }
    }

    private final void triggerSendingPostReports(String migrationId, Plan plan2, CloudSite cloudSite2, MigrationProtocol protocol) {
        if (plan2 != null) {
            this.validateAndProcessPMRAEvents(migrationId, cloudSite2, plan2, protocol);
            this.postMigrationReportsService.sendPostReport(plan2, migrationId);
        }
    }

    private final void validateAndProcessPMRAEvents(String migrationId, CloudSite cloudSite2, Plan plan2, MigrationProtocol protocol) {
        try {
            boolean isV4Protocol;
            boolean bl = isV4Protocol = protocol == MigrationProtocol.V4;
            if (isV4Protocol && this.migrationFeatures.getEnableFetchingJQLErrorsFromMRC()) {
                String executionId = plan2.getPreflightCheckExecutionId();
                this.pmraFailedEntityLogService.fetchPMRAEventsAndSaveToDB(executionId, migrationId, cloudSite2, plan2);
            }
        }
        catch (Exception e) {
            log.error("Error processing PMRA events data for " + migrationId + ": " + e, (Throwable)e);
        }
    }

    private final Migration getMigration(String migrationId) {
        return this.migrationRepository.findByMigrationId(migrationId);
    }

    public static final /* synthetic */ JiraEventDetectionService access$getJiraEventDetectionService$p(StatusPoller $this) {
        return $this.jiraEventDetectionService;
    }

    public static final /* synthetic */ MigrationRepository access$getMigrationRepository$p(StatusPoller $this) {
        return $this.migrationRepository;
    }

    public static final /* synthetic */ MetricsEventService access$getMetricsEventService$p(StatusPoller $this) {
        return $this.metricsEventService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/StatusPoller$Companion;", "", "()V", "FAILED", "", "INCOMPLETE", "JOIN_SEPARATOR", "SUCCESS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "toIncrementStatus", "Lcom/atlassian/jira/migration/migration/MigrationIncrementStatus;", "taskStatus", "Lcom/atlassian/jira/migration/progress/IncrementalTaskStatus;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final MigrationIncrementStatus toIncrementStatus(@NotNull IncrementalTaskStatus taskStatus) {
            MigrationIncrementStatus migrationIncrementStatus;
            Intrinsics.checkNotNullParameter((Object)((Object)taskStatus), (String)"taskStatus");
            switch (WhenMappings.$EnumSwitchMapping$0[taskStatus.ordinal()]) {
                case 1: 
                case 2: {
                    migrationIncrementStatus = MigrationIncrementStatus.Success;
                    break;
                }
                case 3: 
                case 4: {
                    migrationIncrementStatus = MigrationIncrementStatus.Failure;
                    break;
                }
                case 5: 
                case 6: {
                    migrationIncrementStatus = MigrationIncrementStatus.InProgress;
                    break;
                }
                case 7: {
                    migrationIncrementStatus = MigrationIncrementStatus.Incomplete;
                    break;
                }
                case 8: {
                    migrationIncrementStatus = MigrationIncrementStatus.Ready;
                    break;
                }
                case 9: {
                    migrationIncrementStatus = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return migrationIncrementStatus;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IncrementalTaskStatus.values().length];
                try {
                    nArray[IncrementalTaskStatus.COMPLETE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IncrementalTaskStatus.SYNCED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IncrementalTaskStatus.FAILED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IncrementalTaskStatus.ERROR.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IncrementalTaskStatus.FINAL_SYNC.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IncrementalTaskStatus.SYNCING.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IncrementalTaskStatus.INCOMPLETE.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IncrementalTaskStatus.READY.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IncrementalTaskStatus.UNKNOWN.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

