/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.tracking.polling;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.jiraservice.JiraMetadataService;
import com.atlassian.jira.migration.migration.MigrationCommand;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.platform.TransferResultRequest;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.prc.client.PrcHttpClient;
import com.atlassian.jira.migration.tracking.polling.AbstractPoller;
import com.atlassian.jira.migration.tracking.polling.InProgressMigration;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.polling.PollerConfig;
import com.atlassian.jira.migration.tracking.polling.V4PollerKt;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.tracking.tasks.V4Worker;
import com.atlassian.jira.migration.workers.WorkerDataConvertor;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.prc.client.Response;
import com.atlassian.migration.prc.client.model.config.OnDemandPollerConfig;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.Command;
import com.atlassian.migration.prc.model.PrcRequest;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import java.net.URL;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0003J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020\u0003H\u0002J\u0018\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/V4Poller;", "Lcom/atlassian/jira/migration/tracking/polling/AbstractPoller;", "pollerId", "", "config", "Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "worker", "Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "onDemandPrcPoller", "Lcom/atlassian/migration/prc/client/poller/OnDemandPrcPoller;", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "prcHttpClient", "Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;", "jiraMetadataService", "Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;", "workerDataConvertor", "Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "(Ljava/lang/String;Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/migration/prc/client/poller/OnDemandPrcPoller;Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/migration/MigrationCommandService;)V", "getConfig", "()Lcom/atlassian/jira/migration/tracking/polling/PollerConfig;", "getPollerId", "()Ljava/lang/String;", "getWorker", "()Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "doPoll", "", "execute", "command", "Lcom/atlassian/migration/prc/model/Command;", "getPollerConfig", "Lcom/atlassian/migration/prc/client/model/config/OnDemandPollerConfig;", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "pollAndExecute", "migrationId", "reportFailureNoThrow", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "e", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nV4Poller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V4Poller.kt\ncom/atlassian/jira/migration/tracking/polling/V4Poller\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,153:1\n1313#2,2:154\n*S KotlinDebug\n*F\n+ 1 V4Poller.kt\ncom/atlassian/jira/migration/tracking/polling/V4Poller\n*L\n69#1:154,2\n*E\n"})
public final class V4Poller
extends AbstractPoller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pollerId;
    @NotNull
    private final PollerConfig config;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final V4Worker worker;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final OnDemandPrcPoller onDemandPrcPoller;
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final PrcHttpClient prcHttpClient;
    @NotNull
    private final JiraMetadataService jiraMetadataService;
    @NotNull
    private final WorkerDataConvertor workerDataConvertor;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    private static final Logger log = LoggerFactory.getLogger(V4Poller.class);
    @NotNull
    private static final String CHANNEL_NAME_PREFIX = "jira-server-to-cloud-";

    public V4Poller(@NotNull String pollerId, @NotNull PollerConfig config2, @NotNull InProgressMigrationIds migrationIds, @NotNull V4Worker worker, @NotNull DiscoveryService discoveryService, @NotNull OnDemandPrcPoller onDemandPrcPoller, @NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull PrcHttpClient prcHttpClient, @NotNull JiraMetadataService jiraMetadataService, @NotNull WorkerDataConvertor workerDataConvertor, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull MigrationCommandService migrationCommandService) {
        Intrinsics.checkNotNullParameter((Object)pollerId, (String)"pollerId");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)onDemandPrcPoller, (String)"onDemandPrcPoller");
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)prcHttpClient, (String)"prcHttpClient");
        Intrinsics.checkNotNullParameter((Object)jiraMetadataService, (String)"jiraMetadataService");
        Intrinsics.checkNotNullParameter((Object)workerDataConvertor, (String)"workerDataConvertor");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        super(pollerId, config2.getPollingDelay(), jiraThreadLocalUtil, null, 8, null);
        this.pollerId = pollerId;
        this.config = config2;
        this.migrationIds = migrationIds;
        this.worker = worker;
        this.discoveryService = discoveryService;
        this.onDemandPrcPoller = onDemandPrcPoller;
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.prcHttpClient = prcHttpClient;
        this.jiraMetadataService = jiraMetadataService;
        this.workerDataConvertor = workerDataConvertor;
        this.migrationCommandService = migrationCommandService;
    }

    @NotNull
    public final String getPollerId() {
        return this.pollerId;
    }

    @NotNull
    public final PollerConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final V4Worker getWorker() {
        return this.worker;
    }

    @Override
    public void doPoll() {
        Sequence $this$forEach$iv = SequencesKt.filter(this.migrationIds.sequence(), (Function1)((Function1)new Function1<InProgressMigration, Boolean>(this){
            final /* synthetic */ V4Poller this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull InProgressMigration inProgressMigration) {
                Intrinsics.checkNotNullParameter((Object)inProgressMigration, (String)"<name for destructuring parameter 0>");
                MigrationProtocol migrationProtocol = inProgressMigration.component2();
                return this.this$0.getWorker().getMigrationProtocol() == migrationProtocol;
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InProgressMigration inProgressMigration = (InProgressMigration)element$iv;
            boolean bl = false;
            String migrationId = inProgressMigration.component1();
            String[] stringArray = new String[]{migrationId};
            ((CounterDataPoint)V4PollerKt.getPollCounter().labelValues(stringArray)).inc();
            CloudSite cloudSite2 = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, migrationId, false, 2, null);
            if (cloudSite2 != null) {
                this.pollAndExecute(cloudSite2, migrationId);
                continue;
            }
            log.warn("Poller " + this.pollerId + " failed to retrieve cloud site info for migration id " + migrationId + ", will keep trying");
        }
    }

    private final void pollAndExecute(CloudSite cloudSite2, String migrationId) {
        String[] stringArray = new String[]{migrationId};
        ((CounterDataPoint)V4PollerKt.getPollAndExecuteCounter().labelValues(stringArray)).inc();
        try {
            log.debug("Polling command for poller: " + this.pollerId + " and migration id " + migrationId);
            OnDemandPollerConfig pollerConfig = this.getPollerConfig(cloudSite2);
            Command command = this.onDemandPrcPoller.pollAndDeliver(pollerConfig);
            if (command == null) {
                log.debug("No command found for poller " + this.pollerId + ", will keep trying");
            } else {
                log.info("Command: " + command.getId() + " received for poller " + this.pollerId + ". Executing...");
                String[] stringArray2 = new String[]{migrationId};
                ((DistributionDataPoint)V4PollerKt.getExecuteHistogram().labelValues(stringArray2)).time(() -> V4Poller.pollAndExecute$lambda$1(this, command));
            }
        }
        catch (Throwable e) {
            log.warn("Poller " + this.pollerId + " failed, will keep trying", e);
        }
    }

    @VisibleForTesting
    private final void execute(Command command) {
        PrcTask task = this.workerDataConvertor.toPrcTask(command);
        try {
            MigrationCommand migrationCommmand = this.migrationCommandService.upsertVersion(task.getMigrationId(), task.getPrcCommandId());
            task.setVersion(migrationCommmand.getVersion());
            log.info("Execution started for command id: " + command.getId() + " name: " + command.getName());
            this.worker.process(task);
        }
        catch (Throwable e) {
            this.reportFailureNoThrow(task, e);
        }
    }

    private final OnDemandPollerConfig getPollerConfig(CloudSite cloudSite2) {
        String string = CHANNEL_NAME_PREFIX + this.jiraMetadataService.getJiraServerId();
        String string2 = cloudSite2.getCloudId();
        String string3 = cloudSite2.getContainerToken();
        Function4<URL, Map<String, String>, PrcRequest, Boolean, Response> function4 = this.prcHttpClient.getPushAndPollAsCallback();
        String string4 = this.prcHttpClient.getBaseUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return new OnDemandPollerConfig(string, string2, string3, function4, string4, CollectionsKt.listOf((Object)this.worker.getCommandName().getValue()), null, false, 192, null);
    }

    private final void reportFailureNoThrow(PrcTask task, Throwable e) {
        try {
            log.error("Failed to execute command for migration " + task.getMigrationId() + " and prc commandId " + task.getPrcCommandId() + ". Reporting failure to PRC " + e);
            this.prcStatusUpdateService.publishFinalStatus(task, CommandStatus.FAILED, new TransferResultRequest(TransferStatus.FAILED, ProgressItem.Companion.throwableToDetailsMessage(e), null, null, 12, null));
        }
        catch (RuntimeException updateError) {
            log.error("Migration " + task.getMigrationId() + " failed to update task status in PRC: " + task.getPrcCommandId(), (Throwable)updateError);
        }
    }

    private static final void pollAndExecute$lambda$1(V4Poller this$0, Command $command) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.execute($command);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/tracking/polling/V4Poller$Companion;", "", "()V", "CHANNEL_NAME_PREFIX", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

