/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.tracking.tasks.process;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.orchestratorclient.tasks.TaskCompletionStatus;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JF\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0013H\u0002J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0013J:\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017JK\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u001b0\u0017\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor;", "", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;)V", "recordMetric", "", "operationType", "Lcom/atlassian/jira/migration/analytics/MetricsEventService$OperationType;", "operationUniqueKey", "", "startTime", "", "status", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/TaskCompletionStatus;", "count", "dimensions", "", "duration", "runTimedOperation", "operation", "Lkotlin/Function0;", "Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor$OperationOutcome;", "runTimedOperationWithResult", "T", "Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor$OperationOutcomeWithResult;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService$OperationType;Ljava/lang/String;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "OperationOutcome", "OperationOutcomeWithResult", "jira-migration-plugin"})
public abstract class OperationProcessor {
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final JiraEventDetectionService jiraEventDetectionService;

    public OperationProcessor(@NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService) {
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        this.metricsEventService = metricsEventService;
        this.jiraEventDetectionService = jiraEventDetectionService;
    }

    public final void runTimedOperation(@NotNull MetricsEventService.OperationType operationType, @NotNull String operationUniqueKey, @NotNull Map<String, String> dimensions, @NotNull Function0<OperationOutcome> operation) {
        Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
        Intrinsics.checkNotNullParameter((Object)operationUniqueKey, (String)"operationUniqueKey");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        this.runTimedOperationWithResult(operationType, operationUniqueKey, dimensions, (Function0)new Function0<OperationOutcomeWithResult<Boolean>>(operation){
            final /* synthetic */ Function0<OperationOutcome> $operation;
            {
                this.$operation = $operation;
                super(0);
            }

            @NotNull
            public final OperationOutcomeWithResult<Boolean> invoke() {
                return new OperationOutcomeWithResult<Boolean>(((OperationOutcome)this.$operation.invoke()).getCount(), true);
            }
        });
    }

    public static /* synthetic */ void runTimedOperation$default(OperationProcessor operationProcessor, MetricsEventService.OperationType operationType, String string, Map map, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runTimedOperation");
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        operationProcessor.runTimedOperation(operationType, string, map, (Function0<OperationOutcome>)function0);
    }

    public final <T> T runTimedOperationWithResult(@NotNull MetricsEventService.OperationType operationType, @NotNull String operationUniqueKey, @NotNull Map<String, String> dimensions, @NotNull Function0<OperationOutcomeWithResult<T>> operation) {
        Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
        Intrinsics.checkNotNullParameter((Object)operationUniqueKey, (String)"operationUniqueKey");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        return this.jiraEventDetectionService.runAndDetect(operationUniqueKey, (Function0)new Function0<T>(this, operation, operationType, operationUniqueKey, dimensions){
            final /* synthetic */ OperationProcessor this$0;
            final /* synthetic */ Function0<OperationOutcomeWithResult<T>> $operation;
            final /* synthetic */ MetricsEventService.OperationType $operationType;
            final /* synthetic */ String $operationUniqueKey;
            final /* synthetic */ Map<String, String> $dimensions;
            {
                this.this$0 = $receiver;
                this.$operation = $operation;
                this.$operationType = $operationType;
                this.$operationUniqueKey = $operationUniqueKey;
                this.$dimensions = $dimensions;
                super(0);
            }

            public final T invoke() {
                Object object;
                Object $this$invoke_u24lambda_u240;
                long startTime = System.currentTimeMillis();
                Object object2 = this.this$0;
                Object object3 = this.$operation;
                try {
                    $this$invoke_u24lambda_u240 = object2;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)((OperationOutcomeWithResult)object3.invoke()));
                }
                catch (Throwable throwable) {
                    $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = $this$invoke_u24lambda_u240;
                object3 = this.this$0;
                $this$invoke_u24lambda_u240 = this.$operationType;
                String string = this.$operationUniqueKey;
                Map<String, String> map = this.$dimensions;
                if (Result.isSuccess-impl((Object)object2)) {
                    OperationOutcomeWithResult it = (OperationOutcomeWithResult)object2;
                    boolean bl = false;
                    OperationProcessor.access$recordMetric(object3, (MetricsEventService.OperationType)((Object)$this$invoke_u24lambda_u240), string, startTime, TaskCompletionStatus.SUCCESS, it.getCount(), map);
                }
                object3 = this.this$0;
                $this$invoke_u24lambda_u240 = this.$operationType;
                string = this.$operationUniqueKey;
                map = this.$dimensions;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Throwable throwable2;
                    Throwable it = throwable2 = throwable;
                    boolean bl = false;
                    OperationProcessor.access$recordMetric(object3, (MetricsEventService.OperationType)((Object)$this$invoke_u24lambda_u240), string, startTime, TaskCompletionStatus.FAILURE, 0L, map);
                }
                if (Result.isSuccess-impl((Object)object2)) {
                    OperationOutcomeWithResult it = (OperationOutcomeWithResult)object2;
                    boolean bl = false;
                    object = Result.constructor-impl(it.getResult());
                } else {
                    object = Result.constructor-impl((Object)object2);
                }
                object2 = object;
                ResultKt.throwOnFailure((Object)object2);
                return (T)object2;
            }
        });
    }

    public static /* synthetic */ Object runTimedOperationWithResult$default(OperationProcessor operationProcessor, MetricsEventService.OperationType operationType, String string, Map map, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runTimedOperationWithResult");
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return operationProcessor.runTimedOperationWithResult(operationType, string, map, function0);
    }

    private final void recordMetric(MetricsEventService.OperationType operationType, String operationUniqueKey, long startTime, TaskCompletionStatus status, long count2, Map<String, String> dimensions) {
        Map<String, String> eventTags = this.jiraEventDetectionService.getEventMapForOperation(operationUniqueKey);
        this.metricsEventService.sendTimeForOperation(operationType, status.toString(), System.currentTimeMillis() - startTime, count2, MapsKt.plus(eventTags, dimensions));
    }

    static /* synthetic */ void recordMetric$default(OperationProcessor operationProcessor, MetricsEventService.OperationType operationType, String string, long l, TaskCompletionStatus taskCompletionStatus, long l2, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: recordMetric");
        }
        if ((n & 0x20) != 0) {
            map = MapsKt.emptyMap();
        }
        operationProcessor.recordMetric(operationType, string, l, taskCompletionStatus, l2, map);
    }

    public final void recordMetric(@NotNull MetricsEventService.OperationType operationType, @NotNull String operationUniqueKey, long duration, @NotNull Map<String, String> dimensions) {
        Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
        Intrinsics.checkNotNullParameter((Object)operationUniqueKey, (String)"operationUniqueKey");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        this.metricsEventService.sendTimerEvent(operationType, duration, MapsKt.plus(dimensions, this.jiraEventDetectionService.getEventMapForOperation(operationUniqueKey)));
    }

    public static /* synthetic */ void recordMetric$default(OperationProcessor operationProcessor, MetricsEventService.OperationType operationType, String string, long l, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: recordMetric");
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        operationProcessor.recordMetric(operationType, string, l, map);
    }

    public static final /* synthetic */ void access$recordMetric(OperationProcessor $this, MetricsEventService.OperationType operationType, String operationUniqueKey, long startTime, TaskCompletionStatus status, long count2, Map dimensions) {
        $this.recordMetric(operationType, operationUniqueKey, startTime, status, count2, dimensions);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor$OperationOutcome;", "", "count", "", "(J)V", "getCount", "()J", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class OperationOutcome {
        private final long count;

        public OperationOutcome(long count2) {
            this.count = count2;
        }

        public final long getCount() {
            return this.count;
        }

        public final long component1() {
            return this.count;
        }

        @NotNull
        public final OperationOutcome copy(long count2) {
            return new OperationOutcome(count2);
        }

        public static /* synthetic */ OperationOutcome copy$default(OperationOutcome operationOutcome, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = operationOutcome.count;
            }
            return operationOutcome.copy(l);
        }

        @NotNull
        public String toString() {
            return "OperationOutcome(count=" + this.count + ')';
        }

        public int hashCode() {
            return Long.hashCode(this.count);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OperationOutcome)) {
                return false;
            }
            OperationOutcome operationOutcome = (OperationOutcome)other;
            return this.count == operationOutcome.count;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\r\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor$OperationOutcomeWithResult;", "T", "", "count", "", "result", "(JLjava/lang/Object;)V", "getCount", "()J", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(JLjava/lang/Object;)Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor$OperationOutcomeWithResult;", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class OperationOutcomeWithResult<T> {
        private final long count;
        private final T result;

        public OperationOutcomeWithResult(long count2, T result2) {
            this.count = count2;
            this.result = result2;
        }

        public final long getCount() {
            return this.count;
        }

        public final T getResult() {
            return this.result;
        }

        public final long component1() {
            return this.count;
        }

        public final T component2() {
            return this.result;
        }

        @NotNull
        public final OperationOutcomeWithResult<T> copy(long count2, T result2) {
            return new OperationOutcomeWithResult<T>(count2, result2);
        }

        public static /* synthetic */ OperationOutcomeWithResult copy$default(OperationOutcomeWithResult operationOutcomeWithResult, long l, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                l = operationOutcomeWithResult.count;
            }
            if ((n & 2) != 0) {
                object = operationOutcomeWithResult.result;
            }
            return operationOutcomeWithResult.copy(l, object);
        }

        @NotNull
        public String toString() {
            return "OperationOutcomeWithResult(count=" + this.count + ", result=" + this.result + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.count);
            result2 = result2 * 31 + (this.result == null ? 0 : this.result.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OperationOutcomeWithResult)) {
                return false;
            }
            OperationOutcomeWithResult operationOutcomeWithResult = (OperationOutcomeWithResult)other;
            if (this.count != operationOutcomeWithResult.count) {
                return false;
            }
            return Intrinsics.areEqual(this.result, operationOutcomeWithResult.result);
        }
    }
}

