/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.tracking.utils;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tJ$\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/tracking/utils/ThreadUtils;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "safeExecutePeriodicallyUntilStopped", "", "what", "Lkotlin/Function0;", "delay", "Ljava/time/Duration;", "shouldKeepRunning", "", "Ljava/util/concurrent/atomic/AtomicBoolean;", "jira-migration-plugin"})
public final class ThreadUtils {
    @NotNull
    public static final ThreadUtils INSTANCE = new ThreadUtils();
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);

    private ThreadUtils() {
    }

    public final void safeExecutePeriodicallyUntilStopped(@NotNull Function0<Unit> what, @NotNull Duration delay, @NotNull AtomicBoolean shouldKeepRunning) {
        Intrinsics.checkNotNullParameter(what, (String)"what");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter((Object)shouldKeepRunning, (String)"shouldKeepRunning");
        this.safeExecutePeriodicallyUntilStopped(what, delay, (Function0<Boolean>)((Function0)new Function0<Boolean>(shouldKeepRunning){
            final /* synthetic */ AtomicBoolean $shouldKeepRunning;
            {
                this.$shouldKeepRunning = $shouldKeepRunning;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$shouldKeepRunning.get();
            }
        }));
    }

    public final void safeExecutePeriodicallyUntilStopped(@NotNull Function0<Unit> what, @NotNull Duration delay, @NotNull Function0<Boolean> shouldKeepRunning) {
        Intrinsics.checkNotNullParameter(what, (String)"what");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter(shouldKeepRunning, (String)"shouldKeepRunning");
        AtomicBoolean hasBeenInterrupted = new AtomicBoolean(false);
        while (((Boolean)shouldKeepRunning.invoke()).booleanValue() && !hasBeenInterrupted.get()) {
            try {
                what.invoke();
            }
            catch (Throwable e) {
                log.error("uncaught exception in periodic executor", e);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(delay.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                hasBeenInterrupted.set(true);
            }
        }
    }
}

