/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskEntity;
import com.atlassian.jira.migration.backgroundtask.repository.BackgroundTaskUnitEntity;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskStatus;
import com.atlassian.jira.migration.backgroundtask.service.BackgroundTaskUnitStatus;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/upgrade/BackgroundTaskUnitEntityUpgradeTaskV13;", "Lcom/atlassian/activeobjects/external/ActiveObjectsUpgradeTask;", "()V", "log", "Lorg/slf4j/Logger;", "defineBackgroundTaskStatus", "Lcom/atlassian/jira/migration/backgroundtask/service/BackgroundTaskStatus;", "taskUnits", "", "Lcom/atlassian/jira/migration/backgroundtask/repository/BackgroundTaskUnitEntity;", "executeUpgrade", "", "activeObjects", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "getCreatedAt", "", "getModelVersion", "Lcom/atlassian/activeobjects/external/ModelVersion;", "getUpdatedAt", "upgrade", "modelVersion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBackgroundTaskUnitEntityUpgradeTaskV13.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundTaskUnitEntityUpgradeTaskV13.kt\ncom/atlassian/jira/migration/upgrade/BackgroundTaskUnitEntityUpgradeTaskV13\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1855#2,2:99\n1549#2:101\n1620#2,3:102\n1#3:105\n*S KotlinDebug\n*F\n+ 1 BackgroundTaskUnitEntityUpgradeTaskV13.kt\ncom/atlassian/jira/migration/upgrade/BackgroundTaskUnitEntityUpgradeTaskV13\n*L\n44#1:99,2\n72#1:101\n72#1:102,3\n*E\n"})
public final class BackgroundTaskUnitEntityUpgradeTaskV13
implements ActiveObjectsUpgradeTask {
    @NotNull
    private final Logger log;

    public BackgroundTaskUnitEntityUpgradeTaskV13() {
        Logger logger2 = LoggerFactory.getLogger(BackgroundTaskUnitEntityUpgradeTaskV13.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    @NotNull
    public ModelVersion getModelVersion() {
        ModelVersion modelVersion = ModelVersion.valueOf((String)"13");
        Intrinsics.checkNotNullExpressionValue((Object)modelVersion, (String)"valueOf(...)");
        return modelVersion;
    }

    public void upgrade(@NotNull ModelVersion modelVersion, @NotNull ActiveObjects activeObjects) {
        Intrinsics.checkNotNullParameter((Object)modelVersion, (String)"modelVersion");
        Intrinsics.checkNotNullParameter((Object)activeObjects, (String)"activeObjects");
        try {
            Class[] classArray = new Class[]{BackgroundTaskUnitEntity.class};
            activeObjects.migrate(classArray);
            this.executeUpgrade(activeObjects);
        }
        catch (SQLSyntaxErrorException e) {
            this.log.error("Error while migrating BackgroundTaskUnitEntity, but we'll try it again.", (Throwable)e);
            this.executeUpgrade(activeObjects);
        }
    }

    private final void executeUpgrade(ActiveObjects activeObjects) {
        Class[] classArray = new Class[]{BackgroundTaskEntity.class};
        activeObjects.migrate(classArray);
        RawEntity[] rawEntityArray = activeObjects.find(BackgroundTaskUnitEntity.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        List currentTaskUnits = ArraysKt.toList((Object[])rawEntityArray);
        if (!((Collection)currentTaskUnits).isEmpty()) {
            activeObjects.deleteWithSQL(BackgroundTaskUnitEntity.class, null, new Object[0]);
            Iterable $this$forEach$iv = currentTaskUnits;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BackgroundTaskUnitEntity it = (BackgroundTaskUnitEntity)element$iv;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"TASK_UNIT_ID", (Object)it.getTaskUnitId()), TuplesKt.to((Object)"TASK_ID", (Object)"defaultTaskId"), TuplesKt.to((Object)"NODE_ID", (Object)"defaultNode"), TuplesKt.to((Object)"STATUS", (Object)((Object)it.getStatus())), TuplesKt.to((Object)"CREATED_AT", (Object)it.getCreatedAt()), TuplesKt.to((Object)"UPDATED_AT", (Object)it.getUpdatedAt())};
                activeObjects.create(BackgroundTaskUnitEntity.class, MapsKt.mapOf((Pair[])pairArray));
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"TASK_ID", (Object)"defaultTaskId"), TuplesKt.to((Object)"STATUS", (Object)((Object)this.defineBackgroundTaskStatus(currentTaskUnits))), TuplesKt.to((Object)"CREATED_AT", (Object)this.getCreatedAt(currentTaskUnits)), TuplesKt.to((Object)"UPDATED_AT", (Object)this.getUpdatedAt(currentTaskUnits))};
            activeObjects.create(BackgroundTaskEntity.class, MapsKt.mapOf((Pair[])pairArray));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final BackgroundTaskStatus defineBackgroundTaskStatus(List<? extends BackgroundTaskUnitEntity> taskUnits) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = taskUnits;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BackgroundTaskUnitEntity backgroundTaskUnitEntity = (BackgroundTaskUnitEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStatus());
        }
        Set it = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        return it.contains((Object)BackgroundTaskUnitStatus.CANCELED) ? BackgroundTaskStatus.CANCELED : (it.contains((Object)BackgroundTaskUnitStatus.FAILED) ? BackgroundTaskStatus.INCOMPLETE : (it.contains((Object)BackgroundTaskUnitStatus.INCOMPLETE) ? BackgroundTaskStatus.INCOMPLETE : (it.contains((Object)BackgroundTaskUnitStatus.IN_PROGRESS) ? BackgroundTaskStatus.INCOMPLETE : (it.contains((Object)BackgroundTaskUnitStatus.COMPLETE) ? BackgroundTaskStatus.COMPLETE : BackgroundTaskStatus.NOT_STARTED))));
    }

    private final long getCreatedAt(List<? extends BackgroundTaskUnitEntity> taskUnits) {
        Comparable comparable;
        Iterator iterator2 = ((Iterable)taskUnits).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            BackgroundTaskUnitEntity it = (BackgroundTaskUnitEntity)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getCreatedAt());
            while (iterator2.hasNext()) {
                BackgroundTaskUnitEntity it2 = (BackgroundTaskUnitEntity)iterator2.next();
                $i$a$-minOfOrNull-BackgroundTaskUnitEntityUpgradeTaskV13$getCreatedAt$1 = false;
                Comparable comparable3 = Long.valueOf(it2.getCreatedAt());
                if (comparable2.compareTo(comparable3) <= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Long l = (Long)comparable;
        return l != null ? l : System.currentTimeMillis();
    }

    private final long getUpdatedAt(List<? extends BackgroundTaskUnitEntity> taskUnits) {
        Comparable comparable;
        Iterator iterator2 = ((Iterable)taskUnits).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            BackgroundTaskUnitEntity it = (BackgroundTaskUnitEntity)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getUpdatedAt());
            while (iterator2.hasNext()) {
                BackgroundTaskUnitEntity it2 = (BackgroundTaskUnitEntity)iterator2.next();
                $i$a$-maxOfOrNull-BackgroundTaskUnitEntityUpgradeTaskV13$getUpdatedAt$1 = false;
                Comparable comparable3 = Long.valueOf(it2.getUpdatedAt());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Long l = (Long)comparable;
        return l != null ? l : System.currentTimeMillis();
    }
}

