/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.userinterface;

import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="user-interface")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/userinterface/UserInterfaceLoggingResource;", "", "()V", "buildLogMessage", "", "message", "stackTrace", "logPost", "Ljavax/ws/rs/core/Response;", "logData", "Lcom/atlassian/jira/migration/userinterface/UserInterfaceLoggingResource$LogData;", "Companion", "LogData", "LogLevel", "jira-migration-plugin"})
public final class UserInterfaceLoggingResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(UserInterfaceLoggingResource.class);

    @POST
    @Path(value="/log")
    @NotNull
    public final Response logPost(@NotNull LogData logData) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        String string = logData.getMessage();
        if (string == null) {
            string = "null";
        }
        String logMessage = this.buildLogMessage(string, logData.getStackTrace());
        LogLevel logLevel = logData.getLogLevel();
        switch (logLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[logLevel.ordinal()]) {
            case 1: {
                log.info(logMessage);
                break;
            }
            case 2: {
                log.debug(logMessage);
                break;
            }
            case 3: {
                log.warn(logMessage);
                break;
            }
            case 4: {
                log.error(logMessage);
                break;
            }
            default: {
                log.debug(logMessage);
            }
        }
        Response response2 = Response.status((Response.Status)Response.Status.ACCEPTED).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @VisibleForTesting
    @NotNull
    public final String buildLogMessage(@NotNull String message, @Nullable String stackTrace) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return stackTrace != null ? message + " - " + stackTrace : message;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/userinterface/UserInterfaceLoggingResource$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/userinterface/UserInterfaceLoggingResource$LogData;", "", "logLevel", "Lcom/atlassian/jira/migration/userinterface/UserInterfaceLoggingResource$LogLevel;", "message", "", "stackTrace", "(Lcom/atlassian/jira/migration/userinterface/UserInterfaceLoggingResource$LogLevel;Ljava/lang/String;Ljava/lang/String;)V", "getLogLevel", "()Lcom/atlassian/jira/migration/userinterface/UserInterfaceLoggingResource$LogLevel;", "getMessage", "()Ljava/lang/String;", "getStackTrace", "jira-migration-plugin"})
    public static final class LogData {
        @Nullable
        private final LogLevel logLevel;
        @Nullable
        private final String message;
        @Nullable
        private final String stackTrace;

        public LogData(@org.codehaus.jackson.annotate.JsonProperty(value="logLevel") @JsonProperty(value="logLevel") @Nullable LogLevel logLevel, @org.codehaus.jackson.annotate.JsonProperty(value="message") @JsonProperty(value="message") @Nullable String message, @org.codehaus.jackson.annotate.JsonProperty(value="stackTrace") @JsonProperty(value="stackTrace") @Nullable String stackTrace) {
            this.logLevel = logLevel;
            this.message = message;
            this.stackTrace = stackTrace;
        }

        @Nullable
        public final LogLevel getLogLevel() {
            return this.logLevel;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getStackTrace() {
            return this.stackTrace;
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/userinterface/UserInterfaceLoggingResource$LogLevel;", "", "(Ljava/lang/String;I)V", "DEBUG", "INFO", "WARN", "ERROR", "jira-migration-plugin"})
    public static final class LogLevel
    extends Enum<LogLevel> {
        @org.codehaus.jackson.annotate.JsonProperty(value="DEBUG")
        @JsonProperty(value="DEBUG")
        public static final /* enum */ LogLevel DEBUG = new LogLevel();
        @org.codehaus.jackson.annotate.JsonProperty(value="INFO")
        @JsonProperty(value="INFO")
        public static final /* enum */ LogLevel INFO = new LogLevel();
        @org.codehaus.jackson.annotate.JsonProperty(value="WARN")
        @JsonProperty(value="WARN")
        public static final /* enum */ LogLevel WARN = new LogLevel();
        @org.codehaus.jackson.annotate.JsonProperty(value="ERROR")
        @JsonProperty(value="ERROR")
        public static final /* enum */ LogLevel ERROR = new LogLevel();
        private static final /* synthetic */ LogLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LogLevel[] values() {
            return (LogLevel[])$VALUES.clone();
        }

        public static LogLevel valueOf(String value) {
            return Enum.valueOf(LogLevel.class, value);
        }

        @NotNull
        public static EnumEntries<LogLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = logLevelArray = new LogLevel[]{LogLevel.DEBUG, LogLevel.INFO, LogLevel.WARN, LogLevel.ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WARN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

