/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.usermapping;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.common.SequenceExtensionKt;
import com.atlassian.jira.migration.email.BatchUpsertResultAggregator;
import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.email.InvalidEmailService;
import com.atlassian.jira.migration.email.db.CorrectedEmailRepository;
import com.atlassian.jira.migration.email.db.IncorrectEmailRepository;
import com.atlassian.jira.migration.email.model.BatchUpsertResult;
import com.atlassian.jira.migration.email.model.CorrectedEmail;
import com.atlassian.jira.migration.email.model.IncorrectEmail;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migrationservice.ContainerTokenTTLService;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.usermapping.UserMappingService;
import com.atlassian.jira.migration.usermapping.event.UserMappingEvent;
import com.atlassian.jira.migration.usermapping.event.UserMappingEventFailedUpload;
import com.atlassian.jira.migration.usermapping.event.UserMappingEventFailedValidation;
import com.atlassian.jira.migration.usermapping.event.UserMappingEventFileUploadSuccess;
import com.atlassian.jira.migration.usermapping.model.EmailDataDeserializer;
import com.atlassian.jira.migration.usermapping.model.ErrorType;
import com.atlassian.jira.migration.usermapping.model.ProgressStatus;
import com.atlassian.jira.migration.usermapping.model.UserMappingUploadStatus;
import com.atlassian.jira.migration.utils.EmailValidityCheckerUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.userbasescan.UserBaseScan;
import com.atlassian.migration.udc.common.model.usermapping.model.SourceFileAvailability;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCConfigAction;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingCsvData;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingCsvRecordResult;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingException;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingFilteringResult;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingStatistics;
import com.atlassian.migration.udc.scan.UserBaseScanService;
import com.atlassian.migration.udc.usermapping.UserMappingCsvZipService;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0007\u0018\u0000 m2\u00020\u0001:\u0001mB\u008f\u0001\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010$B\u009d\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010(\u001a\u00020)\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010*J6\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001082\n\b\u0002\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0016\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u000202J\u000e\u0010?\u001a\u0002002\u0006\u0010<\u001a\u00020=J\n\u0010@\u001a\u0004\u0018\u00010AH\u0002J\u0006\u0010B\u001a\u00020:J\u000e\u0010C\u001a\u0002002\u0006\u0010D\u001a\u00020EJ\u001e\u0010F\u001a\u00020,2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020I0H2\u0006\u0010J\u001a\u000202H\u0002J\b\u0010K\u001a\u000200H\u0007J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0016J4\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0H2\u0006\u00101\u001a\u0002022\u0006\u0010R\u001a\u0002022\u0006\u0010S\u001a\u0002022\f\u0010T\u001a\b\u0012\u0004\u0012\u00020U0HH\u0002J6\u0010V\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001082\n\b\u0002\u00109\u001a\u0004\u0018\u00010:H\u0002J\"\u0010W\u001a\u00020:2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0H2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020Y0HJ\u001e\u0010[\u001a\u0002002\u0006\u0010>\u001a\u0002022\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u000202J\u0006\u0010_\u001a\u00020`J\b\u0010a\u001a\u000200H\u0007J\u0018\u0010b\u001a\n d*\u0004\u0018\u00010c0c2\u0006\u0010e\u001a\u00020,H\u0002J.\u0010f\u001a\u00020,2\u0006\u00101\u001a\u0002022\u0006\u0010>\u001a\u0002022\f\u0010g\u001a\b\u0012\u0004\u0012\u00020I0H2\u0006\u0010h\u001a\u000202H\u0002J$\u0010i\u001a\b\u0012\u0004\u0012\u00020Q0H2\u0006\u00101\u001a\u0002022\f\u0010g\u001a\b\u0012\u0004\u0012\u00020I0HH\u0002J.\u0010j\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020Q0l\u0012\n\u0012\b\u0012\u0004\u0012\u00020U0l0k2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020I0HH\u0002R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006n"}, d2={"Lcom/atlassian/jira/migration/usermapping/UserMappingService;", "Lcom/atlassian/scheduler/JobRunner;", "userBaseScanService", "Lcom/atlassian/jira/migration/email/UserBaseScanService;", "correctedEmailRepository", "Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "globalEmailFixesConfigService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "containerTokenTTLService", "Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "invalidEmailService", "Lcom/atlassian/jira/migration/email/InvalidEmailService;", "incorrectEmailRepository", "Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "udcUserMappingService", "Lcom/atlassian/migration/udc/usermapping/UserMappingService;", "udcUserMappingCsvZipService", "Lcom/atlassian/migration/udc/usermapping/UserMappingCsvZipService;", "udcScanDelegate", "Lcom/atlassian/migration/udc/scan/UserBaseScanService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/email/UserBaseScanService;Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/beehive/ClusterLockService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/email/InvalidEmailService;Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/migration/udc/usermapping/UserMappingService;Lcom/atlassian/migration/udc/usermapping/UserMappingCsvZipService;Lcom/atlassian/migration/udc/scan/UserBaseScanService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "batchUpsertResultAggregator", "Lcom/atlassian/jira/migration/email/BatchUpsertResultAggregator;", "Lcom/atlassian/jira/migration/email/model/CorrectedEmail;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/jira/migration/email/UserBaseScanService;Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;Lcom/atlassian/jira/migration/email/BatchUpsertResultAggregator;Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/beehive/ClusterLockService;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/email/InvalidEmailService;Lcom/atlassian/jira/migration/email/db/IncorrectEmailRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/migration/udc/usermapping/UserMappingService;Lcom/atlassian/migration/udc/usermapping/UserMappingCsvZipService;Lcom/atlassian/migration/udc/scan/UserBaseScanService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "userMappingUploadStatus", "Lcom/atlassian/jira/migration/usermapping/model/UserMappingUploadStatus;", "getUserMappingUploadStatus", "()Lcom/atlassian/jira/migration/usermapping/model/UserMappingUploadStatus;", "buildAndSendAnalyticsEvent", "", "executionId", "", "filteredRecordsCount", "", "executionStart", "", "errorType", "Lcom/atlassian/jira/migration/usermapping/model/ErrorType;", "statistics", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UserMappingStatistics;", "buildSourceFileZip", "outputStream", "Ljava/io/OutputStream;", "cloudId", "getAllUserMappings", "getLatestStartedUserBaseScan", "Lcom/atlassian/migration/udc/common/model/userbasescan/UserBaseScan;", "getUserMappingStatistics", "getValidationErrorsCsv", "inMemoryOutputStream", "Ljava/io/ByteArrayOutputStream;", "recordCorrectedEmailData", "userMappingRecordResults", "", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UserMappingCsvRecordResult$UserMappingRecordResult;", "userKey", "register", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "runUmsValidation", "Lcom/atlassian/cmpt/check/email/EmailData;", "containerToken", "migrationScopeId", "jiraUsers", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "safelyBuildAndSendAnalyticsEvent", "saveUserMappingStatistics", "filteredUploadedRecords", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UserMappingCsvData;", "originalRecordsMap", "scheduleCsvUploadJob", "stream", "Ljava/io/InputStream;", "name", "sourceFileAvailability", "Lcom/atlassian/migration/udc/common/model/usermapping/model/SourceFileAvailability;", "unregister", "updateValidationStatus", "", "kotlin.jvm.PlatformType", "status", "validateAndUpsertFilteredRecords", "records", "loggedInUserUserKey", "verifyAllUsersAreFixed", "verifyAllUsersExistInJira", "Lkotlin/Pair;", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUserMappingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserMappingService.kt\ncom/atlassian/jira/migration/usermapping/UserMappingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,374:1\n1549#2:375\n1620#2,3:376\n1549#2:380\n1620#2,3:381\n1789#2,3:384\n1549#2:387\n1620#2,3:388\n1#3:379\n*S KotlinDebug\n*F\n+ 1 UserMappingService.kt\ncom/atlassian/jira/migration/usermapping/UserMappingService\n*L\n172#1:375\n172#1:376,3\n327#1:380\n327#1:381,3\n328#1:384,3\n345#1:387\n345#1:388,3\n*E\n"})
public final class UserMappingService
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final com.atlassian.jira.migration.email.UserBaseScanService userBaseScanService;
    @NotNull
    private final CorrectedEmailRepository correctedEmailRepository;
    @NotNull
    private final BatchUpsertResultAggregator<CorrectedEmail> batchUpsertResultAggregator;
    @NotNull
    private final PluginSettingsFactory pluginSettingsFactory;
    @NotNull
    private final ClusterLockService clusterLockService;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final ContainerTokenTTLService containerTokenTTLService;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final InvalidEmailService invalidEmailService;
    @NotNull
    private final IncorrectEmailRepository incorrectEmailRepository;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final com.atlassian.migration.udc.usermapping.UserMappingService udcUserMappingService;
    @NotNull
    private final UserMappingCsvZipService udcUserMappingCsvZipService;
    @NotNull
    private final UserBaseScanService udcScanDelegate;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final Logger log = LoggerFactory.getLogger(UserMappingService.class);
    @NotNull
    public static final String USER_MAPPING_LOCK = "jcma.migration.user.mapping";
    @NotNull
    public static final String USER_MAPPING_JOB_ID = "udcUserMappingCsvUpload";
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;

    @VisibleForTesting
    public UserMappingService(@NotNull com.atlassian.jira.migration.email.UserBaseScanService userBaseScanService, @NotNull CorrectedEmailRepository correctedEmailRepository, @NotNull BatchUpsertResultAggregator<CorrectedEmail> batchUpsertResultAggregator, @NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull ClusterLockService clusterLockService, @NotNull ObjectMapper objectMapper2, @NotNull GlobalEmailFixesConfigService globalEmailFixesConfigService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull ContainerTokenTTLService containerTokenTTLService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull UserManager userManager, @NotNull InvalidEmailService invalidEmailService, @NotNull IncorrectEmailRepository incorrectEmailRepository, @NotNull MigrationEventBus migrationEventBus, @NotNull com.atlassian.migration.udc.usermapping.UserMappingService udcUserMappingService, @NotNull UserMappingCsvZipService udcUserMappingCsvZipService, @NotNull UserBaseScanService udcScanDelegate, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)userBaseScanService, (String)"userBaseScanService");
        Intrinsics.checkNotNullParameter((Object)correctedEmailRepository, (String)"correctedEmailRepository");
        Intrinsics.checkNotNullParameter(batchUpsertResultAggregator, (String)"batchUpsertResultAggregator");
        Intrinsics.checkNotNullParameter((Object)pluginSettingsFactory, (String)"pluginSettingsFactory");
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)globalEmailFixesConfigService, (String)"globalEmailFixesConfigService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)invalidEmailService, (String)"invalidEmailService");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailRepository, (String)"incorrectEmailRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)udcUserMappingService, (String)"udcUserMappingService");
        Intrinsics.checkNotNullParameter((Object)udcUserMappingCsvZipService, (String)"udcUserMappingCsvZipService");
        Intrinsics.checkNotNullParameter((Object)udcScanDelegate, (String)"udcScanDelegate");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.userBaseScanService = userBaseScanService;
        this.correctedEmailRepository = correctedEmailRepository;
        this.batchUpsertResultAggregator = batchUpsertResultAggregator;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.clusterLockService = clusterLockService;
        this.objectMapper = objectMapper2;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.containerTokenTTLService = containerTokenTTLService;
        this.migrationScopeManager = migrationScopeManager;
        this.userManager = userManager;
        this.invalidEmailService = invalidEmailService;
        this.incorrectEmailRepository = incorrectEmailRepository;
        this.migrationEventBus = migrationEventBus;
        this.udcUserMappingService = udcUserMappingService;
        this.udcUserMappingCsvZipService = udcUserMappingCsvZipService;
        this.udcScanDelegate = udcScanDelegate;
        this.migrationFeatures = migrationFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public UserMappingService(@NotNull com.atlassian.jira.migration.email.UserBaseScanService userBaseScanService, @NotNull CorrectedEmailRepository correctedEmailRepository, @NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull ClusterLockService clusterLockService, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull GlobalEmailFixesConfigService globalEmailFixesConfigService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull ContainerTokenTTLService containerTokenTTLService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull UserManager userManager, @NotNull InvalidEmailService invalidEmailService, @NotNull IncorrectEmailRepository incorrectEmailRepository, @NotNull MigrationEventBus migrationEventBus, @NotNull com.atlassian.migration.udc.usermapping.UserMappingService udcUserMappingService, @NotNull UserMappingCsvZipService udcUserMappingCsvZipService, @NotNull UserBaseScanService udcScanDelegate, @NotNull MigrationFeatures migrationFeatures) {
        void $this$_init__u24lambda_u240;
        SimpleModule simpleModule;
        Intrinsics.checkNotNullParameter((Object)userBaseScanService, (String)"userBaseScanService");
        Intrinsics.checkNotNullParameter((Object)correctedEmailRepository, (String)"correctedEmailRepository");
        Intrinsics.checkNotNullParameter((Object)pluginSettingsFactory, (String)"pluginSettingsFactory");
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)globalEmailFixesConfigService, (String)"globalEmailFixesConfigService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)invalidEmailService, (String)"invalidEmailService");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailRepository, (String)"incorrectEmailRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)udcUserMappingService, (String)"udcUserMappingService");
        Intrinsics.checkNotNullParameter((Object)udcUserMappingCsvZipService, (String)"udcUserMappingCsvZipService");
        Intrinsics.checkNotNullParameter((Object)udcScanDelegate, (String)"udcScanDelegate");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        SimpleModule simpleModule2 = simpleModule = new SimpleModule();
        ObjectMapper objectMapper2 = objectMapperFactory.createObjectMapper();
        ClusterLockService clusterLockService2 = clusterLockService;
        PluginSettingsFactory pluginSettingsFactory2 = pluginSettingsFactory;
        BatchUpsertResultAggregator<CorrectedEmail> batchUpsertResultAggregator = new BatchUpsertResultAggregator<CorrectedEmail>();
        CorrectedEmailRepository correctedEmailRepository2 = correctedEmailRepository;
        com.atlassian.jira.migration.email.UserBaseScanService userBaseScanService2 = userBaseScanService;
        UserMappingService userMappingService = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.addDeserializer(EmailData.class, (JsonDeserializer)new EmailDataDeserializer());
        Unit unit = Unit.INSTANCE;
        ObjectMapper objectMapper3 = objectMapper2.registerModule((Module)simpleModule);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper3, (String)"registerModule(...)");
        userMappingService(userBaseScanService2, correctedEmailRepository2, batchUpsertResultAggregator, pluginSettingsFactory2, clusterLockService2, objectMapper3, globalEmailFixesConfigService, cloudSiteRepository, containerTokenTTLService, migrationScopeManager, userManager, invalidEmailService, incorrectEmailRepository, migrationEventBus, udcUserMappingService, udcUserMappingCsvZipService, udcScanDelegate, migrationFeatures);
    }

    @NotNull
    public final UserMappingUploadStatus getUserMappingUploadStatus() {
        UserMappingUploadStatus userMappingUploadStatus;
        Object object = this.pluginSettingsFactory.createGlobalSettings().get(USER_MAPPING_JOB_ID);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            userMappingUploadStatus = (UserMappingUploadStatus)this.objectMapper.readValue((String)it, UserMappingUploadStatus.class);
        } else {
            userMappingUploadStatus = null;
        }
        UserMappingUploadStatus userMappingUploadStatus2 = userMappingUploadStatus;
        return userMappingUploadStatus2 == null ? new UserMappingUploadStatus(ProgressStatus.NOT_STARTED, null, null, null, null, null, 62, null) : userMappingUploadStatus2;
    }

    @PostConstruct
    public final void register() {
        this.udcUserMappingService.register();
    }

    @PreDestroy
    public final void unregister() {
        this.udcUserMappingService.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ClusterLock lock = this.clusterLockService.getLockForName(USER_MAPPING_LOCK);
        if (lock.tryLock()) {
            JobRunnerResponse jobRunnerResponse2;
            try {
                JobRunnerResponse jobRunnerResponse3;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                log.info("Processing user mapping CSV");
                long executionStart = System.currentTimeMillis();
                List originalFileRecords = this.udcUserMappingCsvZipService.getOriginalSourceFileRecords();
                UserMappingFilteringResult filteringResult = this.udcUserMappingCsvZipService.readAndFilterUploadedCsv(originalFileRecords);
                UserBaseScan userBaseScan = this.getLatestStartedUserBaseScan();
                Intrinsics.checkNotNull((Object)userBaseScan);
                String executionId = userBaseScan.getId();
                if (!((Collection)filteringResult.getRecordErrors()).isEmpty()) {
                    UserMappingService.safelyBuildAndSendAnalyticsEvent$default(this, executionId, filteringResult.getRecordResults().size(), executionStart, ErrorType.RECORD_VALIDATION_FAILED, null, 16, null);
                    ProgressStatus progressStatus = ProgressStatus.FAILED;
                    ErrorType errorType = ErrorType.RECORD_VALIDATION_FAILED;
                    List list = filteringResult.getRecordErrors();
                    this.updateValidationStatus(new UserMappingUploadStatus(progressStatus, null, null, list, errorType, null, 38, null));
                    JobRunnerResponse jobRunnerResponse4 = JobRunnerResponse.failed((String)"User mapping CSV contains errors");
                    Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse4, (String)"failed(...)");
                    progressStatus = jobRunnerResponse4;
                    return progressStatus;
                }
                if (!((Collection)filteringResult.getUnknownUsers()).isEmpty()) {
                    UserMappingService.safelyBuildAndSendAnalyticsEvent$default(this, executionId, filteringResult.getRecordResults().size(), executionStart, ErrorType.UNKNOWN_USERS, null, 16, null);
                    this.updateValidationStatus(new UserMappingUploadStatus(ProgressStatus.FAILED, null, null, null, ErrorType.UNKNOWN_USERS, filteringResult.getUnknownUsers(), 14, null));
                    JobRunnerResponse jobRunnerResponse5 = JobRunnerResponse.failed((String)"User mapping CSV contains unknown users");
                    Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse5, (String)"failed(...)");
                    JobRunnerResponse jobRunnerResponse6 = jobRunnerResponse5;
                    return jobRunnerResponse6;
                }
                String cloudId2 = String.valueOf(request.getJobConfig().getParameters().get("cloudId"));
                String loggedInUserUserKey = String.valueOf(request.getJobConfig().getParameters().get("userKey"));
                String fileName = String.valueOf(request.getJobConfig().getParameters().get("fileName"));
                UserMappingUploadStatus result2 = this.validateAndUpsertFilteredRecords(executionId, cloudId2, filteringResult.getRecordResults(), loggedInUserUserKey);
                Iterable iterable = filteringResult.getRecordResults();
                UserMappingService userMappingService = this;
                boolean $i$f$map = false;
                JobRunnerResponse jobRunnerResponse7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    UserMappingCsvRecordResult.UserMappingRecordResult userMappingRecordResult = (UserMappingCsvRecordResult.UserMappingRecordResult)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getUserMappingCsvData());
                }
                UserMappingStatistics statistics = userMappingService.saveUserMappingStatistics((List)destination$iv$iv, originalFileRecords);
                this.safelyBuildAndSendAnalyticsEvent(executionId, filteringResult.getRecordResults().size(), executionStart, result2.getErrorType(), statistics);
                this.updateValidationStatus(result2);
                ErrorType errorType = result2.getErrorType();
                switch (errorType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[errorType.ordinal()]) {
                    case 1: {
                        JobRunnerResponse jobRunnerResponse8 = JobRunnerResponse.failed((String)"User mapping CSV contains incorrect user keys");
                        jobRunnerResponse3 = jobRunnerResponse8;
                        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse8, (String)"failed(...)");
                        break;
                    }
                    case 2: {
                        JobRunnerResponse jobRunnerResponse9 = JobRunnerResponse.failed((String)"User mapping CSV contains unfixed users");
                        jobRunnerResponse3 = jobRunnerResponse9;
                        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse9, (String)"failed(...)");
                        break;
                    }
                    case 3: {
                        JobRunnerResponse jobRunnerResponse10 = JobRunnerResponse.failed((String)"User mapping CSV contains invalid users");
                        jobRunnerResponse3 = jobRunnerResponse10;
                        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse10, (String)"failed(...)");
                        break;
                    }
                    case 4: {
                        JobRunnerResponse jobRunnerResponse11 = JobRunnerResponse.failed((String)"User mapping CSV record insertion failed");
                        jobRunnerResponse3 = jobRunnerResponse11;
                        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse11, (String)"failed(...)");
                        break;
                    }
                    case 5: {
                        JobRunnerResponse jobRunnerResponse12 = JobRunnerResponse.failed((String)"User mapping CSV contains no changes");
                        jobRunnerResponse3 = jobRunnerResponse12;
                        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse12, (String)"failed(...)");
                        break;
                    }
                    default: {
                        this.globalEmailFixesConfigService.saveUserMappingConfigState(UDCConfigAction.SET_DRAFT);
                        GlobalEmailFixesConfigService.saveUserMappingFileName$default(this.globalEmailFixesConfigService, fileName, false, 2, null);
                        jobRunnerResponse7 = JobRunnerResponse.success((String)"User mapping CSV processed successfully");
                        Intrinsics.checkNotNull((Object)jobRunnerResponse7);
                        jobRunnerResponse3 = jobRunnerResponse7;
                    }
                }
                iterable = jobRunnerResponse3;
                return iterable;
            }
            catch (Exception e) {
                this.migrationEventBus.post(new UserMappingEventFailedUpload());
                this.updateValidationStatus(new UserMappingUploadStatus(ProgressStatus.FAILED, null, null, null, null, null, 62, null));
                log.error("Error while processing user mapping CSV", (Throwable)e);
                jobRunnerResponse2 = JobRunnerResponse.failed((Throwable)e);
            }
            finally {
                lock.unlock();
            }
            JobRunnerResponse jobRunnerResponse13 = jobRunnerResponse2;
            Intrinsics.checkNotNull((Object)jobRunnerResponse13);
            jobRunnerResponse = jobRunnerResponse13;
        } else {
            log.error("Could not acquire lock jcma.migration.user.mapping");
            JobRunnerResponse jobRunnerResponse14 = JobRunnerResponse.aborted((String)"could not acquire lock jcma.migration.user.mapping");
            Intrinsics.checkNotNull((Object)jobRunnerResponse14);
            jobRunnerResponse = jobRunnerResponse14;
        }
        return jobRunnerResponse;
    }

    private final void safelyBuildAndSendAnalyticsEvent(String executionId, int filteredRecordsCount, long executionStart, ErrorType errorType, UserMappingStatistics statistics) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                UserMappingService $this$safelyBuildAndSendAnalyticsEvent_u24lambda_u243 = object2;
                boolean bl = false;
                $this$safelyBuildAndSendAnalyticsEvent_u24lambda_u243.buildAndSendAnalyticsEvent(executionId, filteredRecordsCount, executionStart, errorType, statistics);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            log.warn("Failed to send user mapping analytics event", (Throwable)it);
        }
    }

    static /* synthetic */ void safelyBuildAndSendAnalyticsEvent$default(UserMappingService userMappingService, String string, int n, long l, ErrorType errorType, UserMappingStatistics userMappingStatistics, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            userMappingStatistics = null;
        }
        userMappingService.safelyBuildAndSendAnalyticsEvent(string, n, l, errorType, userMappingStatistics);
    }

    private final void buildAndSendAnalyticsEvent(String executionId, int filteredRecordsCount, long executionStart, ErrorType errorType, UserMappingStatistics statistics) {
        UserMappingEvent userMappingEvent;
        long executionTime = System.currentTimeMillis() - executionStart;
        if (errorType != null) {
            userMappingEvent = new UserMappingEventFailedValidation(executionTime, errorType);
        } else {
            long modifiedInvalidCount = this.incorrectEmailRepository.countByTypeAndExecutionId(executionId, EmailCheckType.INV);
            long modifiedDuplicateCount = this.incorrectEmailRepository.countByTypeAndExecutionId(executionId, EmailCheckType.DUP);
            long modifiedValidCount = (long)filteredRecordsCount - modifiedInvalidCount - modifiedDuplicateCount;
            int n = (int)modifiedInvalidCount;
            int n2 = (int)modifiedDuplicateCount;
            int n3 = (int)modifiedValidCount;
            UserMappingStatistics userMappingStatistics = statistics;
            Intrinsics.checkNotNull((Object)userMappingStatistics);
            userMappingEvent = new UserMappingEventFileUploadSuccess(n, n2, n3, userMappingStatistics.getAllUserCount(), executionTime, statistics.getMerge(), statistics.getUseNewEmail(), statistics.getTombstone());
        }
        UserMappingEvent userMappingEvent2 = userMappingEvent;
        this.migrationEventBus.post(userMappingEvent2);
    }

    static /* synthetic */ void buildAndSendAnalyticsEvent$default(UserMappingService userMappingService, String string, int n, long l, ErrorType errorType, UserMappingStatistics userMappingStatistics, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            userMappingStatistics = null;
        }
        userMappingService.buildAndSendAnalyticsEvent(string, n, l, errorType, userMappingStatistics);
    }

    @NotNull
    public final UserMappingStatistics getUserMappingStatistics() {
        return this.udcUserMappingService.getUserMappingStatistics();
    }

    @NotNull
    public final UserMappingStatistics saveUserMappingStatistics(@NotNull List<UserMappingCsvData> filteredUploadedRecords, @NotNull List<UserMappingCsvData> originalRecordsMap) {
        Intrinsics.checkNotNullParameter(filteredUploadedRecords, (String)"filteredUploadedRecords");
        Intrinsics.checkNotNullParameter(originalRecordsMap, (String)"originalRecordsMap");
        return this.udcUserMappingService.saveUserMappingStatistics(filteredUploadedRecords, originalRecordsMap);
    }

    private final UserMappingUploadStatus validateAndUpsertFilteredRecords(String executionId, String cloudId2, List<UserMappingCsvRecordResult.UserMappingRecordResult> records, String loggedInUserUserKey) {
        CloudSite cloudSite2;
        CloudSite cloudSite3 = cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        String containerToken = cloudSite3 != null ? cloudSite3.getContainerToken() : null;
        if (containerToken == null) {
            log.error("Invalid cloud site.");
            throw new UserMappingException(UserMappingException.Type.INVALID_CLOUD_SITE, null, 2, null);
        }
        if (!this.containerTokenTTLService.isValidToken(containerToken)) {
            log.error("Container token expired.");
            throw new UserMappingException(UserMappingException.Type.CONTAINER_TOKEN_EXPIRED, null, 2, null);
        }
        String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(cloudSite2);
        List<EmailData> unfixedEmails = this.verifyAllUsersAreFixed(executionId, records);
        if (!((Collection)unfixedEmails).isEmpty()) {
            return new UserMappingUploadStatus(ProgressStatus.FAILED, null, null, null, ErrorType.UNFIXED_USERS, unfixedEmails, 14, null);
        }
        if (records.isEmpty()) {
            return new UserMappingUploadStatus(ProgressStatus.FAILED, null, null, null, ErrorType.NO_CHANGES, CollectionsKt.emptyList(), 14, null);
        }
        Pair<List<EmailData>, List<JiraUser>> pair = this.verifyAllUsersExistInJira(records);
        List notExistingUsers = (List)pair.component1();
        List jiraUsers = (List)pair.component2();
        if (!((Collection)notExistingUsers).isEmpty()) {
            return new UserMappingUploadStatus(ProgressStatus.FAILED, null, null, null, ErrorType.INCORRECT_USER_KEYS, notExistingUsers, 14, null);
        }
        List<EmailData> invalidEmails = this.runUmsValidation(executionId, containerToken, migrationScopeId2, jiraUsers);
        if (!((Collection)invalidEmails).isEmpty()) {
            return new UserMappingUploadStatus(ProgressStatus.FAILED, null, null, null, ErrorType.INVALID_USERS, invalidEmails, 14, null);
        }
        return this.recordCorrectedEmailData(records, loggedInUserUserKey);
    }

    public final void scheduleCsvUploadJob(@NotNull String cloudId2, @NotNull InputStream stream, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.udcUserMappingService.scheduleCsvUploadJob(cloudId2, stream, name);
    }

    public final void buildSourceFileZip(@NotNull OutputStream outputStream, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        this.udcUserMappingService.buildSourceFileZip(outputStream, cloudId2);
    }

    @NotNull
    public final SourceFileAvailability sourceFileAvailability() {
        return this.udcUserMappingService.sourceFileAvailability();
    }

    public final void getAllUserMappings(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.udcUserMappingService.getAllUserMappings(outputStream);
    }

    public final void getValidationErrorsCsv(@NotNull ByteArrayOutputStream inMemoryOutputStream) {
        Intrinsics.checkNotNullParameter((Object)inMemoryOutputStream, (String)"inMemoryOutputStream");
        this.udcUserMappingService.getValidationErrorsCsv(inMemoryOutputStream);
    }

    private final UserMappingUploadStatus recordCorrectedEmailData(List<UserMappingCsvRecordResult.UserMappingRecordResult> userMappingRecordResults, String userKey) {
        UserMappingUploadStatus userMappingUploadStatus;
        this.correctedEmailRepository.deleteDraft(UDCMode.ADVANCED);
        BatchUpsertResultAggregator.FailFastAggregateResult<CorrectedEmail> aggregateResult2 = this.batchUpsertResultAggregator.aggregateFailFast(this.correctedEmailRepository.insert((Sequence<CorrectedEmail>)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)userMappingRecordResults), (Function1)recordCorrectedEmailData.aggregateResult.1.INSTANCE), userKey));
        BatchUpsertResult.Failed<CorrectedEmail> failed = aggregateResult2.getFailed();
        if (failed != null) {
            BatchUpsertResult.Failed<CorrectedEmail> it = failed;
            boolean bl = false;
            ProgressStatus progressStatus = ProgressStatus.FAILED;
            ErrorType errorType = ErrorType.RECORD_INSERT_FAILED;
            String string = it.getError().getLocalizedMessage() + ", Please check the server log";
            userMappingUploadStatus = new UserMappingUploadStatus(progressStatus, null, string, null, errorType, null, 42, null);
        } else {
            userMappingUploadStatus = new UserMappingUploadStatus(ProgressStatus.FINISHED, userMappingRecordResults.size(), null, null, null, null, 60, null);
        }
        return userMappingUploadStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<EmailData>, List<JiraUser>> verifyAllUsersExistInJira(List<UserMappingCsvRecordResult.UserMappingRecordResult> records) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = records;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void record;
            UserMappingCsvRecordResult.UserMappingRecordResult userMappingRecordResult = (UserMappingCsvRecordResult.UserMappingRecordResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(record.getUserMappingCsvData());
        }
        $this$map$iv = (List)destination$iv$iv;
        Pair initial$iv = new Pair((Object)new ArrayList(), (Object)new ArrayList());
        boolean $i$f$fold = false;
        Pair accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void userRecord;
            Pair pair;
            Object item$iv$iv;
            item$iv$iv = (UserMappingCsvData)element$iv;
            Pair acc = accumulator$iv;
            boolean bl = false;
            Pair $this$verifyAllUsersExistInJira_u24lambda_u248_u24lambda_u247 = pair = acc;
            boolean bl2 = false;
            ApplicationUser applicationUser = this.userManager.getUserByKey(userRecord.getUserKey());
            if (applicationUser == null) {
                ((List)acc.getFirst()).add(new EmailData(userRecord.getUserName(), userRecord.getOldEmail()));
            } else {
                ((List)acc.getSecond()).add(JiraUser.copy$default(JiraUser.Companion.fromApplicationUser(applicationUser), userRecord.getNewEmail(), null, false, null, null, null, null, null, null, 510, null));
            }
            accumulator$iv = pair;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EmailData> verifyAllUsersAreFixed(String executionId, List<UserMappingCsvRecordResult.UserMappingRecordResult> records) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = records;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserMappingCsvRecordResult.UserMappingRecordResult userMappingRecordResult = (UserMappingCsvRecordResult.UserMappingRecordResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUserMappingCsvData().getUserKey());
        }
        Set userKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMapIterable(SequenceExtensionKt.takeWhileInclusive(this.incorrectEmailRepository.read(executionId, 1000, (Function1<? super String, IncorrectEmail>)((Function1)new Function1<String, IncorrectEmail>((Object)this.objectMapper){

            @NotNull
            public final IncorrectEmail invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ObjectMapper $this$readValue$iv = (ObjectMapper)this.receiver;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                return (IncorrectEmail)$this$readValue$iv.readValue(p0, (TypeReference)new TypeReference<IncorrectEmail>(){});
            }
        })), verifyAllUsersAreFixed.2.INSTANCE), (Function1)verifyAllUsersAreFixed.3.INSTANCE), (Function1)((Function1)new Function1<IncorrectEmail, Boolean>((Set<String>)userKeys){
            final /* synthetic */ Set<String> $userKeys;
            {
                this.$userKeys = $userKeys;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IncorrectEmail it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$userKeys.contains(it.getUserKeyValue());
            }
        })), (Function1)verifyAllUsersAreFixed.5.INSTANCE));
    }

    private final List<EmailData> runUmsValidation(String executionId, String containerToken, String migrationScopeId2, List<JiraUser> jiraUsers) {
        CheckResult checkResult = this.invalidEmailService.validate(executionId, containerToken, migrationScopeId2, jiraUsers);
        Map map = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        return EmailValidityCheckerUtil.INSTANCE.getInvalidEmails(map);
    }

    private final Object updateValidationStatus(UserMappingUploadStatus status) {
        return this.pluginSettingsFactory.createGlobalSettings().put(USER_MAPPING_JOB_ID, (Object)this.objectMapper.writeValueAsString((Object)status));
    }

    private final UserBaseScan getLatestStartedUserBaseScan() {
        return this.migrationFeatures.getUseUDCLibraryForUserBaseScan() ? this.udcScanDelegate.findLatestOrGivenScanWitStatusRefreshed(null) : this.userBaseScanService.getLatestStarted();
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)Companion.toString());
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/usermapping/UserMappingService$Companion;", "", "()V", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "USER_MAPPING_JOB_ID", "", "USER_MAPPING_LOCK", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ErrorType.values().length];
            try {
                nArray[ErrorType.INCORRECT_USER_KEYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.UNFIXED_USERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.INVALID_USERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.RECORD_INSERT_FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.NO_CHANGES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

