/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.usermapping.context;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.MigrationScopeContext;
import com.atlassian.jira.migration.usermapping.context.MigrationScopeManagerProvider;
import com.atlassian.migration.udc.auth.ContainerTokenProvider;
import com.atlassian.migration.udc.common.model.context.Context;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/usermapping/context/CloudContextProvider;", "Lcom/atlassian/migration/udc/context/CloudContextProvider;", "containerTokenProvider", "Lcom/atlassian/migration/udc/auth/ContainerTokenProvider;", "migrationScopeProvider", "Lcom/atlassian/jira/migration/usermapping/context/MigrationScopeManagerProvider;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "(Lcom/atlassian/migration/udc/auth/ContainerTokenProvider;Lcom/atlassian/jira/migration/usermapping/context/MigrationScopeManagerProvider;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;)V", "getCloudContext", "Lcom/atlassian/migration/udc/common/model/context/Context$CloudContext;", "context", "Lcom/atlassian/migration/udc/common/model/context/Context;", "cloudId", "", "getCloudIdContext", "Lcom/atlassian/migration/udc/common/model/context/Context$CloudIdContext;", "getMigrationScopeContext", "Lcom/atlassian/jira/migration/common/MigrationScopeContext;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudContextProvider.kt\ncom/atlassian/jira/migration/usermapping/context/CloudContextProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class CloudContextProvider
extends com.atlassian.migration.udc.context.CloudContextProvider {
    @NotNull
    private final ContainerTokenProvider containerTokenProvider;
    @NotNull
    private final MigrationScopeManagerProvider migrationScopeProvider;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;

    @Inject
    public CloudContextProvider(@NotNull ContainerTokenProvider containerTokenProvider, @NotNull MigrationScopeManagerProvider migrationScopeProvider, @NotNull CloudSiteRepository cloudSiteRepository) {
        Intrinsics.checkNotNullParameter((Object)containerTokenProvider, (String)"containerTokenProvider");
        Intrinsics.checkNotNullParameter((Object)migrationScopeProvider, (String)"migrationScopeProvider");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        this.containerTokenProvider = containerTokenProvider;
        this.migrationScopeProvider = migrationScopeProvider;
        this.cloudSiteRepository = cloudSiteRepository;
    }

    @NotNull
    public Context.CloudContext getCloudContext(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        String containerToken = this.containerTokenProvider.getContainerToken(cloudId2);
        String migrationScopeId2 = this.migrationScopeProvider.getMigrationScopeId(cloudId2);
        return new Context.CloudContext(containerToken, migrationScopeId2);
    }

    @NotNull
    public final Context.CloudIdContext getCloudIdContext(@NotNull Context context) {
        Context.CloudIdContext cloudIdContext;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context;
        if (context2 instanceof Context.CloudIdContext) {
            cloudIdContext = (Context.CloudIdContext)context;
        } else if (context2 instanceof Context.CloudContext) {
            if (((Context.CloudContext)context).getContainerToken() == null) {
                boolean bl = false;
                String string = "Cloud context does not have container token";
                throw new IllegalArgumentException(string.toString());
            }
            CloudSite cloudSite2 = this.cloudSiteRepository.getSiteByContainerToken(((Context.CloudContext)context).getContainerToken());
            if (cloudSite2 == null) {
                throw new IllegalArgumentException("CloudSite not found for container token: " + ((Context.CloudContext)context).getContainerToken());
            }
            CloudSite cloudSite3 = cloudSite2;
            cloudIdContext = new Context.CloudIdContext(cloudSite3.getCloudId());
        } else {
            throw new IllegalArgumentException("Unsupported context type: " + context.getClass().getName());
        }
        return cloudIdContext;
    }

    private final Context.CloudContext getCloudContext(Context context) {
        Context.CloudContext cloudContext;
        Context context2 = context;
        if (context2 instanceof Context.CloudContext) {
            cloudContext = (Context.CloudContext)context;
        } else if (context2 instanceof Context.CloudIdContext) {
            cloudContext = this.getCloudContext(((Context.CloudIdContext)context).getCloudId());
        } else {
            throw new IllegalArgumentException("Unsupported context type: " + context.getClass().getName());
        }
        return cloudContext;
    }

    @NotNull
    public final MigrationScopeContext getMigrationScopeContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context.CloudContext resolvedContext = this.getCloudContext(context);
        return new MigrationScopeContext(resolvedContext.getContainerToken(), resolvedContext.getMigrationScopeId());
    }
}

