/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.usermapping.context;

import com.atlassian.jira.migration.utils.UDCConverterKt;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.udc.common.model.user.User;
import com.atlassian.migration.udc.common.model.user.UserWithId;
import com.atlassian.migration.udc.context.UserManager;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/usermapping/context/UserManagerProvider;", "Lcom/atlassian/migration/udc/context/UserManager;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "(Lcom/atlassian/jira/user/util/UserManager;)V", "getUserByKey", "Lcom/atlassian/migration/udc/common/model/user/User;", "key", "", "getUserId", "userKey", "getUserWithIdByKey", "Lcom/atlassian/migration/udc/common/model/user/UserWithId;", "jira-migration-plugin"})
public final class UserManagerProvider
implements UserManager {
    @NotNull
    private final com.atlassian.jira.user.util.UserManager userManager;

    @Inject
    public UserManagerProvider(@NotNull com.atlassian.jira.user.util.UserManager userManager) {
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        this.userManager = userManager;
    }

    @Nullable
    public User getUserByKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ApplicationUser applicationUser = this.userManager.getUserByKey(key);
        return applicationUser != null ? UDCConverterKt.toUDC(applicationUser) : null;
    }

    @NotNull
    public String getUserId(@NotNull String userKey) {
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        Object object = this.userManager.getUserByKey(userKey);
        if (object == null || (object = object.getId()) == null || (object = String.valueOf(object)) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public UserWithId getUserWithIdByKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String userId = this.getUserId(key);
        ApplicationUser applicationUser = this.userManager.getUserByKey(key);
        return applicationUser != null ? UDCConverterKt.toUDCWithId(applicationUser, userId) : null;
    }
}

