/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.usermapping.rest;

import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.usermapping.UserMappingService;
import com.atlassian.jira.migration.usermapping.model.ErrorType;
import com.atlassian.jira.migration.usermapping.model.ProgressStatus;
import com.atlassian.jira.migration.usermapping.model.UserMappingUploadStatusDTO;
import com.atlassian.jira.migration.usermapping.rest.ErrorEntity;
import com.atlassian.jira.migration.usermapping.rest.SaveUserMappingConfig;
import com.atlassian.jira.migration.usermapping.rest.UserMappingStatisticsDTO;
import com.atlassian.jira.migration.utils.CsvUtil;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCConfigAction;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingException;
import com.atlassian.migration.udc.config.ConfigUpdateResult;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="user-mapping")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0001H\u0002J\b\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0015\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\nH\u0007J\b\u0010\u0017\u001a\u00020\bH\u0007J\b\u0010\u0018\u001a\u00020\bH\u0007J\b\u0010\u0019\u001a\u00020\bH\u0007J\b\u0010\u001a\u001a\u00020\bH\u0007J\b\u0010\u001b\u001a\u00020\bH\u0007J\b\u0010\u001c\u001a\u00020\bH\u0007J\u0016\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001fH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020!H\u0007J$\u0010\"\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\n2\b\b\u0001\u0010\u000e\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/atlassian/jira/migration/usermapping/rest/UserMappingResource;", "", "userMappingService", "Lcom/atlassian/jira/migration/usermapping/UserMappingService;", "globalEmailFixesConfigService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "(Lcom/atlassian/jira/migration/usermapping/UserMappingService;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;)V", "buildBadRequestResponse", "Ljavax/ws/rs/core/Response;", "message", "", "buildCsvResponse", "inMemoryOutputStream", "Ljava/io/ByteArrayOutputStream;", "fileName", "buildExceptionResponse", "type", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UserMappingException$Type;", "errorEntity", "buildUploadStatusResponse", "buildZipResponse", "downloadZip", "cloudId", "getAllUserMappingsCsv", "getDownloadSourceFileStatus", "getInvalidEmails", "getUploadStatus", "getUserMappingConfig", "getUserMappingStatistics", "handleRequest", "action", "Lkotlin/Function0;", "saveUserMappingConfig", "Lcom/atlassian/jira/migration/usermapping/rest/SaveUserMappingConfig;", "uploadCsv", "file", "Ljava/io/InputStream;", "jira-migration-plugin"})
public final class UserMappingResource {
    @NotNull
    private final UserMappingService userMappingService;
    @NotNull
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;

    @Inject
    public UserMappingResource(@NotNull UserMappingService userMappingService, @NotNull GlobalEmailFixesConfigService globalEmailFixesConfigService) {
        Intrinsics.checkNotNullParameter((Object)userMappingService, (String)"userMappingService");
        Intrinsics.checkNotNullParameter((Object)globalEmailFixesConfigService, (String)"globalEmailFixesConfigService");
        this.userMappingService = userMappingService;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
    }

    @GET
    @Path(value="/mappings")
    @NotNull
    public final Response getAllUserMappingsCsv() {
        ByteArrayOutputStream inMemoryOutputStream = new ByteArrayOutputStream();
        return this.handleRequest((Function0<? extends Response>)((Function0)new Function0<Response>(this, inMemoryOutputStream){
            final /* synthetic */ UserMappingResource this$0;
            final /* synthetic */ ByteArrayOutputStream $inMemoryOutputStream;
            {
                this.this$0 = $receiver;
                this.$inMemoryOutputStream = $inMemoryOutputStream;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                UserMappingResource.access$getUserMappingService$p(this.this$0).getAllUserMappings(this.$inMemoryOutputStream);
                return UserMappingResource.access$buildCsvResponse(this.this$0, this.$inMemoryOutputStream, "user-mapping.csv");
            }
        }));
    }

    @GET
    @Path(value="/statistics")
    @NotNull
    public final Response getUserMappingStatistics() {
        return this.handleRequest((Function0<? extends Response>)((Function0)new Function0<Response>(this){
            final /* synthetic */ UserMappingResource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                Response response2 = Response.ok((Object)UserMappingStatisticsDTO.Companion.from(UserMappingResource.access$getUserMappingService$p(this.this$0).getUserMappingStatistics())).build();
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
                return response2;
            }
        }));
    }

    @PUT
    @Path(value="/config")
    @NotNull
    public final Response saveUserMappingConfig(@NotNull SaveUserMappingConfig action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.handleRequest((Function0<? extends Response>)((Function0)new Function0<Response>(action, this){
            final /* synthetic */ SaveUserMappingConfig $action;
            final /* synthetic */ UserMappingResource this$0;
            {
                this.$action = $action;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Response invoke() {
                Response response2;
                UDCConfigAction uDCConfigAction;
                try {
                    String string;
                    block13: {
                        block12: {
                            string = this.$action.getAction();
                            if (string == null) break block12;
                            String string2 = string.toUpperCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                            string = string2;
                            if (string2 != null) break block13;
                        }
                        string = "unknown";
                    }
                    uDCConfigAction = UDCConfigAction.valueOf((String)string);
                }
                catch (IllegalArgumentException expectedException) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    UDCConfigAction[] uDCConfigActionArray = UDCConfigAction.values();
                    StringBuilder stringBuilder = new StringBuilder().append(this.$action).append(" argument provided for action parameter is invalid.\nList of allowed parameters: ");
                    UserMappingResource userMappingResource = this.this$0;
                    boolean $i$f$map = false;
                    void var6_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        UDCConfigAction uDCConfigAction2 = (UDCConfigAction)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.name());
                    }
                    collection = (List)destination$iv$iv;
                    return UserMappingResource.access$buildBadRequestResponse(userMappingResource, stringBuilder.append(collection).toString());
                }
                UDCConfigAction resolvedAction = uDCConfigAction;
                ConfigUpdateResult result2 = UserMappingResource.access$getGlobalEmailFixesConfigService$p(this.this$0).saveUserMappingConfigState(resolvedAction);
                if (Intrinsics.areEqual((Object)result2, (Object)ConfigUpdateResult.Success.INSTANCE)) {
                    Response response3 = Response.ok((Object)"User mapping config action executed").build();
                    response2 = response3;
                    Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
                } else if (Intrinsics.areEqual((Object)result2, (Object)ConfigUpdateResult.MigrationIsRunningError.INSTANCE)) {
                    Response response4 = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Can't update config when a migration is running").build();
                    response2 = response4;
                    Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"build(...)");
                } else if (result2 instanceof ConfigUpdateResult.ValidationError) {
                    Response response5 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)((ConfigUpdateResult.ValidationError)result2).getErrorMessage()).build();
                    response2 = response5;
                    Intrinsics.checkNotNullExpressionValue((Object)response5, (String)"build(...)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return response2;
            }
        }));
    }

    @GET
    @Path(value="/config")
    @NotNull
    public final Response getUserMappingConfig() {
        return this.handleRequest((Function0<? extends Response>)((Function0)new Function0<Response>(this){
            final /* synthetic */ UserMappingResource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                Response response2 = Response.ok((Object)UserMappingResource.access$getGlobalEmailFixesConfigService$p(this.this$0).getUserMappingConfig()).build();
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
                return response2;
            }
        }));
    }

    @POST
    @Path(value="/upload/{cloudId}")
    @Consumes(value={"application/octet-stream"})
    @NotNull
    public final Response uploadCsv(@PathParam(value="cloudId") @NotNull String cloudId2, @QueryParam(value="fileName") @NotNull String fileName, @NotNull InputStream file2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.handleRequest((Function0<? extends Response>)((Function0)new Function0<Response>(fileName, this, cloudId2, file2){
            final /* synthetic */ String $fileName;
            final /* synthetic */ UserMappingResource this$0;
            final /* synthetic */ String $cloudId;
            final /* synthetic */ InputStream $file;
            {
                this.$fileName = $fileName;
                this.this$0 = $receiver;
                this.$cloudId = $cloudId;
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                if (!CsvUtil.INSTANCE.isFileCsv(this.$fileName)) {
                    return UserMappingResource.buildExceptionResponse$default(this.this$0, UserMappingException.Type.INVALID_FILE_TYPE, null, 2, null);
                }
                try {
                    UserMappingResource.access$getUserMappingService$p(this.this$0).scheduleCsvUploadJob(this.$cloudId, this.$file, this.$fileName);
                }
                catch (UserMappingException e) {
                    return UserMappingResource.buildExceptionResponse$default(this.this$0, e.getType(), null, 2, null);
                }
                Response response2 = Response.ok().build();
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
                return response2;
            }
        }));
    }

    @GET
    @Path(value="/upload/summary")
    @NotNull
    public final Response getUploadStatus() {
        return this.handleRequest((Function0<? extends Response>)((Function0)new Function0<Response>(this){
            final /* synthetic */ UserMappingResource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                return UserMappingResource.access$buildUploadStatusResponse(this.this$0);
            }
        }));
    }

    @GET
    @Path(value="upload/summary/invalid-emails")
    @NotNull
    public final Response getInvalidEmails() {
        ByteArrayOutputStream inMemoryOutputStream = new ByteArrayOutputStream();
        return this.handleRequest((Function0<? extends Response>)((Function0)new Function0<Response>(this, inMemoryOutputStream){
            final /* synthetic */ UserMappingResource this$0;
            final /* synthetic */ ByteArrayOutputStream $inMemoryOutputStream;
            {
                this.this$0 = $receiver;
                this.$inMemoryOutputStream = $inMemoryOutputStream;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                UserMappingResource.access$getUserMappingService$p(this.this$0).getValidationErrorsCsv(this.$inMemoryOutputStream);
                return UserMappingResource.access$buildCsvResponse(this.this$0, this.$inMemoryOutputStream, "user-mapping-validation-errors.csv");
            }
        }));
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/download/{cloudId}")
    @NotNull
    public final Response downloadZip(@PathParam(value="cloudId") @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        return this.handleRequest((Function0<? extends Response>)((Function0)new Function0<Response>(this, cloudId2){
            final /* synthetic */ UserMappingResource this$0;
            final /* synthetic */ String $cloudId;
            {
                this.this$0 = $receiver;
                this.$cloudId = $cloudId;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                ByteArrayOutputStream inMemoryOutputStream = new ByteArrayOutputStream();
                try {
                    UserMappingResource.access$getUserMappingService$p(this.this$0).buildSourceFileZip(inMemoryOutputStream, this.$cloudId);
                }
                catch (UserMappingException e) {
                    return UserMappingResource.buildExceptionResponse$default(this.this$0, e.getType(), null, 2, null);
                }
                return UserMappingResource.access$buildZipResponse(this.this$0, inMemoryOutputStream);
            }
        }));
    }

    @GET
    @Path(value="/download/availability")
    @NotNull
    public final Response getDownloadSourceFileStatus() {
        return this.handleRequest((Function0<? extends Response>)((Function0)new Function0<Response>(this){
            final /* synthetic */ UserMappingResource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                Response response2 = Response.ok((Object)UserMappingResource.access$getUserMappingService$p(this.this$0).sourceFileAvailability()).build();
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
                return response2;
            }
        }));
    }

    private final Response handleRequest(Function0<? extends Response> action) {
        return (Response)action.invoke();
    }

    private final Response buildUploadStatusResponse() {
        UserMappingException.Type type;
        ErrorType errorType;
        ProgressStatus progressStatus = this.userMappingService.getUserMappingUploadStatus().getProgressStatus();
        if (progressStatus != ProgressStatus.FAILED) {
            Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)new UserMappingUploadStatusDTO(progressStatus, null, 2, null)).build();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
            return response2;
        }
        ErrorType errorType2 = errorType = this.userMappingService.getUserMappingUploadStatus().getErrorType();
        switch (errorType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[errorType2.ordinal()]) {
            case 1: {
                type = UserMappingException.Type.CSV_RECORD_VALIDATION_FAILED;
                break;
            }
            case 2: {
                type = UserMappingException.Type.INVALID_USERS_FOUND;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                type = UserMappingException.Type.MISMATCHED_USERS;
                break;
            }
            case 6: {
                type = UserMappingException.Type.CSV_NO_CHANGES;
                break;
            }
            case -1: 
            case 7: {
                type = UserMappingException.Type.CSV_UPLOAD_FAILED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        UserMappingException.Type exceptionType = type;
        return this.buildExceptionResponse(exceptionType, new UserMappingUploadStatusDTO(progressStatus, exceptionType.name()));
    }

    private final Response buildExceptionResponse(UserMappingException.Type type, Object errorEntity) {
        Response.Status status;
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                status = Response.Status.OK;
                break;
            }
            default: {
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        Response.Status status2 = status;
        Response response2 = Response.status((Response.Status)status2).entity(errorEntity).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    static /* synthetic */ Response buildExceptionResponse$default(UserMappingResource userMappingResource, UserMappingException.Type type, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = new ErrorEntity(type.name());
        }
        return userMappingResource.buildExceptionResponse(type, object);
    }

    private final Response buildBadRequestResponse(String message) {
        Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    private final Response buildZipResponse(ByteArrayOutputStream inMemoryOutputStream) {
        Response response2 = Response.ok(arg_0 -> UserMappingResource.buildZipResponse$lambda$0(inMemoryOutputStream, arg_0)).type("application/zip").header("Content-disposition", (Object)"attachment; filename=user-mapping.zip").build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    private final Response buildCsvResponse(ByteArrayOutputStream inMemoryOutputStream, String fileName) {
        Response response2 = Response.ok(arg_0 -> UserMappingResource.buildCsvResponse$lambda$1(inMemoryOutputStream, arg_0)).type("text/csv").header("Content-disposition", (Object)("attachment; filename=" + fileName)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    private static final void buildZipResponse$lambda$0(ByteArrayOutputStream $inMemoryOutputStream, OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)$inMemoryOutputStream, (String)"$inMemoryOutputStream");
        $inMemoryOutputStream.writeTo(output);
    }

    private static final void buildCsvResponse$lambda$1(ByteArrayOutputStream $inMemoryOutputStream, OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)$inMemoryOutputStream, (String)"$inMemoryOutputStream");
        $inMemoryOutputStream.writeTo(output);
    }

    public static final /* synthetic */ UserMappingService access$getUserMappingService$p(UserMappingResource $this) {
        return $this.userMappingService;
    }

    public static final /* synthetic */ Response access$buildCsvResponse(UserMappingResource $this, ByteArrayOutputStream inMemoryOutputStream, String fileName) {
        return $this.buildCsvResponse(inMemoryOutputStream, fileName);
    }

    public static final /* synthetic */ Response access$buildBadRequestResponse(UserMappingResource $this, String message) {
        return $this.buildBadRequestResponse(message);
    }

    public static final /* synthetic */ GlobalEmailFixesConfigService access$getGlobalEmailFixesConfigService$p(UserMappingResource $this) {
        return $this.globalEmailFixesConfigService;
    }

    public static final /* synthetic */ Response access$buildUploadStatusResponse(UserMappingResource $this) {
        return $this.buildUploadStatusResponse();
    }

    public static final /* synthetic */ Response access$buildZipResponse(UserMappingResource $this, ByteArrayOutputStream inMemoryOutputStream) {
        return $this.buildZipResponse(inMemoryOutputStream);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ErrorType.values().length];
            try {
                nArray[ErrorType.RECORD_VALIDATION_FAILED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.INVALID_USERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.UNKNOWN_USERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.UNFIXED_USERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.INCORRECT_USER_KEYS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.NO_CHANGES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.RECORD_INSERT_FAILED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UserMappingException.Type.values().length];
            try {
                nArray[UserMappingException.Type.USER_BASE_SCAN_NOT_FINISHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserMappingException.Type.FILE_DOES_NOT_EXIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserMappingException.Type.USER_MAPPING_UPLOAD_ALREADY_IN_PROGRESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserMappingException.Type.FILE_DOES_NOT_EXIST_RERUNNING_USERBASE_SCAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserMappingException.Type.INVALID_FILE_TYPE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserMappingException.Type.CSV_RECORD_VALIDATION_FAILED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserMappingException.Type.INVALID_USERS_FOUND.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserMappingException.Type.MISMATCHED_USERS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserMappingException.Type.CSV_NO_CHANGES.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

