/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.usersmigrationservice;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.usersmigrationservice.CheckStatusResponse;
import com.atlassian.jira.migration.usersmigrationservice.CreateTombstoneAccountRequest;
import com.atlassian.jira.migration.usersmigrationservice.GroupsConflictCheckResponse;
import com.atlassian.jira.migration.usersmigrationservice.InitiateCheckRequest;
import com.atlassian.jira.migration.usersmigrationservice.InitiateCheckResponse;
import com.atlassian.jira.migration.usersmigrationservice.PublishTombstoneMappingRequest;
import com.atlassian.jira.migration.usersmigrationservice.StartGroupConflictsCheckRequest;
import com.atlassian.jira.migration.usersmigrationservice.StartGroupConflictsCheckResponse;
import com.atlassian.jira.migration.usersmigrationservice.TombstoneAccountsResponse;
import com.atlassian.jira.migration.usersmigrationservice.TombstoneUser;
import com.atlassian.jira.migration.utils.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 42\u00020\u0001:\u000245B/\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB'\b\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ6\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0$J\u0016\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J&\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-J$\u0010.\u001a\u00020/2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0011J\u001c\u00101\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001603R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "httpOk200", "", "", "createTombstoneAccounts", "Lcom/atlassian/jira/migration/usersmigrationservice/TombstoneAccountsResponse;", "containerToken", "", "createTombstoneAccountRequest", "Lcom/atlassian/jira/migration/usersmigrationservice/CreateTombstoneAccountRequest;", "numberOfAccountsRequired", "filterInvalidTombstoneUsers", "", "tombstoneUser", "Lcom/atlassian/jira/migration/usersmigrationservice/TombstoneUser;", "getCheckStatus", "Lcom/atlassian/jira/migration/usersmigrationservice/CheckStatusResponse;", "path", "migrationScopeId", "taskId", "responseClass", "Ljava/lang/Class;", "getGroupsConflictResponse", "Lcom/atlassian/jira/migration/usersmigrationservice/GroupsConflictCheckResponse;", "getUsersMigrationServiceBaseURI", "Ljava/net/URI;", "getUsersMigrationServiceEGBaseURI", "initiateCheck", "Lcom/atlassian/jira/migration/usersmigrationservice/InitiateCheckResponse;", "requestBody", "Lcom/atlassian/jira/migration/usersmigrationservice/InitiateCheckRequest;", "publishTombstoneUsers", "", "tombstones", "startGroupConflictsCheck", "groups", "", "Companion", "Routes", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUsersMigrationServiceClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsersMigrationServiceClient.kt\ncom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n51#2:201\n819#3:202\n847#3,2:203\n*S KotlinDebug\n*F\n+ 1 UsersMigrationServiceClient.kt\ncom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient\n*L\n77#1:201\n116#1:202\n116#1:203,2\n*E\n"})
public final class UsersMigrationServiceClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationPluginHttpClient httpClient;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Set<Integer> httpOk200;
    private static final Logger log = LoggerFactory.getLogger(UsersMigrationServiceClient.class);
    @NotNull
    public static final String SEN_HEADER_KEY = "X-ASEN";
    public static final int TOMBSTONE_API_LIMIT = 200;

    @VisibleForTesting
    public UsersMigrationServiceClient(@NotNull MigrationPluginHttpClient httpClient, @NotNull SENSupplier senSupplier, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.httpClient = httpClient;
        this.senSupplier = senSupplier;
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.migrationFeatures = migrationFeatures;
        this.httpOk200 = SetsKt.setOf((Object)200);
        log.info("users migration service base url : " + this.getUsersMigrationServiceBaseURI());
    }

    @Inject
    public UsersMigrationServiceClient(@NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull SENSupplier senSupplier, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this(new MigrationPluginHttpClient(userAgentProvider, objectMapperFactory.createObjectMapperHandlingUnknownFields()), senSupplier, migrationServicesConfiguration, migrationFeatures);
    }

    private final URI getUsersMigrationServiceBaseURI() {
        URI baseURI = this.migrationServicesConfiguration.getUsersMigrationServiceBaseURI();
        URI uRI = baseURI.resolve("/migration/");
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resolve(...)");
        return uRI;
    }

    private final URI getUsersMigrationServiceEGBaseURI() {
        URI baseURI = this.migrationServicesConfiguration.getUsersMigrationServiceBaseURI();
        URI uRI = baseURI.resolve("/migrations/v1/");
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resolve(...)");
        return uRI;
    }

    @NotNull
    public final TombstoneAccountsResponse createTombstoneAccounts(@NotNull String containerToken, @NotNull CreateTombstoneAccountRequest createTombstoneAccountRequest, int numberOfAccountsRequired) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)createTombstoneAccountRequest, (String)"createTombstoneAccountRequest");
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        String sen = string;
        CreateTombstoneAccountRequest createTombstoneAccountRequest2 = CreateTombstoneAccountRequest.copy$default(createTombstoneAccountRequest, null, sen, 1, null);
        Object object = new String[]{String.valueOf(numberOfAccountsRequired)};
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getUsersMigrationServiceBaseURI(), "users/tombstones/{count}", object, null, 8, null);
        object = this.httpOk200;
        boolean $i$f$jacksonTypeRef = false;
        return (TombstoneAccountsResponse)this.httpClient.execute(new MigrationPluginHttpRequest("POST", uRI, (Set)object, createTombstoneAccountRequest2, null, null, 48, null).addHeader(SEN_HEADER_KEY, sen).contentTypeJson().acceptsJson().authorization("Bearer " + containerToken), (TypeReference)new TypeReference<TombstoneAccountsResponse>(){});
    }

    @NotNull
    public final String startGroupConflictsCheck(@NotNull String containerToken, @NotNull List<String> groups2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        StartGroupConflictsCheckRequest requestBody = new StartGroupConflictsCheckRequest(groups2);
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getUsersMigrationServiceBaseURI(), "users/groupsconflict/jira", new String[0], null, 8, null);
        Set<Integer> set = this.httpOk200;
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("POST", uRI, set, requestBody, null, null, 48, null);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        StartGroupConflictsCheckResponse response2 = this.httpClient.execute(migrationPluginHttpRequest.addHeader(SEN_HEADER_KEY, string).contentTypeJson().acceptsJson().authorization("Bearer " + containerToken), StartGroupConflictsCheckResponse.class);
        return response2.getTaskId();
    }

    @NotNull
    public final GroupsConflictCheckResponse getGroupsConflictResponse(@NotNull String containerToken, @NotNull String taskId2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
        String[] stringArray = new String[]{taskId2};
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(this.getUsersMigrationServiceBaseURI(), "users/groupsconflict/jira/{taskId}", stringArray, null, 8, null), this.httpOk200, null, null, null, 56, null);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        return this.httpClient.execute(migrationPluginHttpRequest.addHeader(SEN_HEADER_KEY, string).acceptsJson().authorization("Bearer " + containerToken), GroupsConflictCheckResponse.class);
    }

    /*
     * WARNING - void declaration
     */
    public final void publishTombstoneUsers(@NotNull String migrationScopeId2, @NotNull String containerToken, @NotNull Set<TombstoneUser> tombstones) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(tombstones, (String)"tombstones");
        Iterable $this$filterNot$iv = tombstones;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            TombstoneUser it = (TombstoneUser)element$iv$iv;
            boolean bl = false;
            if (this.filterInvalidTombstoneUsers(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)200, (Function1)((Function1)new Function1<List<? extends TombstoneUser>, Unit>(this, migrationScopeId2, containerToken){
            final /* synthetic */ UsersMigrationServiceClient this$0;
            final /* synthetic */ String $migrationScopeId;
            final /* synthetic */ String $containerToken;
            {
                this.this$0 = $receiver;
                this.$migrationScopeId = $migrationScopeId;
                this.$containerToken = $containerToken;
                super(1);
            }

            public final void invoke(@NotNull List<TombstoneUser> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                MigrationPluginHttpClient migrationPluginHttpClient = UsersMigrationServiceClient.access$getHttpClient$p(this.this$0);
                PublishTombstoneMappingRequest publishTombstoneMappingRequest = new PublishTombstoneMappingRequest(this.$migrationScopeId, CollectionsKt.toSet((Iterable)it));
                URI uRI = AbstractPluginHttpClientKt.buildURI$default(UsersMigrationServiceClient.access$getUsersMigrationServiceBaseURI(this.this$0), "users/tombstones/publish/jira", new String[0], null, 8, null);
                Set set = SetsKt.setOf((Object)204);
                MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("PUT", uRI, set, publishTombstoneMappingRequest, null, null, 48, null);
                String string = UsersMigrationServiceClient.access$getSenSupplier$p(this.this$0).getFirstSen();
                if (string == null) {
                    string = "";
                }
                migrationPluginHttpClient.execute(migrationPluginHttpRequest.addHeader("X-ASEN", string).contentTypeJson().acceptsJson().authorization("Bearer " + this.$containerToken));
            }
        }));
    }

    public final boolean filterInvalidTombstoneUsers(@NotNull TombstoneUser tombstoneUser) {
        Intrinsics.checkNotNullParameter((Object)tombstoneUser, (String)"tombstoneUser");
        return !this.migrationFeatures.getDisableInvalidTombstoneUsersFix() && StringUtils.INSTANCE.isBlankJavaImplementation(tombstoneUser.getUserKey());
    }

    @NotNull
    public final InitiateCheckResponse initiateCheck(@NotNull String containerToken, @NotNull String path, @NotNull String migrationScopeId2, @NotNull InitiateCheckRequest requestBody) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Object object = new String[]{migrationScopeId2};
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getUsersMigrationServiceEGBaseURI(), path, object, null, 8, null);
        object = this.httpOk200;
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("POST", uRI, (Set)object, requestBody, null, null, 48, null);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        return this.httpClient.execute(migrationPluginHttpRequest.addHeader(SEN_HEADER_KEY, string).contentTypeJson().acceptsJson().authorization("Bearer " + containerToken), InitiateCheckResponse.class);
    }

    @NotNull
    public final CheckStatusResponse getCheckStatus(@NotNull String containerToken, @NotNull String path, @NotNull String migrationScopeId2, @NotNull String taskId2, @NotNull Class<? extends CheckStatusResponse> responseClass) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        String[] stringArray = new String[]{migrationScopeId2, taskId2};
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(this.getUsersMigrationServiceEGBaseURI(), path, stringArray, null, 8, null), this.httpOk200, null, null, null, 56, null);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        return this.httpClient.execute(migrationPluginHttpRequest.addHeader(SEN_HEADER_KEY, string).contentTypeJson().acceptsJson().authorization("Bearer " + containerToken), responseClass);
    }

    public static final /* synthetic */ MigrationPluginHttpClient access$getHttpClient$p(UsersMigrationServiceClient $this) {
        return $this.httpClient;
    }

    public static final /* synthetic */ URI access$getUsersMigrationServiceBaseURI(UsersMigrationServiceClient $this) {
        return $this.getUsersMigrationServiceBaseURI();
    }

    public static final /* synthetic */ SENSupplier access$getSenSupplier$p(UsersMigrationServiceClient $this) {
        return $this.senSupplier;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient$Companion;", "", "()V", "SEN_HEADER_KEY", "", "getSEN_HEADER_KEY$annotations", "TOMBSTONE_API_LIMIT", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSEN_HEADER_KEY$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient$Routes;", "", "()V", "EMAIL_CHECK_STATUS", "", "GROUP_CONFLICT_CHECK", "GROUP_CONFLICT_CHECK_RESPONSE", "INITIATE_EMAIL_CHECK", "INITIATE_LICENCE_CHECK", "INITIATE_PRODUCT_MISMATCH_CHECK", "LICENCE_CHECK_STATUS", "PRODUCT_MISMATCH_CHECK_STATUS", "TOMBSTONE_ACCOUNTS", "TOMBSTONE_ACCOUNTS_PUBLISH", "USERS_MIGRATION_SERVICE_ENTERPRISE_GATEKEEPER_BASE_ROUTE", "USERS_MIGRATION_SERVICE_STARGATE_BASE_ROUTE", "jira-migration-plugin"})
    public static final class Routes {
        @NotNull
        public static final Routes INSTANCE = new Routes();
        @NotNull
        public static final String USERS_MIGRATION_SERVICE_STARGATE_BASE_ROUTE = "/migration/";
        @NotNull
        public static final String USERS_MIGRATION_SERVICE_ENTERPRISE_GATEKEEPER_BASE_ROUTE = "/migrations/v1/";
        @NotNull
        public static final String GROUP_CONFLICT_CHECK = "users/groupsconflict/jira";
        @NotNull
        public static final String TOMBSTONE_ACCOUNTS = "users/tombstones/{count}";
        @NotNull
        public static final String GROUP_CONFLICT_CHECK_RESPONSE = "users/groupsconflict/jira/{taskId}";
        @NotNull
        public static final String TOMBSTONE_ACCOUNTS_PUBLISH = "users/tombstones/publish/jira";
        @NotNull
        public static final String INITIATE_EMAIL_CHECK = "scope/{migrationScopeId}/jira/check/emails";
        @NotNull
        public static final String INITIATE_LICENCE_CHECK = "scope/{migrationScopeId}/check/licence";
        @NotNull
        public static final String INITIATE_PRODUCT_MISMATCH_CHECK = "scope/{migrationScopeId}/check/products";
        @NotNull
        public static final String EMAIL_CHECK_STATUS = "scope/{migrationScopeId}/jira/check/emails/{taskId}";
        @NotNull
        public static final String LICENCE_CHECK_STATUS = "scope/{migrationScopeId}/check/licence/{taskId}";
        @NotNull
        public static final String PRODUCT_MISMATCH_CHECK_STATUS = "scope/{migrationScopeId}/check/products/{taskId}";

        private Routes() {
        }
    }
}

