/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utility;

import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\bJ\"\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/utility/FileChunkUtility;", "", "()V", "CHUNK_10MB", "", "CHUNK_30MB", "CHUNK_60MB", "FILE_290GB", "", "FILE_490GB", "FILE_90GB", "MAX_PARTS_ALLOWED", "", "MB", "calSha256Checksum", "", "byteArray", "", "calculateChunkSize", "fileSize", "toChunks", "Lkotlin/sequences/Sequence;", "Lkotlin/collections/IndexedValue;", "inputStream", "Ljava/io/InputStream;", "ofSize", "jira-migration-plugin"})
public final class FileChunkUtility {
    @NotNull
    public static final FileChunkUtility INSTANCE = new FileChunkUtility();
    public static final int MB = 0x100000;
    public static final int CHUNK_10MB = 0xA00000;
    public static final int CHUNK_30MB = 0x1E00000;
    public static final int CHUNK_60MB = 0x3C00000;
    public static final long FILE_90GB = 96636764160L;
    public static final long FILE_290GB = 0x4880000000L;
    public static final long FILE_490GB = 526133493760L;
    private static final double MAX_PARTS_ALLOWED = 9900.0;

    private FileChunkUtility() {
    }

    @NotNull
    public final Sequence<IndexedValue<byte[]>> toChunks(@NotNull InputStream inputStream, int ofSize) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        byte[] buffer = new byte[ofSize];
        return SequencesKt.withIndex((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<byte[]>(ofSize, inputStream, buffer){
            final /* synthetic */ int $ofSize;
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ byte[] $buffer;
            {
                this.$ofSize = $ofSize;
                this.$inputStream = $inputStream;
                this.$buffer = $buffer;
                super(0);
            }

            @Nullable
            public final byte[] invoke() {
                byte[] byArray;
                int remainingSpace;
                int totalRead;
                int bytesRead;
                for (totalRead = 0; totalRead < this.$ofSize && (bytesRead = this.$inputStream.read(this.$buffer, totalRead, remainingSpace = this.$ofSize - totalRead)) >= 0; totalRead += bytesRead) {
                }
                if (totalRead < 1) {
                    byArray = null;
                } else {
                    byte[] byArray2 = Arrays.copyOf(this.$buffer, totalRead);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
                }
                return byArray;
            }
        })));
    }

    @NotNull
    public final String calSha256Checksum(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        MessageDigest sha256Digest = DigestUtils.getSha256Digest();
        sha256Digest.update(byteArray);
        String string = Base64.getEncoder().encodeToString(sha256Digest.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    public final int calculateChunkSize(long fileSize) {
        return fileSize < 96636764160L ? 0xA00000 : (fileSize < 0x4880000000L ? 0x1E00000 : (fileSize < 526133493760L ? 0x3C00000 : (int)Math.ceil((double)fileSize / 9900.0)));
    }
}

