/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utility;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.migration.jiraservice.JiraSearchService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00112\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/utility/JQLUtility;", "", "jiraSearchService", "Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "(Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;Lcom/atlassian/jira/security/JiraAuthenticationContext;)V", "doesJQLHaveProjectDenialClauses", "", "jql", "", "executeJQL", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/issue/Issue;", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "validateJQL", "Lkotlin/Pair;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJQLUtility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JQLUtility.kt\ncom/atlassian/jira/migration/utility/JQLUtility\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1747#2,3:59\n*S KotlinDebug\n*F\n+ 1 JQLUtility.kt\ncom/atlassian/jira/migration/utility/JQLUtility\n*L\n50#1:59,3\n*E\n"})
public final class JQLUtility {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraSearchService jiraSearchService;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private static final Logger log = LoggerFactory.getLogger(JQLUtility.class);

    @Inject
    public JQLUtility(@NotNull JiraSearchService jiraSearchService, @NotNull JiraAuthenticationContext jiraAuthenticationContext) {
        Intrinsics.checkNotNullParameter((Object)jiraSearchService, (String)"jiraSearchService");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        this.jiraSearchService = jiraSearchService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @NotNull
    public final Sequence<Issue> executeJQL(@Nullable ApplicationUser user, @NotNull String jql) {
        Intrinsics.checkNotNullParameter((Object)jql, (String)"jql");
        ApplicationUser applicationUser = user;
        if (applicationUser == null) {
            applicationUser = this.jiraAuthenticationContext.getLoggedInUser();
        }
        ApplicationUser loggedInUser = applicationUser;
        Query query = this.jiraSearchService.parseQuery(loggedInUser, jql).getQuery();
        Intrinsics.checkNotNull((Object)loggedInUser);
        Intrinsics.checkNotNull((Object)query);
        return JiraSearchService.searchOverrideSecurity$default(this.jiraSearchService, loggedInUser, query, 0, 4, null);
    }

    @NotNull
    public final Pair<Boolean, String> validateJQL(@NotNull String jql) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)jql, (String)"jql");
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        try {
            Pair pair2;
            SearchService.ParseResult parseResult = this.jiraSearchService.parseQuery(loggedInUser, jql);
            if (parseResult.isValid()) {
                pair2 = new Pair((Object)true, null);
            } else {
                Boolean bl = false;
                Set set = parseResult.getErrors().getErrorMessages();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getErrorMessages(...)");
                pair2 = new Pair((Object)bl, (Object)CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null));
            }
            pair = pair2;
        }
        catch (Exception e) {
            log.error("Exception while validating JQL: " + jql, (Throwable)e);
            pair = new Pair((Object)false, (Object)e.getMessage());
        }
        return pair;
    }

    public final boolean doesJQLHaveProjectDenialClauses(@NotNull String jql) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)jql, (String)"jql");
            Object[] objectArray = new String[]{"PROJECT !=", "NOT PROJECT", "PROJECT NOT IN"};
            List denialClauses = CollectionsKt.listOf((Object[])objectArray);
            CharSequence charSequence = jql;
            Regex regex = new Regex("\\s+");
            String string = " ";
            String jqlSingleSpace = regex.replace(charSequence, string);
            Iterable $this$any$iv = denialClauses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains((CharSequence)jqlSingleSpace, (CharSequence)it, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/utility/JQLUtility$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

