/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utility;

import com.atlassian.jira.migration.httpclient.exceptions.RetryAttemptsExceededException;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\"\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0001H\u0000\u001aM\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0013\u00a2\u0006\u0002\u0010\u0014\u001a;\u0010\u0015\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\u0010\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"BACKOFF_FACTOR", "", "BACKOFF_MAX_TIME_MS", "", "BACKOFF_OFFSET_MS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getRetryBackoffTime", "currentAttempt", "", "maxBackOff", "backoffFactor", "retryWithExponentialBackoff", "T", "maxAttempts", "retryableStatusCodes", "", "action", "Lkotlin/Function0;", "(IJDLjava/util/List;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "retryWithMaxAttempts", "successCondition", "Lkotlin/Function1;", "", "(ILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nRetryUtility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryUtility.kt\ncom/atlassian/jira/migration/utility/RetryUtilityKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class RetryUtilityKt {
    private static final Logger log = LoggerFactory.getLogger((String)"RetryUtility");
    private static final long BACKOFF_OFFSET_MS = 1000L;
    private static final double BACKOFF_FACTOR = 2.0;
    private static final long BACKOFF_MAX_TIME_MS = 300000L;

    public static final <T> T retryWithMaxAttempts(int maxAttempts, @NotNull Function0<? extends T> action, @NotNull Function1<? super T, Boolean> successCondition) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(successCondition, (String)"successCondition");
        Object result2 = null;
        int attempts = 0;
        while (attempts < maxAttempts) {
            result2 = action.invoke();
            if (((Boolean)successCondition.invoke(result2)).booleanValue()) {
                return (T)result2;
            }
            log.warn("attempt " + ++attempts + " failed, will retry");
        }
        throw new RetryAttemptsExceededException("Failed to get a successful result after " + maxAttempts + " attempts.");
    }

    @Nullable
    public static final <T> T retryWithExponentialBackoff(int maxAttempts, long maxBackOff, double backoffFactor, @NotNull List<Integer> retryableStatusCodes, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(retryableStatusCodes, (String)"retryableStatusCodes");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!(maxBackOff > 0L)) {
            boolean $i$a$-require-RetryUtilityKt$retryWithExponentialBackoff$22 = false;
            String $i$a$-require-RetryUtilityKt$retryWithExponentialBackoff$22 = "maxBackoff must be greater than 0";
            throw new IllegalArgumentException($i$a$-require-RetryUtilityKt$retryWithExponentialBackoff$22.toString());
        }
        for (int currentAttempt = 0; currentAttempt < maxAttempts; ++currentAttempt) {
            try {
                return (T)action.invoke();
            }
            catch (Exception e) {
                if (!((Collection)retryableStatusCodes).isEmpty() && e instanceof UnexpectedStatusCodeException && !retryableStatusCodes.contains(((UnexpectedStatusCodeException)e).getStatusCode())) {
                    throw e;
                }
                long backoff = RetryUtilityKt.getRetryBackoffTime(currentAttempt, maxBackOff, backoffFactor);
                log.info("backoff " + backoff);
                Thread.sleep(backoff);
                log.warn("attempt " + currentAttempt + " failed, will retry");
                continue;
            }
        }
        throw new RetryAttemptsExceededException("Failed to get a successful result after " + maxAttempts + " attempts.");
    }

    public static /* synthetic */ Object retryWithExponentialBackoff$default(int n, long l, double d, List list, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = 300000L;
        }
        if ((n2 & 4) != 0) {
            d = 2.0;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return RetryUtilityKt.retryWithExponentialBackoff(n, l, d, list, function0);
    }

    public static final long getRetryBackoffTime(int currentAttempt, long maxBackOff, double backoffFactor) {
        return RangesKt.coerceAtMost((long)(1000L * (long)Math.pow(backoffFactor, currentAttempt)), (long)maxBackOff);
    }

    public static /* synthetic */ long getRetryBackoffTime$default(int n, long l, double d, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d = 2.0;
        }
        return RetryUtilityKt.getRetryBackoffTime(n, l, d);
    }
}

