/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utils;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.jiracloudservice.JiraCloudClient;
import com.atlassian.migration.api.ContainerToken;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/utils/CloudUtil;", "", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "jiraCloudClient", "Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;", "(Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;)V", "getCloudSiteRegion", "", "cloudId", "jira-migration-plugin"})
public final class CloudUtil {
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final JiraCloudClient jiraCloudClient;

    @Inject
    public CloudUtil(@NotNull DiscoveryService discoveryService, @NotNull JiraCloudClient jiraCloudClient) {
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)jiraCloudClient, (String)"jiraCloudClient");
        this.discoveryService = discoveryService;
        this.jiraCloudClient = jiraCloudClient;
    }

    @NotNull
    public final String getCloudSiteRegion(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(cloudId2);
        if (cloudSite2 == null) {
            throw new IllegalStateException(("Cloud site not found for " + cloudId2).toString());
        }
        CloudSite cloudSite3 = cloudSite2;
        return this.jiraCloudClient.getTenantInformation(new ContainerToken(cloudSite3.getContainerToken()), cloudSite3.getCloudId()).getRegion();
    }
}

