/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utils;

import java.io.InputStream;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/utils/CsvUtil;", "", "()V", "PEEK_BUFFER_SIZE", "", "determineCsvPreference", "Lorg/supercsv/prefs/CsvPreference;", "inputStream", "Ljava/io/InputStream;", "isFileCsv", "", "filename", "", "peekAtCsvHeader", "StrNotBlank", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCsvUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CsvUtil.kt\ncom/atlassian/jira/migration/utils/CsvUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n123#2,2:94\n1#3:96\n*S KotlinDebug\n*F\n+ 1 CsvUtil.kt\ncom/atlassian/jira/migration/utils/CsvUtil\n*L\n33#1:94,2\n*E\n"})
public final class CsvUtil {
    @NotNull
    public static final CsvUtil INSTANCE = new CsvUtil();
    private static final int PEEK_BUFFER_SIZE = 255;

    private CsvUtil() {
    }

    public final boolean isFileCsv(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return StringsKt.endsWith((String)filename, (String)".csv", (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CsvPreference determineCsvPreference(@NotNull InputStream inputStream) {
        CsvPreference csvPreference;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            Object element$iv2;
            block4: {
                void $this$first$iv;
                Pair[] commonDelimiters;
                String csvHeader = this.peekAtCsvHeader(inputStream);
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf(','), (Object)CsvPreference.STANDARD_PREFERENCE), TuplesKt.to((Object)Character.valueOf(';'), (Object)CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE), TuplesKt.to((Object)Character.valueOf('\t'), (Object)CsvPreference.TAB_PREFERENCE)};
                pairArray = commonDelimiters = SequencesKt.sequenceOf((Object[])pairArray);
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Pair pair = (Pair)element$iv2;
                    boolean bl = false;
                    char delimiter = ((Character)pair.component1()).charValue();
                    if (!StringsKt.contains$default((CharSequence)csvHeader, (char)delimiter, (boolean)false, (int)2, null)) continue;
                    break block4;
                }
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            Pair pair = (Pair)element$iv2;
            boolean bl = false;
            CsvPreference preference = (CsvPreference)pair.component2();
            csvPreference = preference;
            Intrinsics.checkNotNull((Object)csvPreference);
        }
        catch (Exception e) {
            Exception exception = e;
            if (!(exception instanceof UnsupportedOperationException ? true : exception instanceof NoSuchElementException)) {
                throw e;
            }
            CsvPreference csvPreference2 = CsvPreference.STANDARD_PREFERENCE;
            Intrinsics.checkNotNull((Object)csvPreference2);
            csvPreference = csvPreference2;
        }
        return csvPreference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String peekAtCsvHeader(InputStream inputStream) {
        boolean bufferIsEmpty;
        int n;
        boolean canPeek = inputStream.markSupported();
        if (!canPeek) {
            throw new UnsupportedOperationException("Can't read CSV header since the InputStream doesn't support mark/reset operations.");
        }
        byte[] buffer = new byte[255];
        inputStream.mark(255);
        try {
            n = inputStream.read(buffer, 0, 255);
        }
        finally {
            inputStream.reset();
        }
        int numberOfBytesRead = n;
        boolean bl = bufferIsEmpty = numberOfBytesRead == -1;
        if (bufferIsEmpty) {
            return "";
        }
        return ((Object)StringsKt.trim((CharSequence)StringsKt.substring((String)new String(buffer, Charsets.UTF_8), (IntRange)RangesKt.until((int)0, (int)numberOfBytesRead)))).toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/utils/CsvUtil$StrNotBlank;", "Lorg/supercsv/cellprocessor/CellProcessorAdaptor;", "next", "Lorg/supercsv/cellprocessor/ift/CellProcessor;", "(Lorg/supercsv/cellprocessor/ift/CellProcessor;)V", "execute", "T", "value", "", "context", "Lorg/supercsv/util/CsvContext;", "(Ljava/lang/Object;Lorg/supercsv/util/CsvContext;)Ljava/lang/Object;", "jira-migration-plugin"})
    public static final class StrNotBlank
    extends CellProcessorAdaptor {
        public StrNotBlank(@NotNull CellProcessor next) {
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            super(next);
        }

        public <T> T execute(@Nullable Object value, @Nullable CsvContext context) {
            if (value == null) {
                throw new SuperCsvConstraintViolationException("the String should not be null", context, (CellProcessor)this);
            }
            if (!(value instanceof String) || !(!StringsKt.isBlank((CharSequence)((CharSequence)value)))) {
                if (value instanceof String && StringsKt.isBlank((CharSequence)((CharSequence)value))) {
                    throw new SuperCsvConstraintViolationException("the String should not be blank", context, (CellProcessor)this);
                }
                throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
            }
            return (T)this.next.execute(value, context);
        }
    }
}

