/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utils;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.clause.DeMorgansVisitor;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.QueryContextVisitor;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u00020\u00022\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0002J(\u0010\u0012\u001a\u00020\u00022\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0010\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000fH\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0010\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001dH\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/utils/CustomQueryContextVisitor;", "Lcom/atlassian/query/clause/ClauseVisitor;", "Lcom/atlassian/jira/jql/context/QueryContextVisitor$ContextResult;", "contextSetUtil", "Lcom/atlassian/jira/jql/context/ContextSetUtil;", "searchHandlerManager", "Lcom/atlassian/jira/issue/search/managers/SearchHandlerManager;", "(Lcom/atlassian/jira/jql/context/ContextSetUtil;Lcom/atlassian/jira/issue/search/managers/SearchHandlerManager;)V", "rootClause", "", "createContext", "clause", "Lcom/atlassian/query/clause/Clause;", "createIntersectionResult", "fullContexts", "", "Lcom/atlassian/jira/jql/context/ClauseContext;", "simpleContexts", "createUnionResult", "isExplicit", "Lcom/atlassian/query/clause/TerminalClause;", "replaceEmptyContextsWithGlobal", "result", "safeIntersection", "contexts", "safeUnion", "visit", "andClause", "Lcom/atlassian/query/clause/AndClause;", "Lcom/atlassian/query/clause/ChangedClause;", "notClause", "Lcom/atlassian/query/clause/NotClause;", "orClause", "Lcom/atlassian/query/clause/OrClause;", "Lcom/atlassian/query/clause/WasClause;", "QueryContextVisitorFactory", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomQueryContextVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomQueryContextVisitor.kt\ncom/atlassian/jira/migration/utils/CustomQueryContextVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1549#2:157\n1620#2,3:158\n1549#2:161\n1620#2,3:162\n1549#2:165\n1620#2,3:166\n1549#2:169\n1620#2,3:170\n1549#2:173\n1620#2,3:174\n1549#2:177\n1620#2,3:178\n1549#2:181\n1620#2,3:182\n1549#2:185\n1620#2,3:186\n1549#2:189\n1620#2,3:190\n766#2:193\n857#2,2:194\n*S KotlinDebug\n*F\n+ 1 CustomQueryContextVisitor.kt\ncom/atlassian/jira/migration/utils/CustomQueryContextVisitor\n*L\n65#1:157\n65#1:158,3\n66#1:161\n66#1:162,3\n67#1:165\n67#1:166,3\n68#1:169\n68#1:170,3\n85#1:173\n85#1:174,3\n86#1:177\n86#1:178,3\n87#1:181\n87#1:182,3\n88#1:185\n88#1:186,3\n98#1:189\n98#1:190,3\n99#1:193\n99#1:194,2\n*E\n"})
public final class CustomQueryContextVisitor
implements ClauseVisitor<QueryContextVisitor.ContextResult> {
    @NotNull
    private final ContextSetUtil contextSetUtil;
    @NotNull
    private final SearchHandlerManager searchHandlerManager;
    private boolean rootClause;

    public CustomQueryContextVisitor(@NotNull ContextSetUtil contextSetUtil, @NotNull SearchHandlerManager searchHandlerManager) {
        Intrinsics.checkNotNullParameter((Object)contextSetUtil, (String)"contextSetUtil");
        Intrinsics.checkNotNullParameter((Object)searchHandlerManager, (String)"searchHandlerManager");
        this.contextSetUtil = contextSetUtil;
        this.searchHandlerManager = searchHandlerManager;
        this.rootClause = true;
    }

    @NotNull
    public final QueryContextVisitor.ContextResult createContext(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        this.rootClause = false;
        Object object = clause.accept((ClauseVisitor)new DeMorgansVisitor());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.query.clause.Clause");
        Clause normalisedClause = (Clause)object;
        Object object2 = normalisedClause.accept((ClauseVisitor)this);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.atlassian.jira.jql.context.QueryContextVisitor.ContextResult");
        QueryContextVisitor.ContextResult result2 = (QueryContextVisitor.ContextResult)object2;
        this.rootClause = true;
        return this.replaceEmptyContextsWithGlobal(result2);
    }

    @NotNull
    public final QueryContextVisitor.ContextResult replaceEmptyContextsWithGlobal(@NotNull QueryContextVisitor.ContextResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        ClauseContext clauseContext = result2.getFullContext();
        Collection collection = clauseContext != null ? clauseContext.getContexts() : null;
        ClauseContext fullContext = collection == null || collection.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : result2.getFullContext();
        ClauseContext clauseContext2 = result2.getSimpleContext();
        Collection collection2 = clauseContext2 != null ? clauseContext2.getContexts() : null;
        ClauseContext simpleContext = collection2 == null || collection2.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : result2.getSimpleContext();
        return new QueryContextVisitor.ContextResult(fullContext, simpleContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public QueryContextVisitor.ContextResult visit(@NotNull AndClause andClause) {
        QueryContextVisitor.ContextResult contextResult;
        Intrinsics.checkNotNullParameter((Object)andClause, (String)"andClause");
        if (this.rootClause) {
            contextResult = this.createContext((Clause)andClause);
        } else {
            Iterable $this$mapTo$iv$iv;
            QueryContextVisitor.ContextResult it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            List list = andClause.getClauses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getClauses(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Clause clause = (Clause)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.accept((ClauseVisitor)this);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.jql.context.QueryContextVisitor.ContextResult");
                collection.add((QueryContextVisitor.ContextResult)object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (QueryContextVisitor.ContextResult)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFullContext());
            }
            Set fullChildClauseContexts = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            List list2 = andClause.getClauses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getClauses(...)");
            Iterable $this$map$iv2 = list2;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Clause bl = (Clause)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Object object = it2.accept((ClauseVisitor)this);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.jql.context.QueryContextVisitor.ContextResult");
                collection.add((QueryContextVisitor.ContextResult)object);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                QueryContextVisitor.ContextResult it2 = (QueryContextVisitor.ContextResult)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it2.getSimpleContext());
            }
            Set simpleChildClauseContexts = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
            contextResult = this.createIntersectionResult(fullChildClauseContexts, simpleChildClauseContexts);
        }
        return contextResult;
    }

    @NotNull
    public QueryContextVisitor.ContextResult visit(@NotNull NotClause notClause) {
        Intrinsics.checkNotNullParameter((Object)notClause, (String)"notClause");
        if (!this.rootClause) {
            throw new IllegalStateException("We have removed all the NOT clauses from the query, this should never occur.".toString());
        }
        return this.createContext((Clause)notClause);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public QueryContextVisitor.ContextResult visit(@NotNull OrClause orClause) {
        QueryContextVisitor.ContextResult contextResult;
        Intrinsics.checkNotNullParameter((Object)orClause, (String)"orClause");
        if (this.rootClause) {
            contextResult = this.createContext((Clause)orClause);
        } else {
            Iterable $this$mapTo$iv$iv;
            QueryContextVisitor.ContextResult it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            List list = orClause.getClauses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getClauses(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Clause clause = (Clause)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.accept((ClauseVisitor)this);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.jql.context.QueryContextVisitor.ContextResult");
                collection.add((QueryContextVisitor.ContextResult)object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (QueryContextVisitor.ContextResult)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFullContext());
            }
            Set fullChildClauseContexts = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            List list2 = orClause.getClauses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getClauses(...)");
            Iterable $this$map$iv2 = list2;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Clause bl = (Clause)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Object object = it2.accept((ClauseVisitor)this);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.jql.context.QueryContextVisitor.ContextResult");
                collection.add((QueryContextVisitor.ContextResult)object);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                QueryContextVisitor.ContextResult it2 = (QueryContextVisitor.ContextResult)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it2.getSimpleContext());
            }
            Set simpleChildClauseContexts = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
            contextResult = this.createUnionResult(fullChildClauseContexts, simpleChildClauseContexts);
        }
        return contextResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public QueryContextVisitor.ContextResult visit(@NotNull TerminalClause clause) {
        QueryContextVisitor.ContextResult contextResult;
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        if (this.rootClause) {
            contextResult = this.createContext((Clause)clause);
        } else {
            Set set;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ClauseContext it;
            void $this$mapTo$iv$iv;
            Collection collection = this.searchHandlerManager.getClauseHandler(clause.getName());
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getClauseHandler(...)");
            Collection handlers = collection;
            Iterable $this$map$iv = handlers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ClauseHandler clauseHandler = (ClauseHandler)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getClauseContextFactory().getClauseContext(null, clause));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ClauseContext)element$iv$iv;
                boolean bl = false;
                Set set2 = it.getContexts();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getContexts(...)");
                boolean bl2 = !((Collection)set2).isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set fullClauseContexts = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            if (this.isExplicit(clause)) {
                set = fullClauseContexts;
            } else {
                Object[] objectArray = new ClauseContext[]{ClauseContextImpl.createGlobalClauseContext()};
                set = SetsKt.mutableSetOf((Object[])objectArray);
            }
            Set simpleClauseContexts = set;
            contextResult = this.createUnionResult(fullClauseContexts, simpleClauseContexts);
        }
        return contextResult;
    }

    @NotNull
    public QueryContextVisitor.ContextResult visit(@NotNull WasClause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        return new QueryContextVisitor.ContextResult(ClauseContextImpl.createGlobalClauseContext(), ClauseContextImpl.createGlobalClauseContext());
    }

    @NotNull
    public QueryContextVisitor.ContextResult visit(@NotNull ChangedClause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        return new QueryContextVisitor.ContextResult(ClauseContextImpl.createGlobalClauseContext(), ClauseContextImpl.createGlobalClauseContext());
    }

    private final boolean isExplicit(TerminalClause clause) {
        return SystemSearchConstants.forProject().getJqlClauseNames().contains(clause.getName()) || SystemSearchConstants.forIssueType().getJqlClauseNames().contains(clause.getName());
    }

    private final QueryContextVisitor.ContextResult createUnionResult(Set<? extends ClauseContext> fullContexts, Set<? extends ClauseContext> simpleContexts) {
        ClauseContext fullContext = this.safeUnion(fullContexts);
        ClauseContext simpleContext = Intrinsics.areEqual(fullContexts, simpleContexts) ? fullContext : this.safeUnion(simpleContexts);
        return new QueryContextVisitor.ContextResult(fullContext, simpleContext);
    }

    private final QueryContextVisitor.ContextResult createIntersectionResult(Set<? extends ClauseContext> fullContexts, Set<? extends ClauseContext> simpleContexts) {
        ClauseContext fullContext = this.safeIntersection(fullContexts);
        ClauseContext simpleContext = Intrinsics.areEqual(fullContexts, simpleContexts) ? fullContext : this.safeIntersection(simpleContexts);
        return new QueryContextVisitor.ContextResult(fullContext, simpleContext);
    }

    private final ClauseContext safeUnion(Set<? extends ClauseContext> contexts) {
        ClauseContext returnContext;
        Collection collection = contexts;
        if (collection == null || collection.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        ClauseContext clauseContext = returnContext = contexts.size() == 1 ? (ClauseContext)CollectionsKt.first((Iterable)contexts) : this.contextSetUtil.union(contexts);
        Collection collection2 = clauseContext != null ? clauseContext.getContexts() : null;
        return collection2 == null || collection2.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : returnContext;
    }

    private final ClauseContext safeIntersection(Set<? extends ClauseContext> contexts) {
        ClauseContext returnContext;
        Collection collection = contexts;
        if (collection == null || collection.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        ClauseContext clauseContext = returnContext = contexts.size() == 1 ? (ClauseContext)CollectionsKt.first((Iterable)contexts) : this.contextSetUtil.intersect(contexts);
        Collection collection2 = clauseContext != null ? clauseContext.getContexts() : null;
        return collection2 == null || collection2.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : returnContext;
    }

    @Named
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/utils/CustomQueryContextVisitor$QueryContextVisitorFactory;", "", "searchHandlerManager", "Lcom/atlassian/jira/issue/search/managers/SearchHandlerManager;", "(Lcom/atlassian/jira/issue/search/managers/SearchHandlerManager;)V", "createVisitor", "Lcom/atlassian/jira/migration/utils/CustomQueryContextVisitor;", "jira-migration-plugin"})
    public static final class QueryContextVisitorFactory {
        @NotNull
        private final SearchHandlerManager searchHandlerManager;

        @Inject
        public QueryContextVisitorFactory(@NotNull SearchHandlerManager searchHandlerManager) {
            Intrinsics.checkNotNullParameter((Object)searchHandlerManager, (String)"searchHandlerManager");
            this.searchHandlerManager = searchHandlerManager;
        }

        @NotNull
        public final CustomQueryContextVisitor createVisitor() {
            return new CustomQueryContextVisitor(new ContextSetUtil(), this.searchHandlerManager);
        }
    }
}

