/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/utils/DateSerializerUtil;", "", "()V", "JsonDateSerializer", "JsonDateSerializerFasterxml", "jira-migration-plugin"})
public final class DateSerializerUtil {

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/utils/DateSerializerUtil$JsonDateSerializer;", "Lorg/codehaus/jackson/map/JsonSerializer;", "Ljava/util/Date;", "()V", "serialize", "", "date", "gen", "Lorg/codehaus/jackson/JsonGenerator;", "provider", "Lorg/codehaus/jackson/map/SerializerProvider;", "jira-migration-plugin"})
    public static final class JsonDateSerializer
    extends JsonSerializer<Date> {
        @NotNull
        public static final JsonDateSerializer INSTANCE = new JsonDateSerializer();

        private JsonDateSerializer() {
        }

        public void serialize(@NotNull Date date, @NotNull org.codehaus.jackson.JsonGenerator gen, @Nullable SerializerProvider provider) throws IOException, JsonProcessingException {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            gen.writeString(new SimpleDateFormat("yyyy-MM-dd").format(date));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/utils/DateSerializerUtil$JsonDateSerializerFasterxml;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/util/Date;", "()V", "serialize", "", "date", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "jira-migration-plugin"})
    public static final class JsonDateSerializerFasterxml
    extends com.fasterxml.jackson.databind.JsonSerializer<Date> {
        @NotNull
        public static final JsonDateSerializerFasterxml INSTANCE = new JsonDateSerializerFasterxml();

        private JsonDateSerializerFasterxml() {
        }

        public void serialize(@NotNull Date date, @NotNull JsonGenerator gen, @NotNull com.fasterxml.jackson.databind.SerializerProvider provider) throws IOException {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            gen.writeString(new SimpleDateFormat("yyyy-MM-dd").format(date));
        }
    }
}

