/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utils;

import com.atlassian.jira.migration.datafilters.utils.DataFiltersUtil;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.plan.CrossProjectBoardsAndFiltersMigrationOption;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.plan.JsdCustomersMigrationOption;
import com.atlassian.jira.migration.plan.LiftAndShiftMode;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0019\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\"\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/utils/MigrationModeUtil;", "", "()V", "doNotMigrateCrossProjectBoardsAndFilters", "", "crossProjectBoardsAndFiltersMigrationOption", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardsAndFiltersMigrationOption;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "doNotMigrateCustomer", "usersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "doNotMigrateDashboards", "dashboardsMigrationMode", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "isAppDataPreloadMode", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "isAttachmentsOnlyMode", "isLiftAndShiftMode", "singlePathMode", "Lcom/atlassian/jira/migration/plan/SinglePathMode;", "isManualInterventionExport", "liftAndShiftMode", "Lcom/atlassian/jira/migration/plan/LiftAndShiftMode;", "isManualInterventionImport", "isWithoutAttachments", "isTestMigrationWithoutAttachments", "shouldExportChangeHistoryUseFlatRead", "exportContext", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "shouldExportUseFlatRead", "shouldMigrateArchivedIssues", "migrateArchivedIssues", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Ljava/lang/Boolean;)Z", "shouldMigrateArchivedIssuesAsActiveOrArchived", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationModeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationModeUtil.kt\ncom/atlassian/jira/migration/utils/MigrationModeUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class MigrationModeUtil {
    @NotNull
    public static final MigrationModeUtil INSTANCE = new MigrationModeUtil();

    private MigrationModeUtil() {
    }

    public final boolean isAttachmentsOnlyMode(@NotNull ProjectDataMigrationMode projectDataMigrationMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
        return projectDataMigrationMode == ProjectDataMigrationMode.ATTACHMENTS_ONLY || projectDataMigrationMode == ProjectDataMigrationMode.ATTACHMENTS_ONLY_V2;
    }

    public final boolean isAppDataPreloadMode(@NotNull ProjectDataMigrationMode projectDataMigrationMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
        return projectDataMigrationMode == ProjectDataMigrationMode.APP_DATA_PRELOAD;
    }

    public final boolean doNotMigrateCustomer(@NotNull UsersGroupsMigrationOption usersGroupsMigrationOption) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
        JsdCustomersMigrationOption jsdCustomersMigrationOption = usersGroupsMigrationOption.getJsdCustomersMigrationOption();
        if (jsdCustomersMigrationOption != null) {
            JsdCustomersMigrationOption it = jsdCustomersMigrationOption;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)JsdCustomersMigrationOption.Companion.getNONE());
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean isLiftAndShiftMode(@Nullable SinglePathMode singlePathMode, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return !migrationFeatures.getDisableSinglePathMigration() && singlePathMode == SinglePathMode.LIFT_AND_SHIFT;
    }

    public final boolean isManualInterventionExport(@Nullable LiftAndShiftMode liftAndShiftMode, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return migrationFeatures.getEnableSinglePathManualIntervention() && liftAndShiftMode == LiftAndShiftMode.MANUAL_EXPORT;
    }

    public final boolean isManualInterventionImport(@Nullable LiftAndShiftMode liftAndShiftMode, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return migrationFeatures.getEnableSinglePathManualIntervention() && liftAndShiftMode == LiftAndShiftMode.MANUAL_IMPORT;
    }

    public final boolean isWithoutAttachments(boolean isTestMigrationWithoutAttachments, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return !migrationFeatures.getDisableSinglePathWithoutAttachments() && isTestMigrationWithoutAttachments;
    }

    public final boolean doNotMigrateCrossProjectBoardsAndFilters(@Nullable CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return !migrationFeatures.getEnableCrossProjectBoardsAndFilters() || crossProjectBoardsAndFiltersMigrationOption == null || crossProjectBoardsAndFiltersMigrationOption.getBoardsAndFiltersMigrationMode() == CrossProjectBoardAndFiltersMigrationMode.NONE;
    }

    public final boolean shouldMigrateArchivedIssues(@NotNull MigrationFeatures migrationFeatures, @Nullable Boolean migrateArchivedIssues) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return migrationFeatures.getEnableArchivedIssueMigrationAsArchived() || migrationFeatures.getEnableArchivedIssueMigrationGA() && Intrinsics.areEqual((Object)migrateArchivedIssues, (Object)true);
    }

    public final boolean shouldMigrateArchivedIssuesAsActiveOrArchived(@NotNull MigrationFeatures migrationFeatures, @Nullable Boolean migrateArchivedIssues) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return migrationFeatures.getEnableArchivedIssueMigration() || this.shouldMigrateArchivedIssues(migrationFeatures, migrateArchivedIssues);
    }

    public final boolean doNotMigrateDashboards(@Nullable DashboardsMigrationMode dashboardsMigrationMode) {
        return dashboardsMigrationMode == null || dashboardsMigrationMode == DashboardsMigrationMode.NONE;
    }

    public final boolean shouldExportUseFlatRead(@NotNull ExportContext exportContext, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)exportContext, (String)"exportContext");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return !exportContext.getEntityCachePersistedAndValidForExport() && migrationFeatures.getEnableFlatRead() && !DataFiltersUtil.INSTANCE.shouldApplyDataFilters(migrationFeatures, exportContext.getDataFilterContext());
    }

    public final boolean shouldExportChangeHistoryUseFlatRead(@NotNull ExportContext exportContext, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)exportContext, (String)"exportContext");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return !exportContext.getEntityCachePersistedAndValidForExport() && migrationFeatures.getEnableFlatReadChangeHistory() && !DataFiltersUtil.INSTANCE.shouldApplyDataFilters(migrationFeatures, exportContext.getDataFilterContext());
    }
}

