/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utils;

import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.EntityCounts;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.orchestratorclient.tasks.TaskCompletionStatus;
import com.atlassian.jira.migration.progress.TaskList;
import com.atlassian.jira.migration.progress.TaskListStatus;
import com.atlassian.jira.migration.utils.PlanCompletionEventsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \u00032\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/utils/PlanCompletionEventsUtil;", "", "()V", "Companion", "ProgressItemList", "TaskProgressMap", "TaskTypeStatus", "jira-migration-plugin"})
public final class PlanCompletionEventsUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u0004J \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u00042\u0006\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u00042\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u0004J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u0014\u001a\u00020\u0015*\u00020\rH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$Companion;", "", "()V", "createTaskTypeToErrorMap", "", "", "", "Lcom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$TaskProgressMap;", "migrationTaskTypeToProgressMap", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "createTaskTypeToProgressMap", "currentStatus", "Lcom/atlassian/jira/migration/progress/TaskList;", "createTaskTypeToStatusMap", "Lcom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$TaskTypeStatus;", "getErrorsForTask", "taskProgress", "retrieveTaskListStatus", "Lcom/atlassian/jira/migration/progress/TaskListStatus;", "isFailed", "", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nPlanCompletionEventsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanCompletionEventsUtil.kt\ncom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n215#2:91\n216#2:95\n215#2:103\n216#2:108\n1855#3:92\n1856#3:94\n1855#3:104\n1855#3,2:105\n1856#3:107\n766#3:110\n857#3,2:111\n1#4:93\n526#5:96\n511#5,6:97\n13309#6:109\n13310#6:113\n*S KotlinDebug\n*F\n+ 1 PlanCompletionEventsUtil.kt\ncom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$Companion\n*L\n24#1:91\n24#1:95\n56#1:103\n56#1:108\n25#1:92\n25#1:94\n58#1:104\n60#1:105,2\n58#1:107\n76#1:110\n76#1:111,2\n45#1:96\n45#1:97,6\n74#1:109\n74#1:113\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TaskListStatus retrieveTaskListStatus(@NotNull TaskList currentStatus) {
            Intrinsics.checkNotNullParameter((Object)currentStatus, (String)"currentStatus");
            TaskListStatus taskListStatus = this.isFailed(currentStatus) || currentStatus.isCompletedWithBlockingFailures() ? TaskListStatus.FAILED : (currentStatus.isCompletedPartially() || currentStatus.isCompletedWithSoftFailures() ? TaskListStatus.PARTIALLY_COMPLETED : (currentStatus.isCompletedSuccessfully() ? TaskListStatus.COMPLETED_SUCCESSFULLY : TaskListStatus.UNKNOWN));
            return taskListStatus;
        }

        private final boolean isFailed(TaskList $this$isFailed) {
            return $this$isFailed.findAllFailedBlockerProgressItems() != null;
        }

        @NotNull
        public final Map<String, List<TaskProgressMap>> createTaskTypeToErrorMap(@NotNull Map<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>> migrationTaskTypeToProgressMap) {
            Intrinsics.checkNotNullParameter(migrationTaskTypeToProgressMap, (String)"migrationTaskTypeToProgressMap");
            Map migrationTaskTypeToErrorMap = new LinkedHashMap();
            Map<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>> $this$forEach$iv = migrationTaskTypeToProgressMap;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>> element$iv;
                Map.Entry<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>> types = element$iv = iterator2.next();
                boolean bl = false;
                Iterable $this$forEach$iv2 = types.getValue();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    GetTaskStatusResponse.TaskProgress taskProgress = (GetTaskStatusResponse.TaskProgress)element$iv2;
                    boolean bl2 = false;
                    TaskProgressMap taskIdToErrorMap = Companion.getErrorsForTask(taskProgress);
                    if (!(!taskIdToErrorMap.getTaskProgressMap().isEmpty())) continue;
                    Map map = migrationTaskTypeToErrorMap;
                    Object object = map.get(taskProgress.getTask().getMigrationTaskType().getTaskTypeName());
                    if (object == null) {
                        boolean bl3 = false;
                        object = new ArrayList();
                    }
                    List list = (List)object;
                    list.add(taskIdToErrorMap);
                    migrationTaskTypeToErrorMap.put(taskProgress.getTask().getMigrationTaskType().getTaskTypeName(), list);
                }
            }
            return MapsKt.toMap((Map)migrationTaskTypeToErrorMap);
        }

        /*
         * WARNING - void declaration
         */
        private final TaskProgressMap getErrorsForTask(GetTaskStatusResponse.TaskProgress taskProgress) {
            Map taskIdToErrorMap = new LinkedHashMap();
            List progressItemMutableErrorList = new ArrayList();
            MigrationTask task = taskProgress.component1();
            Map<ProgressUnit, ProgressItem> progressItems = taskProgress.component2();
            for (ProgressItem progressItem : progressItems.values()) {
                if (!progressItem.isCompletedSuccessfully()) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Map<String, EntityCounts> map = progressItem.getCompletedEntityCounts();
                    String string = null;
                    TaskCompletionStatus taskCompletionStatus = null;
                    boolean bl = false;
                    ProgressUnit progressUnit = null;
                    long l = 0L;
                    long l2 = 0L;
                    ProgressItem progressItem2 = progressItem;
                    boolean $i$f$filter = false;
                    void var11_11 = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$filterTo = false;
                    Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv$iv;
                        Map.Entry it = element$iv$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(((EntityCounts)it.getValue()).getFailed() > 0L)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    Map map2 = destination$iv$iv;
                    ProgressItem updatedProgressItem = ProgressItem.copy$default(progressItem2, l2, l, progressUnit, bl, taskCompletionStatus, string, map2, null, null, 447, null);
                    progressItemMutableErrorList.add(updatedProgressItem);
                }
                if (!(!((Collection)progressItemMutableErrorList).isEmpty())) continue;
                taskIdToErrorMap.put(task.getTaskId(), new ProgressItemList(CollectionsKt.toList((Iterable)progressItemMutableErrorList)));
            }
            return new TaskProgressMap(MapsKt.toMap((Map)taskIdToErrorMap));
        }

        @NotNull
        public final Map<MigrationTaskType, TaskTypeStatus> createTaskTypeToStatusMap(@NotNull Map<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>> migrationTaskTypeToProgressMap) {
            Intrinsics.checkNotNullParameter(migrationTaskTypeToProgressMap, (String)"migrationTaskTypeToProgressMap");
            Map migrationTaskTypeToStatus = new LinkedHashMap();
            Map<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>> $this$forEach$iv = migrationTaskTypeToProgressMap;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>> element$iv;
                Map.Entry<MigrationTaskType, ? extends List<GetTaskStatusResponse.TaskProgress>> types = element$iv = iterator2.next();
                boolean bl = false;
                boolean completedSuccessfully = false;
                completedSuccessfully = true;
                Iterable $this$forEach$iv2 = types.getValue();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    GetTaskStatusResponse.TaskProgress taskProgress = (GetTaskStatusResponse.TaskProgress)element$iv2;
                    boolean bl2 = false;
                    Map<ProgressUnit, ProgressItem> progressItems = taskProgress.getProgressItems();
                    Iterable $this$forEach$iv3 = progressItems.keySet();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        ProgressUnit progressUnit = (ProgressUnit)((Object)element$iv3);
                        boolean bl3 = false;
                        ProgressItem progressItem = progressItems.get((Object)progressUnit);
                        ProgressItem progressItem2 = progressItem;
                        completedSuccessfully &= progressItem2 != null ? progressItem2.isCompletedSuccessfully() : false;
                    }
                    migrationTaskTypeToStatus.put(types.getKey(), completedSuccessfully ? TaskTypeStatus.SUCCESS : TaskTypeStatus.NOT_SUCCESS);
                }
            }
            return MapsKt.toMap((Map)migrationTaskTypeToStatus);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<MigrationTaskType, List<GetTaskStatusResponse.TaskProgress>> createTaskTypeToProgressMap(@NotNull TaskList currentStatus) {
            Intrinsics.checkNotNullParameter((Object)currentStatus, (String)"currentStatus");
            Map migrationTaskTypeToProgressMap = new LinkedHashMap();
            MigrationTaskType[] $this$forEach$iv = MigrationTaskType.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                void $this$filterTo$iv$iv;
                MigrationTaskType element$iv;
                MigrationTaskType type = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Map map = migrationTaskTypeToProgressMap;
                Iterable $this$filter$iv = currentStatus.getTaskProgressList();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getTask().getMigrationTaskType() == type)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                map.put(type, list);
            }
            migrationTaskTypeToProgressMap.entrySet().removeIf(arg_0 -> Companion.createTaskTypeToProgressMap$lambda$9(createTaskTypeToProgressMap.2.INSTANCE, arg_0));
            return MapsKt.toMap((Map)migrationTaskTypeToProgressMap);
        }

        private static final boolean createTaskTypeToProgressMap$lambda$9(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$ProgressItemList;", "", "progressItems", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressItem;", "(Ljava/util/List;)V", "getProgressItems", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class ProgressItemList {
        @NotNull
        private final List<ProgressItem> progressItems;

        public ProgressItemList(@NotNull List<ProgressItem> progressItems) {
            Intrinsics.checkNotNullParameter(progressItems, (String)"progressItems");
            this.progressItems = progressItems;
        }

        @NotNull
        public final List<ProgressItem> getProgressItems() {
            return this.progressItems;
        }

        @NotNull
        public final List<ProgressItem> component1() {
            return this.progressItems;
        }

        @NotNull
        public final ProgressItemList copy(@NotNull List<ProgressItem> progressItems) {
            Intrinsics.checkNotNullParameter(progressItems, (String)"progressItems");
            return new ProgressItemList(progressItems);
        }

        public static /* synthetic */ ProgressItemList copy$default(ProgressItemList progressItemList, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = progressItemList.progressItems;
            }
            return progressItemList.copy(list);
        }

        @NotNull
        public String toString() {
            return "ProgressItemList(progressItems=" + this.progressItems + ')';
        }

        public int hashCode() {
            return ((Object)this.progressItems).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProgressItemList)) {
                return false;
            }
            ProgressItemList progressItemList = (ProgressItemList)other;
            return Intrinsics.areEqual(this.progressItems, progressItemList.progressItems);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$TaskProgressMap;", "", "taskProgressMap", "", "", "Lcom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$ProgressItemList;", "(Ljava/util/Map;)V", "getTaskProgressMap", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class TaskProgressMap {
        @NotNull
        private final Map<String, ProgressItemList> taskProgressMap;

        public TaskProgressMap(@NotNull Map<String, ProgressItemList> taskProgressMap) {
            Intrinsics.checkNotNullParameter(taskProgressMap, (String)"taskProgressMap");
            this.taskProgressMap = taskProgressMap;
        }

        @NotNull
        public final Map<String, ProgressItemList> getTaskProgressMap() {
            return this.taskProgressMap;
        }

        @NotNull
        public final Map<String, ProgressItemList> component1() {
            return this.taskProgressMap;
        }

        @NotNull
        public final TaskProgressMap copy(@NotNull Map<String, ProgressItemList> taskProgressMap) {
            Intrinsics.checkNotNullParameter(taskProgressMap, (String)"taskProgressMap");
            return new TaskProgressMap(taskProgressMap);
        }

        public static /* synthetic */ TaskProgressMap copy$default(TaskProgressMap taskProgressMap, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = taskProgressMap.taskProgressMap;
            }
            return taskProgressMap.copy(map);
        }

        @NotNull
        public String toString() {
            return "TaskProgressMap(taskProgressMap=" + this.taskProgressMap + ')';
        }

        public int hashCode() {
            return ((Object)this.taskProgressMap).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TaskProgressMap)) {
                return false;
            }
            TaskProgressMap taskProgressMap = (TaskProgressMap)other;
            return Intrinsics.areEqual(this.taskProgressMap, taskProgressMap.taskProgressMap);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/utils/PlanCompletionEventsUtil$TaskTypeStatus;", "", "(Ljava/lang/String;I)V", "SUCCESS", "NOT_SUCCESS", "jira-migration-plugin"})
    public static final class TaskTypeStatus
    extends Enum<TaskTypeStatus> {
        public static final /* enum */ TaskTypeStatus SUCCESS = new TaskTypeStatus();
        public static final /* enum */ TaskTypeStatus NOT_SUCCESS = new TaskTypeStatus();
        private static final /* synthetic */ TaskTypeStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TaskTypeStatus[] values() {
            return (TaskTypeStatus[])$VALUES.clone();
        }

        public static TaskTypeStatus valueOf(String value) {
            return Enum.valueOf(TaskTypeStatus.class, value);
        }

        @NotNull
        public static EnumEntries<TaskTypeStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = taskTypeStatusArray = new TaskTypeStatus[]{TaskTypeStatus.SUCCESS, TaskTypeStatus.NOT_SUCCESS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

