/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.utils;

import com.atlassian.jira.migration.utils.SegregatedProjectKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/utils/ProjectKeysProcessor;", "", "()V", "projectKeysJoiningDelimiter", "", "projectKeysSeparationDelimiter", "getKeysAsList", "", "", "keys", "mergeKeys", "segregatedProjectKeys", "Lcom/atlassian/jira/migration/utils/SegregatedProjectKeys;", "splitKeys", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectKeysProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectKeysProcessor.kt\ncom/atlassian/jira/migration/utils/ProjectKeysProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n3190#2,10:44\n*S KotlinDebug\n*F\n+ 1 ProjectKeysProcessor.kt\ncom/atlassian/jira/migration/utils/ProjectKeysProcessor\n*L\n13#1:44,10\n*E\n"})
public final class ProjectKeysProcessor {
    @NotNull
    public static final ProjectKeysProcessor INSTANCE = new ProjectKeysProcessor();
    public static final char projectKeysSeparationDelimiter = '$';
    public static final char projectKeysJoiningDelimiter = ',';

    private ProjectKeysProcessor() {
    }

    @NotNull
    public final SegregatedProjectKeys splitKeys(@NotNull String keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        if (!StringsKt.contains$default((CharSequence)keys, (char)'$', (boolean)false, (int)2, null)) {
            return new SegregatedProjectKeys(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        char[] cArray = new char[]{'$'};
        List list = StringsKt.split$default((CharSequence)keys, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        String projectKeysAsString = (String)list.get(0);
        String arPlanOrCrossProjectKeysAsString = (String)list.get(1);
        List<String> projectKeys = this.getKeysAsList(projectKeysAsString);
        List<String> arPlanOrCrossProjectKeys = this.getKeysAsList(arPlanOrCrossProjectKeysAsString);
        Iterable $this$partition$iv = arPlanOrCrossProjectKeys;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)"CROSS-PROJECT-DATA")) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List arPlanProjectKeys = (List)pair.component1();
        List crossProjectKey = (List)pair.component2();
        return new SegregatedProjectKeys(projectKeys, arPlanProjectKeys, crossProjectKey);
    }

    @NotNull
    public final String mergeKeys(@NotNull SegregatedProjectKeys segregatedProjectKeys) {
        Intrinsics.checkNotNullParameter((Object)segregatedProjectKeys, (String)"segregatedProjectKeys");
        return CollectionsKt.joinToString$default((Iterable)segregatedProjectKeys.getProjectKeys(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + '$' + CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)segregatedProjectKeys.getArPlanProjectKeys(), (Iterable)segregatedProjectKeys.getCrossProjectKey()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    private final List<String> getKeysAsList(String keys) {
        List list;
        if (StringsKt.contains$default((CharSequence)keys, (char)',', (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{','};
            list = StringsKt.split$default((CharSequence)keys, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list = CollectionsKt.listOf((Object)keys);
        }
        return list;
    }
}

