/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.validation;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.common.PluginAccessorExtensionsKt;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaReader;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.serverdataextractors.ProjectsReader;
import com.atlassian.jira.migration.serverdataextractors.ServerProject;
import com.atlassian.jira.migration.validation.PlanValidationException;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0016\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ\u001e\u0010\u0017\u001a\u00020\u00182\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/validation/PlanValidation;", "", "projectsReader", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "objectSchemaReader", "Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaReader;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "(Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaReader;Lcom/atlassian/plugin/PluginAccessor;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/issue/IssueManager;)V", "sortProjectsByIssueCount", "", "", "projectKeys", "validateAssetsSchemaKeys", "", "assetsSchemaKeys", "validateProjectKey", "", "key", "validateProjectKeys", "Lcom/atlassian/jira/migration/validation/PlanValidation$ProjectKeysValidationResult;", "ignoreInvalidProjectKeys", "validateSchemaKey", "ProjectKeysValidationResult", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanValidation.kt\ncom/atlassian/jira/migration/validation/PlanValidation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1855#2,2:122\n1549#2:124\n1620#2,3:125\n1054#2:128\n1549#2:129\n1620#2,3:130\n1855#2,2:133\n*S KotlinDebug\n*F\n+ 1 PlanValidation.kt\ncom/atlassian/jira/migration/validation/PlanValidation\n*L\n34#1:122,2\n56#1:124\n56#1:125,3\n61#1:128\n61#1:129\n61#1:130,3\n82#1:133,2\n*E\n"})
public final class PlanValidation {
    @NotNull
    private final ProjectsReader projectsReader;
    @NotNull
    private final ObjectSchemaReader objectSchemaReader;
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final IssueManager issueManager;

    @Inject
    public PlanValidation(@NotNull ProjectsReader projectsReader, @NotNull ObjectSchemaReader objectSchemaReader, @NotNull PluginAccessor pluginAccessor, @NotNull MigrationFeatures migrationFeatures, @NotNull IssueManager issueManager) {
        Intrinsics.checkNotNullParameter((Object)projectsReader, (String)"projectsReader");
        Intrinsics.checkNotNullParameter((Object)objectSchemaReader, (String)"objectSchemaReader");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        this.projectsReader = projectsReader;
        this.objectSchemaReader = objectSchemaReader;
        this.pluginAccessor = pluginAccessor;
        this.migrationFeatures = migrationFeatures;
        this.issueManager = issueManager;
    }

    @NotNull
    public final ProjectKeysValidationResult validateProjectKeys(@NotNull List<String> projectKeys, boolean ignoreInvalidProjectKeys) {
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        Set uniqueProjectKeys = new LinkedHashSet();
        Set duplicateProjectKeys = new LinkedHashSet();
        Set invalidProjectKeys = new LinkedHashSet();
        Iterable $this$forEach$iv = projectKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (uniqueProjectKeys.contains(it)) {
                duplicateProjectKeys.add(it);
            }
            if (!this.validateProjectKey(it)) {
                invalidProjectKeys.add(it);
            }
            uniqueProjectKeys.add(it);
        }
        if (CollectionsKt.any((Iterable)duplicateProjectKeys)) {
            throw new PlanValidationException("Plan includes duplicate project keys " + duplicateProjectKeys);
        }
        if (!ignoreInvalidProjectKeys && CollectionsKt.any((Iterable)invalidProjectKeys)) {
            throw new PlanValidationException("Plan includes invalid project keys " + invalidProjectKeys);
        }
        return new ProjectKeysValidationResult(invalidProjectKeys);
    }

    public static /* synthetic */ ProjectKeysValidationResult validateProjectKeys$default(PlanValidation planValidation, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return planValidation.validateProjectKeys(list, bl);
    }

    public final boolean validateProjectKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.projectsReader.getServerProjectByKey(key) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> sortProjectsByIssueCount(@NotNull List<String> projectKeys) {
        Pair projectKey;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        Iterable $this$map$iv = projectKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ServerProject serverProject = this.projectsReader.getServerProjectByKey((String)projectKey);
            Long projectId = serverProject != null ? Long.valueOf(serverProject.getId()) : null;
            long issueCount = projectId != null ? this.issueManager.getIssueCountForProject(projectId) : 0L;
            collection.add(new Pair((Object)projectKey, (Object)issueCount));
        }
        List issueCountOfProjects = (List)destination$iv$iv;
        Iterable $this$sortedByDescending$iv = issueCountOfProjects;
        boolean $i$f$sortedByDescending = false;
        $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Long)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getSecond()));
            }
        });
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            projectKey = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        return (List)destination$iv$iv;
    }

    private final boolean validateSchemaKey(String key) {
        return this.objectSchemaReader.getObjectSchemaByKey(key) != null;
    }

    public final void validateAssetsSchemaKeys(@Nullable List<String> assetsSchemaKeys) {
        Collection collection;
        if (!this.migrationFeatures.getEnableAssetsMigration() || (collection = (Collection)assetsSchemaKeys) == null || collection.isEmpty()) {
            return;
        }
        if (!PluginAccessorExtensionsKt.hasAssetsInstalled(this.pluginAccessor)) {
            throw new PlanValidationException("Plan includes Assets' Object Schema keys " + assetsSchemaKeys + " but Assets plugin is not installed");
        }
        Set uniqueSchemaKeys = new LinkedHashSet();
        Set duplicateSchemaKeys = new LinkedHashSet();
        Set invalidSchemaKeys = new LinkedHashSet();
        Iterable $this$forEach$iv = assetsSchemaKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (uniqueSchemaKeys.contains(it)) {
                duplicateSchemaKeys.add(it);
            }
            if (!this.validateSchemaKey(it)) {
                invalidSchemaKeys.add(it);
            }
            uniqueSchemaKeys.add(it);
        }
        if (CollectionsKt.any((Iterable)duplicateSchemaKeys)) {
            throw new PlanValidationException("Plan includes duplicate Assets' Object Schema keys " + duplicateSchemaKeys);
        }
        if (CollectionsKt.any((Iterable)invalidSchemaKeys)) {
            throw new PlanValidationException("Plan includes invalid Assets' Object Schema keys " + invalidSchemaKeys);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/validation/PlanValidation$ProjectKeysValidationResult;", "", "invalidProjectKeys", "", "", "(Ljava/util/Set;)V", "getInvalidProjectKeys", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class ProjectKeysValidationResult {
        @NotNull
        private final Set<String> invalidProjectKeys;

        public ProjectKeysValidationResult(@NotNull Set<String> invalidProjectKeys) {
            Intrinsics.checkNotNullParameter(invalidProjectKeys, (String)"invalidProjectKeys");
            this.invalidProjectKeys = invalidProjectKeys;
        }

        @NotNull
        public final Set<String> getInvalidProjectKeys() {
            return this.invalidProjectKeys;
        }

        @NotNull
        public final Set<String> component1() {
            return this.invalidProjectKeys;
        }

        @NotNull
        public final ProjectKeysValidationResult copy(@NotNull Set<String> invalidProjectKeys) {
            Intrinsics.checkNotNullParameter(invalidProjectKeys, (String)"invalidProjectKeys");
            return new ProjectKeysValidationResult(invalidProjectKeys);
        }

        public static /* synthetic */ ProjectKeysValidationResult copy$default(ProjectKeysValidationResult projectKeysValidationResult, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = projectKeysValidationResult.invalidProjectKeys;
            }
            return projectKeysValidationResult.copy(set);
        }

        @NotNull
        public String toString() {
            return "ProjectKeysValidationResult(invalidProjectKeys=" + this.invalidProjectKeys + ')';
        }

        public int hashCode() {
            return ((Object)this.invalidProjectKeys).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectKeysValidationResult)) {
                return false;
            }
            ProjectKeysValidationResult projectKeysValidationResult = (ProjectKeysValidationResult)other;
            return Intrinsics.areEqual(this.invalidProjectKeys, projectKeysValidationResult.invalidProjectKeys);
        }
    }
}

