/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.version;

import com.atlassian.jira.migration.common.EnvironmentConfigs;
import com.atlassian.jira.migration.version.VersionService;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.PluginAccessor;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "Lcom/atlassian/jira/migration/version/VersionService;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "configuration", "Lcom/atlassian/jira/migration/common/EnvironmentConfigs;", "buildUtilsInfo", "Lcom/atlassian/jira/util/BuildUtilsInfo;", "(Lcom/atlassian/plugin/PluginAccessor;Lcom/atlassian/jira/migration/common/EnvironmentConfigs;Lcom/atlassian/jira/util/BuildUtilsInfo;)V", "isTestVersion", "", "()Z", "jiraMajorVersion", "", "getJiraMajorVersion", "()I", "jiraServerBuildNumber", "getJiraServerBuildNumber", "jiraServerVersion", "", "getJiraServerVersion", "()Ljava/lang/String;", "pluginKey", "pluginVersionOverride", "Companion", "jira-migration-plugin"})
public final class JiraMigrationVersionService
extends VersionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvironmentConfigs configuration;
    @NotNull
    private final BuildUtilsInfo buildUtilsInfo;
    @NotNull
    public static final String PLUGIN_KEY_DEFAULT = "com.atlassian.jira.migration.jira-migration-plugin";

    @Inject
    public JiraMigrationVersionService(@NotNull PluginAccessor pluginAccessor, @NotNull EnvironmentConfigs configuration, @NotNull BuildUtilsInfo buildUtilsInfo) {
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)buildUtilsInfo, (String)"buildUtilsInfo");
        super(pluginAccessor);
        this.configuration = configuration;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    @NotNull
    public final String getJiraServerVersion() {
        String string = this.buildUtilsInfo.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        return string;
    }

    public final int getJiraMajorVersion() {
        return this.buildUtilsInfo.getVersionNumbers()[0];
    }

    public final int getJiraServerBuildNumber() {
        return this.buildUtilsInfo.getApplicationBuildNumber();
    }

    public final boolean isTestVersion() {
        String string = this.getPluginVersion().toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return StringsKt.endsWith$default((String)string, (String)"-snapshot", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public String pluginKey() {
        return this.configuration.get("migration.plugin.key", PLUGIN_KEY_DEFAULT);
    }

    @Override
    @NotNull
    public String pluginVersionOverride() {
        return this.configuration.get("migration.plugin.version", "UNKNOWN");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/version/JiraMigrationVersionService$Companion;", "", "()V", "PLUGIN_KEY_DEFAULT", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

