/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.version;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000b\u001a\u00020\u0006H&J\b\u0010\u000e\u001a\u00020\u0006H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/version/VersionService;", "", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "(Lcom/atlassian/plugin/PluginAccessor;)V", "pluginVersion", "", "getPluginVersion", "()Ljava/lang/String;", "findPluginVersion", "findPluginVersionOrThrow", "pluginKey", "isPluginVersionUnknown", "", "pluginVersionOverride", "Companion", "jira-migration-plugin"})
public abstract class VersionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginAccessor pluginAccessor;
    private static final Logger log = LoggerFactory.getLogger(VersionService.class);
    @NotNull
    public static final String UNKNOWN_VERSION = "UNKNOWN";

    public VersionService(@NotNull PluginAccessor pluginAccessor) {
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        this.pluginAccessor = pluginAccessor;
    }

    @NotNull
    public final String getPluginVersion() {
        return this.findPluginVersion();
    }

    public final boolean isPluginVersionUnknown() {
        return Intrinsics.areEqual((Object)this.getPluginVersion(), (Object)UNKNOWN_VERSION);
    }

    @NotNull
    public abstract String pluginKey();

    @NotNull
    public abstract String pluginVersionOverride();

    private final String findPluginVersion() {
        String pluginKey = this.pluginKey();
        try {
            String pluginVersionOverride = this.pluginVersionOverride();
            if (!Intrinsics.areEqual((Object)UNKNOWN_VERSION, (Object)pluginVersionOverride)) {
                log.warn("Using overridden plugin version: " + pluginVersionOverride);
                return pluginVersionOverride;
            }
            String version = this.findPluginVersionOrThrow(pluginKey);
            log.debug("Found version " + version + " for plugin with key " + pluginKey + '.');
            return version;
        }
        catch (RuntimeException e) {
            log.warn("Plugin version could not be determined for plugin with key " + pluginKey + ". Reason=" + e.getMessage() + '.');
            return UNKNOWN_VERSION;
        }
    }

    private final String findPluginVersionOrThrow(String pluginKey) {
        Object object = this.pluginAccessor.getPlugin(pluginKey);
        if (object == null) {
            throw new IllegalStateException("Plugin accessor failed to find plugin with key " + pluginKey);
        }
        Plugin plugin = object;
        PluginInformation pluginInformation = plugin.getPluginInformation();
        String string = object = pluginInformation != null ? pluginInformation.getVersion() : null;
        if (object == null) {
            throw new IllegalStateException("Found plugin, but failed to find its version.");
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/version/VersionService$Companion;", "", "()V", "UNKNOWN_VERSION", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

